/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.renderer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.Attribute;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.Renderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptionsRenderer
implements Renderer {
    private static final Pattern OPTIONS_PATTERN = Pattern.compile(Pattern.quote("{options[") + "(.+)" + Pattern.quote("]}"));
    private static final Logger LOG = LoggerFactory.getLogger(OptionsRenderer.class);
    private final ApplicationContext applicationContext;
    private final Renderer renderer;

    public OptionsRenderer(ApplicationContext applicationContext, Renderer renderer) {
        this.applicationContext = applicationContext;
        this.renderer = renderer;
    }

    public boolean isRenderable(String path, Request request) {
        return this.renderer.isRenderable(path, request);
    }

    public void render(String path, Request request) throws IOException {
        Matcher matcher = OPTIONS_PATTERN.matcher(path);
        if (null != matcher && matcher.find()) {
            boolean done = false;
            String match = matcher.group(1);
            ListAttribute fallbacks = (ListAttribute)TilesAccess.getCurrentContainer((Request)request).getAttributeContext(request).getAttribute(match);
            if (null == fallbacks) {
                throw new IllegalStateException("A matching list-attribute name=\"" + match + "\" must be defined.");
            }
            if (fallbacks.getValue().isEmpty()) {
                throw new IllegalStateException("list-attribute name=\"" + match + "\" must have minimum one attribute");
            }
            for (Attribute option : fallbacks.getValue()) {
                String template = path.replaceFirst(Pattern.quote(matcher.group()), (String)option.getValue());
                done = this.renderAttempt(template, request);
                if (!done) continue;
                break;
            }
            if (!done) {
                throw new IOException("None of the options existed for " + path);
            }
        } else {
            this.renderer.render(path, request);
        }
    }

    private boolean renderAttempt(String template, Request request) throws IOException {
        boolean result = false;
        if (!Cache.isTemplateMissing(template)) {
            try {
                if (null != this.applicationContext.getResource(template)) {
                    this.renderer.render(template, request);
                    result = true;
                    Cache.setIfAbsentTemplateFound(template, true);
                }
            }
            catch (FileNotFoundException ex) {
                if (ex.getMessage().contains(template)) {
                    LOG.trace(ex.getMessage());
                }
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
            Cache.setIfAbsentTemplateFound(template, false);
        }
        return result;
    }

    private static final class Cache {
        private static final ConcurrentMap<String, Boolean> TEMPLATE_EXISTS = new ConcurrentHashMap<String, Boolean>();
        private static volatile long cacheLastCleaned = System.currentTimeMillis();
        private static final String CACHE_LIFE_PROPERTY = Cache.class.getName() + ".ttl_ms";
        private static final long CACHE_LIFE = null != Long.getLong(CACHE_LIFE_PROPERTY) ? Long.getLong(CACHE_LIFE_PROPERTY) : 300000L;

        static boolean isTemplateMissing(String template) {
            if (0L < CACHE_LIFE && System.currentTimeMillis() > cacheLastCleaned + CACHE_LIFE) {
                cacheLastCleaned = System.currentTimeMillis();
                TEMPLATE_EXISTS.clear();
                return false;
            }
            return TEMPLATE_EXISTS.containsKey(template) && (Boolean)TEMPLATE_EXISTS.get(template) == false;
        }

        static void setIfAbsentTemplateFound(String template, boolean found) {
            if (0L < CACHE_LIFE && !TEMPLATE_EXISTS.containsKey(template)) {
                TEMPLATE_EXISTS.putIfAbsent(template, found);
            }
        }

        private Cache() {
        }
    }
}

