/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioParser
implements Parser {
    private static final long serialVersionUID = -6015684081240882695L;
    private static final String UNSUPPORTED_AUDIO_FILE_EXCEPTION = "An UnsupportedAudioFileException was thrown.  This could mean that the underlying parser hit an EndOfFileException or that the file is unsupported. \u00af\\_(\u30c4)_/\u00af";
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.audio((String)"basic"), MediaType.audio((String)"vnd.wave"), MediaType.audio((String)"x-wav"), MediaType.audio((String)"x-aiff"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream((InputStream)stream);
        }
        stream = new SkipFullyInputStream((InputStream)stream);
        try {
            int bits;
            float rate;
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(stream);
            AudioFileFormat.Type type = fileFormat.getType();
            if (type == AudioFileFormat.Type.AIFC || type == AudioFileFormat.Type.AIFF) {
                metadata.set("Content-Type", "audio/x-aiff");
            } else if (type == AudioFileFormat.Type.AU || type == AudioFileFormat.Type.SND) {
                metadata.set("Content-Type", "audio/basic");
            } else if (type == AudioFileFormat.Type.WAVE) {
                metadata.set("Content-Type", "audio/vnd.wave");
            }
            AudioFormat audioFormat = fileFormat.getFormat();
            int channels = audioFormat.getChannels();
            if (channels != -1) {
                metadata.set("channels", String.valueOf(channels));
            }
            if ((rate = audioFormat.getSampleRate()) != -1.0f) {
                metadata.set("samplerate", String.valueOf(rate));
                metadata.set(XMPDM.AUDIO_SAMPLE_RATE, Integer.toString((int)rate));
            }
            if ((bits = audioFormat.getSampleSizeInBits()) != -1) {
                metadata.set("bits", String.valueOf(bits));
                if (bits == 8) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "8Int");
                } else if (bits == 16) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "16Int");
                } else if (bits == 32) {
                    metadata.set(XMPDM.AUDIO_SAMPLE_TYPE, "32Int");
                }
            }
            metadata.set("encoding", audioFormat.getEncoding().toString());
            this.addMetadata(metadata, fileFormat.properties());
            this.addMetadata(metadata, audioFormat.properties());
        }
        catch (UnsupportedAudioFileException e) {
            metadata.add(TikaCoreProperties.TIKA_META_EXCEPTION_WARNING, UNSUPPORTED_AUDIO_FILE_EXCEPTION);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    private void addMetadata(Metadata metadata, Map<String, Object> properties) {
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                metadata.set(entry.getKey(), value.toString());
            }
        }
    }

    private static class SkipFullyInputStream
    extends ProxyInputStream {
        public SkipFullyInputStream(InputStream proxy) {
            super(proxy);
        }

        public long skip(long ln) throws IOException {
            IOUtils.skipFully((InputStream)this.in, (long)ln);
            return ln;
        }
    }
}

