/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.AdvisorDef2;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.Locatable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceAdvisor;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.ServiceDecorator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectResource;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.ServiceId;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.ContributionDef2;
import org.apache.tapestry5.ioc.def.ContributionDef3;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.DecoratorDef2;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.ConstructionPlan;
import org.apache.tapestry5.ioc.internal.util.ConstructorInvoker;
import org.apache.tapestry5.ioc.internal.util.InitializationPlan;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.LoggingInvokableWrapper;
import org.apache.tapestry5.ioc.internal.util.MethodInvoker;
import org.apache.tapestry5.ioc.internal.util.UtilMessages;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    public static final boolean SERVICE_CLASS_RELOADING_ENABLED = Boolean.parseBoolean(System.getProperty("tapestry.service-reloading-enabled", "true"));
    private static final String NAME_PREFIX = "_$";
    private static final Pattern NAME_PATTERN = Pattern.compile("^[_|$]*([\\p{javaJavaIdentifierPart}]+?)[_|$]*$", 2);
    public static AnnotationProvider NULL_ANNOTATION_PROVIDER = new NullAnnotationProvider();
    public static final Mapper<Class, AnnotationProvider> CLASS_TO_AP_MAPPER = new Mapper<Class, AnnotationProvider>(){

        public AnnotationProvider map(Class element) {
            return InternalUtils.toAnnotationProvider(element);
        }
    };
    public static final Mapper<Method, AnnotationProvider> METHOD_TO_AP_MAPPER = new Mapper<Method, AnnotationProvider>(){

        public AnnotationProvider map(Method element) {
            return InternalUtils.toAnnotationProvider(element);
        }
    };
    private static final AtomicLong uuidGenerator = new AtomicLong(System.nanoTime());

    public static String asString(Method method, PlasticProxyFactory proxyFactory) {
        Location location = proxyFactory.getMethodLocation(method);
        return location != null ? location.toString() : InternalUtils.asString(method);
    }

    public static String asString(Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            String name = method.getParameterTypes()[i].getSimpleName();
            buffer.append(name);
        }
        return buffer.append(")").toString();
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static int size(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    public static String stripMemberName(String memberName) {
        assert (InternalUtils.isNonBlank(memberName));
        Matcher matcher = NAME_PATTERN.matcher(memberName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input '%s' is not a valid Java identifier.", memberName));
        }
        return matcher.group(1);
    }

    public static List<String> toList(Enumeration e) {
        List<String> result = CollectionFactory.newList();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    private static Object calculateInjection(Class injectionType, Type genericType, final Annotation[] annotations, ObjectLocator locator, InjectionResources resources) {
        Object result;
        AnnotationProvider provider = new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return InternalUtils.findAnnotation(annotations, annotationClass);
            }
        };
        InjectService is = provider.getAnnotation(InjectService.class);
        if (is != null) {
            String serviceId = is.value();
            return locator.getService(serviceId, injectionType);
        }
        Named named = provider.getAnnotation(Named.class);
        if (named != null) {
            return locator.getService(named.value(), injectionType);
        }
        if (provider.getAnnotation(Inject.class) == null && (result = resources.findResource(injectionType, genericType)) != null) {
            return result;
        }
        return locator.getObject(injectionType, provider);
    }

    public static Object[] calculateParametersForMethod(Method method, ObjectLocator locator, InjectionResources resources, OperationTracker tracker) {
        return InternalUtils.calculateParameters(locator, resources, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations(), tracker);
    }

    public static Object[] calculateParameters(final ObjectLocator locator, final InjectionResources resources, Class[] parameterTypes, Type[] genericTypes, Annotation[][] parameterAnnotations, OperationTracker tracker) {
        int parameterCount = parameterTypes.length;
        Object[] parameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            final Class type = parameterTypes[i];
            final Type genericType = genericTypes[i];
            final Annotation[] annotations = parameterAnnotations[i];
            String description = String.format("Determining injection value for parameter #%d (%s)", i + 1, PlasticUtils.toTypeName((Class)type));
            Invokable<Object> operation = new Invokable<Object>(){

                @Override
                public Object invoke() {
                    return InternalUtils.calculateInjection(type, genericType, annotations, locator, resources);
                }
            };
            parameters[i] = tracker.invoke(description, operation);
        }
        return parameters;
    }

    public static void injectIntoFields(final Object object, final ObjectLocator locator, final InjectionResources resources, OperationTracker tracker) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (final Field f : fields = clazz.getDeclaredFields()) {
                int fieldModifiers = f.getModifiers();
                if (Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
                final AnnotationProvider ap = new AnnotationProvider(){

                    @Override
                    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                        return f.getAnnotation(annotationClass);
                    }
                };
                String description = String.format("Calculating possible injection value for field %s.%s (%s)", clazz.getName(), f.getName(), PlasticUtils.toTypeName(f.getType()));
                tracker.run(description, new Runnable(){

                    public void run() {
                        Class<?> fieldType = f.getType();
                        InjectService is = ap.getAnnotation(InjectService.class);
                        if (is != null) {
                            InternalUtils.inject(object, f, locator.getService(is.value(), fieldType));
                            return;
                        }
                        if (ap.getAnnotation(Inject.class) != null || ap.getAnnotation(InjectResource.class) != null) {
                            Object value = resources.findResource(fieldType, f.getGenericType());
                            if (value != null) {
                                InternalUtils.inject(object, f, value);
                                return;
                            }
                            InternalUtils.inject(object, f, locator.getObject(fieldType, ap));
                            return;
                        }
                        if (ap.getAnnotation(javax.inject.Inject.class) != null) {
                            Named named = ap.getAnnotation(Named.class);
                            if (named == null) {
                                InternalUtils.inject(object, f, locator.getObject(fieldType, ap));
                            } else {
                                InternalUtils.inject(object, f, locator.getService(named.value(), fieldType));
                            }
                            return;
                        }
                    }
                });
            }
        }
    }

    private static synchronized void inject(Object target, Field field, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(target, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to set field '%s' of %s to %s: %s", field.getName(), target, value, InternalUtils.toMessage(ex)));
        }
    }

    public static String join(List elements) {
        return InternalUtils.join(elements, ", ");
    }

    public static String join(List elements, String separator) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).toString();
            }
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object o : elements) {
            String string;
            if (!first) {
                buffer.append(separator);
            }
            if ((string = String.valueOf(o)).equals("")) {
                string = "(blank)";
            }
            buffer.append(string);
            first = false;
        }
        return buffer.toString();
    }

    public static String joinSorted(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return "(none)";
        }
        List list = CollectionFactory.newList();
        for (Object o : elements) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return InternalUtils.join(list);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static boolean isEmptyCollection(Object input) {
        if (input instanceof Collection) {
            return ((Collection)input).isEmpty();
        }
        return false;
    }

    public static boolean isNonBlank(String input) {
        return !InternalUtils.isBlank(input);
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static Location locationOf(Object location) {
        if (location == null) {
            return null;
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        if (location instanceof Locatable) {
            return ((Locatable)location).getLocation();
        }
        return null;
    }

    public static List<String> sortedKeys(Map map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<String> keys = CollectionFactory.newList();
        for (Object o : map.keySet()) {
            keys.add(String.valueOf(o));
        }
        Collections.sort(keys);
        return keys;
    }

    public static <K, V> Set<K> keys(Map<K, V> map) {
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static <T> Iterator<T> reverseIterator(List<T> list) {
        final ListIterator<T> normal = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return normal.hasPrevious();
            }

            @Override
            public T next() {
                return normal.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean containsSymbols(String input) {
        return input.contains("${");
    }

    public static String lastTerm(String input) {
        assert (InternalUtils.isNonBlank(input));
        int dotx = input.lastIndexOf(46);
        if (dotx < 0) {
            return input;
        }
        return input.substring(dotx + 1);
    }

    public static Constructor findAutobuildConstructor(Class clazz) {
        Constructor[] constructors = clazz.getConstructors();
        switch (constructors.length) {
            case 1: {
                return constructors[0];
            }
            case 0: {
                return null;
            }
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return constructor;
        }
        Constructor standardConstructor = InternalUtils.findConstructorByAnnotation(constructors, Inject.class);
        Constructor javaxConstructor = InternalUtils.findConstructorByAnnotation(constructors, javax.inject.Inject.class);
        if (standardConstructor != null && javaxConstructor != null) {
            throw new IllegalArgumentException(String.format("Too many autobuilt constructors found. Please use either '@%s' or '@%s' annotation to mark a constructor for autobuilding.", Inject.class.getName(), javax.inject.Inject.class.getName()));
        }
        if (standardConstructor != null) {
            return standardConstructor;
        }
        if (javaxConstructor != null) {
            return javaxConstructor;
        }
        Comparator<Constructor> comparator = new Comparator<Constructor>(){

            @Override
            public int compare(Constructor o1, Constructor o2) {
                return o2.getParameterTypes().length - o1.getParameterTypes().length;
            }
        };
        Arrays.sort(constructors, comparator);
        return constructors[0];
    }

    private static <T extends Annotation> Constructor findConstructorByAnnotation(Constructor[] constructors, Class<T> annotationClass) {
        for (Constructor c : constructors) {
            if (c.getAnnotation(annotationClass) == null) continue;
            return c;
        }
        return null;
    }

    public static <K, V> void addToMapList(Map<K, List<V>> map, K key, V value) {
        List<Object> list = map.get(key);
        if (list == null) {
            list = CollectionFactory.newList();
            map.put(key, list);
        }
        list.add(value);
    }

    public static void validateMarkerAnnotation(Class markerClass) {
        Retention policy = markerClass.getAnnotation(Retention.class);
        if (policy != null && policy.value() == RetentionPolicy.RUNTIME) {
            return;
        }
        throw new IllegalArgumentException(UtilMessages.badMarkerAnnotation(markerClass));
    }

    public static void validateMarkerAnnotations(Class[] markerClasses) {
        for (Class markerClass : markerClasses) {
            InternalUtils.validateMarkerAnnotation(markerClass);
        }
    }

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String toMessage(Throwable exception) {
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.getClass().getName();
    }

    public static void validateConstructorForAutobuild(Constructor constructor) {
        Class clazz = constructor.getDeclaringClass();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format("Class %s is not a public class and may not be autobuilt.", clazz.getName()));
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalArgumentException(String.format("Constructor %s is not public and may not be used for autobuilding an instance of the class. You should make the constructor public, or mark an alternate public constructor with the @Inject annotation.", constructor));
        }
    }

    public static AnnotationProvider toAnnotationProvider(final Class element) {
        return new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)annotationClass.cast(element.getAnnotation(annotationClass)));
            }
        };
    }

    public static final Method findMethod(Class containingClass, String methodName, Class ... parameterTypes) {
        if (containingClass == null) {
            return null;
        }
        try {
            return containingClass.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static ServiceDef3 toServiceDef3(ServiceDef sd) {
        if (sd instanceof ServiceDef3) {
            return (ServiceDef3)sd;
        }
        final ServiceDef2 sd2 = InternalUtils.toServiceDef2(sd);
        return new ServiceDef3(){

            @Override
            public AnnotationProvider getClassAnnotationProvider() {
                return InternalUtils.toAnnotationProvider(this.getServiceInterface());
            }

            @Override
            public AnnotationProvider getMethodAnnotationProvider(String methodName, Class ... argumentTypes) {
                return InternalUtils.toAnnotationProvider(InternalUtils.findMethod(this.getServiceInterface(), methodName, argumentTypes));
            }

            @Override
            public boolean isPreventDecoration() {
                return sd2.isPreventDecoration();
            }

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return sd2.createServiceCreator(resources);
            }

            @Override
            public String getServiceId() {
                return sd2.getServiceId();
            }

            @Override
            public Set<Class> getMarkers() {
                return sd2.getMarkers();
            }

            @Override
            public Class getServiceInterface() {
                return sd2.getServiceInterface();
            }

            @Override
            public String getServiceScope() {
                return sd2.getServiceScope();
            }

            @Override
            public boolean isEagerLoad() {
                return sd2.isEagerLoad();
            }
        };
    }

    public static ServiceDef2 toServiceDef2(final ServiceDef sd) {
        if (sd instanceof ServiceDef2) {
            return (ServiceDef2)sd;
        }
        return new ServiceDef2(){

            @Override
            public boolean isPreventDecoration() {
                return false;
            }

            @Override
            public ObjectCreator createServiceCreator(ServiceBuilderResources resources) {
                return sd.createServiceCreator(resources);
            }

            @Override
            public String getServiceId() {
                return sd.getServiceId();
            }

            @Override
            public Set<Class> getMarkers() {
                return sd.getMarkers();
            }

            @Override
            public Class getServiceInterface() {
                return sd.getServiceInterface();
            }

            @Override
            public String getServiceScope() {
                return sd.getServiceScope();
            }

            @Override
            public boolean isEagerLoad() {
                return sd.isEagerLoad();
            }

            public String toString() {
                return sd.toString();
            }
        };
    }

    public static ModuleDef2 toModuleDef2(final ModuleDef md) {
        if (md instanceof ModuleDef2) {
            return (ModuleDef2)md;
        }
        return new ModuleDef2(){

            @Override
            public Set<AdvisorDef> getAdvisorDefs() {
                return Collections.emptySet();
            }

            @Override
            public Class getBuilderClass() {
                return md.getBuilderClass();
            }

            @Override
            public Set<ContributionDef> getContributionDefs() {
                return md.getContributionDefs();
            }

            @Override
            public Set<DecoratorDef> getDecoratorDefs() {
                return md.getDecoratorDefs();
            }

            @Override
            public String getLoggerName() {
                return md.getLoggerName();
            }

            @Override
            public ServiceDef getServiceDef(String serviceId) {
                return md.getServiceDef(serviceId);
            }

            @Override
            public Set<String> getServiceIds() {
                return md.getServiceIds();
            }
        };
    }

    public static ServiceLifecycle2 toServiceLifecycle2(final ServiceLifecycle lifecycle) {
        if (lifecycle instanceof ServiceLifecycle2) {
            return (ServiceLifecycle2)lifecycle;
        }
        return new ServiceLifecycle2(){

            public boolean requiresProxy() {
                return true;
            }

            public Object createService(ServiceResources resources, ObjectCreator creator) {
                return lifecycle.createService(resources, creator);
            }

            public boolean isSingleton() {
                return lifecycle.isSingleton();
            }
        };
    }

    public static <T extends Comparable<T>> List<T> matchAndSort(Collection<? extends T> collection, Predicate<T> predicate) {
        assert (predicate != null);
        List result = CollectionFactory.newList();
        for (Comparable object : collection) {
            if (!predicate.accept((Object)object)) continue;
            result.add(object);
        }
        Collections.sort(result);
        return result;
    }

    public static ContributionDef2 toContributionDef2(final ContributionDef contribution) {
        if (contribution instanceof ContributionDef2) {
            return (ContributionDef2)contribution;
        }
        return new ContributionDef2(){

            @Override
            public Set<Class> getMarkers() {
                return Collections.emptySet();
            }

            @Override
            public Class getServiceInterface() {
                return null;
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, Configuration configuration) {
                contribution.contribute(moduleSource, resources, configuration);
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, OrderedConfiguration configuration) {
                contribution.contribute(moduleSource, resources, configuration);
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, MappedConfiguration configuration) {
                contribution.contribute(moduleSource, resources, configuration);
            }

            @Override
            public String getServiceId() {
                return contribution.getServiceId();
            }

            public String toString() {
                return contribution.toString();
            }
        };
    }

    public static ContributionDef3 toContributionDef3(ContributionDef contribution) {
        if (contribution instanceof ContributionDef2) {
            return (ContributionDef3)contribution;
        }
        final ContributionDef2 cd2 = InternalUtils.toContributionDef2(contribution);
        return new ContributionDef3(){

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public String getServiceId() {
                return cd2.getServiceId();
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, Configuration configuration) {
                cd2.contribute(moduleSource, resources, configuration);
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, OrderedConfiguration configuration) {
                cd2.contribute(moduleSource, resources, configuration);
            }

            @Override
            public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, MappedConfiguration configuration) {
                cd2.contribute(moduleSource, resources, configuration);
            }

            @Override
            public Set<Class> getMarkers() {
                return cd2.getMarkers();
            }

            @Override
            public Class getServiceInterface() {
                return cd2.getServiceInterface();
            }

            public String toString() {
                return cd2.toString();
            }
        };
    }

    public static AdvisorDef2 toAdvisorDef2(final AdvisorDef advisor) {
        if (advisor instanceof AdvisorDef2) {
            return (AdvisorDef2)advisor;
        }
        return new AdvisorDef2(){

            @Override
            public ServiceAdvisor createAdvisor(ModuleBuilderSource moduleSource, ServiceResources resources) {
                return advisor.createAdvisor(moduleSource, resources);
            }

            @Override
            public String getAdvisorId() {
                return advisor.getAdvisorId();
            }

            @Override
            public String[] getConstraints() {
                return advisor.getConstraints();
            }

            @Override
            public boolean matches(ServiceDef serviceDef) {
                return advisor.matches(serviceDef);
            }

            @Override
            public Set<Class> getMarkers() {
                return Collections.emptySet();
            }

            @Override
            public Class getServiceInterface() {
                return null;
            }

            public String toString() {
                return advisor.toString();
            }
        };
    }

    public static DecoratorDef2 toDecoratorDef2(final DecoratorDef decorator) {
        if (decorator instanceof DecoratorDef2) {
            return (DecoratorDef2)decorator;
        }
        return new DecoratorDef2(){

            @Override
            public ServiceDecorator createDecorator(ModuleBuilderSource moduleSource, ServiceResources resources) {
                return decorator.createDecorator(moduleSource, resources);
            }

            @Override
            public String[] getConstraints() {
                return decorator.getConstraints();
            }

            @Override
            public String getDecoratorId() {
                return decorator.getDecoratorId();
            }

            @Override
            public boolean matches(ServiceDef serviceDef) {
                return decorator.matches(serviceDef);
            }

            @Override
            public Set<Class> getMarkers() {
                return Collections.emptySet();
            }

            @Override
            public Class getServiceInterface() {
                return null;
            }

            public String toString() {
                return decorator.toString();
            }
        };
    }

    public static boolean isLocalFile(Class clazz) {
        String path = PlasticInternalUtils.toClassPath((String)clazz.getName());
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            return false;
        }
        URL classFileURL = loader.getResource(path);
        return classFileURL != null && classFileURL.getProtocol().equals("file");
    }

    public static <S, T> Mapper<S, T> toMapper(final Coercion<S, T> coercion) {
        assert (coercion != null);
        return new Mapper<S, T>(){

            public T map(S value) {
                return coercion.coerce(value);
            }
        };
    }

    public static long nextUUID() {
        return uuidGenerator.incrementAndGet();
    }

    public static String getServiceId(AnnotatedElement annotated) {
        String value;
        ServiceId serviceIdAnnotation = annotated.getAnnotation(ServiceId.class);
        if (serviceIdAnnotation != null) {
            return serviceIdAnnotation.value();
        }
        Named namedAnnotation = annotated.getAnnotation(Named.class);
        if (namedAnnotation != null && InternalUtils.isNonBlank(value = namedAnnotation.value())) {
            return value;
        }
        return null;
    }

    public static org.apache.tapestry5.plastic.MethodAdvice toPlasticMethodAdvice(final MethodAdvice iocMethodAdvice, final AnnotationProvider methodAnnotationProvider) {
        assert (iocMethodAdvice != null);
        return new org.apache.tapestry5.plastic.MethodAdvice(){

            public void advise(final MethodInvocation invocation) {
                Invocation iocInvocation = new Invocation(){

                    @Override
                    public void rethrow() {
                        invocation.rethrow();
                    }

                    @Override
                    public void proceed() {
                        invocation.proceed();
                    }

                    @Override
                    public void overrideThrown(Exception thrown) {
                        invocation.setCheckedException(thrown);
                    }

                    @Override
                    public void overrideResult(Object newResult) {
                        invocation.setReturnValue(newResult);
                    }

                    @Override
                    public void override(int index, Object newParameter) {
                        invocation.setParameter(index, newParameter);
                    }

                    @Override
                    public boolean isFail() {
                        return invocation.didThrowCheckedException();
                    }

                    @Override
                    public <T extends Throwable> T getThrown(Class<T> throwableClass) {
                        return (T)invocation.getCheckedException(throwableClass);
                    }

                    @Override
                    public Object getParameter(int index) {
                        return invocation.getParameter(index);
                    }

                    @Override
                    public Object getResult() {
                        return invocation.getReturnValue();
                    }

                    @Override
                    public Class getResultType() {
                        return this.method().getReturnType();
                    }

                    private Method method() {
                        return invocation.getMethod();
                    }

                    @Override
                    public Class getParameterType(int index) {
                        return this.method().getParameterTypes()[index];
                    }

                    @Override
                    public int getParameterCount() {
                        return this.method().getParameterTypes().length;
                    }

                    @Override
                    public String getMethodName() {
                        return this.method().getName();
                    }

                    @Override
                    public <T extends Annotation> T getMethodAnnotation(Class<T> annotationClass) {
                        return methodAnnotationProvider.getAnnotation(annotationClass);
                    }
                };
                iocMethodAdvice.advise(iocInvocation);
            }
        };
    }

    public static AnnotationProvider toAnnotationProvider(final Method element) {
        if (element == null) {
            return NULL_ANNOTATION_PROVIDER;
        }
        return new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return element.getAnnotation(annotationClass);
            }
        };
    }

    public static <T> ObjectCreator<T> createConstructorConstructionPlan(final OperationTracker tracker, final ObjectLocator locator, final InjectionResources resources, final Logger logger, final String description, final Constructor<T> constructor) {
        return (ObjectCreator)tracker.invoke(String.format("Creating plan to instantiate %s via %s", constructor.getDeclaringClass().getName(), constructor), new Invokable<ObjectCreator<T>>(){

            @Override
            public ObjectCreator<T> invoke() {
                InternalUtils.validateConstructorForAutobuild(constructor);
                Object[] constructorParameters = InternalUtils.calculateParameters(locator, resources, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), tracker);
                ConstructorInvoker core = new ConstructorInvoker(constructor, constructorParameters);
                Invokable wrapped = logger == null ? core : new LoggingInvokableWrapper(logger, description, core);
                ConstructionPlan plan = new ConstructionPlan(tracker, description, wrapped);
                InternalUtils.extendPlanForInjectedFields(plan, tracker, locator, resources, constructor.getDeclaringClass());
                InternalUtils.extendPlanForPostInjectionMethods(plan, tracker, locator, resources, constructor.getDeclaringClass());
                return plan;
            }
        });
    }

    private static <T> void extendPlanForInjectedFields(final ConstructionPlan<T> plan, OperationTracker tracker, final ObjectLocator locator, final InjectionResources resources, Class<T> instantiatedClass) {
        for (Class<T> clazz = instantiatedClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (final Field f : fields = clazz.getDeclaredFields()) {
                int fieldModifiers = f.getModifiers();
                if (Modifier.isStatic(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
                final AnnotationProvider ap = new AnnotationProvider(){

                    @Override
                    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                        return f.getAnnotation(annotationClass);
                    }
                };
                String description = String.format("Calculating possible injection value for field %s.%s (%s)", clazz.getName(), f.getName(), PlasticUtils.toTypeName(f.getType()));
                tracker.run(description, new Runnable(){

                    public void run() {
                        Class<?> fieldType = f.getType();
                        InjectService is = ap.getAnnotation(InjectService.class);
                        if (is != null) {
                            InternalUtils.addInjectPlan(plan, f, locator.getService(is.value(), fieldType));
                            return;
                        }
                        if (ap.getAnnotation(Inject.class) != null || ap.getAnnotation(InjectResource.class) != null) {
                            Object value = resources.findResource(fieldType, f.getGenericType());
                            if (value != null) {
                                InternalUtils.addInjectPlan(plan, f, value);
                                return;
                            }
                            InternalUtils.addInjectPlan(plan, f, locator.getObject(fieldType, ap));
                            return;
                        }
                        if (ap.getAnnotation(javax.inject.Inject.class) != null) {
                            Named named = ap.getAnnotation(Named.class);
                            if (named == null) {
                                InternalUtils.addInjectPlan(plan, f, locator.getObject(fieldType, ap));
                            } else {
                                InternalUtils.addInjectPlan(plan, f, locator.getService(named.value(), fieldType));
                            }
                            return;
                        }
                    }
                });
            }
        }
    }

    private static <T> void addInjectPlan(ConstructionPlan<T> plan, final Field field, final Object injectedValue) {
        plan.add(new InitializationPlan<T>(){

            @Override
            public String getDescription() {
                return String.format("Injecting %s into field %s of class %s.", injectedValue, field.getName(), field.getDeclaringClass().getName());
            }

            @Override
            public void initialize(T instance) {
                InternalUtils.inject(instance, field, injectedValue);
            }
        });
    }

    private static boolean hasAnnotation(AccessibleObject member, Class<? extends Annotation> annotationType) {
        return member.getAnnotation(annotationType) != null;
    }

    private static <T> void extendPlanForPostInjectionMethods(ConstructionPlan<T> plan, OperationTracker tracker, ObjectLocator locator, InjectionResources resources, Class<T> instantiatedClass) {
        for (Method m : instantiatedClass.getMethods()) {
            if (!InternalUtils.hasAnnotation(m, PostInjection.class) && !InternalUtils.hasAnnotation(m, PostConstruct.class)) continue;
            InternalUtils.extendPlanForPostInjectionMethod(plan, tracker, locator, resources, m);
        }
    }

    private static void extendPlanForPostInjectionMethod(final ConstructionPlan<?> plan, final OperationTracker tracker, final ObjectLocator locator, final InjectionResources resources, final Method method) {
        tracker.run("Computing parameters for post-injection method " + method, new Runnable(){

            public void run() {
                final Object[] parameters = InternalUtils.calculateParametersForMethod(method, locator, resources, tracker);
                plan.add(new InitializationPlan<Object>(){

                    @Override
                    public String getDescription() {
                        return "Invoking " + method;
                    }

                    @Override
                    public void initialize(Object instance) {
                        Throwable fail = null;
                        try {
                            method.invoke(instance, parameters);
                        }
                        catch (InvocationTargetException ex) {
                            fail = ex.getTargetException();
                        }
                        catch (Exception ex) {
                            fail = ex;
                        }
                        if (fail != null) {
                            throw new RuntimeException(String.format("Exception invoking method %s: %s", method, InternalUtils.toMessage(fail)), fail);
                        }
                    }
                });
            }
        });
    }

    public static <T> ObjectCreator<T> createMethodInvocationPlan(final OperationTracker tracker, final ObjectLocator locator, final InjectionResources resources, final Logger logger, final String description, final Object instance, final Method method) {
        return (ObjectCreator)tracker.invoke("Creating plan to invoke " + method, new Invokable<ObjectCreator<T>>(){

            @Override
            public ObjectCreator<T> invoke() {
                Object[] methodParameters = InternalUtils.calculateParametersForMethod(method, locator, resources, tracker);
                MethodInvoker core = new MethodInvoker(instance, method, methodParameters);
                Invokable wrapped = logger == null ? core : new LoggingInvokableWrapper(logger, description, core);
                return new ConstructionPlan(tracker, description, wrapped);
            }
        });
    }
}

