/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.util;

import java.util.Formatter;

public final class BodyBuilder {
    private static final int DEFAULT_LENGTH = 200;
    private static final String INDENT = "  ";
    private final StringBuilder buffer = new StringBuilder(200);
    private final Formatter formatter = new Formatter(this.buffer);
    private int nestingDepth = 0;
    private boolean atNewLine = true;

    public BodyBuilder clear() {
        this.nestingDepth = 0;
        this.atNewLine = true;
        this.buffer.setLength(0);
        return this;
    }

    public BodyBuilder add(String format, Object ... args) {
        this.add(format, args, false);
        return this;
    }

    public BodyBuilder addln(String format, Object ... args) {
        this.add(format, args, true);
        return this;
    }

    private BodyBuilder add(String format, Object[] args, boolean newLine) {
        this.indent();
        this.formatter.format(format, args);
        if (newLine) {
            this.newline();
        }
        return this;
    }

    private void newline() {
        this.buffer.append("\n");
        this.atNewLine = true;
    }

    public BodyBuilder begin() {
        if (!this.atNewLine) {
            this.newline();
        }
        this.indent();
        this.buffer.append("{");
        this.newline();
        ++this.nestingDepth;
        return this;
    }

    public BodyBuilder end() {
        if (!this.atNewLine) {
            this.newline();
        }
        --this.nestingDepth;
        this.indent();
        this.buffer.append("}");
        this.newline();
        return this;
    }

    private void indent() {
        if (this.atNewLine) {
            for (int i = 0; i < this.nestingDepth; ++i) {
                this.buffer.append(INDENT);
            }
            this.atNewLine = false;
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

