/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Iterator;
import org.apache.tapestry5.ioc.services.ExceptionTracker;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.slf4j.Logger;

public final class MethodLogger {
    private static final int BUFFER_SIZE = 200;
    private static final String ENTER = "ENTER";
    private static final String EXIT = " EXIT";
    private static final String FAIL = " FAIL";
    private final Logger logger;
    private final ExceptionTracker exceptionTracker;

    public MethodLogger(Logger logger, ExceptionTracker exceptionTracker) {
        this.logger = logger;
        this.exceptionTracker = exceptionTracker;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void entry(MethodInvocation invocation) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(String.format("[%s] %s(", ENTER, invocation.getMethod().getName()));
        for (int i = 0; i < invocation.getMethod().getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, invocation.getParameter(i));
        }
        buffer.append(")");
        this.logger.debug(buffer.toString());
    }

    private void convert(StringBuilder buffer, Object object) {
        if (object == null) {
            buffer.append("null");
            return;
        }
        if (object instanceof String) {
            buffer.append("\"");
            buffer.append(object.toString());
            buffer.append("\"");
            return;
        }
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            buffer.append('{');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                this.convert(buffer, values[i]);
            }
            buffer.append('}');
            return;
        }
        if (object instanceof Iterable) {
            Iterable itr = (Iterable)object;
            boolean first = true;
            buffer.append('[');
            Iterator i = itr.iterator();
            while (i.hasNext()) {
                if (!first) {
                    buffer.append(", ");
                }
                this.convert(buffer, i.next());
                first = false;
            }
            buffer.append(']');
            return;
        }
        buffer.append(object.toString());
    }

    public void exit(MethodInvocation invocation) {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(String.format("[%s] %s", EXIT, invocation.getMethod().getName()));
        if (invocation.getMethod().getReturnType() != Void.TYPE) {
            buffer.append(" [");
            this.convert(buffer, invocation.getReturnValue());
            buffer.append(']');
        }
        this.logger.debug(buffer.toString());
    }

    public void fail(MethodInvocation invocation, Throwable t) {
        this.logger.debug(String.format("[%s] %s -- %s", FAIL, invocation.getMethod().getName(), t.getClass().getName()), this.exceptionTracker.exceptionLogged(t) ? null : t);
    }
}

