/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.internal.ObjectCreatorSource;
import org.apache.tapestry5.ioc.internal.ReloadableServiceImplementationObjectCreator;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.services.UpdateListenerHub;

public class ReloadableObjectCreatorSource
implements ObjectCreatorSource {
    private final PlasticProxyFactory proxyFactory;
    private final Method bindMethod;
    private final Class serviceInterfaceClass;
    private final Class serviceImplementationClass;
    private final boolean eagerLoad;

    public ReloadableObjectCreatorSource(PlasticProxyFactory proxyFactory, Method bindMethod, Class serviceInterfaceClass, Class serviceImplementationClass, boolean eagerLoad) {
        this.proxyFactory = proxyFactory;
        this.bindMethod = bindMethod;
        this.serviceInterfaceClass = serviceInterfaceClass;
        this.serviceImplementationClass = serviceImplementationClass;
        this.eagerLoad = eagerLoad;
    }

    public ObjectCreator constructCreator(final ServiceBuilderResources resources) {
        return new ObjectCreator(){

            public Object createObject() {
                return ReloadableObjectCreatorSource.this.createReloadableProxy(resources);
            }

            public String toString() {
                return ReloadableObjectCreatorSource.this.proxyFactory.getMethodLocation(ReloadableObjectCreatorSource.this.bindMethod).toString();
            }
        };
    }

    public String getDescription() {
        return String.format("Reloadable %s via %s", this.serviceImplementationClass.getName(), this.proxyFactory.getMethodLocation(this.bindMethod));
    }

    private Object createReloadableProxy(ServiceBuilderResources resources) {
        ReloadableServiceImplementationObjectCreator reloadableCreator = new ReloadableServiceImplementationObjectCreator(resources, this.proxyFactory.getClassLoader(), this.serviceImplementationClass.getName());
        resources.getService(UpdateListenerHub.class).addUpdateListener(reloadableCreator);
        if (this.eagerLoad) {
            reloadableCreator.createObject();
        }
        return this.proxyFactory.createProxy(this.serviceInterfaceClass, reloadableCreator, this.getDescription());
    }
}

