/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JustInTimeObjectCreator<T>
implements ObjectCreator<T>,
EagerLoadServiceProxy,
RegistryShutdownListener {
    private final ServiceActivityTracker tracker;
    private volatile ObjectCreator<T> creator;
    private volatile T object;
    private final String serviceId;

    public JustInTimeObjectCreator(ServiceActivityTracker tracker, ObjectCreator<T> creator, String serviceId) {
        this.tracker = tracker;
        this.creator = creator;
        this.serviceId = serviceId;
    }

    @Override
    public T createObject() {
        if (this.object == null) {
            this.obtainObjectFromCreator();
        }
        return this.object;
    }

    private synchronized void obtainObjectFromCreator() {
        if (this.object != null) {
            return;
        }
        try {
            this.object = this.creator.createObject();
            this.tracker.setStatus(this.serviceId, Status.REAL);
            this.creator = null;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(ServiceMessages.serviceBuildFailure(this.serviceId, ex), ex);
        }
    }

    @Override
    public void eagerLoadService() {
        this.createObject();
    }

    @Override
    public void registryDidShutdown() {
        this.creator = new ObjectCreator<T>(){

            @Override
            public T createObject() {
                throw new IllegalStateException(ServiceMessages.registryShutdown(JustInTimeObjectCreator.this.serviceId));
            }
        };
        this.object = null;
    }
}

