/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceBuilderResources;
import org.apache.tapestry5.ioc.internal.AbstractServiceCreator;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class ServiceBuilderMethodInvoker
extends AbstractServiceCreator {
    private final Method builderMethod;

    public ServiceBuilderMethodInvoker(ServiceBuilderResources resources, String creatorDescription, Method method) {
        super(resources, creatorDescription);
        this.builderMethod = method;
    }

    public Object createObject() {
        final Object moduleInstance = InternalUtils.isStatic(this.builderMethod) ? null : this.resources.getModuleBuilder();
        OperationTracker tracker = this.resources.getTracker();
        return tracker.invoke(String.format("Invoking " + this.creatorDescription, new Object[0]), new Invokable<Object>(){

            @Override
            public Object invoke() {
                OperationTracker tracker = ServiceBuilderMethodInvoker.this.resources.getTracker();
                Object result = null;
                Throwable failure = null;
                try {
                    Object[] parameters = InternalUtils.calculateParametersForMethod(ServiceBuilderMethodInvoker.this.builderMethod, ServiceBuilderMethodInvoker.this.resources, ServiceBuilderMethodInvoker.this.createInjectionResources(), tracker);
                    if (ServiceBuilderMethodInvoker.this.logger.isDebugEnabled()) {
                        ServiceBuilderMethodInvoker.this.logger.debug(IOCMessages.invokingMethod(ServiceBuilderMethodInvoker.this.creatorDescription));
                    }
                    result = ServiceBuilderMethodInvoker.this.builderMethod.invoke(moduleInstance, parameters);
                }
                catch (InvocationTargetException ite) {
                    failure = ite.getTargetException();
                }
                catch (Exception ex) {
                    failure = ex;
                }
                if (failure != null) {
                    throw new RuntimeException(IOCMessages.builderMethodError(ServiceBuilderMethodInvoker.this.creatorDescription, ServiceBuilderMethodInvoker.this.serviceId, failure), failure);
                }
                if (result == null) {
                    throw new RuntimeException(IOCMessages.builderMethodReturnedNull(ServiceBuilderMethodInvoker.this.creatorDescription, ServiceBuilderMethodInvoker.this.serviceId));
                }
                return result;
            }
        });
    }

    public String toString() {
        return this.creatorDescription;
    }
}

