/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.util.Locale;
import java.util.Map;
import org.apache.tapestry.ioc.MessageFormatter;
import org.apache.tapestry.ioc.Messages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.ConcurrentBarrier;
import org.apache.tapestry.ioc.internal.util.Invokable;
import org.apache.tapestry.ioc.internal.util.MessageFormatterImpl;

public abstract class AbstractMessages
implements Messages {
    private final ConcurrentBarrier _barrier = new ConcurrentBarrier();
    private final Map<String, MessageFormatter> _cache = CollectionFactory.newCaseInsensitiveMap();
    private final Locale _locale;

    protected AbstractMessages(Locale locale) {
        this._locale = locale;
    }

    protected abstract String valueForKey(String var1);

    public boolean contains(String key) {
        return this.valueForKey(key) != null;
    }

    public String get(String key) {
        if (this.contains(key)) {
            return this.valueForKey(key);
        }
        return String.format("[[missing key: %s]]", key);
    }

    public MessageFormatter getFormatter(final String key) {
        MessageFormatter result = this._barrier.withRead(new Invokable<MessageFormatter>(){

            @Override
            public MessageFormatter invoke() {
                return (MessageFormatter)AbstractMessages.this._cache.get(key);
            }
        });
        if (result != null) {
            return result;
        }
        final MessageFormatter newFormatter = this.buildMessageFormatter(key);
        this._barrier.withWrite(new Runnable(){

            public void run() {
                AbstractMessages.this._cache.put(key, newFormatter);
            }
        });
        return newFormatter;
    }

    private MessageFormatter buildMessageFormatter(String key) {
        String format = this.get(key);
        return new MessageFormatterImpl(format, this._locale);
    }

    public String format(String key, Object ... args) {
        return this.getFormatter(key).format(args);
    }
}

