/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.internal.services.CompoundCoercion;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InheritanceSearch;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.Coercion;
import org.apache.tapestry.ioc.services.CoercionTuple;
import org.apache.tapestry.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCoercerImpl
implements TypeCoercer {
    private final Map<Class, List<CoercionTuple>> _sourceTypeToTuple = CollectionFactory.newMap();
    private final Map<CacheKey, Coercion> _cache = CollectionFactory.newConcurrentMap();
    private static final Coercion COERCION_NULL_TO_OBJECT = new Coercion<Void, Object>(){

        @Override
        public Object coerce(Void input) {
            return null;
        }

        public String toString() {
            return "null --> null";
        }
    };

    public TypeCoercerImpl(Collection<CoercionTuple> tuples) {
        for (CoercionTuple tuple : tuples) {
            Class key = tuple.getSourceType();
            InternalUtils.addToMapList(this._sourceTypeToTuple, key, tuple);
        }
    }

    public Object coerce(Object input, Class targetType) {
        Object result;
        Defense.notNull(targetType, "targetType");
        Class<Void> sourceType = input != null ? input.getClass() : Void.TYPE;
        Class effectiveTargetType = ClassFabUtils.getWrapperType(targetType);
        if (effectiveTargetType.isAssignableFrom(sourceType)) {
            return input;
        }
        Coercion coercion = this.findCoercion(sourceType, effectiveTargetType);
        try {
            result = coercion.coerce(input);
        }
        catch (Exception ex) {
            throw new RuntimeException(ServiceMessages.failedCoercion(input, targetType, coercion, ex), ex);
        }
        return effectiveTargetType.cast(result);
    }

    @Override
    public <S, T> String explain(Class<S> inputType, Class<T> targetType) {
        Defense.notNull(inputType, "inputType");
        Defense.notNull(targetType, "targetType");
        Class effectiveTargetType = ClassFabUtils.getWrapperType(targetType);
        if (effectiveTargetType.isAssignableFrom(inputType)) {
            return "";
        }
        Coercion coercion = this.findCoercion(inputType, effectiveTargetType);
        return coercion.toString();
    }

    private Coercion findCoercion(Class sourceType, Class targetType) {
        CacheKey key = new CacheKey(sourceType, targetType);
        Coercion result = this._cache.get(key);
        if (result == null) {
            result = this.findOrCreateCoercion(sourceType, targetType);
            this._cache.put(key, result);
        }
        return result;
    }

    @Override
    public void clearCache() {
        this._cache.clear();
    }

    private Coercion findOrCreateCoercion(Class sourceType, Class targetType) {
        Set<CoercionTuple> consideredTuples = CollectionFactory.newSet();
        LinkedList<CoercionTuple> queue = CollectionFactory.newLinkedList();
        this.seedQueue(sourceType, consideredTuples, queue);
        while (!queue.isEmpty()) {
            CoercionTuple tuple = queue.removeFirst();
            Class tupleTargetType = tuple.getTargetType();
            if (targetType.isAssignableFrom(tupleTargetType)) {
                return tuple.getCoercion();
            }
            this.queueIntermediates(sourceType, tuple, consideredTuples, queue);
        }
        if (sourceType == Void.TYPE) {
            return COERCION_NULL_TO_OBJECT;
        }
        throw new IllegalArgumentException(ServiceMessages.noCoercionFound(sourceType, targetType, this.buildCoercionCatalog()));
    }

    private String buildCoercionCatalog() {
        List descriptions = CollectionFactory.newList();
        for (List<CoercionTuple> list : this._sourceTypeToTuple.values()) {
            for (CoercionTuple tuple : list) {
                descriptions.add(tuple.toString());
            }
        }
        return InternalUtils.joinSorted(descriptions);
    }

    private void seedQueue(Class sourceType, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        for (Class c : new InheritanceSearch(sourceType)) {
            List<CoercionTuple> tuples = this._sourceTypeToTuple.get(c);
            if (tuples == null) continue;
            for (CoercionTuple tuple : tuples) {
                queue.addLast(tuple);
                consideredTuples.add(tuple);
            }
        }
    }

    private void queueIntermediates(Class sourceType, CoercionTuple intermediateTuple, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        Class intermediateType = intermediateTuple.getTargetType();
        for (Class c : new InheritanceSearch(intermediateType)) {
            List<CoercionTuple> tuples = this._sourceTypeToTuple.get(c);
            if (tuples == null) continue;
            for (CoercionTuple tuple : tuples) {
                Class newIntermediateType;
                if (consideredTuples.contains(tuple) || sourceType.isAssignableFrom(newIntermediateType = tuple.getTargetType())) continue;
                CompoundCoercion compoundCoercer = new CompoundCoercion(intermediateTuple.getCoercion(), tuple.getCoercion());
                CoercionTuple compoundTuple = new CoercionTuple(sourceType, newIntermediateType, compoundCoercer, false);
                queue.addLast(compoundTuple);
                consideredTuples.add(tuple);
            }
        }
    }

    static class CacheKey {
        private final Class _sourceClass;
        private final Class _targetClass;

        CacheKey(Class sourceClass, Class targetClass) {
            this._sourceClass = sourceClass;
            this._targetClass = targetClass;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this._sourceClass.equals(other._sourceClass) && this._targetClass.equals(other._targetClass);
        }

        public int hashCode() {
            return this._sourceClass.hashCode() * 27 % this._targetClass.hashCode();
        }

        public String toString() {
            return String.format("CacheKey[%s --> %s]", this._sourceClass.getName(), this._targetClass.getName());
        }
    }
}

