/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tapestry.ioc.internal.services.ServiceLogger;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.Builtin;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFabUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.ExceptionTracker;
import org.apache.tapestry.ioc.services.LoggingDecorator;
import org.apache.tapestry.ioc.services.MethodIterator;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.util.BodyBuilder;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDecoratorImpl
implements LoggingDecorator {
    private final ClassFactory _classFactory;
    private final ExceptionTracker _exceptionTracker;

    public LoggingDecoratorImpl(@Builtin ClassFactory classFactory, ExceptionTracker exceptionTracker) {
        this._classFactory = classFactory;
        this._exceptionTracker = exceptionTracker;
    }

    @Override
    public <T> T build(Class<T> serviceInterface, T delegate, String serviceId, Logger logger) {
        Class interceptorClass = this.createInterceptorClass(serviceInterface, serviceId);
        ServiceLogger serviceLogger = new ServiceLogger(logger, this._exceptionTracker);
        Constructor<?> cc = interceptorClass.getConstructors()[0];
        Object interceptor = null;
        Throwable fail = null;
        try {
            interceptor = cc.newInstance(delegate, serviceLogger);
        }
        catch (InvocationTargetException ite) {
            fail = ite.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        if (fail != null) {
            throw new RuntimeException(fail);
        }
        return serviceInterface.cast(interceptor);
    }

    private Class createInterceptorClass(Class serviceInterface, String serviceId) {
        ClassFab cf = this._classFactory.newClass(serviceInterface);
        cf.addField("_delegate", 18, serviceInterface);
        cf.addField("_logger", 18, ServiceLogger.class);
        cf.addConstructor(new Class[]{serviceInterface, ServiceLogger.class}, null, "{ _delegate = $1; _logger = $2; }");
        this.addMethods(cf, serviceInterface, serviceId);
        return cf.createClass();
    }

    private void addMethods(ClassFab cf, Class serviceInterface, String serviceId) {
        MethodIterator mi = new MethodIterator(serviceInterface);
        while (mi.hasNext()) {
            this.addMethod(cf, mi.next());
        }
        if (!mi.getToString()) {
            cf.addToString(ServiceMessages.loggingInterceptor(serviceId, serviceInterface));
        }
    }

    private void addMethod(ClassFab cf, MethodSignature signature) {
        String name = '\"' + signature.getName() + '\"';
        Class returnType = signature.getReturnType();
        boolean isVoid = returnType.equals(Void.TYPE);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("boolean debug = _logger.isDebugEnabled();", new Object[0]);
        builder.addln("if (debug)", new Object[0]);
        builder.addln("  _logger.entry(%s, $args);", name);
        builder.addln("try", new Object[0]);
        builder.begin();
        if (!isVoid) {
            builder.add("%s result = ", ClassFabUtils.toJavaClassName(returnType));
        }
        builder.addln("_delegate.%s($$);", signature.getName());
        if (isVoid) {
            builder.addln("if (debug)", new Object[0]);
            builder.addln(String.format("  _logger.voidExit(%s);", name), new Object[0]);
            builder.addln("return;", new Object[0]);
        } else {
            builder.addln("if (debug)", new Object[0]);
            builder.addln(String.format("  _logger.exit(%s, ($w)result);", name), new Object[0]);
            builder.addln("return result;", new Object[0]);
        }
        builder.end();
        if (signature.getExceptionTypes() != null) {
            for (Class exceptionType : signature.getExceptionTypes()) {
                this.addExceptionHandler(builder, name, exceptionType);
            }
        }
        this.addExceptionHandler(builder, name, RuntimeException.class);
        builder.end();
        cf.addMethod(1, signature, builder.toString());
    }

    private void addExceptionHandler(BodyBuilder builder, String quotedMethodName, Class exceptionType) {
        builder.addln("catch (%s ex)", exceptionType.getName());
        builder.begin();
        builder.addln("if (debug)", new Object[0]);
        builder.addln("  _logger.fail(%s, ex);", quotedMethodName);
        builder.addln("throw ex;", new Object[0]);
        builder.end();
    }
}

