/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry.ioc.internal.services.FilterMethodAnalyzer;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodIterator;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BridgeBuilder<S, F> {
    private final Logger _logger;
    private final Class<S> _serviceInterface;
    private final Class<F> _filterInterface;
    private final ClassFab _classFab;
    private final FilterMethodAnalyzer _filterMethodAnalyzer;
    private Constructor _constructor;

    BridgeBuilder(Logger logger, Class<S> serviceInterface, Class<F> filterInterface, ClassFactory classFactory) {
        this._logger = logger;
        this._serviceInterface = serviceInterface;
        this._filterInterface = filterInterface;
        this._classFab = classFactory.newClass(this._serviceInterface);
        this._filterMethodAnalyzer = new FilterMethodAnalyzer(serviceInterface);
    }

    private void createClass() {
        List serviceMethods = CollectionFactory.newList();
        List filterMethods = CollectionFactory.newList();
        this.createInfrastructure();
        MethodIterator mi = new MethodIterator(this._serviceInterface);
        while (mi.hasNext()) {
            serviceMethods.add(mi.next());
        }
        boolean toStringMethodExists = mi.getToString();
        mi = new MethodIterator(this._filterInterface);
        while (mi.hasNext()) {
            filterMethods.add(mi.next());
        }
        while (!serviceMethods.isEmpty()) {
            MethodSignature ms = (MethodSignature)serviceMethods.remove(0);
            this.addBridgeMethod(ms, filterMethods);
        }
        this.reportExtraFilterMethods(filterMethods);
        if (!toStringMethodExists) {
            String toString = String.format("<PipelineBridge from %s to %s>", this._serviceInterface.getName(), this._filterInterface.getName());
            this._classFab.addToString(toString);
        }
        Class bridgeClass = this._classFab.createClass();
        this._constructor = bridgeClass.getConstructors()[0];
    }

    private void createInfrastructure() {
        this._classFab.addField("_next", 18, this._serviceInterface);
        this._classFab.addField("_filter", 18, this._filterInterface);
        this._classFab.addConstructor(new Class[]{this._serviceInterface, this._filterInterface}, null, "{ _next = $1; _filter = $2; }");
        this._classFab.addInterface(this._serviceInterface);
    }

    public S instantiateBridge(S nextBridge, F filter) {
        if (this._constructor == null) {
            this.createClass();
        }
        try {
            Object instance = this._constructor.newInstance(nextBridge, filter);
            return this._serviceInterface.cast(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void reportExtraFilterMethods(List filterMethods) {
        for (MethodSignature ms : filterMethods) {
            this._logger.error(ServiceMessages.extraFilterMethod(ms, this._filterInterface, this._serviceInterface));
        }
    }

    private void addBridgeMethod(MethodSignature ms, List filterMethods) {
        Iterator i = filterMethods.iterator();
        while (i.hasNext()) {
            MethodSignature fms = (MethodSignature)i.next();
            int position = this._filterMethodAnalyzer.findServiceInterfacePosition(ms, fms);
            if (position < 0) continue;
            this.addBridgeMethod(position, ms, fms);
            i.remove();
            return;
        }
        String message = ServiceMessages.unmatchedServiceMethod(ms, this._filterInterface);
        this._logger.error(message);
        String code = String.format("throw new %s(\"%s\");", RuntimeException.class.getName(), message);
        this._classFab.addMethod(1, ms, code);
    }

    private void addBridgeMethod(int position, MethodSignature ms, MethodSignature fms) {
        int i;
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("return ($r) _filter.");
        buffer.append(ms.getName());
        buffer.append("(");
        boolean comma = false;
        int filterParameterCount = fms.getParameterTypes().length;
        for (i = 0; i < position; ++i) {
            if (comma) {
                buffer.append(", ");
            }
            buffer.append("$");
            buffer.append(i + 1);
            comma = true;
        }
        if (comma) {
            buffer.append(", ");
        }
        buffer.append("_next");
        for (i = position + 1; i < filterParameterCount; ++i) {
            buffer.append(", $");
            buffer.append(i);
        }
        buffer.append(");");
        this._classFab.addMethod(1, ms, buffer.toString());
    }
}

