/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.internal.ConfigurationType;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceCreator
implements ObjectCreator {
    protected final String _serviceId;
    private final Map<Class, Object> _parameterDefaults = CollectionFactory.newMap();
    protected final ServiceBuilderResources _resources;
    protected final Logger _logger;
    private static final Map<Class, ConfigurationType> PARAMETER_TYPE_TO_CONFIGURATION_TYPE = CollectionFactory.newMap();
    protected final String _creatorDescription;

    public AbstractServiceCreator(ServiceBuilderResources resources, String creatorDescription) {
        this._serviceId = resources.getServiceId();
        this._resources = resources;
        this._creatorDescription = creatorDescription;
        this._logger = resources.getLogger();
        this._parameterDefaults.put(String.class, this._serviceId);
        this._parameterDefaults.put(ServiceResources.class, resources);
        this._parameterDefaults.put(Logger.class, this._logger);
        this._parameterDefaults.put(Class.class, resources.getServiceInterface());
    }

    protected final Map<Class, Object> getParameterDefaultsWithConfiguration(Class[] parameterTypes, Type[] genericParameterTypes) {
        Map<Class, Object> result = CollectionFactory.newMap(this._parameterDefaults);
        ConfigurationType type = null;
        block5: for (int i = 0; i < parameterTypes.length; ++i) {
            Class parameterType = parameterTypes[i];
            ConfigurationType thisType = PARAMETER_TYPE_TO_CONFIGURATION_TYPE.get(parameterType);
            if (thisType == null) continue;
            if (type != null) {
                this._logger.warn(IOCMessages.tooManyConfigurationParameters(this._creatorDescription));
                break;
            }
            type = thisType;
            Type genericType = genericParameterTypes[i];
            switch (type) {
                case UNORDERED: {
                    this.addUnorderedConfigurationParameter(result, genericType);
                    continue block5;
                }
                case ORDERED: {
                    this.addOrderedConfigurationParameter(result, genericType);
                    continue block5;
                }
                case MAPPED: {
                    this.addMappedConfigurationParameter(result, genericType);
                }
            }
        }
        return result;
    }

    private void addOrderedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType);
        List configuration = this._resources.getOrderedConfiguration(valueType);
        parameterDefaults.put(List.class, configuration);
    }

    private void addUnorderedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType);
        Collection configuration = this._resources.getUnorderedConfiguration(valueType);
        parameterDefaults.put(Collection.class, configuration);
    }

    private void addMappedConfigurationParameter(Map<Class, Object> parameterDefaults, Type genericType) {
        Class keyType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType, 0);
        Class valueType = AbstractServiceCreator.findParameterizedTypeFromGenericType(genericType, 1);
        if (keyType == null || valueType == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(genericType));
        }
        Map configuration = this._resources.getMappedConfiguration(keyType, valueType);
        parameterDefaults.put(Map.class, configuration);
    }

    static Class findParameterizedTypeFromGenericType(Type type) {
        Class result = AbstractServiceCreator.findParameterizedTypeFromGenericType(type, 0);
        if (result == null) {
            throw new IllegalArgumentException(IOCMessages.genericTypeNotSupported(type));
        }
        return result;
    }

    private static Class findParameterizedTypeFromGenericType(Type type, int typeIndex) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] types = pt.getActualTypeArguments();
        Type actualType = types[typeIndex];
        return actualType instanceof Class ? (Class)actualType : null;
    }

    static {
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Collection.class, ConfigurationType.UNORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(List.class, ConfigurationType.ORDERED);
        PARAMETER_TYPE_TO_CONFIGURATION_TYPE.put(Map.class, ConfigurationType.MAPPED);
    }
}

