/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ExceptionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionInfoImpl
implements ExceptionInfo {
    private final String _className;
    private final String _message;
    private final Map<String, Object> _properties;
    private final List<StackTraceElement> _stackTrace;

    public ExceptionInfoImpl(Throwable t, Map<String, Object> properties, List<StackTraceElement> stackTrace) {
        this._className = t.getClass().getName();
        this._message = t.getMessage() != null ? t.getMessage() : "";
        this._properties = properties;
        this._stackTrace = Collections.unmodifiableList(stackTrace);
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    @Override
    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    @Override
    public List<String> getPropertyNames() {
        return InternalUtils.sortedKeys(this._properties);
    }

    @Override
    public List<StackTraceElement> getStackTrace() {
        return this._stackTrace;
    }
}

