/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.def.ContributionDef;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ModuleDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.InterceptorStackBuilder;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.LifecycleWrappedServiceCreator;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.ObjectLocatorImpl;
import org.apache.tapestry.ioc.internal.RecursiveServiceCreationCheckWrapper;
import org.apache.tapestry.ioc.internal.SerializationSupport;
import org.apache.tapestry.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry.ioc.internal.ServiceProxyToken;
import org.apache.tapestry.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry.ioc.internal.services.JustInTimeObjectCreator;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.apache.tapestry.ioc.services.MethodSignature;
import org.apache.tapestry.ioc.services.Status;
import org.apache.tapestry.ioc.services.TapestryIOCModule;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleImpl
implements Module {
    private final InternalRegistry _registry;
    private final ServiceActivityTracker _tracker;
    private final ModuleDef _moduleDef;
    private final ClassFactory _classFactory;
    private final Logger _logger;
    private Object _moduleBuilder;
    private static final Object MUTEX = new Object();
    private boolean _insideConstructor;
    private final Map<String, Object> _services = CollectionFactory.newCaseInsensitiveMap();

    public ModuleImpl(InternalRegistry registry, ServiceActivityTracker tracker, ModuleDef moduleDef, ClassFactory classFactory, Logger logger) {
        this._registry = registry;
        this._tracker = tracker;
        this._moduleDef = moduleDef;
        this._classFactory = classFactory;
        this._logger = logger;
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        Defense.notBlank(serviceId, "serviceId");
        Defense.notNull(serviceInterface, "serviceInterface");
        ServiceDef def = this._moduleDef.getServiceDef(serviceId);
        assert (def != null);
        Object service = this.findOrCreate(def, null);
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, def.getServiceInterface(), serviceInterface));
        }
    }

    @Override
    public Set<DecoratorDef> findMatchingDecoratorDefs(ServiceDef serviceDef) {
        Set<DecoratorDef> result = CollectionFactory.newSet();
        for (DecoratorDef def : this._moduleDef.getDecoratorDefs()) {
            if (!def.matches(serviceDef)) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public List<ServiceDecorator> findDecoratorsForService(String serviceId) {
        ServiceDef sd = this._moduleDef.getServiceDef(serviceId);
        return this._registry.findDecoratorsForService(sd);
    }

    @Override
    public Collection<String> findServiceIdsForInterface(Class serviceInterface) {
        Defense.notNull(serviceInterface, "serviceInterface");
        List<String> result = CollectionFactory.newList();
        for (String id : this._moduleDef.getServiceIds()) {
            ServiceDef def = this._moduleDef.getServiceDef(id);
            if (!serviceInterface.isAssignableFrom(def.getServiceInterface())) continue;
            result.add(id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findOrCreate(ServiceDef def, List<EagerLoadServiceProxy> eagerLoadProxies) {
        Object object = MUTEX;
        synchronized (object) {
            String key = def.getServiceId();
            Object result = this._services.get(key);
            if (result == null) {
                result = this.create(def, eagerLoadProxies);
                this._services.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eagerLoadServices() {
        List<EagerLoadServiceProxy> proxies = CollectionFactory.newList();
        Object object = MUTEX;
        synchronized (object) {
            for (String serviceId : this._moduleDef.getServiceIds()) {
                ServiceDef def = this._moduleDef.getServiceDef(serviceId);
                if (!def.isEagerLoad()) continue;
                this.findOrCreate(def, proxies);
            }
            for (EagerLoadServiceProxy proxy : proxies) {
                proxy.eagerLoadService();
            }
        }
    }

    private Object create(ServiceDef def, List<EagerLoadServiceProxy> eagerLoadProxies) {
        String serviceId = def.getServiceId();
        Logger logger = this._registry.getServiceLogger(serviceId);
        if (logger.isDebugEnabled()) {
            logger.debug(IOCMessages.creatingService(serviceId));
        }
        try {
            ServiceResourcesImpl resources = new ServiceResourcesImpl(this._registry, this, def, this._classFactory, logger);
            ObjectCreator creator = def.createServiceCreator(resources);
            Class serviceInterface = def.getServiceInterface();
            if (!serviceInterface.isInterface()) {
                return creator.createObject();
            }
            creator = new LifecycleWrappedServiceCreator(this._registry, def.getServiceScope(), resources, creator);
            if (!TapestryIOCModule.class.equals((Object)this._moduleDef.getBuilderClass())) {
                creator = new InterceptorStackBuilder(this, serviceId, creator);
            }
            creator = new RecursiveServiceCreationCheckWrapper(def, creator, logger);
            JustInTimeObjectCreator delegate = new JustInTimeObjectCreator(this._tracker, creator, serviceId);
            Object proxy = this.createProxy(resources, delegate);
            this._registry.addRegistryShutdownListener(delegate);
            if (def.isEagerLoad() && eagerLoadProxies != null) {
                eagerLoadProxies.add(delegate);
            }
            this._tracker.setStatus(serviceId, Status.VIRTUAL);
            return proxy;
        }
        catch (Exception ex) {
            throw new RuntimeException(IOCMessages.errorBuildingService(serviceId, def, ex), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getModuleBuilder() {
        Object object = MUTEX;
        synchronized (object) {
            if (this._moduleBuilder == null) {
                this._moduleBuilder = this.instantiateModuleBuilder();
            }
            return this._moduleBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateModuleBuilder() {
        Class builderClass = this._moduleDef.getBuilderClass();
        Constructor<?>[] constructors = builderClass.getConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException(IOCMessages.noPublicConstructors(builderClass));
        }
        if (constructors.length > 1) {
            Comparator<Constructor> comparator = new Comparator<Constructor>(){

                @Override
                public int compare(Constructor c1, Constructor c2) {
                    return c2.getParameterTypes().length - c1.getParameterTypes().length;
                }
            };
            Arrays.sort(constructors, comparator);
            this._logger.warn(IOCMessages.tooManyPublicConstructors(builderClass, constructors[0]));
        }
        Constructor<?> constructor = constructors[0];
        if (this._insideConstructor) {
            throw new RuntimeException(IOCMessages.recursiveModuleConstructor(builderClass, constructor));
        }
        ObjectLocatorImpl locator = new ObjectLocatorImpl(this._registry, this);
        Map<Class, Object> parameterDefaults = CollectionFactory.newMap();
        parameterDefaults.put(Logger.class, this._logger);
        parameterDefaults.put(ObjectLocator.class, locator);
        Throwable fail = null;
        try {
            this._insideConstructor = true;
            Object[] parameterValues = InternalUtils.calculateParameters(locator, parameterDefaults, constructor.getParameterTypes(), constructor.getParameterAnnotations());
            Object obj = constructor.newInstance(parameterValues);
            return obj;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        finally {
            this._insideConstructor = false;
        }
        throw new RuntimeException(IOCMessages.instantiateBuilderError(builderClass, fail), fail);
    }

    private Object createProxy(ServiceResources resources, ObjectCreator creator) {
        String serviceId = resources.getServiceId();
        Class serviceInterface = resources.getServiceInterface();
        String toString = String.format("<Proxy for %s(%s)>", serviceId, serviceInterface.getName());
        return this.createProxyInstance(creator, serviceId, serviceInterface, toString);
    }

    private Object createProxyInstance(ObjectCreator creator, String serviceId, Class serviceInterface, String description) {
        ServiceProxyToken token = SerializationSupport.createToken(serviceId);
        ClassFab classFab = this._registry.newClass(serviceInterface);
        classFab.addField("_creator", 18, ObjectCreator.class);
        classFab.addField("_token", 18, ServiceProxyToken.class);
        classFab.addConstructor(new Class[]{ObjectCreator.class, ServiceProxyToken.class}, null, "{ _creator = $1; _token = $2; }");
        classFab.addInterface(Serializable.class);
        MethodSignature writeReplaceSig = new MethodSignature(Object.class, "writeReplace", null, new Class[]{ObjectStreamException.class});
        classFab.addMethod(2, writeReplaceSig, "return _token;");
        String body = String.format("return (%s) _creator.createObject();", serviceInterface.getName());
        MethodSignature sig = new MethodSignature(serviceInterface, "_delegate", null, null);
        classFab.addMethod(2, sig, body);
        classFab.proxyMethodsToDelegate(serviceInterface, "_delegate()", description);
        Class proxyClass = classFab.createClass();
        try {
            return proxyClass.getConstructors()[0].newInstance(creator, token);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public Set<ContributionDef> getContributorDefsForService(String serviceId) {
        Set<ContributionDef> result = CollectionFactory.newSet();
        for (ContributionDef def : this._moduleDef.getContributionDefs()) {
            if (!def.getServiceId().equals(serviceId)) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public ServiceDef getServiceDef(String serviceId) {
        return this._moduleDef.getServiceDef(serviceId);
    }

    @Override
    public String getLoggerName() {
        return this._moduleDef.getLoggerName();
    }
}

