/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.JspSupportServlet;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.FreemarkerResult;
import org.apache.struts2.views.freemarker.StrutsBeanWrapper;
import org.apache.tiles.Attribute;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.freemarker.template.TilesFMModelRepository;
import org.apache.tiles.impl.InvalidTemplateException;
import org.apache.tiles.renderer.impl.AbstractTypeDetectingAttributeRenderer;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.apache.tiles.servlet.context.ServletUtil;

public class StrutsFreeMarkerAttributeRenderer
extends AbstractTypeDetectingAttributeRenderer {
    private static Logger LOG = LoggerFactory.getLogger(StrutsFreeMarkerAttributeRenderer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Object value, Attribute attribute, TilesRequestContext request) throws IOException {
        if (value == null) {
            LOG.error("Value is null, cannot render template!", new String[0]);
            throw new InvalidTemplateException("Cannot render a null template");
        }
        if (!(value instanceof String)) {
            LOG.error("Value {} is not a String, cannot render template!", new Object[]{value});
            throw new InvalidTemplateException("Cannot render a template that is not a string: " + String.valueOf(value));
        }
        LOG.trace("Rendering freemarker tile ...", new String[0]);
        ServletTilesRequestContext servletRequest = ServletUtil.getServletRequest((TilesRequestContext)request);
        HttpServletRequest httpRequest = servletRequest.getRequest();
        ActionContext ctx = ServletActionContext.getActionContext((HttpServletRequest)httpRequest);
        if (ctx == null) {
            throw new ConfigurationException("There is no ActionContext for current request!");
        }
        this.registerTilesBeanModel(ctx);
        String include = (String)value;
        FreemarkerResult result = new FreemarkerResult(include);
        result.setWriter(request.getWriter());
        Container container = ctx.getContainer();
        container.inject((Object)result);
        try {
            ActionInvocation invocation = ctx.getActionInvocation();
            result.doExecute(include, invocation);
            return;
        }
        catch (TemplateException e) {
            LOG.error("Exception was thrown during rendering value {}: {}", new Object[]{value, e.getMessage()});
            throw new InvalidTemplateException((Exception)((Object)e));
        }
    }

    public boolean isRenderable(Object value, Attribute attribute, TilesRequestContext request) {
        if (value instanceof String) {
            String string = (String)value;
            return string.startsWith("/") && string.endsWith(".ftl");
        }
        return false;
    }

    protected void registerTilesBeanModel(ActionContext ctx) {
        ServletContext servletContext = ServletActionContext.getServletContext();
        Configuration configuration = ((FreemarkerManager)ctx.getInstance(FreemarkerManager.class)).getConfiguration(servletContext);
        StrutsBeanWrapper wrapper = (StrutsBeanWrapper)((FreemarkerManager)ctx.getInstance(FreemarkerManager.class)).getWrapper();
        LOG.trace("Adding support for Tiles tags, please remember to register {} in web.xml!", new String[]{JspSupportServlet.class.getName()});
        BeanModel tilesBeanModel = new BeanModel((Object)new TilesFMModelRepository(), (BeansWrapper)wrapper);
        configuration.setSharedVariable("tiles", (TemplateModel)tilesBeanModel);
    }
}

