/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.annotations.JSON;
import org.apache.struts2.json.annotations.JSONFieldBridge;
import org.apache.struts2.json.annotations.JSONParameter;
import org.apache.struts2.json.bridge.FieldBridge;
import org.apache.struts2.json.bridge.ParameterizedBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONWriter.class);
    public static final boolean ENUM_AS_BEAN_DEFAULT = false;
    private static char[] hex = "0123456789ABCDEF".toCharArray();
    private static final ConcurrentMap<Class<?>, BeanInfo> BEAN_INFO_CACHE_IGNORE_HIERARCHY = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, BeanInfo> BEAN_INFO_CACHE = new ConcurrentHashMap();
    private StringBuilder buf = new StringBuilder();
    private Stack<Object> stack = new Stack();
    private boolean ignoreHierarchy = true;
    private Object root;
    private boolean buildExpr = true;
    private String exprStack = "";
    private Collection<Pattern> excludeProperties;
    private Collection<Pattern> includeProperties;
    private DateFormat formatter;
    private boolean enumAsBean = false;
    private boolean excludeNullProperties;

    public String write(Object object) throws JSONException {
        return this.write(object, null, null, false);
    }

    public String write(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean excludeNullProperties) throws JSONException {
        this.excludeNullProperties = excludeNullProperties;
        this.buf.setLength(0);
        this.root = object;
        this.exprStack = "";
        this.buildExpr = excludeProperties != null && !excludeProperties.isEmpty() || includeProperties != null && !includeProperties.isEmpty();
        this.excludeProperties = excludeProperties;
        this.includeProperties = includeProperties;
        this.value(object, null);
        return this.buf.toString();
    }

    protected void value(Object object, Method method) throws JSONException {
        if (object == null) {
            this.add("null");
            return;
        }
        if (this.stack.contains(object)) {
            Class<?> clazz = object.getClass();
            if (clazz.isPrimitive() || clazz.equals(String.class)) {
                this.process(object, method);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cyclic reference detected on " + object, new String[0]);
                }
                this.add("null");
            }
            return;
        }
        this.process(object, method);
    }

    protected void process(Object object, Method method) throws JSONException {
        this.stack.push(object);
        if (object instanceof Class) {
            this.string(object);
        } else if (object instanceof Boolean) {
            this.bool((Boolean)object);
        } else if (object instanceof Number) {
            this.add(object);
        } else if (object instanceof String) {
            this.string(object);
        } else if (object instanceof Character) {
            this.string(object);
        } else if (object instanceof Map) {
            this.map((Map)object, method);
        } else if (object.getClass().isArray()) {
            this.array(object, method);
        } else if (object instanceof Iterable) {
            this.array(((Iterable)object).iterator(), method);
        } else if (object instanceof Date) {
            this.date((Date)object, method);
        } else if (object instanceof Calendar) {
            this.date(((Calendar)object).getTime(), method);
        } else if (object instanceof Locale) {
            this.string(object);
        } else if (object instanceof Enum) {
            this.enumeration((Enum)object);
        } else {
            this.processCustom(object, method);
        }
        this.stack.pop();
    }

    protected void processCustom(Object object, Method method) throws JSONException {
        this.bean(object);
    }

    protected void bean(Object object) throws JSONException {
        this.add("{");
        try {
            Class<?> clazz = object.getClass();
            BeanInfo info = object == this.root && this.ignoreHierarchy ? this.getBeanInfoIgnoreHierarchy(clazz) : this.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            boolean hasData = false;
            for (PropertyDescriptor prop : props) {
                String name = prop.getName();
                Method accessor = prop.getReadMethod();
                Method baseAccessor = this.findBaseAccessor(clazz, accessor);
                if (baseAccessor == null) continue;
                if (baseAccessor.isAnnotationPresent(JSON.class)) {
                    JSONAnnotationFinder jsonFinder = new JSONAnnotationFinder(baseAccessor).invoke();
                    if (!jsonFinder.shouldSerialize()) continue;
                    if (jsonFinder.getName() != null) {
                        name = jsonFinder.getName();
                    }
                }
                if (this.shouldExcludeProperty(prop)) continue;
                String expr = null;
                if (this.buildExpr) {
                    expr = this.expandExpr(name);
                    if (this.shouldExcludeProperty(expr)) continue;
                    expr = this.setExprStack(expr);
                }
                Object value = accessor.invoke(object, new Object[0]);
                if (baseAccessor.isAnnotationPresent(JSONFieldBridge.class)) {
                    value = this.getBridgedValue(baseAccessor, value);
                }
                boolean propertyPrinted = this.add(name, value, accessor, hasData);
                boolean bl = hasData = hasData || propertyPrinted;
                if (!this.buildExpr) continue;
                this.setExprStack(expr);
            }
            if (object instanceof Enum) {
                String value = ((Enum)object).name();
                this.add("_name", value, object.getClass().getMethod("name", new Class[0]), hasData);
            }
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        this.add("}");
    }

    protected BeanInfo getBeanInfoIgnoreHierarchy(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)BEAN_INFO_CACHE_IGNORE_HIERARCHY.get(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        beanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
        BEAN_INFO_CACHE_IGNORE_HIERARCHY.put(clazz, beanInfo);
        return beanInfo;
    }

    protected BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo = (BeanInfo)BEAN_INFO_CACHE.get(clazz);
        if (beanInfo != null) {
            return beanInfo;
        }
        beanInfo = Introspector.getBeanInfo(clazz);
        BEAN_INFO_CACHE.put(clazz, beanInfo);
        return beanInfo;
    }

    protected Object getBridgedValue(Method baseAccessor, Object value) throws InstantiationException, IllegalAccessException {
        JSONFieldBridge fieldBridgeAnn = baseAccessor.getAnnotation(JSONFieldBridge.class);
        if (fieldBridgeAnn != null) {
            Class<? extends FieldBridge> impl = fieldBridgeAnn.impl();
            FieldBridge instance = impl.newInstance();
            if (fieldBridgeAnn.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(impl)) {
                HashMap<String, String> params = new HashMap<String, String>(fieldBridgeAnn.params().length);
                for (JSONParameter param : fieldBridgeAnn.params()) {
                    params.put(param.name(), param.value());
                }
                ((ParameterizedBridge)((Object)instance)).setParameterValues(params);
            }
            value = instance.objectToString(value);
        }
        return value;
    }

    protected Method findBaseAccessor(Class clazz, Method accessor) {
        Method baseAccessor = null;
        if (clazz.getName().contains("$$EnhancerByCGLIB$$")) {
            try {
                baseAccessor = Thread.currentThread().getContextClassLoader().loadClass(clazz.getName().substring(0, clazz.getName().indexOf("$$"))).getMethod(accessor.getName(), accessor.getParameterTypes());
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
            }
        } else if (clazz.getName().contains("$$_javassist")) {
            try {
                baseAccessor = Class.forName(clazz.getName().substring(0, clazz.getName().indexOf("_$$"))).getMethod(accessor.getName(), accessor.getParameterTypes());
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
            }
        } else if (clazz.getName().contains("$$_jvst")) {
            try {
                baseAccessor = Class.forName(clazz.getName().substring(0, clazz.getName().indexOf("_$$"))).getMethod(accessor.getName(), accessor.getParameterTypes());
            }
            catch (Exception ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
            }
        } else {
            return accessor;
        }
        return baseAccessor;
    }

    protected void enumeration(Enum enumeration) throws JSONException {
        if (this.enumAsBean) {
            this.bean(enumeration);
        } else {
            this.string(enumeration.name());
        }
    }

    protected boolean shouldExcludeProperty(PropertyDescriptor prop) throws SecurityException, NoSuchFieldException {
        String name = prop.getName();
        return name.equals("class") || name.equals("declaringClass") || name.equals("cachedSuperClass") || name.equals("metaClass");
    }

    protected String expandExpr(int i) {
        return this.exprStack + "[" + i + "]";
    }

    protected String expandExpr(String property) {
        if (this.exprStack.length() == 0) {
            return property;
        }
        return this.exprStack + "." + property;
    }

    protected String setExprStack(String expr) {
        String s = this.exprStack;
        this.exprStack = expr;
        return s;
    }

    protected boolean shouldExcludeProperty(String expr) {
        if (this.excludeProperties != null) {
            for (Pattern pattern : this.excludeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring property because of exclude rule: " + expr, new String[0]);
                }
                return true;
            }
        }
        if (this.includeProperties != null) {
            for (Pattern pattern : this.includeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring property because of include rule:  " + expr, new String[0]);
            }
            return true;
        }
        return false;
    }

    protected boolean add(String name, Object value, Method method, boolean hasData) throws JSONException {
        if (this.excludeNullProperties && value == null) {
            return false;
        }
        if (hasData) {
            this.add(',');
        }
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value, method);
        return true;
    }

    protected void map(Map map, Method method) throws JSONException {
        this.add("{");
        Iterator it = map.entrySet().iterator();
        boolean warnedNonString = false;
        boolean hasData = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (this.excludeNullProperties && entry.getValue() == null) continue;
            Object key = entry.getKey();
            if (key == null) {
                LOG.error("Cannot build expression for null key in #0", new String[]{this.exprStack});
                continue;
            }
            String expr = null;
            if (this.buildExpr) {
                expr = this.expandExpr(key.toString());
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            if (!warnedNonString && !(key instanceof String)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("JavaScript doesn't support non-String keys, using toString() on #0", new String[]{key.getClass().getName()});
                }
                warnedNonString = true;
            }
            this.value(key.toString(), method);
            this.add(":");
            this.value(entry.getValue(), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("}");
    }

    protected void date(Date date, Method method) {
        JSON json = null;
        if (method != null) {
            json = method.getAnnotation(JSON.class);
        }
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        DateFormat formatter = json != null && json.format().length() > 0 ? new SimpleDateFormat(json.format()) : this.formatter;
        this.string(formatter.format(date));
    }

    /*
     * Unable to fully structure code
     */
    protected void array(Iterator it, Method method) throws JSONException {
        this.add("[");
        hasData = false;
        i = 0;
        while (it.hasNext()) {
            expr = null;
            if (!this.buildExpr) ** GOTO lbl13
            expr = this.expandExpr(i);
            if (this.shouldExcludeProperty(expr)) {
                it.next();
            } else {
                expr = this.setExprStack(expr);
lbl13:
                // 2 sources

                if (hasData) {
                    this.add(',');
                }
                hasData = true;
                this.value(it.next(), method);
                if (this.buildExpr) {
                    this.setExprStack(expr);
                }
            }
            ++i;
        }
        this.add("]");
    }

    protected void array(Object object, Method method) throws JSONException {
        this.add("[");
        int length = Array.getLength(object);
        boolean hasData = false;
        for (int i = 0; i < length; ++i) {
            String expr = null;
            if (this.buildExpr) {
                expr = this.expandExpr(i);
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            this.value(Array.get(object, i), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("]");
    }

    protected void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    protected void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    protected void add(Object obj) {
        this.buf.append(obj);
    }

    protected void add(char c) {
        this.buf.append(c);
    }

    protected void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setEnumAsBean(boolean enumAsBean) {
        this.enumAsBean = enumAsBean;
    }

    public void setDateFormatter(String defaultDateFormat) {
        if (defaultDateFormat != null) {
            this.formatter = new SimpleDateFormat(defaultDateFormat);
        }
    }

    protected static class JSONAnnotationFinder {
        private boolean serialize = true;
        private Method accessor;
        private String name;

        public JSONAnnotationFinder(Method accessor) {
            this.accessor = accessor;
        }

        public boolean shouldSerialize() {
            return this.serialize;
        }

        public String getName() {
            return this.name;
        }

        public JSONAnnotationFinder invoke() {
            JSON json = this.accessor.getAnnotation(JSON.class);
            this.serialize = json.serialize();
            if (this.serialize && json.name().length() > 0) {
                this.name = json.name();
            }
            return this;
        }
    }
}

