/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StreamingUpdateSolrServer
extends CommonsHttpSolrServer {
    static final Logger log = LoggerFactory.getLogger(StreamingUpdateSolrServer.class);
    final BlockingQueue<UpdateRequest> queue;
    final ExecutorService scheduler = Executors.newCachedThreadPool();
    final String updateUrl = "/update";
    final Queue<Runner> runners;
    volatile CountDownLatch lock = null;
    final int threadCount;

    public StreamingUpdateSolrServer(String solrServerUrl, int queueSize, int threadCount) throws MalformedURLException {
        this(solrServerUrl, null, queueSize, threadCount);
    }

    public StreamingUpdateSolrServer(String solrServerUrl, HttpClient client, int queueSize, int threadCount) throws MalformedURLException {
        super(solrServerUrl, client);
        this.queue = new LinkedBlockingQueue<UpdateRequest>(queueSize);
        this.threadCount = threadCount;
        this.runners = new LinkedList<Runner>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        if (!(request instanceof UpdateRequest)) {
            return super.request(request);
        }
        UpdateRequest req = (UpdateRequest)request;
        if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
            this.blockUntilFinished();
            return super.request(request);
        }
        ModifiableSolrParams params = req.getParams();
        if (params != null && params.getBool("waitSearcher", false)) {
            log.info("blocking for commit/optimize");
            this.blockUntilFinished();
            return super.request(request);
        }
        try {
            CountDownLatch tmpLock = this.lock;
            if (tmpLock != null) {
                tmpLock.await();
            }
            boolean success = this.queue.offer(req);
            while (true) {
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    if (this.runners.isEmpty() || this.queue.remainingCapacity() < this.queue.size() && this.runners.size() < this.threadCount) {
                        Runner r = new Runner();
                        this.runners.add(r);
                        this.scheduler.execute(r);
                    } else if (success) {
                        break;
                    }
                }
                if (success) continue;
                success = this.queue.offer(req, 100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("interrupted", (Throwable)e);
            throw new IOException(e.getLocalizedMessage());
        }
        NamedList<Object> dummy = new NamedList<Object>();
        dummy.add("NOTE", "the request is processed in a background stream");
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blockUntilFinished() {
        this.lock = new CountDownLatch(1);
        try {
            while (true) {
                Runner runner;
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    runner = this.runners.peek();
                }
                if (runner == null) {
                    break;
                }
                runner.runnerLock.lock();
                runner.runnerLock.unlock();
            }
        }
        finally {
            this.lock.countDown();
            this.lock = null;
        }
    }

    public void handleError(Throwable ex) {
        log.error("error", ex);
    }

    class Runner
    implements Runnable {
        final Lock runnerLock = new ReentrantLock();

        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.runnerLock.lock();
            log.info("starting runner: {}", (Object)this);
            PostMethod method = null;
            try {
                while (!StreamingUpdateSolrServer.this.queue.isEmpty()) {
                    try {
                        final UpdateRequest updateRequest = StreamingUpdateSolrServer.this.queue.poll(250L, TimeUnit.MILLISECONDS);
                        if (updateRequest == null) {
                            return;
                        }
                        RequestEntity request = new RequestEntity(){

                            public long getContentLength() {
                                return -1L;
                            }

                            public String getContentType() {
                                return StreamingUpdateSolrServer.this.requestWriter.getUpdateContentType();
                            }

                            public boolean isRepeatable() {
                                return false;
                            }

                            public void writeRequest(OutputStream out) throws IOException {
                                try {
                                    if ("application/xml; charset=UTF-8".equals(StreamingUpdateSolrServer.this.requestWriter.getUpdateContentType())) {
                                        out.write("<stream>".getBytes("UTF-8"));
                                    }
                                    UpdateRequest req = updateRequest;
                                    while (req != null) {
                                        ModifiableSolrParams params;
                                        StreamingUpdateSolrServer.this.requestWriter.write(req, out);
                                        if ("application/xml; charset=UTF-8".equals(StreamingUpdateSolrServer.this.requestWriter.getUpdateContentType()) && (params = req.getParams()) != null) {
                                            String fmt = null;
                                            if (params.getBool("optimize", false)) {
                                                fmt = "<optimize waitSearcher=\"%s\" waitFlush=\"%s\" />";
                                            } else if (params.getBool("commit", false)) {
                                                fmt = "<commit waitSearcher=\"%s\" waitFlush=\"%s\" />";
                                            }
                                            if (fmt != null) {
                                                byte[] content = String.format(fmt, params.getBool("waitSearcher", false) + "").getBytes("UTF-8");
                                                out.write(content);
                                            }
                                        }
                                        out.flush();
                                        req = StreamingUpdateSolrServer.this.queue.poll(250L, TimeUnit.MILLISECONDS);
                                    }
                                    if ("application/xml; charset=UTF-8".equals(StreamingUpdateSolrServer.this.requestWriter.getUpdateContentType())) {
                                        out.write("</stream>".getBytes("UTF-8"));
                                    }
                                    out.flush();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        String path = "application/xml; charset=UTF-8".equals(StreamingUpdateSolrServer.this.requestWriter.getUpdateContentType()) ? "/update" : "/update/javabin";
                        method = new PostMethod(StreamingUpdateSolrServer.this._baseURL + path);
                        method.setRequestEntity(request);
                        method.setFollowRedirects(false);
                        method.addRequestHeader("User-Agent", CommonsHttpSolrServer.AGENT);
                        int statusCode = StreamingUpdateSolrServer.this.getHttpClient().executeMethod((HttpMethod)method);
                        log.info("Status for: " + updateRequest.getDocuments().get(0).getFieldValue("id") + " is " + statusCode);
                        if (statusCode == 200) continue;
                        StringBuilder msg = new StringBuilder();
                        msg.append(method.getStatusLine().getReasonPhrase());
                        msg.append("\n\n");
                        msg.append(method.getStatusText());
                        msg.append("\n\n");
                        msg.append("request: ").append(method.getURI());
                        StreamingUpdateSolrServer.this.handleError(new Exception(msg.toString()));
                    }
                    finally {
                        try {
                            if (method == null) continue;
                            method.releaseConnection();
                        }
                        catch (Exception ex) {}
                    }
                }
                return;
            }
            catch (Throwable e) {
                StreamingUpdateSolrServer.this.handleError(e);
                return;
            }
            finally {
                Queue<Runner> ex = StreamingUpdateSolrServer.this.runners;
                synchronized (ex) {
                    if (StreamingUpdateSolrServer.this.runners.size() == 1 && StreamingUpdateSolrServer.this.queue.remainingCapacity() == 0) {
                        StreamingUpdateSolrServer.this.scheduler.execute(this);
                    } else {
                        StreamingUpdateSolrServer.this.runners.remove(this);
                    }
                }
                log.info("finished: {}", (Object)this);
                this.runnerLock.unlock();
            }
        }
    }
}

