/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import javax.portlet.PortletRequest;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.apache.pluto.testsuite.test.ExpectedResults;

public class SecurityMappingTest
extends AbstractReflectivePortletTest {
    protected TestResult checkIsUserInMappedRole(PortletRequest request) {
        TestResult result = this.isUserLoggedIn(request);
        result.setDescription("Test if user is in mapped role.");
        if (result.getReturnCode() == 0) {
            return result;
        }
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String role = expectedResults.getMappedSecurityRole();
        if (request.isUserInRole(role)) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(0);
            result.setResultMessage("User is not in the expected role: " + role + ". This may be due to misconfiuration.");
        }
        return result;
    }

    protected TestResult checkIsUserInUnmappedRole(PortletRequest request) {
        TestResult result = this.isUserLoggedIn(request);
        result.setDescription("Test if user is in unmapped role");
        if (result.getReturnCode() == 0) {
            return result;
        }
        ExpectedResults expectedResults = ExpectedResults.getInstance();
        String role = expectedResults.getUnmappedSecurityRole();
        if (request.isUserInRole(role)) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(0);
            result.setResultMessage("User is not in the expected role: " + role + ". This may be due to misconfiuration.");
        }
        return result;
    }

    protected TestResult checkIsUserIndUndeclaredRole(PortletRequest request) {
        TestResult result = this.isUserLoggedIn(request);
        result.setDescription("Test if user is in undeclared role");
        if (result.getReturnCode() == 0) {
            return result;
        }
        String fakeRole = "fakeTestRoleFooBar";
        if (!request.isUserInRole(fakeRole)) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("User is in the fake role named " + fakeRole);
        }
        return result;
    }

    private TestResult isUserLoggedIn(PortletRequest request) {
        TestResult result = new TestResult();
        if (request.getRemoteUser() == null) {
            result.setReturnCode(0);
            result.setResultMessage("User is not logged in.");
        }
        return result;
    }
}

