/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.io.IOException;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.AbstractReflectivePortletTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderResponseNoContentTypeTest
extends AbstractReflectivePortletTest {
    private static final Logger LOG = LoggerFactory.getLogger(RenderResponseNoContentTypeTest.class);

    public String getRenderResponseContentType() {
        return null;
    }

    protected TestResult checkGetPortletOutputStream(PortletResponse response) {
        TestResult result = new TestResult();
        result.setDescription("Ensure If the getPortletOutputStream() method is called before the setContentType() method, it will throw an IllegalStateException.");
        result.setSpecPLT("12.3.1");
        RenderResponse renderResponse = (RenderResponse)response;
        this.ensureContentTypeNotSet(renderResponse, result);
        if (result.getReturnCode() == 0) {
            return result;
        }
        try {
            renderResponse.getPortletOutputStream();
            result.setReturnCode(1);
            result.setResultMessage("Method getPortletOutputStream() didn't throw an IllegalStateException when content type is not set before.");
        }
        catch (IllegalStateException ex) {
            result.setReturnCode(2);
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Method getPortletOutputStream() throws an unexpected IOException", (Throwable)ex, (TestResult)result);
        }
        return result;
    }

    protected TestResult checkGetWriter(PortletResponse response) {
        TestResult result = new TestResult();
        result.setDescription("Ensure If the getWriter() method is called before the setContentType() method, it will throw an IllegalStateException.");
        result.setSpecPLT("12.3.1");
        RenderResponse renderResponse = (RenderResponse)response;
        this.ensureContentTypeNotSet(renderResponse, result);
        if (result.getReturnCode() == 0) {
            return result;
        }
        try {
            renderResponse.getWriter();
            result.setReturnCode(1);
            result.setResultMessage("Method getWriter() didn't throw an IllegalStateException when content type is not set before.");
        }
        catch (IllegalStateException ex) {
            result.setReturnCode(2);
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Method getWriter() throws an unexpected IOException", (Throwable)ex, (TestResult)result);
        }
        return result;
    }

    private void ensureContentTypeNotSet(RenderResponse response, TestResult result) {
        String contentType = response.getContentType();
        if (contentType != null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unable to run test: content type is already set (" + contentType + ").");
            }
            result.setReturnCode(0);
            result.setResultMessage("The content type of the render response is not as expected (" + contentType + " != null).");
        }
    }
}

