/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hwpf.model.PICF;
import org.apache.poi.hwpf.model.PICFAndOfficeArtData;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.PngUtils;
import org.apache.poi.util.StringUtil;

public final class Picture {
    @Deprecated
    public static final byte[] BMP = new byte[]{66, 77};
    public static final byte[] COMPRESSED1 = new byte[]{-2, 120, -38};
    public static final byte[] COMPRESSED2 = new byte[]{-2, 120, -100};
    @Deprecated
    public static final byte[] EMF = new byte[]{1, 0, 0, 0};
    @Deprecated
    public static final byte[] GIF = new byte[]{71, 73, 70};
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    @Deprecated
    public static final byte[] JPG = new byte[]{-1, -40};
    private static final POILogger log = POILogFactory.getLogger(Picture.class);
    @Deprecated
    public static final byte[] PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    @Deprecated
    public static final byte[] TIFF = new byte[]{73, 73, 42, 0};
    @Deprecated
    public static final byte[] TIFF1 = new byte[]{77, 77, 0, 42};
    @Deprecated
    public static final byte[] WMF1 = new byte[]{-41, -51, -58, -102, 0, 0};
    @Deprecated
    public static final byte[] WMF2 = new byte[]{1, 0, 9, 0, 0, 3};
    private PICF _picf;
    private PICFAndOfficeArtData _picfAndOfficeArtData;
    private List<? extends EscherRecord> _blipRecords;
    private byte[] content;
    private int dataBlockStartOfsset;
    private int height = -1;
    private int width = -1;

    private static int getBigEndianInt(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
    }

    private static int getBigEndianShort(byte[] data, int offset) {
        return ((data[offset] & 0xFF) << 8) + (data[offset + 1] & 0xFF);
    }

    private static boolean matchSignature(byte[] pictureData, byte[] signature, int offset) {
        boolean matched = offset < pictureData.length;
        for (int i = 0; i + offset < pictureData.length && i < signature.length; ++i) {
            if (pictureData[i + offset] == signature[i]) continue;
            matched = false;
            break;
        }
        return matched;
    }

    public Picture(EscherBlipRecord blipRecord) {
        this._blipRecords = Arrays.asList(blipRecord);
    }

    public Picture(int dataBlockStartOfsset, byte[] _dataStream, boolean fillBytes) {
        this._picfAndOfficeArtData = new PICFAndOfficeArtData(_dataStream, dataBlockStartOfsset);
        this._picf = this._picfAndOfficeArtData.getPicf();
        this.dataBlockStartOfsset = dataBlockStartOfsset;
        if (this._picfAndOfficeArtData != null && this._picfAndOfficeArtData.getBlipRecords() != null) {
            this._blipRecords = this._picfAndOfficeArtData.getBlipRecords();
        }
        if (fillBytes) {
            this.fillImageContent();
        }
    }

    private void fillImageContent() {
        if (this.content != null && this.content.length > 0) {
            return;
        }
        byte[] rawContent = this.getRawContent();
        if (Picture.matchSignature(rawContent, COMPRESSED1, 32) || Picture.matchSignature(rawContent, COMPRESSED2, 32)) {
            try {
                int readBytes;
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(rawContent, 33, rawContent.length - 33));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((readBytes = in.read(buf)) > 0) {
                    out.write(buf, 0, readBytes);
                }
                this.content = out.toByteArray();
            }
            catch (IOException e) {
                log.log(3, new Object[]{"Possibly corrupt compression or non-compressed data", e});
            }
        } else {
            this.content = rawContent;
            if (PngUtils.matchesPngHeader((byte[])this.content, (int)16)) {
                byte[] png = new byte[this.content.length - 16];
                System.arraycopy(this.content, 16, png, 0, png.length);
                this.content = png;
            }
        }
    }

    private void fillJPGWidthHeight() {
        byte[] jpegContent = this.getContent();
        int pointer = 2;
        byte firstByte = jpegContent[pointer];
        byte secondByte = jpegContent[pointer + 1];
        int endOfPicture = jpegContent.length;
        while (pointer < endOfPicture - 1) {
            do {
                firstByte = jpegContent[pointer];
                secondByte = jpegContent[pointer + 1];
            } while (firstByte != -1 && (pointer += 2) < endOfPicture - 1);
            if (firstByte == -1 && pointer < endOfPicture - 1) {
                if (secondByte == -39 || secondByte == -38) break;
                if ((secondByte & 0xF0) == 192 && secondByte != -60 && secondByte != -56 && secondByte != -52) {
                    this.height = Picture.getBigEndianShort(jpegContent, pointer += 5);
                    this.width = Picture.getBigEndianShort(jpegContent, pointer + 2);
                    break;
                }
                ++pointer;
                int length = Picture.getBigEndianShort(jpegContent, ++pointer);
                pointer += length;
                continue;
            }
            ++pointer;
        }
    }

    void fillPNGWidthHeight() {
        int HEADER_START;
        byte[] pngContent = this.getContent();
        if (Picture.matchSignature(pngContent, IHDR, HEADER_START = PNG.length + 4)) {
            int IHDR_CHUNK_WIDTH = HEADER_START + 4;
            this.width = Picture.getBigEndianInt(pngContent, IHDR_CHUNK_WIDTH);
            this.height = Picture.getBigEndianInt(pngContent, IHDR_CHUNK_WIDTH + 4);
        }
    }

    private void fillWidthHeight() {
        PictureType pictureType = this.suggestPictureType();
        switch (pictureType) {
            case JPEG: {
                this.fillJPGWidthHeight();
                break;
            }
            case PNG: {
                this.fillPNGWidthHeight();
                break;
            }
        }
    }

    @Deprecated
    public int getAspectRatioX() {
        return this._picf.getMx() / 10;
    }

    @Deprecated
    public int getAspectRatioY() {
        return this._picf.getMy() / 10;
    }

    public byte[] getContent() {
        this.fillImageContent();
        return this.content;
    }

    @Deprecated
    public int getDxaCropLeft() {
        return this._picf.getDxaReserved1();
    }

    @Deprecated
    public int getDxaCropRight() {
        return this._picf.getDxaReserved2();
    }

    public int getDxaGoal() {
        return this._picf.getDxaGoal();
    }

    @Deprecated
    public int getDyaCropBottom() {
        return this._picf.getDyaReserved2();
    }

    @Deprecated
    public int getDyaCropTop() {
        return this._picf.getDyaReserved1();
    }

    public int getDyaGoal() {
        return this._picf.getDyaGoal();
    }

    public int getHeight() {
        if (this.height == -1) {
            this.fillWidthHeight();
        }
        return this.height;
    }

    public int getHorizontalScalingFactor() {
        return this._picf.getMx();
    }

    public String getMimeType() {
        return this.suggestPictureType().getMime();
    }

    public byte[] getRawContent() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return new byte[0];
        }
        EscherRecord escherRecord = this._blipRecords.get(0);
        if (escherRecord instanceof EscherBlipRecord) {
            return ((EscherBlipRecord)escherRecord).getPicturedata();
        }
        if (escherRecord instanceof EscherBSERecord) {
            return ((EscherBSERecord)escherRecord).getBlipRecord().getPicturedata();
        }
        return new byte[0];
    }

    public int getSize() {
        return this.getContent().length;
    }

    public int getStartOffset() {
        return this.dataBlockStartOfsset;
    }

    public int getVerticalScalingFactor() {
        return this._picf.getMy();
    }

    public int getWidth() {
        if (this.width == -1) {
            this.fillWidthHeight();
        }
        return this.width;
    }

    public String getDescription() {
        for (EscherRecord escherRecord : this._picfAndOfficeArtData.getShape().getChildRecords()) {
            if (!(escherRecord instanceof EscherOptRecord)) continue;
            EscherOptRecord escherOptRecord = (EscherOptRecord)escherRecord;
            for (EscherProperty property : escherOptRecord.getEscherProperties()) {
                if (897 != property.getPropertyNumber()) continue;
                byte[] complexData = ((EscherComplexProperty)property).getComplexData();
                return StringUtil.getFromUnicodeLE((byte[])complexData, (int)0, (int)(complexData.length / 2 - 1));
            }
        }
        return null;
    }

    public String suggestFileExtension() {
        return this.suggestPictureType().getExtension();
    }

    public String suggestFullFileName() {
        String fileExt = this.suggestFileExtension();
        return Integer.toHexString(this.dataBlockStartOfsset) + (fileExt.length() > 0 ? "." + fileExt : "");
    }

    public PictureType suggestPictureType() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return PictureType.UNKNOWN;
        }
        EscherRecord escherRecord = this._blipRecords.get(0);
        switch (escherRecord.getRecordId()) {
            case -4089: {
                EscherBSERecord bseRecord = (EscherBSERecord)escherRecord;
                switch (bseRecord.getBlipTypeWin32()) {
                    case 0: {
                        return PictureType.UNKNOWN;
                    }
                    case 1: {
                        return PictureType.UNKNOWN;
                    }
                    case 2: {
                        return PictureType.EMF;
                    }
                    case 3: {
                        return PictureType.WMF;
                    }
                    case 4: {
                        return PictureType.PICT;
                    }
                    case 5: {
                        return PictureType.JPEG;
                    }
                    case 6: {
                        return PictureType.PNG;
                    }
                    case 7: {
                        return PictureType.BMP;
                    }
                    case 17: {
                        return PictureType.TIFF;
                    }
                    case 18: {
                        return PictureType.JPEG;
                    }
                }
                return PictureType.UNKNOWN;
            }
            case -4070: {
                return PictureType.EMF;
            }
            case -4069: {
                return PictureType.WMF;
            }
            case -4068: {
                return PictureType.PICT;
            }
            case -4067: {
                return PictureType.JPEG;
            }
            case -4066: {
                return PictureType.PNG;
            }
            case -4065: {
                return PictureType.BMP;
            }
            case -4055: {
                return PictureType.TIFF;
            }
            case -4054: {
                return PictureType.JPEG;
            }
        }
        return PictureType.UNKNOWN;
    }

    public void writeImageContent(OutputStream out) throws IOException {
        byte[] content = this.getContent();
        if (content != null && content.length > 0) {
            out.write(content, 0, content.length);
        }
    }
}

