/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.Constants;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.internal.InternalPortletPreference;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.internal.PortletEntity;
import org.apache.pluto.internal.impl.PortletPreferenceImpl;
import org.apache.pluto.spi.optional.PortletPreferencesService;
import org.apache.pluto.util.StringManager;

public class PortletPreferencesImpl
implements PortletPreferences {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$PortletPreferencesImpl == null ? (class$org$apache$pluto$internal$impl$PortletPreferencesImpl = PortletPreferencesImpl.class$("org.apache.pluto.internal.impl.PortletPreferencesImpl")) : class$org$apache$pluto$internal$impl$PortletPreferencesImpl));
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$impl$PortletPreferencesImpl == null ? (class$org$apache$pluto$internal$impl$PortletPreferencesImpl = PortletPreferencesImpl.class$("org.apache.pluto.internal.impl.PortletPreferencesImpl")) : class$org$apache$pluto$internal$impl$PortletPreferencesImpl).getPackage().getName());
    private final PortletPreferencesService preferencesService;
    private final InternalPortletWindow window;
    private final InternalPortletRequest request;
    private final InternalPortletPreference[] defaultPreferences;
    private final Map preferences = new HashMap();
    private final Integer methodId;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletPreferencesImpl;

    public PortletPreferencesImpl(PortletContainer container, InternalPortletWindow window, InternalPortletRequest request, Integer methodId) {
        this.window = window;
        this.request = request;
        this.methodId = methodId;
        this.preferencesService = container.getOptionalContainerServices().getPortletPreferencesService();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using PortletPreferencesService: " + this.preferencesService.getClass().getName()));
        }
        PortletEntity entity = window.getPortletEntity();
        this.defaultPreferences = entity.getDefaultPreferences();
        for (int i = 0; i < this.defaultPreferences.length; ++i) {
            this.preferences.put(this.defaultPreferences[i].getName(), this.defaultPreferences[i].clone());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded default preferences: " + this.toString()));
        }
        try {
            InternalPortletPreference[] storedPreferences = this.preferencesService.getStoredPreferences(window, request);
            for (int i = 0; i < storedPreferences.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Merging stored preference: " + storedPreferences[i].getName()));
                }
                this.preferences.put(storedPreferences[i].getName(), storedPreferences[i]);
            }
            this.internalStore();
        }
        catch (PortletContainerException ex) {
            LOG.error((Object)"Error retrieving preferences.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)"Error retrieving preferences.", (Throwable)ex);
        }
        catch (ValidatorException ex) {
            LOG.warn((Object)"ValidatorException initializing portlet preferences. This is not illegal at this point since we are just retreiving from portlet.xml.", (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Merged stored preferences: " + this.toString()));
        }
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException(EXCEPTIONS.getString("error.null", "Preference key "));
        }
        InternalPortletPreference pref = (InternalPortletPreference)this.preferences.get(key);
        return pref != null && pref.isReadOnly();
    }

    public String getValue(String key, String defaultValue) {
        String[] values = this.getValues(key, new String[]{defaultValue});
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getValues(String key, String[] defaultValues) {
        if (key == null) {
            throw new IllegalArgumentException(EXCEPTIONS.getString("error.null", "Preference key "));
        }
        String[] values = null;
        InternalPortletPreference pref = (InternalPortletPreference)this.preferences.get(key);
        if (pref != null) {
            values = pref.getValues();
        }
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly", key));
        }
        InternalPortletPreference pref = (InternalPortletPreference)this.preferences.get(key);
        if (pref != null) {
            pref.setValues(new String[]{value});
        } else {
            pref = new PortletPreferenceImpl(key, new String[]{value});
            this.preferences.put(key, pref);
        }
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly"));
        }
        InternalPortletPreference pref = (InternalPortletPreference)this.preferences.get(key);
        if (pref != null) {
            pref.setValues(values);
        } else {
            pref = new PortletPreferenceImpl(key, values);
            this.preferences.put(key, pref);
        }
    }

    public Enumeration getNames() {
        return new Vector(this.preferences.keySet()).elements();
    }

    public Map getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator it = this.preferences.keySet().iterator();
        while (it.hasNext()) {
            InternalPortletPreference pref = (InternalPortletPreference)this.preferences.get(it.next());
            map.put(pref.getName(), pref.getValues() != null ? pref.getValues().clone() : null);
        }
        return Collections.unmodifiableMap(map);
    }

    public void reset(String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(EXCEPTIONS.getString("error.preference.readonly", "Preference key "));
        }
        boolean resetDone = false;
        for (int i = 0; !resetDone && i < this.defaultPreferences.length; ++i) {
            if (!key.equals(this.defaultPreferences[i].getName())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resetting preference for key: " + key));
            }
            this.preferences.put(key, this.defaultPreferences[i].clone());
            resetDone = true;
        }
        if (!resetDone) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resetting preference to null for key: " + key));
            }
            this.preferences.remove(key);
        }
    }

    public void store() throws IOException, ValidatorException {
        if (!Constants.METHOD_ACTION.equals(this.methodId)) {
            throw new IllegalStateException("store is only allowed inside a processAction call.");
        }
        this.internalStore();
    }

    private void internalStore() throws IOException, ValidatorException {
        PreferencesValidator validator = this.window.getPortletEntity().getPreferencesValidator();
        if (validator != null) {
            validator.validate((PortletPreferences)this);
        }
        InternalPortletPreference[] prefs = new ArrayList(this.preferences.values()).toArray(new InternalPortletPreference[this.preferences.size()]);
        try {
            this.preferencesService.store(this.window, this.request, prefs);
        }
        catch (PortletContainerException ex) {
            LOG.error((Object)"Error storing preferences.", (Throwable)ex);
            throw new IOException("Error storing perferences: " + ex.getMessage());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("[");
        Enumeration en = this.getNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            buffer.append(name);
            buffer.append("(readOnly:").append(this.isReadOnly(name)).append(")=");
            String[] values = this.getValues(name, null);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    buffer.append(values[i]);
                    if (i >= values.length - 1) continue;
                    buffer.append(",");
                }
            } else {
                buffer.append("NULL");
            }
            buffer.append(";");
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

