/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.internal.InternalPortletContext;
import org.apache.pluto.internal.impl.Environment;
import org.apache.pluto.internal.impl.PortletRequestDispatcherImpl;

public class PortletContextImpl
implements PortletContext,
InternalPortletContext {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$PortletContextImpl == null ? (class$org$apache$pluto$internal$impl$PortletContextImpl = PortletContextImpl.class$("org.apache.pluto.internal.impl.PortletContextImpl")) : class$org$apache$pluto$internal$impl$PortletContextImpl));
    private final String applicationId;
    private String applicationName;
    private final PortletAppDD portletAppDD;
    private final ServletContext servletContext;
    private ClassLoader contextClassLoader;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletContextImpl;

    public PortletContextImpl(String portletApplicationId, ServletContext servletContext, PortletAppDD portletAppDD) {
        this.servletContext = servletContext;
        this.portletAppDD = portletAppDD;
        this.applicationId = portletApplicationId;
        this.applicationName = servletContext.getServletContextName();
        if (this.applicationName == null) {
            this.applicationName = this.applicationId;
        }
        this.init();
    }

    private void init() {
        this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
    }

    public String getServerInfo() {
        return Environment.getServerInfo();
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PortletRequestDispatcher requested: " + path));
        }
        if (path == null || !path.startsWith("/")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Failed to retrieve PortletRequestDispatcher: path name must begin with a slash '/'.");
            }
            return null;
        }
        String queryString = null;
        int index = path.indexOf("?");
        if (index > 0 && index < path.length() - 1) {
            queryString = path.substring(index + 1);
        }
        PortletRequestDispatcherImpl portletRequestDispatcher = null;
        try {
            RequestDispatcher servletRequestDispatcher = this.servletContext.getRequestDispatcher(path);
            if (servletRequestDispatcher != null) {
                portletRequestDispatcher = new PortletRequestDispatcherImpl(servletRequestDispatcher, queryString);
            } else if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No matching request dispatcher found for: " + path));
            }
        }
        catch (Exception ex) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Failed to retrieve PortletRequestDispatcher: " + ex.getMessage()));
            }
            portletRequestDispatcher = null;
        }
        return portletRequestDispatcher;
    }

    public PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher dispatcher = this.servletContext.getNamedDispatcher(name);
        if (dispatcher != null) {
            return new PortletRequestDispatcherImpl(dispatcher);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("No matching request dispatcher found for name: " + name));
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return Environment.getMajorSpecificationVersion();
    }

    public int getMinorVersion() {
        return Environment.getMinorSpecificationVersion();
    }

    public String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException("path must start with a '/'");
        }
        return this.servletContext.getResource(path);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        return this.servletContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name == null");
        }
        return this.servletContext.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public void log(String msg) {
        this.servletContext.log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name == null");
        }
        this.servletContext.setAttribute(name, object);
    }

    public String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletAppDD getPortletApplicationDefinition() {
        return this.portletAppDD;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

