/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.SupportsDD;
import org.apache.pluto.internal.InternalActionResponse;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.internal.impl.PortletResponseImpl;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.spi.ResourceURLProvider;
import org.apache.pluto.util.StringUtils;

public class ActionResponseImpl
extends PortletResponseImpl
implements ActionResponse,
InternalActionResponse {
    boolean redirectAllowed = true;
    private boolean redirected;
    private String redirectLocation;
    private Map renderParameters = new HashMap();
    private WindowState windowState = null;
    private PortletMode portletMode = null;
    private PortalCallbackService callback;
    private PortalContext context;

    public ActionResponseImpl(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(container, internalPortletWindow, servletRequest, servletResponse);
        this.context = container.getRequiredContainerServices().getPortalContext();
        this.callback = container.getRequiredContainerServices().getPortalCallbackService();
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.redirected) {
            throw new IllegalStateException("it is not allowed to invoke setWindowState after sendRedirect has been called");
        }
        if (!this.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Can't set this WindowState", windowState);
        }
        this.windowState = windowState;
        this.redirectAllowed = false;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.redirected) {
            throw new IllegalStateException("it is not allowed to invoke setPortletMode after sendRedirect has been called");
        }
        boolean supported = this.isPortletModeAllowed(portletMode);
        if (!supported) {
            throw new PortletModeException("Can't set this PortletMode", portletMode);
        }
        this.portletMode = portletMode;
        this.redirectAllowed = false;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.redirectAllowed) {
            if (location != null) {
                HttpServletResponse redirectResponse = this.getHttpServletResponse();
                while (redirectResponse instanceof HttpServletResponseWrapper) {
                    redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
                }
                ResourceURLProvider provider = this.callback.getResourceURLProvider(this.getHttpServletRequest(), this.getInternalPortletWindow());
                if (location.indexOf("://") != -1) {
                    provider.setAbsoluteURL(location);
                } else {
                    provider.setFullPath(location);
                }
                this.redirectLocation = location = redirectResponse.encodeRedirectURL(((Object)provider).toString());
                this.redirected = true;
            }
        } else {
            throw new IllegalStateException("Can't invoke sendRedirect() after certain methods have been called");
        }
    }

    public void setRenderParameters(Map parameters) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameters() after sendRedirect() has been called");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Render parameters must not be null.");
        }
        Iterator iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Key must not be null and of type java.lang.String.");
            }
            if (entry.getValue() instanceof String[]) continue;
            throw new IllegalArgumentException("Value must not be null and of type java.lang.String[].");
        }
        this.renderParameters = StringUtils.copyParameters(parameters);
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String value) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException("Render parameter key or value must not be null.");
        }
        this.renderParameters.put(key, new String[]{value});
        this.redirectAllowed = false;
    }

    public void setRenderParameter(String key, String[] values) {
        if (this.redirected) {
            throw new IllegalStateException("Can't invoke setRenderParameter() after sendRedirect() has been called");
        }
        if (key == null || values == null || values.length == 0) {
            throw new IllegalArgumentException("Render parameter key or value must not be null or values be an empty array.");
        }
        this.renderParameters.put(key, StringUtils.copy(values));
        this.redirectAllowed = false;
    }

    public Map getRenderParameters() {
        return this.renderParameters;
    }

    public PortletMode getChangedPortletMode() {
        return this.portletMode;
    }

    public WindowState getChangedWindowState() {
        return this.windowState;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    private boolean isPortletModeAllowed(PortletMode mode) {
        return this.isPortletModeAllowedByPortlet(mode) && this.isPortletModeAllowedByPortal(mode);
    }

    private boolean isPortletModeAllowedByPortlet(PortletMode mode) {
        PortletDD dd = this.getInternalPortletWindow().getPortletEntity().getPortletDefinition();
        Iterator supports = dd.getSupports().iterator();
        while (supports.hasNext()) {
            SupportsDD sup = (SupportsDD)supports.next();
            Iterator modes = sup.getPortletModes().iterator();
            while (modes.hasNext()) {
                if (!modes.next().toString().equalsIgnoreCase(mode.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPortletModeAllowedByPortal(PortletMode mode) {
        Enumeration supportedModes = this.context.getSupportedPortletModes();
        while (supportedModes.hasMoreElements()) {
            if (!supportedModes.nextElement().toString().equalsIgnoreCase(mode.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isWindowStateAllowed(WindowState state) {
        Enumeration supportedStates = this.context.getSupportedWindowStates();
        while (supportedStates.hasMoreElements()) {
            if (!supportedStates.nextElement().toString().equalsIgnoreCase(state.toString())) continue;
            return true;
        }
        return false;
    }
}

