package org.apache.parquet.column.values.bitpacking;

/**
 * Packs from the Most Significant Bit first
 * 
 * @author automatically generated
 * @see ByteBasedBitPackingGenerator
 *
 */
public abstract class ByteBitPackingBE {

  private static final BytePacker[] packers = new BytePacker[33];
  static {
    packers[0] = new Packer0();
    packers[1] = new Packer1();
    packers[2] = new Packer2();
    packers[3] = new Packer3();
    packers[4] = new Packer4();
    packers[5] = new Packer5();
    packers[6] = new Packer6();
    packers[7] = new Packer7();
    packers[8] = new Packer8();
    packers[9] = new Packer9();
    packers[10] = new Packer10();
    packers[11] = new Packer11();
    packers[12] = new Packer12();
    packers[13] = new Packer13();
    packers[14] = new Packer14();
    packers[15] = new Packer15();
    packers[16] = new Packer16();
    packers[17] = new Packer17();
    packers[18] = new Packer18();
    packers[19] = new Packer19();
    packers[20] = new Packer20();
    packers[21] = new Packer21();
    packers[22] = new Packer22();
    packers[23] = new Packer23();
    packers[24] = new Packer24();
    packers[25] = new Packer25();
    packers[26] = new Packer26();
    packers[27] = new Packer27();
    packers[28] = new Packer28();
    packers[29] = new Packer29();
    packers[30] = new Packer30();
    packers[31] = new Packer31();
    packers[32] = new Packer32();
  }

  public static final BytePackerFactory factory = new BytePackerFactory() {
    public BytePacker newBytePacker(int bitWidth) {
      return packers[bitWidth];
    }
  };

  private static final class Packer0 extends BytePacker {

    private Packer0() {
      super(0);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
    }
  }

  private static final class Packer1 extends BytePacker {

    private Packer1() {
      super(1);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 0 + inPos] & 1) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 1 + inPos] & 1) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[ 2 + inPos] & 1) <<  5)
        | //           [___4____]
          //              [0]
           ((in[ 3 + inPos] & 1) <<  4)
        | //           [____3___]
          //               [0]
           ((in[ 4 + inPos] & 1) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[ 5 + inPos] & 1) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[ 6 + inPos] & 1) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[ 7 + inPos] & 1))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 0 + inPos] & 1) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 1 + inPos] & 1) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[ 2 + inPos] & 1) <<  5)
        | //           [___4____]
          //              [0]
           ((in[ 3 + inPos] & 1) <<  4)
        | //           [____3___]
          //               [0]
           ((in[ 4 + inPos] & 1) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[ 5 + inPos] & 1) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[ 6 + inPos] & 1) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[ 7 + inPos] & 1))) & 255);
      out[ 1 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[ 8 + inPos] & 1) <<  7)
        | //           [_6______]
          //            [0]
           ((in[ 9 + inPos] & 1) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[10 + inPos] & 1) <<  5)
        | //           [___4____]
          //              [0]
           ((in[11 + inPos] & 1) <<  4)
        | //           [____3___]
          //               [0]
           ((in[12 + inPos] & 1) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[13 + inPos] & 1) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[14 + inPos] & 1) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[15 + inPos] & 1))) & 255);
      out[ 2 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[16 + inPos] & 1) <<  7)
        | //           [_6______]
          //            [0]
           ((in[17 + inPos] & 1) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[18 + inPos] & 1) <<  5)
        | //           [___4____]
          //              [0]
           ((in[19 + inPos] & 1) <<  4)
        | //           [____3___]
          //               [0]
           ((in[20 + inPos] & 1) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[21 + inPos] & 1) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[22 + inPos] & 1) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[23 + inPos] & 1))) & 255);
      out[ 3 + outPos] = (byte)((
          //           [7_______]
          //           [0]
           ((in[24 + inPos] & 1) <<  7)
        | //           [_6______]
          //            [0]
           ((in[25 + inPos] & 1) <<  6)
        | //           [__5_____]
          //             [0]
           ((in[26 + inPos] & 1) <<  5)
        | //           [___4____]
          //              [0]
           ((in[27 + inPos] & 1) <<  4)
        | //           [____3___]
          //               [0]
           ((in[28 + inPos] & 1) <<  3)
        | //           [_____2__]
          //                [0]
           ((in[29 + inPos] & 1) <<  2)
        | //           [______1_]
          //                 [0]
           ((in[30 + inPos] & 1) <<  1)
        | //           [_______0]
          //                  [0]
           ((in[31 + inPos] & 1))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  7) & 1);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  6) & 1);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  5) & 1);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 1);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  3) & 1);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 1);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  1) & 1);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            (((((int)in[ 0 + inPos]) & 255) ) & 1);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //           [7_______]
          //           [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  7) & 1);
      out[ 1 + outPos] =
          //           [_6______]
          //            [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  6) & 1);
      out[ 2 + outPos] =
          //           [__5_____]
          //             [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  5) & 1);
      out[ 3 + outPos] =
          //           [___4____]
          //              [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 1);
      out[ 4 + outPos] =
          //           [____3___]
          //               [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  3) & 1);
      out[ 5 + outPos] =
          //           [_____2__]
          //                [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 1);
      out[ 6 + outPos] =
          //           [______1_]
          //                 [0]
            (((((int)in[ 0 + inPos]) & 255) >>>  1) & 1);
      out[ 7 + outPos] =
          //           [_______0]
          //                  [0]
            (((((int)in[ 0 + inPos]) & 255) ) & 1);
      out[ 8 + outPos] =
          //           [7_______]
          //           [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  7) & 1);
      out[ 9 + outPos] =
          //           [_6______]
          //            [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 1);
      out[10 + outPos] =
          //           [__5_____]
          //             [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  5) & 1);
      out[11 + outPos] =
          //           [___4____]
          //              [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 1);
      out[12 + outPos] =
          //           [____3___]
          //               [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  3) & 1);
      out[13 + outPos] =
          //           [_____2__]
          //                [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 1);
      out[14 + outPos] =
          //           [______1_]
          //                 [0]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 1);
      out[15 + outPos] =
          //           [_______0]
          //                  [0]
            (((((int)in[ 1 + inPos]) & 255) ) & 1);
      out[16 + outPos] =
          //           [7_______]
          //           [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  7) & 1);
      out[17 + outPos] =
          //           [_6______]
          //            [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 1);
      out[18 + outPos] =
          //           [__5_____]
          //             [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  5) & 1);
      out[19 + outPos] =
          //           [___4____]
          //              [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 1);
      out[20 + outPos] =
          //           [____3___]
          //               [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 1);
      out[21 + outPos] =
          //           [_____2__]
          //                [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 1);
      out[22 + outPos] =
          //           [______1_]
          //                 [0]
            (((((int)in[ 2 + inPos]) & 255) >>>  1) & 1);
      out[23 + outPos] =
          //           [_______0]
          //                  [0]
            (((((int)in[ 2 + inPos]) & 255) ) & 1);
      out[24 + outPos] =
          //           [7_______]
          //           [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  7) & 1);
      out[25 + outPos] =
          //           [_6______]
          //            [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 1);
      out[26 + outPos] =
          //           [__5_____]
          //             [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 1);
      out[27 + outPos] =
          //           [___4____]
          //              [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 1);
      out[28 + outPos] =
          //           [____3___]
          //               [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  3) & 1);
      out[29 + outPos] =
          //           [_____2__]
          //                [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 1);
      out[30 + outPos] =
          //           [______1_]
          //                 [0]
            (((((int)in[ 3 + inPos]) & 255) >>>  1) & 1);
      out[31 + outPos] =
          //           [_______0]
          //                  [0]
            (((((int)in[ 3 + inPos]) & 255) ) & 1);
    }
  }

  private static final class Packer2 extends BytePacker {

    private Packer2() {
      super(2);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 0 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 1 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 2 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 3 + inPos] & 3))) & 255);
      out[ 1 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 4 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 5 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 6 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 7 + inPos] & 3))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 0 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 1 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 2 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 3 + inPos] & 3))) & 255);
      out[ 1 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 4 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 5 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[ 6 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[ 7 + inPos] & 3))) & 255);
      out[ 2 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[ 8 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[ 9 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[10 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[11 + inPos] & 3))) & 255);
      out[ 3 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[12 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[13 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[14 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[15 + inPos] & 3))) & 255);
      out[ 4 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[16 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[17 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[18 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[19 + inPos] & 3))) & 255);
      out[ 5 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[20 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[21 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[22 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[23 + inPos] & 3))) & 255);
      out[ 6 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[24 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[25 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[26 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[27 + inPos] & 3))) & 255);
      out[ 7 + outPos] = (byte)((
          //            [76______]
          //            [10]
           ((in[28 + inPos] & 3) <<  6)
        | //            [__54____]
          //              [10]
           ((in[29 + inPos] & 3) <<  4)
        | //            [____32__]
          //                [10]
           ((in[30 + inPos] & 3) <<  2)
        | //            [______10]
          //                  [10]
           ((in[31 + inPos] & 3))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  6) & 3);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 3);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 3);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 0 + inPos]) & 255) ) & 3);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 3);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 3);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 3);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 1 + inPos]) & 255) ) & 3);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  6) & 3);
      out[ 1 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 3);
      out[ 2 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 3);
      out[ 3 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 0 + inPos]) & 255) ) & 3);
      out[ 4 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 3);
      out[ 5 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 3);
      out[ 6 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 3);
      out[ 7 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 1 + inPos]) & 255) ) & 3);
      out[ 8 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 3);
      out[ 9 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 3);
      out[10 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 3);
      out[11 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 2 + inPos]) & 255) ) & 3);
      out[12 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 3);
      out[13 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 3);
      out[14 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 3);
      out[15 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 3 + inPos]) & 255) ) & 3);
      out[16 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 4 + inPos]) & 255) >>>  6) & 3);
      out[17 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 3);
      out[18 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 4 + inPos]) & 255) >>>  2) & 3);
      out[19 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 4 + inPos]) & 255) ) & 3);
      out[20 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 3);
      out[21 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 3);
      out[22 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 5 + inPos]) & 255) >>>  2) & 3);
      out[23 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 5 + inPos]) & 255) ) & 3);
      out[24 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 3);
      out[25 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 3);
      out[26 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 3);
      out[27 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 6 + inPos]) & 255) ) & 3);
      out[28 + outPos] =
          //            [76______]
          //            [10]
            (((((int)in[ 7 + inPos]) & 255) >>>  6) & 3);
      out[29 + outPos] =
          //            [__54____]
          //              [10]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 3);
      out[30 + outPos] =
          //            [____32__]
          //                [10]
            (((((int)in[ 7 + inPos]) & 255) >>>  2) & 3);
      out[31 + outPos] =
          //            [______10]
          //                  [10]
            (((((int)in[ 7 + inPos]) & 255) ) & 3);
    }
  }

  private static final class Packer3 extends BytePacker {

    private Packer3() {
      super(3);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 0 + inPos] & 7) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 1 + inPos] & 7) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[ 2 + inPos] & 7) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[ 2 + inPos] & 7) <<  7)
        | //             [_654____]
          //              [210]
           ((in[ 3 + inPos] & 7) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[ 4 + inPos] & 7) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[ 5 + inPos] & 7) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[ 5 + inPos] & 7) <<  6)
        | //             [__543___]
          //               [210]
           ((in[ 6 + inPos] & 7) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[ 7 + inPos] & 7))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 0 + inPos] & 7) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 1 + inPos] & 7) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[ 2 + inPos] & 7) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[ 2 + inPos] & 7) <<  7)
        | //             [_654____]
          //              [210]
           ((in[ 3 + inPos] & 7) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[ 4 + inPos] & 7) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[ 5 + inPos] & 7) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[ 5 + inPos] & 7) <<  6)
        | //             [__543___]
          //               [210]
           ((in[ 6 + inPos] & 7) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[ 7 + inPos] & 7))) & 255);
      out[ 3 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[ 8 + inPos] & 7) <<  5)
        | //             [___432__]
          //                [210]
           ((in[ 9 + inPos] & 7) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[10 + inPos] & 7) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[10 + inPos] & 7) <<  7)
        | //             [_654____]
          //              [210]
           ((in[11 + inPos] & 7) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[12 + inPos] & 7) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[13 + inPos] & 7) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[13 + inPos] & 7) <<  6)
        | //             [__543___]
          //               [210]
           ((in[14 + inPos] & 7) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[15 + inPos] & 7))) & 255);
      out[ 6 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[16 + inPos] & 7) <<  5)
        | //             [___432__]
          //                [210]
           ((in[17 + inPos] & 7) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[18 + inPos] & 7) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[18 + inPos] & 7) <<  7)
        | //             [_654____]
          //              [210]
           ((in[19 + inPos] & 7) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[20 + inPos] & 7) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[21 + inPos] & 7) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[21 + inPos] & 7) <<  6)
        | //             [__543___]
          //               [210]
           ((in[22 + inPos] & 7) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[23 + inPos] & 7))) & 255);
      out[ 9 + outPos] = (byte)((
          //             [765_____]
          //             [210]
           ((in[24 + inPos] & 7) <<  5)
        | //             [___432__]
          //                [210]
           ((in[25 + inPos] & 7) <<  2)
        | //             [______10]
          //                   [21_]
           ((in[26 + inPos] & 7) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //             [7_______]
          //           [__0]
           ((in[26 + inPos] & 7) <<  7)
        | //             [_654____]
          //              [210]
           ((in[27 + inPos] & 7) <<  4)
        | //             [____321_]
          //                 [210]
           ((in[28 + inPos] & 7) <<  1)
        | //             [_______0]
          //                    [2__]
           ((in[29 + inPos] & 7) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //             [76______]
          //            [_10]
           ((in[29 + inPos] & 7) <<  6)
        | //             [__543___]
          //               [210]
           ((in[30 + inPos] & 7) <<  3)
        | //             [_____210]
          //                  [210]
           ((in[31 + inPos] & 7))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            (((((int)in[ 0 + inPos]) & 255) >>>  5) & 7);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 7);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            (((((int)in[ 0 + inPos]) & 255) <<  1) & 7)
        | //             [7_______]
          //           [__0]
            (((((int)in[ 1 + inPos]) & 255) >>>  7) & 7);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 7);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 7);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 7)
        | //             [76______]
          //            [_10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 7);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 7);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            (((((int)in[ 2 + inPos]) & 255) ) & 7);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //             [765_____]
          //             [210]
            (((((int)in[ 0 + inPos]) & 255) >>>  5) & 7);
      out[ 1 + outPos] =
          //             [___432__]
          //                [210]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 7);
      out[ 2 + outPos] =
          //             [______10]
          //                   [21_]
            (((((int)in[ 0 + inPos]) & 255) <<  1) & 7)
        | //             [7_______]
          //           [__0]
            (((((int)in[ 1 + inPos]) & 255) >>>  7) & 7);
      out[ 3 + outPos] =
          //             [_654____]
          //              [210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 7);
      out[ 4 + outPos] =
          //             [____321_]
          //                 [210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 7);
      out[ 5 + outPos] =
          //             [_______0]
          //                    [2__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 7)
        | //             [76______]
          //            [_10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 7);
      out[ 6 + outPos] =
          //             [__543___]
          //               [210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 7);
      out[ 7 + outPos] =
          //             [_____210]
          //                  [210]
            (((((int)in[ 2 + inPos]) & 255) ) & 7);
      out[ 8 + outPos] =
          //             [765_____]
          //             [210]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 7);
      out[ 9 + outPos] =
          //             [___432__]
          //                [210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 7);
      out[10 + outPos] =
          //             [______10]
          //                   [21_]
            (((((int)in[ 3 + inPos]) & 255) <<  1) & 7)
        | //             [7_______]
          //           [__0]
            (((((int)in[ 4 + inPos]) & 255) >>>  7) & 7);
      out[11 + outPos] =
          //             [_654____]
          //              [210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 7);
      out[12 + outPos] =
          //             [____321_]
          //                 [210]
            (((((int)in[ 4 + inPos]) & 255) >>>  1) & 7);
      out[13 + outPos] =
          //             [_______0]
          //                    [2__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 7)
        | //             [76______]
          //            [_10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 7);
      out[14 + outPos] =
          //             [__543___]
          //               [210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 7);
      out[15 + outPos] =
          //             [_____210]
          //                  [210]
            (((((int)in[ 5 + inPos]) & 255) ) & 7);
      out[16 + outPos] =
          //             [765_____]
          //             [210]
            (((((int)in[ 6 + inPos]) & 255) >>>  5) & 7);
      out[17 + outPos] =
          //             [___432__]
          //                [210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 7);
      out[18 + outPos] =
          //             [______10]
          //                   [21_]
            (((((int)in[ 6 + inPos]) & 255) <<  1) & 7)
        | //             [7_______]
          //           [__0]
            (((((int)in[ 7 + inPos]) & 255) >>>  7) & 7);
      out[19 + outPos] =
          //             [_654____]
          //              [210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 7);
      out[20 + outPos] =
          //             [____321_]
          //                 [210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 7);
      out[21 + outPos] =
          //             [_______0]
          //                    [2__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 7)
        | //             [76______]
          //            [_10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 7);
      out[22 + outPos] =
          //             [__543___]
          //               [210]
            (((((int)in[ 8 + inPos]) & 255) >>>  3) & 7);
      out[23 + outPos] =
          //             [_____210]
          //                  [210]
            (((((int)in[ 8 + inPos]) & 255) ) & 7);
      out[24 + outPos] =
          //             [765_____]
          //             [210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 7);
      out[25 + outPos] =
          //             [___432__]
          //                [210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 7);
      out[26 + outPos] =
          //             [______10]
          //                   [21_]
            (((((int)in[ 9 + inPos]) & 255) <<  1) & 7)
        | //             [7_______]
          //           [__0]
            (((((int)in[10 + inPos]) & 255) >>>  7) & 7);
      out[27 + outPos] =
          //             [_654____]
          //              [210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 7);
      out[28 + outPos] =
          //             [____321_]
          //                 [210]
            (((((int)in[10 + inPos]) & 255) >>>  1) & 7);
      out[29 + outPos] =
          //             [_______0]
          //                    [2__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 7)
        | //             [76______]
          //            [_10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 7);
      out[30 + outPos] =
          //             [__543___]
          //               [210]
            (((((int)in[11 + inPos]) & 255) >>>  3) & 7);
      out[31 + outPos] =
          //             [_____210]
          //                  [210]
            (((((int)in[11 + inPos]) & 255) ) & 7);
    }
  }

  private static final class Packer4 extends BytePacker {

    private Packer4() {
      super(4);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 0 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 1 + inPos] & 15))) & 255);
      out[ 1 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 2 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 3 + inPos] & 15))) & 255);
      out[ 2 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 4 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 5 + inPos] & 15))) & 255);
      out[ 3 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 6 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 7 + inPos] & 15))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 0 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 1 + inPos] & 15))) & 255);
      out[ 1 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 2 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 3 + inPos] & 15))) & 255);
      out[ 2 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 4 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 5 + inPos] & 15))) & 255);
      out[ 3 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 6 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 7 + inPos] & 15))) & 255);
      out[ 4 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[ 8 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[ 9 + inPos] & 15))) & 255);
      out[ 5 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[10 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[11 + inPos] & 15))) & 255);
      out[ 6 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[12 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[13 + inPos] & 15))) & 255);
      out[ 7 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[14 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[15 + inPos] & 15))) & 255);
      out[ 8 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[16 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[17 + inPos] & 15))) & 255);
      out[ 9 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[18 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[19 + inPos] & 15))) & 255);
      out[10 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[20 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[21 + inPos] & 15))) & 255);
      out[11 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[22 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[23 + inPos] & 15))) & 255);
      out[12 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[24 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[25 + inPos] & 15))) & 255);
      out[13 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[26 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[27 + inPos] & 15))) & 255);
      out[14 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[28 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[29 + inPos] & 15))) & 255);
      out[15 + outPos] = (byte)((
          //              [7654____]
          //              [3210]
           ((in[30 + inPos] & 15) <<  4)
        | //              [____3210]
          //                  [3210]
           ((in[31 + inPos] & 15))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 15);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 0 + inPos]) & 255) ) & 15);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 15);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 1 + inPos]) & 255) ) & 15);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 15);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 2 + inPos]) & 255) ) & 15);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 15);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 3 + inPos]) & 255) ) & 15);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 0 + inPos]) & 255) >>>  4) & 15);
      out[ 1 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 0 + inPos]) & 255) ) & 15);
      out[ 2 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 15);
      out[ 3 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 1 + inPos]) & 255) ) & 15);
      out[ 4 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 15);
      out[ 5 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 2 + inPos]) & 255) ) & 15);
      out[ 6 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 15);
      out[ 7 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 3 + inPos]) & 255) ) & 15);
      out[ 8 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 15);
      out[ 9 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 4 + inPos]) & 255) ) & 15);
      out[10 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 15);
      out[11 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 5 + inPos]) & 255) ) & 15);
      out[12 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 15);
      out[13 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 6 + inPos]) & 255) ) & 15);
      out[14 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 15);
      out[15 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 7 + inPos]) & 255) ) & 15);
      out[16 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 8 + inPos]) & 255) >>>  4) & 15);
      out[17 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 8 + inPos]) & 255) ) & 15);
      out[18 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[ 9 + inPos]) & 255) >>>  4) & 15);
      out[19 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[ 9 + inPos]) & 255) ) & 15);
      out[20 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 15);
      out[21 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[10 + inPos]) & 255) ) & 15);
      out[22 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[11 + inPos]) & 255) >>>  4) & 15);
      out[23 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[11 + inPos]) & 255) ) & 15);
      out[24 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 15);
      out[25 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[12 + inPos]) & 255) ) & 15);
      out[26 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 15);
      out[27 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[13 + inPos]) & 255) ) & 15);
      out[28 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[14 + inPos]) & 255) >>>  4) & 15);
      out[29 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[14 + inPos]) & 255) ) & 15);
      out[30 + outPos] =
          //              [7654____]
          //              [3210]
            (((((int)in[15 + inPos]) & 255) >>>  4) & 15);
      out[31 + outPos] =
          //              [____3210]
          //                  [3210]
            (((((int)in[15 + inPos]) & 255) ) & 15);
    }
  }

  private static final class Packer5 extends BytePacker {

    private Packer5() {
      super(5);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 0 + inPos] & 31) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 1 + inPos] & 31) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 1 + inPos] & 31) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[ 2 + inPos] & 31) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[ 3 + inPos] & 31) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[ 3 + inPos] & 31) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[ 4 + inPos] & 31) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[ 4 + inPos] & 31) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[ 5 + inPos] & 31) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[ 6 + inPos] & 31) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[ 6 + inPos] & 31) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[ 7 + inPos] & 31))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 0 + inPos] & 31) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 1 + inPos] & 31) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 1 + inPos] & 31) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[ 2 + inPos] & 31) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[ 3 + inPos] & 31) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[ 3 + inPos] & 31) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[ 4 + inPos] & 31) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[ 4 + inPos] & 31) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[ 5 + inPos] & 31) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[ 6 + inPos] & 31) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[ 6 + inPos] & 31) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[ 7 + inPos] & 31))) & 255);
      out[ 5 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[ 8 + inPos] & 31) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[ 9 + inPos] & 31) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[ 9 + inPos] & 31) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[10 + inPos] & 31) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[11 + inPos] & 31) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[11 + inPos] & 31) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[12 + inPos] & 31) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[12 + inPos] & 31) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[13 + inPos] & 31) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[14 + inPos] & 31) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[14 + inPos] & 31) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[15 + inPos] & 31))) & 255);
      out[10 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[16 + inPos] & 31) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[17 + inPos] & 31) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[17 + inPos] & 31) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[18 + inPos] & 31) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[19 + inPos] & 31) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[19 + inPos] & 31) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[20 + inPos] & 31) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[20 + inPos] & 31) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[21 + inPos] & 31) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[22 + inPos] & 31) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[22 + inPos] & 31) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[23 + inPos] & 31))) & 255);
      out[15 + outPos] = (byte)((
          //               [76543___]
          //               [43210]
           ((in[24 + inPos] & 31) <<  3)
        | //               [_____210]
          //                    [432__]
           ((in[25 + inPos] & 31) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //               [76______]
          //            [___10]
           ((in[25 + inPos] & 31) <<  6)
        | //               [__54321_]
          //                 [43210]
           ((in[26 + inPos] & 31) <<  1)
        | //               [_______0]
          //                      [4____]
           ((in[27 + inPos] & 31) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //               [7654____]
          //              [_3210]
           ((in[27 + inPos] & 31) <<  4)
        | //               [____3210]
          //                   [4321_]
           ((in[28 + inPos] & 31) >>> 1)) & 255);
      out[18 + outPos] = (byte)((
          //               [7_______]
          //           [____0]
           ((in[28 + inPos] & 31) <<  7)
        | //               [_65432__]
          //                [43210]
           ((in[29 + inPos] & 31) <<  2)
        | //               [______10]
          //                     [43___]
           ((in[30 + inPos] & 31) >>> 3)) & 255);
      out[19 + outPos] = (byte)((
          //               [765_____]
          //             [__210]
           ((in[30 + inPos] & 31) <<  5)
        | //               [___43210]
          //                  [43210]
           ((in[31 + inPos] & 31))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            (((((int)in[ 0 + inPos]) & 255) >>>  3) & 31);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            (((((int)in[ 0 + inPos]) & 255) <<  2) & 31)
        | //               [76______]
          //            [___10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 31);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 31);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 31)
        | //               [7654____]
          //              [_3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 31);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            (((((int)in[ 2 + inPos]) & 255) <<  1) & 31)
        | //               [7_______]
          //           [____0]
            (((((int)in[ 3 + inPos]) & 255) >>>  7) & 31);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 31);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            (((((int)in[ 3 + inPos]) & 255) <<  3) & 31)
        | //               [765_____]
          //             [__210]
            (((((int)in[ 4 + inPos]) & 255) >>>  5) & 31);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            (((((int)in[ 4 + inPos]) & 255) ) & 31);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //               [76543___]
          //               [43210]
            (((((int)in[ 0 + inPos]) & 255) >>>  3) & 31);
      out[ 1 + outPos] =
          //               [_____210]
          //                    [432__]
            (((((int)in[ 0 + inPos]) & 255) <<  2) & 31)
        | //               [76______]
          //            [___10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 31);
      out[ 2 + outPos] =
          //               [__54321_]
          //                 [43210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 31);
      out[ 3 + outPos] =
          //               [_______0]
          //                      [4____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 31)
        | //               [7654____]
          //              [_3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 31);
      out[ 4 + outPos] =
          //               [____3210]
          //                   [4321_]
            (((((int)in[ 2 + inPos]) & 255) <<  1) & 31)
        | //               [7_______]
          //           [____0]
            (((((int)in[ 3 + inPos]) & 255) >>>  7) & 31);
      out[ 5 + outPos] =
          //               [_65432__]
          //                [43210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 31);
      out[ 6 + outPos] =
          //               [______10]
          //                     [43___]
            (((((int)in[ 3 + inPos]) & 255) <<  3) & 31)
        | //               [765_____]
          //             [__210]
            (((((int)in[ 4 + inPos]) & 255) >>>  5) & 31);
      out[ 7 + outPos] =
          //               [___43210]
          //                  [43210]
            (((((int)in[ 4 + inPos]) & 255) ) & 31);
      out[ 8 + outPos] =
          //               [76543___]
          //               [43210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 31);
      out[ 9 + outPos] =
          //               [_____210]
          //                    [432__]
            (((((int)in[ 5 + inPos]) & 255) <<  2) & 31)
        | //               [76______]
          //            [___10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 31);
      out[10 + outPos] =
          //               [__54321_]
          //                 [43210]
            (((((int)in[ 6 + inPos]) & 255) >>>  1) & 31);
      out[11 + outPos] =
          //               [_______0]
          //                      [4____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 31)
        | //               [7654____]
          //              [_3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 31);
      out[12 + outPos] =
          //               [____3210]
          //                   [4321_]
            (((((int)in[ 7 + inPos]) & 255) <<  1) & 31)
        | //               [7_______]
          //           [____0]
            (((((int)in[ 8 + inPos]) & 255) >>>  7) & 31);
      out[13 + outPos] =
          //               [_65432__]
          //                [43210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 31);
      out[14 + outPos] =
          //               [______10]
          //                     [43___]
            (((((int)in[ 8 + inPos]) & 255) <<  3) & 31)
        | //               [765_____]
          //             [__210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 31);
      out[15 + outPos] =
          //               [___43210]
          //                  [43210]
            (((((int)in[ 9 + inPos]) & 255) ) & 31);
      out[16 + outPos] =
          //               [76543___]
          //               [43210]
            (((((int)in[10 + inPos]) & 255) >>>  3) & 31);
      out[17 + outPos] =
          //               [_____210]
          //                    [432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 31)
        | //               [76______]
          //            [___10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 31);
      out[18 + outPos] =
          //               [__54321_]
          //                 [43210]
            (((((int)in[11 + inPos]) & 255) >>>  1) & 31);
      out[19 + outPos] =
          //               [_______0]
          //                      [4____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 31)
        | //               [7654____]
          //              [_3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 31);
      out[20 + outPos] =
          //               [____3210]
          //                   [4321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 31)
        | //               [7_______]
          //           [____0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 31);
      out[21 + outPos] =
          //               [_65432__]
          //                [43210]
            (((((int)in[13 + inPos]) & 255) >>>  2) & 31);
      out[22 + outPos] =
          //               [______10]
          //                     [43___]
            (((((int)in[13 + inPos]) & 255) <<  3) & 31)
        | //               [765_____]
          //             [__210]
            (((((int)in[14 + inPos]) & 255) >>>  5) & 31);
      out[23 + outPos] =
          //               [___43210]
          //                  [43210]
            (((((int)in[14 + inPos]) & 255) ) & 31);
      out[24 + outPos] =
          //               [76543___]
          //               [43210]
            (((((int)in[15 + inPos]) & 255) >>>  3) & 31);
      out[25 + outPos] =
          //               [_____210]
          //                    [432__]
            (((((int)in[15 + inPos]) & 255) <<  2) & 31)
        | //               [76______]
          //            [___10]
            (((((int)in[16 + inPos]) & 255) >>>  6) & 31);
      out[26 + outPos] =
          //               [__54321_]
          //                 [43210]
            (((((int)in[16 + inPos]) & 255) >>>  1) & 31);
      out[27 + outPos] =
          //               [_______0]
          //                      [4____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 31)
        | //               [7654____]
          //              [_3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 31);
      out[28 + outPos] =
          //               [____3210]
          //                   [4321_]
            (((((int)in[17 + inPos]) & 255) <<  1) & 31)
        | //               [7_______]
          //           [____0]
            (((((int)in[18 + inPos]) & 255) >>>  7) & 31);
      out[29 + outPos] =
          //               [_65432__]
          //                [43210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 31);
      out[30 + outPos] =
          //               [______10]
          //                     [43___]
            (((((int)in[18 + inPos]) & 255) <<  3) & 31)
        | //               [765_____]
          //             [__210]
            (((((int)in[19 + inPos]) & 255) >>>  5) & 31);
      out[31 + outPos] =
          //               [___43210]
          //                  [43210]
            (((((int)in[19 + inPos]) & 255) ) & 31);
    }
  }

  private static final class Packer6 extends BytePacker {

    private Packer6() {
      super(6);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 0 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 1 + inPos] & 63) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 1 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 2 + inPos] & 63) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 2 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 3 + inPos] & 63))) & 255);
      out[ 3 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 4 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 5 + inPos] & 63) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 5 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 6 + inPos] & 63) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 6 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 7 + inPos] & 63))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 0 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 1 + inPos] & 63) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 1 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 2 + inPos] & 63) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 2 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 3 + inPos] & 63))) & 255);
      out[ 3 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 4 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 5 + inPos] & 63) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 5 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[ 6 + inPos] & 63) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[ 6 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[ 7 + inPos] & 63))) & 255);
      out[ 6 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[ 8 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[ 9 + inPos] & 63) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[ 9 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[10 + inPos] & 63) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[10 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[11 + inPos] & 63))) & 255);
      out[ 9 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[12 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[13 + inPos] & 63) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[13 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[14 + inPos] & 63) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[14 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[15 + inPos] & 63))) & 255);
      out[12 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[16 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[17 + inPos] & 63) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[17 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[18 + inPos] & 63) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[18 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[19 + inPos] & 63))) & 255);
      out[15 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[20 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[21 + inPos] & 63) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[21 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[22 + inPos] & 63) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[22 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[23 + inPos] & 63))) & 255);
      out[18 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[24 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[25 + inPos] & 63) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[25 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[26 + inPos] & 63) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[26 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[27 + inPos] & 63))) & 255);
      out[21 + outPos] = (byte)((
          //                [765432__]
          //                [543210]
           ((in[28 + inPos] & 63) <<  2)
        | //                [______10]
          //                      [54____]
           ((in[29 + inPos] & 63) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                [7654____]
          //              [__3210]
           ((in[29 + inPos] & 63) <<  4)
        | //                [____3210]
          //                    [5432__]
           ((in[30 + inPos] & 63) >>> 2)) & 255);
      out[23 + outPos] = (byte)((
          //                [76______]
          //            [____10]
           ((in[30 + inPos] & 63) <<  6)
        | //                [__543210]
          //                  [543210]
           ((in[31 + inPos] & 63))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 63);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 0 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 63);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 63);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 63);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 63);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 63);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 63);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 63);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 0 + inPos]) & 255) >>>  2) & 63);
      out[ 1 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 0 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 63);
      out[ 2 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 63);
      out[ 3 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 63);
      out[ 4 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 63);
      out[ 5 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 63);
      out[ 6 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 63);
      out[ 7 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 63);
      out[ 8 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 63);
      out[ 9 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 63);
      out[10 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 63);
      out[11 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 63);
      out[12 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 63);
      out[13 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 63);
      out[14 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 63);
      out[15 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[11 + inPos]) & 255) ) & 63);
      out[16 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[12 + inPos]) & 255) >>>  2) & 63);
      out[17 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 63);
      out[18 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[13 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[14 + inPos]) & 255) >>>  6) & 63);
      out[19 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[14 + inPos]) & 255) ) & 63);
      out[20 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 63);
      out[21 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[15 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[16 + inPos]) & 255) >>>  4) & 63);
      out[22 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[16 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[17 + inPos]) & 255) >>>  6) & 63);
      out[23 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[17 + inPos]) & 255) ) & 63);
      out[24 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 63);
      out[25 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[18 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[19 + inPos]) & 255) >>>  4) & 63);
      out[26 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[19 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[20 + inPos]) & 255) >>>  6) & 63);
      out[27 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[20 + inPos]) & 255) ) & 63);
      out[28 + outPos] =
          //                [765432__]
          //                [543210]
            (((((int)in[21 + inPos]) & 255) >>>  2) & 63);
      out[29 + outPos] =
          //                [______10]
          //                      [54____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 63)
        | //                [7654____]
          //              [__3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 63);
      out[30 + outPos] =
          //                [____3210]
          //                    [5432__]
            (((((int)in[22 + inPos]) & 255) <<  2) & 63)
        | //                [76______]
          //            [____10]
            (((((int)in[23 + inPos]) & 255) >>>  6) & 63);
      out[31 + outPos] =
          //                [__543210]
          //                  [543210]
            (((((int)in[23 + inPos]) & 255) ) & 63);
    }
  }

  private static final class Packer7 extends BytePacker {

    private Packer7() {
      super(7);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 0 + inPos] & 127) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 1 + inPos] & 127) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 1 + inPos] & 127) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[ 2 + inPos] & 127) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[ 2 + inPos] & 127) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[ 3 + inPos] & 127) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[ 3 + inPos] & 127) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[ 4 + inPos] & 127) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[ 4 + inPos] & 127) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[ 5 + inPos] & 127) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[ 5 + inPos] & 127) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[ 6 + inPos] & 127) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[ 6 + inPos] & 127) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[ 7 + inPos] & 127))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 0 + inPos] & 127) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 1 + inPos] & 127) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 1 + inPos] & 127) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[ 2 + inPos] & 127) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[ 2 + inPos] & 127) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[ 3 + inPos] & 127) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[ 3 + inPos] & 127) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[ 4 + inPos] & 127) >>> 3)) & 255);
      out[ 4 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[ 4 + inPos] & 127) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[ 5 + inPos] & 127) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[ 5 + inPos] & 127) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[ 6 + inPos] & 127) >>> 1)) & 255);
      out[ 6 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[ 6 + inPos] & 127) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[ 7 + inPos] & 127))) & 255);
      out[ 7 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[ 8 + inPos] & 127) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[ 9 + inPos] & 127) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[ 9 + inPos] & 127) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[10 + inPos] & 127) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[10 + inPos] & 127) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[11 + inPos] & 127) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[11 + inPos] & 127) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[12 + inPos] & 127) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[12 + inPos] & 127) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[13 + inPos] & 127) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[13 + inPos] & 127) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[14 + inPos] & 127) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[14 + inPos] & 127) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[15 + inPos] & 127))) & 255);
      out[14 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[16 + inPos] & 127) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[17 + inPos] & 127) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[17 + inPos] & 127) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[18 + inPos] & 127) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[18 + inPos] & 127) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[19 + inPos] & 127) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[19 + inPos] & 127) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[20 + inPos] & 127) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[20 + inPos] & 127) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[21 + inPos] & 127) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[21 + inPos] & 127) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[22 + inPos] & 127) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[22 + inPos] & 127) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[23 + inPos] & 127))) & 255);
      out[21 + outPos] = (byte)((
          //                 [7654321_]
          //                 [6543210]
           ((in[24 + inPos] & 127) <<  1)
        | //                 [_______0]
          //                        [6______]
           ((in[25 + inPos] & 127) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                 [765432__]
          //                [_543210]
           ((in[25 + inPos] & 127) <<  2)
        | //                 [______10]
          //                       [65_____]
           ((in[26 + inPos] & 127) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                 [76543___]
          //               [__43210]
           ((in[26 + inPos] & 127) <<  3)
        | //                 [_____210]
          //                      [654____]
           ((in[27 + inPos] & 127) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                 [7654____]
          //              [___3210]
           ((in[27 + inPos] & 127) <<  4)
        | //                 [____3210]
          //                     [6543___]
           ((in[28 + inPos] & 127) >>> 3)) & 255);
      out[25 + outPos] = (byte)((
          //                 [765_____]
          //             [____210]
           ((in[28 + inPos] & 127) <<  5)
        | //                 [___43210]
          //                    [65432__]
           ((in[29 + inPos] & 127) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                 [76______]
          //            [_____10]
           ((in[29 + inPos] & 127) <<  6)
        | //                 [__543210]
          //                   [654321_]
           ((in[30 + inPos] & 127) >>> 1)) & 255);
      out[27 + outPos] = (byte)((
          //                 [7_______]
          //           [______0]
           ((in[30 + inPos] & 127) <<  7)
        | //                 [_6543210]
          //                  [6543210]
           ((in[31 + inPos] & 127))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            (((((int)in[ 0 + inPos]) & 255) >>>  1) & 127);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            (((((int)in[ 0 + inPos]) & 255) <<  6) & 127)
        | //                 [765432__]
          //                [_543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 127);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            (((((int)in[ 1 + inPos]) & 255) <<  5) & 127)
        | //                 [76543___]
          //               [__43210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 127);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            (((((int)in[ 2 + inPos]) & 255) <<  4) & 127)
        | //                 [7654____]
          //              [___3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 127);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            (((((int)in[ 3 + inPos]) & 255) <<  3) & 127)
        | //                 [765_____]
          //             [____210]
            (((((int)in[ 4 + inPos]) & 255) >>>  5) & 127);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 127)
        | //                 [76______]
          //            [_____10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 127);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            (((((int)in[ 5 + inPos]) & 255) <<  1) & 127)
        | //                 [7_______]
          //           [______0]
            (((((int)in[ 6 + inPos]) & 255) >>>  7) & 127);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 127);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            (((((int)in[ 0 + inPos]) & 255) >>>  1) & 127);
      out[ 1 + outPos] =
          //                 [_______0]
          //                        [6______]
            (((((int)in[ 0 + inPos]) & 255) <<  6) & 127)
        | //                 [765432__]
          //                [_543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 127);
      out[ 2 + outPos] =
          //                 [______10]
          //                       [65_____]
            (((((int)in[ 1 + inPos]) & 255) <<  5) & 127)
        | //                 [76543___]
          //               [__43210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 127);
      out[ 3 + outPos] =
          //                 [_____210]
          //                      [654____]
            (((((int)in[ 2 + inPos]) & 255) <<  4) & 127)
        | //                 [7654____]
          //              [___3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 127);
      out[ 4 + outPos] =
          //                 [____3210]
          //                     [6543___]
            (((((int)in[ 3 + inPos]) & 255) <<  3) & 127)
        | //                 [765_____]
          //             [____210]
            (((((int)in[ 4 + inPos]) & 255) >>>  5) & 127);
      out[ 5 + outPos] =
          //                 [___43210]
          //                    [65432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 127)
        | //                 [76______]
          //            [_____10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 127);
      out[ 6 + outPos] =
          //                 [__543210]
          //                   [654321_]
            (((((int)in[ 5 + inPos]) & 255) <<  1) & 127)
        | //                 [7_______]
          //           [______0]
            (((((int)in[ 6 + inPos]) & 255) >>>  7) & 127);
      out[ 7 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 127);
      out[ 8 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 127);
      out[ 9 + outPos] =
          //                 [_______0]
          //                        [6______]
            (((((int)in[ 7 + inPos]) & 255) <<  6) & 127)
        | //                 [765432__]
          //                [_543210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 127);
      out[10 + outPos] =
          //                 [______10]
          //                       [65_____]
            (((((int)in[ 8 + inPos]) & 255) <<  5) & 127)
        | //                 [76543___]
          //               [__43210]
            (((((int)in[ 9 + inPos]) & 255) >>>  3) & 127);
      out[11 + outPos] =
          //                 [_____210]
          //                      [654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 127)
        | //                 [7654____]
          //              [___3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 127);
      out[12 + outPos] =
          //                 [____3210]
          //                     [6543___]
            (((((int)in[10 + inPos]) & 255) <<  3) & 127)
        | //                 [765_____]
          //             [____210]
            (((((int)in[11 + inPos]) & 255) >>>  5) & 127);
      out[13 + outPos] =
          //                 [___43210]
          //                    [65432__]
            (((((int)in[11 + inPos]) & 255) <<  2) & 127)
        | //                 [76______]
          //            [_____10]
            (((((int)in[12 + inPos]) & 255) >>>  6) & 127);
      out[14 + outPos] =
          //                 [__543210]
          //                   [654321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 127)
        | //                 [7_______]
          //           [______0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 127);
      out[15 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            (((((int)in[13 + inPos]) & 255) ) & 127);
      out[16 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            (((((int)in[14 + inPos]) & 255) >>>  1) & 127);
      out[17 + outPos] =
          //                 [_______0]
          //                        [6______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 127)
        | //                 [765432__]
          //                [_543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 127);
      out[18 + outPos] =
          //                 [______10]
          //                       [65_____]
            (((((int)in[15 + inPos]) & 255) <<  5) & 127)
        | //                 [76543___]
          //               [__43210]
            (((((int)in[16 + inPos]) & 255) >>>  3) & 127);
      out[19 + outPos] =
          //                 [_____210]
          //                      [654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 127)
        | //                 [7654____]
          //              [___3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 127);
      out[20 + outPos] =
          //                 [____3210]
          //                     [6543___]
            (((((int)in[17 + inPos]) & 255) <<  3) & 127)
        | //                 [765_____]
          //             [____210]
            (((((int)in[18 + inPos]) & 255) >>>  5) & 127);
      out[21 + outPos] =
          //                 [___43210]
          //                    [65432__]
            (((((int)in[18 + inPos]) & 255) <<  2) & 127)
        | //                 [76______]
          //            [_____10]
            (((((int)in[19 + inPos]) & 255) >>>  6) & 127);
      out[22 + outPos] =
          //                 [__543210]
          //                   [654321_]
            (((((int)in[19 + inPos]) & 255) <<  1) & 127)
        | //                 [7_______]
          //           [______0]
            (((((int)in[20 + inPos]) & 255) >>>  7) & 127);
      out[23 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            (((((int)in[20 + inPos]) & 255) ) & 127);
      out[24 + outPos] =
          //                 [7654321_]
          //                 [6543210]
            (((((int)in[21 + inPos]) & 255) >>>  1) & 127);
      out[25 + outPos] =
          //                 [_______0]
          //                        [6______]
            (((((int)in[21 + inPos]) & 255) <<  6) & 127)
        | //                 [765432__]
          //                [_543210]
            (((((int)in[22 + inPos]) & 255) >>>  2) & 127);
      out[26 + outPos] =
          //                 [______10]
          //                       [65_____]
            (((((int)in[22 + inPos]) & 255) <<  5) & 127)
        | //                 [76543___]
          //               [__43210]
            (((((int)in[23 + inPos]) & 255) >>>  3) & 127);
      out[27 + outPos] =
          //                 [_____210]
          //                      [654____]
            (((((int)in[23 + inPos]) & 255) <<  4) & 127)
        | //                 [7654____]
          //              [___3210]
            (((((int)in[24 + inPos]) & 255) >>>  4) & 127);
      out[28 + outPos] =
          //                 [____3210]
          //                     [6543___]
            (((((int)in[24 + inPos]) & 255) <<  3) & 127)
        | //                 [765_____]
          //             [____210]
            (((((int)in[25 + inPos]) & 255) >>>  5) & 127);
      out[29 + outPos] =
          //                 [___43210]
          //                    [65432__]
            (((((int)in[25 + inPos]) & 255) <<  2) & 127)
        | //                 [76______]
          //            [_____10]
            (((((int)in[26 + inPos]) & 255) >>>  6) & 127);
      out[30 + outPos] =
          //                 [__543210]
          //                   [654321_]
            (((((int)in[26 + inPos]) & 255) <<  1) & 127)
        | //                 [7_______]
          //           [______0]
            (((((int)in[27 + inPos]) & 255) >>>  7) & 127);
      out[31 + outPos] =
          //                 [_6543210]
          //                  [6543210]
            (((((int)in[27 + inPos]) & 255) ) & 127);
    }
  }

  private static final class Packer8 extends BytePacker {

    private Packer8() {
      super(8);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 0 + inPos] & 255))) & 255);
      out[ 1 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 1 + inPos] & 255))) & 255);
      out[ 2 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 2 + inPos] & 255))) & 255);
      out[ 3 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 3 + inPos] & 255))) & 255);
      out[ 4 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 4 + inPos] & 255))) & 255);
      out[ 5 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 5 + inPos] & 255))) & 255);
      out[ 6 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 6 + inPos] & 255))) & 255);
      out[ 7 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 7 + inPos] & 255))) & 255);
      out[ 8 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 8 + inPos] & 255))) & 255);
      out[ 9 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[ 9 + inPos] & 255))) & 255);
      out[10 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[10 + inPos] & 255))) & 255);
      out[11 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[11 + inPos] & 255))) & 255);
      out[12 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[12 + inPos] & 255))) & 255);
      out[13 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[13 + inPos] & 255))) & 255);
      out[14 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[14 + inPos] & 255))) & 255);
      out[15 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[15 + inPos] & 255))) & 255);
      out[16 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[16 + inPos] & 255))) & 255);
      out[17 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[17 + inPos] & 255))) & 255);
      out[18 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[18 + inPos] & 255))) & 255);
      out[19 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[19 + inPos] & 255))) & 255);
      out[20 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[20 + inPos] & 255))) & 255);
      out[21 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[21 + inPos] & 255))) & 255);
      out[22 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[22 + inPos] & 255))) & 255);
      out[23 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[23 + inPos] & 255))) & 255);
      out[24 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[24 + inPos] & 255))) & 255);
      out[25 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[25 + inPos] & 255))) & 255);
      out[26 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[26 + inPos] & 255))) & 255);
      out[27 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[27 + inPos] & 255))) & 255);
      out[28 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[28 + inPos] & 255))) & 255);
      out[29 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[29 + inPos] & 255))) & 255);
      out[30 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[30 + inPos] & 255))) & 255);
      out[31 + outPos] = (byte)((
          //                  [76543210]
          //                  [76543210]
           ((in[31 + inPos] & 255))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 0 + inPos]) & 255) ) & 255);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 1 + inPos]) & 255) ) & 255);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 255);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 3 + inPos]) & 255) ) & 255);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 255);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 255);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 255);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 7 + inPos]) & 255) ) & 255);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 0 + inPos]) & 255) ) & 255);
      out[ 1 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 1 + inPos]) & 255) ) & 255);
      out[ 2 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 255);
      out[ 3 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 3 + inPos]) & 255) ) & 255);
      out[ 4 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 255);
      out[ 5 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 255);
      out[ 6 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 255);
      out[ 7 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 7 + inPos]) & 255) ) & 255);
      out[ 8 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 255);
      out[ 9 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 255);
      out[10 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[10 + inPos]) & 255) ) & 255);
      out[11 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[11 + inPos]) & 255) ) & 255);
      out[12 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[12 + inPos]) & 255) ) & 255);
      out[13 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[13 + inPos]) & 255) ) & 255);
      out[14 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[14 + inPos]) & 255) ) & 255);
      out[15 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[15 + inPos]) & 255) ) & 255);
      out[16 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[16 + inPos]) & 255) ) & 255);
      out[17 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[17 + inPos]) & 255) ) & 255);
      out[18 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[18 + inPos]) & 255) ) & 255);
      out[19 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[19 + inPos]) & 255) ) & 255);
      out[20 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[20 + inPos]) & 255) ) & 255);
      out[21 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[21 + inPos]) & 255) ) & 255);
      out[22 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[22 + inPos]) & 255) ) & 255);
      out[23 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[23 + inPos]) & 255) ) & 255);
      out[24 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[24 + inPos]) & 255) ) & 255);
      out[25 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[25 + inPos]) & 255) ) & 255);
      out[26 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[26 + inPos]) & 255) ) & 255);
      out[27 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[27 + inPos]) & 255) ) & 255);
      out[28 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[28 + inPos]) & 255) ) & 255);
      out[29 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[29 + inPos]) & 255) ) & 255);
      out[30 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[30 + inPos]) & 255) ) & 255);
      out[31 + outPos] =
          //                  [76543210]
          //                  [76543210]
            (((((int)in[31 + inPos]) & 255) ) & 255);
    }
  }

  private static final class Packer9 extends BytePacker {

    private Packer9() {
      super(9);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 0 + inPos] & 511) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 0 + inPos] & 511) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 1 + inPos] & 511) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 1 + inPos] & 511) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[ 2 + inPos] & 511) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[ 2 + inPos] & 511) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[ 3 + inPos] & 511) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[ 3 + inPos] & 511) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[ 4 + inPos] & 511) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[ 4 + inPos] & 511) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[ 5 + inPos] & 511) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[ 5 + inPos] & 511) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[ 6 + inPos] & 511) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[ 6 + inPos] & 511) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[ 7 + inPos] & 511) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 7 + inPos] & 511))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 0 + inPos] & 511) >>> 1)) & 255);
      out[ 1 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 0 + inPos] & 511) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 1 + inPos] & 511) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 1 + inPos] & 511) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[ 2 + inPos] & 511) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[ 2 + inPos] & 511) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[ 3 + inPos] & 511) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[ 3 + inPos] & 511) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[ 4 + inPos] & 511) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[ 4 + inPos] & 511) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[ 5 + inPos] & 511) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[ 5 + inPos] & 511) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[ 6 + inPos] & 511) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[ 6 + inPos] & 511) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[ 7 + inPos] & 511) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[ 7 + inPos] & 511))) & 255);
      out[ 9 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[ 8 + inPos] & 511) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[ 8 + inPos] & 511) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[ 9 + inPos] & 511) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[ 9 + inPos] & 511) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[10 + inPos] & 511) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[10 + inPos] & 511) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[11 + inPos] & 511) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[11 + inPos] & 511) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[12 + inPos] & 511) >>> 5)) & 255);
      out[14 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[12 + inPos] & 511) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[13 + inPos] & 511) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[13 + inPos] & 511) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[14 + inPos] & 511) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[14 + inPos] & 511) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[15 + inPos] & 511) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[15 + inPos] & 511))) & 255);
      out[18 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[16 + inPos] & 511) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[16 + inPos] & 511) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[17 + inPos] & 511) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[17 + inPos] & 511) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[18 + inPos] & 511) >>> 3)) & 255);
      out[21 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[18 + inPos] & 511) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[19 + inPos] & 511) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[19 + inPos] & 511) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[20 + inPos] & 511) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[20 + inPos] & 511) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[21 + inPos] & 511) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[21 + inPos] & 511) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[22 + inPos] & 511) >>> 7)) & 255);
      out[25 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[22 + inPos] & 511) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[23 + inPos] & 511) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[23 + inPos] & 511))) & 255);
      out[27 + outPos] = (byte)((
          //                   [76543210]
          //                   [87654321_]
           ((in[24 + inPos] & 511) >>> 1)) & 255);
      out[28 + outPos] = (byte)((
          //                   [7_______]
          //           [________0]
           ((in[24 + inPos] & 511) <<  7)
        | //                   [_6543210]
          //                    [8765432__]
           ((in[25 + inPos] & 511) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                   [76______]
          //            [_______10]
           ((in[25 + inPos] & 511) <<  6)
        | //                   [__543210]
          //                     [876543___]
           ((in[26 + inPos] & 511) >>> 3)) & 255);
      out[30 + outPos] = (byte)((
          //                   [765_____]
          //             [______210]
           ((in[26 + inPos] & 511) <<  5)
        | //                   [___43210]
          //                      [87654____]
           ((in[27 + inPos] & 511) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                   [7654____]
          //              [_____3210]
           ((in[27 + inPos] & 511) <<  4)
        | //                   [____3210]
          //                       [8765_____]
           ((in[28 + inPos] & 511) >>> 5)) & 255);
      out[32 + outPos] = (byte)((
          //                   [76543___]
          //               [____43210]
           ((in[28 + inPos] & 511) <<  3)
        | //                   [_____210]
          //                        [876______]
           ((in[29 + inPos] & 511) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                   [765432__]
          //                [___543210]
           ((in[29 + inPos] & 511) <<  2)
        | //                   [______10]
          //                         [87_______]
           ((in[30 + inPos] & 511) >>> 7)) & 255);
      out[34 + outPos] = (byte)((
          //                   [7654321_]
          //                 [__6543210]
           ((in[30 + inPos] & 511) <<  1)
        | //                   [_______0]
          //                          [8________]
           ((in[31 + inPos] & 511) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                   [76543210]
          //                  [_76543210]
           ((in[31 + inPos] & 511))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            (((((int)in[ 0 + inPos]) & 255) <<  1) & 511)
        | //                   [7_______]
          //           [________0]
            (((((int)in[ 1 + inPos]) & 255) >>>  7) & 511);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 511)
        | //                   [76______]
          //            [_______10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 511);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            (((((int)in[ 2 + inPos]) & 255) <<  3) & 511)
        | //                   [765_____]
          //             [______210]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 511);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 511)
        | //                   [7654____]
          //              [_____3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 511);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            (((((int)in[ 4 + inPos]) & 255) <<  5) & 511)
        | //                   [76543___]
          //               [____43210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 511);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 511)
        | //                   [765432__]
          //                [___543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 511);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            (((((int)in[ 6 + inPos]) & 255) <<  7) & 511)
        | //                   [7654321_]
          //                 [__6543210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 511);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 511)
        | //                   [76543210]
          //                  [_76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 511);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            (((((int)in[ 0 + inPos]) & 255) <<  1) & 511)
        | //                   [7_______]
          //           [________0]
            (((((int)in[ 1 + inPos]) & 255) >>>  7) & 511);
      out[ 1 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 511)
        | //                   [76______]
          //            [_______10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 511);
      out[ 2 + outPos] =
          //                   [__543210]
          //                     [876543___]
            (((((int)in[ 2 + inPos]) & 255) <<  3) & 511)
        | //                   [765_____]
          //             [______210]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 511);
      out[ 3 + outPos] =
          //                   [___43210]
          //                      [87654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 511)
        | //                   [7654____]
          //              [_____3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 511);
      out[ 4 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            (((((int)in[ 4 + inPos]) & 255) <<  5) & 511)
        | //                   [76543___]
          //               [____43210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 511);
      out[ 5 + outPos] =
          //                   [_____210]
          //                        [876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 511)
        | //                   [765432__]
          //                [___543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 511);
      out[ 6 + outPos] =
          //                   [______10]
          //                         [87_______]
            (((((int)in[ 6 + inPos]) & 255) <<  7) & 511)
        | //                   [7654321_]
          //                 [__6543210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 511);
      out[ 7 + outPos] =
          //                   [_______0]
          //                          [8________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 511)
        | //                   [76543210]
          //                  [_76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 511);
      out[ 8 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            (((((int)in[ 9 + inPos]) & 255) <<  1) & 511)
        | //                   [7_______]
          //           [________0]
            (((((int)in[10 + inPos]) & 255) >>>  7) & 511);
      out[ 9 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 511)
        | //                   [76______]
          //            [_______10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 511);
      out[10 + outPos] =
          //                   [__543210]
          //                     [876543___]
            (((((int)in[11 + inPos]) & 255) <<  3) & 511)
        | //                   [765_____]
          //             [______210]
            (((((int)in[12 + inPos]) & 255) >>>  5) & 511);
      out[11 + outPos] =
          //                   [___43210]
          //                      [87654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 511)
        | //                   [7654____]
          //              [_____3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 511);
      out[12 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            (((((int)in[13 + inPos]) & 255) <<  5) & 511)
        | //                   [76543___]
          //               [____43210]
            (((((int)in[14 + inPos]) & 255) >>>  3) & 511);
      out[13 + outPos] =
          //                   [_____210]
          //                        [876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 511)
        | //                   [765432__]
          //                [___543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 511);
      out[14 + outPos] =
          //                   [______10]
          //                         [87_______]
            (((((int)in[15 + inPos]) & 255) <<  7) & 511)
        | //                   [7654321_]
          //                 [__6543210]
            (((((int)in[16 + inPos]) & 255) >>>  1) & 511);
      out[15 + outPos] =
          //                   [_______0]
          //                          [8________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 511)
        | //                   [76543210]
          //                  [_76543210]
            (((((int)in[17 + inPos]) & 255) ) & 511);
      out[16 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            (((((int)in[18 + inPos]) & 255) <<  1) & 511)
        | //                   [7_______]
          //           [________0]
            (((((int)in[19 + inPos]) & 255) >>>  7) & 511);
      out[17 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            (((((int)in[19 + inPos]) & 255) <<  2) & 511)
        | //                   [76______]
          //            [_______10]
            (((((int)in[20 + inPos]) & 255) >>>  6) & 511);
      out[18 + outPos] =
          //                   [__543210]
          //                     [876543___]
            (((((int)in[20 + inPos]) & 255) <<  3) & 511)
        | //                   [765_____]
          //             [______210]
            (((((int)in[21 + inPos]) & 255) >>>  5) & 511);
      out[19 + outPos] =
          //                   [___43210]
          //                      [87654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 511)
        | //                   [7654____]
          //              [_____3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 511);
      out[20 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            (((((int)in[22 + inPos]) & 255) <<  5) & 511)
        | //                   [76543___]
          //               [____43210]
            (((((int)in[23 + inPos]) & 255) >>>  3) & 511);
      out[21 + outPos] =
          //                   [_____210]
          //                        [876______]
            (((((int)in[23 + inPos]) & 255) <<  6) & 511)
        | //                   [765432__]
          //                [___543210]
            (((((int)in[24 + inPos]) & 255) >>>  2) & 511);
      out[22 + outPos] =
          //                   [______10]
          //                         [87_______]
            (((((int)in[24 + inPos]) & 255) <<  7) & 511)
        | //                   [7654321_]
          //                 [__6543210]
            (((((int)in[25 + inPos]) & 255) >>>  1) & 511);
      out[23 + outPos] =
          //                   [_______0]
          //                          [8________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 511)
        | //                   [76543210]
          //                  [_76543210]
            (((((int)in[26 + inPos]) & 255) ) & 511);
      out[24 + outPos] =
          //                   [76543210]
          //                   [87654321_]
            (((((int)in[27 + inPos]) & 255) <<  1) & 511)
        | //                   [7_______]
          //           [________0]
            (((((int)in[28 + inPos]) & 255) >>>  7) & 511);
      out[25 + outPos] =
          //                   [_6543210]
          //                    [8765432__]
            (((((int)in[28 + inPos]) & 255) <<  2) & 511)
        | //                   [76______]
          //            [_______10]
            (((((int)in[29 + inPos]) & 255) >>>  6) & 511);
      out[26 + outPos] =
          //                   [__543210]
          //                     [876543___]
            (((((int)in[29 + inPos]) & 255) <<  3) & 511)
        | //                   [765_____]
          //             [______210]
            (((((int)in[30 + inPos]) & 255) >>>  5) & 511);
      out[27 + outPos] =
          //                   [___43210]
          //                      [87654____]
            (((((int)in[30 + inPos]) & 255) <<  4) & 511)
        | //                   [7654____]
          //              [_____3210]
            (((((int)in[31 + inPos]) & 255) >>>  4) & 511);
      out[28 + outPos] =
          //                   [____3210]
          //                       [8765_____]
            (((((int)in[31 + inPos]) & 255) <<  5) & 511)
        | //                   [76543___]
          //               [____43210]
            (((((int)in[32 + inPos]) & 255) >>>  3) & 511);
      out[29 + outPos] =
          //                   [_____210]
          //                        [876______]
            (((((int)in[32 + inPos]) & 255) <<  6) & 511)
        | //                   [765432__]
          //                [___543210]
            (((((int)in[33 + inPos]) & 255) >>>  2) & 511);
      out[30 + outPos] =
          //                   [______10]
          //                         [87_______]
            (((((int)in[33 + inPos]) & 255) <<  7) & 511)
        | //                   [7654321_]
          //                 [__6543210]
            (((((int)in[34 + inPos]) & 255) >>>  1) & 511);
      out[31 + outPos] =
          //                   [_______0]
          //                          [8________]
            (((((int)in[34 + inPos]) & 255) <<  8) & 511)
        | //                   [76543210]
          //                  [_76543210]
            (((((int)in[35 + inPos]) & 255) ) & 511);
    }
  }

  private static final class Packer10 extends BytePacker {

    private Packer10() {
      super(10);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 0 + inPos] & 1023) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 0 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 1 + inPos] & 1023) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 1 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 2 + inPos] & 1023) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 2 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 3 + inPos] & 1023) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 3 + inPos] & 1023))) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 4 + inPos] & 1023) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 4 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 5 + inPos] & 1023) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 5 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 6 + inPos] & 1023) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 6 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 7 + inPos] & 1023) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 7 + inPos] & 1023))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 0 + inPos] & 1023) >>> 2)) & 255);
      out[ 1 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 0 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 1 + inPos] & 1023) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 1 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 2 + inPos] & 1023) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 2 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 3 + inPos] & 1023) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 3 + inPos] & 1023))) & 255);
      out[ 5 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 4 + inPos] & 1023) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 4 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 5 + inPos] & 1023) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 5 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[ 6 + inPos] & 1023) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[ 6 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[ 7 + inPos] & 1023) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[ 7 + inPos] & 1023))) & 255);
      out[10 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[ 8 + inPos] & 1023) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[ 8 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[ 9 + inPos] & 1023) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[ 9 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[10 + inPos] & 1023) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[10 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[11 + inPos] & 1023) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[11 + inPos] & 1023))) & 255);
      out[15 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[12 + inPos] & 1023) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[12 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[13 + inPos] & 1023) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[13 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[14 + inPos] & 1023) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[14 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[15 + inPos] & 1023) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[15 + inPos] & 1023))) & 255);
      out[20 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[16 + inPos] & 1023) >>> 2)) & 255);
      out[21 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[16 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[17 + inPos] & 1023) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[17 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[18 + inPos] & 1023) >>> 6)) & 255);
      out[23 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[18 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[19 + inPos] & 1023) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[19 + inPos] & 1023))) & 255);
      out[25 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[20 + inPos] & 1023) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[20 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[21 + inPos] & 1023) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[21 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[22 + inPos] & 1023) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[22 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[23 + inPos] & 1023) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[23 + inPos] & 1023))) & 255);
      out[30 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[24 + inPos] & 1023) >>> 2)) & 255);
      out[31 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[24 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[25 + inPos] & 1023) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[25 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[26 + inPos] & 1023) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[26 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[27 + inPos] & 1023) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[27 + inPos] & 1023))) & 255);
      out[35 + outPos] = (byte)((
          //                    [76543210]
          //                    [98765432__]
           ((in[28 + inPos] & 1023) >>> 2)) & 255);
      out[36 + outPos] = (byte)((
          //                    [76______]
          //            [________10]
           ((in[28 + inPos] & 1023) <<  6)
        | //                    [__543210]
          //                      [987654____]
           ((in[29 + inPos] & 1023) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                    [7654____]
          //              [______3210]
           ((in[29 + inPos] & 1023) <<  4)
        | //                    [____3210]
          //                        [9876______]
           ((in[30 + inPos] & 1023) >>> 6)) & 255);
      out[38 + outPos] = (byte)((
          //                    [765432__]
          //                [____543210]
           ((in[30 + inPos] & 1023) <<  2)
        | //                    [______10]
          //                          [98________]
           ((in[31 + inPos] & 1023) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                    [76543210]
          //                  [__76543210]
           ((in[31 + inPos] & 1023))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[ 0 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 1023);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 1023);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[ 2 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 1023);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[ 3 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 1023);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[ 5 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 1023);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 1023);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[ 7 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 1023);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 1023);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[ 0 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[ 1 + inPos]) & 255) >>>  6) & 1023);
      out[ 1 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 1023);
      out[ 2 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[ 2 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 1023);
      out[ 3 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[ 3 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 1023);
      out[ 4 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[ 5 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 1023);
      out[ 5 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 1023);
      out[ 6 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[ 7 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 1023);
      out[ 7 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 1023);
      out[ 8 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 1023);
      out[ 9 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 1023);
      out[10 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[12 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[13 + inPos]) & 255) >>>  2) & 1023);
      out[11 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[14 + inPos]) & 255) ) & 1023);
      out[12 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[15 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[16 + inPos]) & 255) >>>  6) & 1023);
      out[13 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 1023);
      out[14 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[17 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 1023);
      out[15 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[18 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[19 + inPos]) & 255) ) & 1023);
      out[16 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[20 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[21 + inPos]) & 255) >>>  6) & 1023);
      out[17 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 1023);
      out[18 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[22 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[23 + inPos]) & 255) >>>  2) & 1023);
      out[19 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[23 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[24 + inPos]) & 255) ) & 1023);
      out[20 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[25 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[26 + inPos]) & 255) >>>  6) & 1023);
      out[21 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[26 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[27 + inPos]) & 255) >>>  4) & 1023);
      out[22 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[27 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[28 + inPos]) & 255) >>>  2) & 1023);
      out[23 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[29 + inPos]) & 255) ) & 1023);
      out[24 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[30 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[31 + inPos]) & 255) >>>  6) & 1023);
      out[25 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[31 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[32 + inPos]) & 255) >>>  4) & 1023);
      out[26 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[32 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[33 + inPos]) & 255) >>>  2) & 1023);
      out[27 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[33 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[34 + inPos]) & 255) ) & 1023);
      out[28 + outPos] =
          //                    [76543210]
          //                    [98765432__]
            (((((int)in[35 + inPos]) & 255) <<  2) & 1023)
        | //                    [76______]
          //            [________10]
            (((((int)in[36 + inPos]) & 255) >>>  6) & 1023);
      out[29 + outPos] =
          //                    [__543210]
          //                      [987654____]
            (((((int)in[36 + inPos]) & 255) <<  4) & 1023)
        | //                    [7654____]
          //              [______3210]
            (((((int)in[37 + inPos]) & 255) >>>  4) & 1023);
      out[30 + outPos] =
          //                    [____3210]
          //                        [9876______]
            (((((int)in[37 + inPos]) & 255) <<  6) & 1023)
        | //                    [765432__]
          //                [____543210]
            (((((int)in[38 + inPos]) & 255) >>>  2) & 1023);
      out[31 + outPos] =
          //                    [______10]
          //                          [98________]
            (((((int)in[38 + inPos]) & 255) <<  8) & 1023)
        | //                    [76543210]
          //                  [__76543210]
            (((((int)in[39 + inPos]) & 255) ) & 1023);
    }
  }

  private static final class Packer11 extends BytePacker {

    private Packer11() {
      super(11);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 0 + inPos] & 2047) >>> 3)) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 0 + inPos] & 2047) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 1 + inPos] & 2047) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 1 + inPos] & 2047) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[ 2 + inPos] & 2047) >>> 9)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 2 + inPos] & 2047) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[ 2 + inPos] & 2047) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[ 3 + inPos] & 2047) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[ 3 + inPos] & 2047) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[ 4 + inPos] & 2047) >>> 7)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[ 4 + inPos] & 2047) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[ 5 + inPos] & 2047) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 5 + inPos] & 2047) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[ 5 + inPos] & 2047) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[ 6 + inPos] & 2047) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[ 6 + inPos] & 2047) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[ 7 + inPos] & 2047) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 7 + inPos] & 2047))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 0 + inPos] & 2047) >>> 3)) & 255);
      out[ 1 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 0 + inPos] & 2047) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 1 + inPos] & 2047) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 1 + inPos] & 2047) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[ 2 + inPos] & 2047) >>> 9)) & 255);
      out[ 3 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[ 2 + inPos] & 2047) >>> 1)) & 255);
      out[ 4 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[ 2 + inPos] & 2047) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[ 3 + inPos] & 2047) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[ 3 + inPos] & 2047) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[ 4 + inPos] & 2047) >>> 7)) & 255);
      out[ 6 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[ 4 + inPos] & 2047) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[ 5 + inPos] & 2047) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[ 5 + inPos] & 2047) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[ 5 + inPos] & 2047) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[ 6 + inPos] & 2047) >>> 5)) & 255);
      out[ 9 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[ 6 + inPos] & 2047) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[ 7 + inPos] & 2047) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[ 7 + inPos] & 2047))) & 255);
      out[11 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[ 8 + inPos] & 2047) >>> 3)) & 255);
      out[12 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[ 8 + inPos] & 2047) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[ 9 + inPos] & 2047) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[ 9 + inPos] & 2047) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[10 + inPos] & 2047) >>> 9)) & 255);
      out[14 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[10 + inPos] & 2047) >>> 1)) & 255);
      out[15 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[10 + inPos] & 2047) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[11 + inPos] & 2047) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[11 + inPos] & 2047) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[12 + inPos] & 2047) >>> 7)) & 255);
      out[17 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[12 + inPos] & 2047) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[13 + inPos] & 2047) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[13 + inPos] & 2047) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[13 + inPos] & 2047) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[14 + inPos] & 2047) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[14 + inPos] & 2047) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[15 + inPos] & 2047) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[15 + inPos] & 2047))) & 255);
      out[22 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[16 + inPos] & 2047) >>> 3)) & 255);
      out[23 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[16 + inPos] & 2047) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[17 + inPos] & 2047) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[17 + inPos] & 2047) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[18 + inPos] & 2047) >>> 9)) & 255);
      out[25 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[18 + inPos] & 2047) >>> 1)) & 255);
      out[26 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[18 + inPos] & 2047) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[19 + inPos] & 2047) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[19 + inPos] & 2047) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[20 + inPos] & 2047) >>> 7)) & 255);
      out[28 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[20 + inPos] & 2047) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[21 + inPos] & 2047) >>> 10)) & 255);
      out[29 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[21 + inPos] & 2047) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[21 + inPos] & 2047) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[22 + inPos] & 2047) >>> 5)) & 255);
      out[31 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[22 + inPos] & 2047) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[23 + inPos] & 2047) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[23 + inPos] & 2047))) & 255);
      out[33 + outPos] = (byte)((
          //                     [76543210]
          //                     [09876543___]
           ((in[24 + inPos] & 2047) >>> 3)) & 255);
      out[34 + outPos] = (byte)((
          //                     [765_____]
          //             [________210]
           ((in[24 + inPos] & 2047) <<  5)
        | //                     [___43210]
          //                        [09876______]
           ((in[25 + inPos] & 2047) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                     [765432__]
          //                [_____543210]
           ((in[25 + inPos] & 2047) <<  2)
        | //                     [______10]
          //                           [09_________]
           ((in[26 + inPos] & 2047) >>> 9)) & 255);
      out[36 + outPos] = (byte)((
          //                     [76543210]
          //                   [__87654321_]
           ((in[26 + inPos] & 2047) >>> 1)) & 255);
      out[37 + outPos] = (byte)((
          //                     [7_______]
          //           [__________0]
           ((in[26 + inPos] & 2047) <<  7)
        | //                     [_6543210]
          //                      [0987654____]
           ((in[27 + inPos] & 2047) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                     [7654____]
          //              [_______3210]
           ((in[27 + inPos] & 2047) <<  4)
        | //                     [____3210]
          //                         [0987_______]
           ((in[28 + inPos] & 2047) >>> 7)) & 255);
      out[39 + outPos] = (byte)((
          //                     [7654321_]
          //                 [____6543210]
           ((in[28 + inPos] & 2047) <<  1)
        | //                     [_______0]
          //                            [0__________]
           ((in[29 + inPos] & 2047) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                     [76543210]
          //                    [_98765432__]
           ((in[29 + inPos] & 2047) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                     [76______]
          //            [_________10]
           ((in[29 + inPos] & 2047) <<  6)
        | //                     [__543210]
          //                       [098765_____]
           ((in[30 + inPos] & 2047) >>> 5)) & 255);
      out[42 + outPos] = (byte)((
          //                     [76543___]
          //               [______43210]
           ((in[30 + inPos] & 2047) <<  3)
        | //                     [_____210]
          //                          [098________]
           ((in[31 + inPos] & 2047) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                     [76543210]
          //                  [___76543210]
           ((in[31 + inPos] & 2047))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            (((((int)in[ 0 + inPos]) & 255) <<  3) & 2047)
        | //                     [765_____]
          //             [________210]
            (((((int)in[ 1 + inPos]) & 255) >>>  5) & 2047);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            (((((int)in[ 1 + inPos]) & 255) <<  6) & 2047)
        | //                     [765432__]
          //                [_____543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 2047);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            (((((int)in[ 2 + inPos]) & 255) <<  9) & 2047)
        | //                     [76543210]
          //                   [__87654321_]
            (((((int)in[ 3 + inPos]) & 255) <<  1) & 2047)
        | //                     [7_______]
          //           [__________0]
            (((((int)in[ 4 + inPos]) & 255) >>>  7) & 2047);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            (((((int)in[ 4 + inPos]) & 255) <<  4) & 2047)
        | //                     [7654____]
          //              [_______3210]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 2047);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            (((((int)in[ 5 + inPos]) & 255) <<  7) & 2047)
        | //                     [7654321_]
          //                 [____6543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  1) & 2047);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            (((((int)in[ 6 + inPos]) & 255) <<  10) & 2047)
        | //                     [76543210]
          //                    [_98765432__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 2047)
        | //                     [76______]
          //            [_________10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 2047);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            (((((int)in[ 8 + inPos]) & 255) <<  5) & 2047)
        | //                     [76543___]
          //               [______43210]
            (((((int)in[ 9 + inPos]) & 255) >>>  3) & 2047);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            (((((int)in[ 9 + inPos]) & 255) <<  8) & 2047)
        | //                     [76543210]
          //                  [___76543210]
            (((((int)in[10 + inPos]) & 255) ) & 2047);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            (((((int)in[ 0 + inPos]) & 255) <<  3) & 2047)
        | //                     [765_____]
          //             [________210]
            (((((int)in[ 1 + inPos]) & 255) >>>  5) & 2047);
      out[ 1 + outPos] =
          //                     [___43210]
          //                        [09876______]
            (((((int)in[ 1 + inPos]) & 255) <<  6) & 2047)
        | //                     [765432__]
          //                [_____543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 2047);
      out[ 2 + outPos] =
          //                     [______10]
          //                           [09_________]
            (((((int)in[ 2 + inPos]) & 255) <<  9) & 2047)
        | //                     [76543210]
          //                   [__87654321_]
            (((((int)in[ 3 + inPos]) & 255) <<  1) & 2047)
        | //                     [7_______]
          //           [__________0]
            (((((int)in[ 4 + inPos]) & 255) >>>  7) & 2047);
      out[ 3 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            (((((int)in[ 4 + inPos]) & 255) <<  4) & 2047)
        | //                     [7654____]
          //              [_______3210]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 2047);
      out[ 4 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            (((((int)in[ 5 + inPos]) & 255) <<  7) & 2047)
        | //                     [7654321_]
          //                 [____6543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  1) & 2047);
      out[ 5 + outPos] =
          //                     [_______0]
          //                            [0__________]
            (((((int)in[ 6 + inPos]) & 255) <<  10) & 2047)
        | //                     [76543210]
          //                    [_98765432__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 2047)
        | //                     [76______]
          //            [_________10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 2047);
      out[ 6 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            (((((int)in[ 8 + inPos]) & 255) <<  5) & 2047)
        | //                     [76543___]
          //               [______43210]
            (((((int)in[ 9 + inPos]) & 255) >>>  3) & 2047);
      out[ 7 + outPos] =
          //                     [_____210]
          //                          [098________]
            (((((int)in[ 9 + inPos]) & 255) <<  8) & 2047)
        | //                     [76543210]
          //                  [___76543210]
            (((((int)in[10 + inPos]) & 255) ) & 2047);
      out[ 8 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            (((((int)in[11 + inPos]) & 255) <<  3) & 2047)
        | //                     [765_____]
          //             [________210]
            (((((int)in[12 + inPos]) & 255) >>>  5) & 2047);
      out[ 9 + outPos] =
          //                     [___43210]
          //                        [09876______]
            (((((int)in[12 + inPos]) & 255) <<  6) & 2047)
        | //                     [765432__]
          //                [_____543210]
            (((((int)in[13 + inPos]) & 255) >>>  2) & 2047);
      out[10 + outPos] =
          //                     [______10]
          //                           [09_________]
            (((((int)in[13 + inPos]) & 255) <<  9) & 2047)
        | //                     [76543210]
          //                   [__87654321_]
            (((((int)in[14 + inPos]) & 255) <<  1) & 2047)
        | //                     [7_______]
          //           [__________0]
            (((((int)in[15 + inPos]) & 255) >>>  7) & 2047);
      out[11 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            (((((int)in[15 + inPos]) & 255) <<  4) & 2047)
        | //                     [7654____]
          //              [_______3210]
            (((((int)in[16 + inPos]) & 255) >>>  4) & 2047);
      out[12 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            (((((int)in[16 + inPos]) & 255) <<  7) & 2047)
        | //                     [7654321_]
          //                 [____6543210]
            (((((int)in[17 + inPos]) & 255) >>>  1) & 2047);
      out[13 + outPos] =
          //                     [_______0]
          //                            [0__________]
            (((((int)in[17 + inPos]) & 255) <<  10) & 2047)
        | //                     [76543210]
          //                    [_98765432__]
            (((((int)in[18 + inPos]) & 255) <<  2) & 2047)
        | //                     [76______]
          //            [_________10]
            (((((int)in[19 + inPos]) & 255) >>>  6) & 2047);
      out[14 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            (((((int)in[19 + inPos]) & 255) <<  5) & 2047)
        | //                     [76543___]
          //               [______43210]
            (((((int)in[20 + inPos]) & 255) >>>  3) & 2047);
      out[15 + outPos] =
          //                     [_____210]
          //                          [098________]
            (((((int)in[20 + inPos]) & 255) <<  8) & 2047)
        | //                     [76543210]
          //                  [___76543210]
            (((((int)in[21 + inPos]) & 255) ) & 2047);
      out[16 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            (((((int)in[22 + inPos]) & 255) <<  3) & 2047)
        | //                     [765_____]
          //             [________210]
            (((((int)in[23 + inPos]) & 255) >>>  5) & 2047);
      out[17 + outPos] =
          //                     [___43210]
          //                        [09876______]
            (((((int)in[23 + inPos]) & 255) <<  6) & 2047)
        | //                     [765432__]
          //                [_____543210]
            (((((int)in[24 + inPos]) & 255) >>>  2) & 2047);
      out[18 + outPos] =
          //                     [______10]
          //                           [09_________]
            (((((int)in[24 + inPos]) & 255) <<  9) & 2047)
        | //                     [76543210]
          //                   [__87654321_]
            (((((int)in[25 + inPos]) & 255) <<  1) & 2047)
        | //                     [7_______]
          //           [__________0]
            (((((int)in[26 + inPos]) & 255) >>>  7) & 2047);
      out[19 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            (((((int)in[26 + inPos]) & 255) <<  4) & 2047)
        | //                     [7654____]
          //              [_______3210]
            (((((int)in[27 + inPos]) & 255) >>>  4) & 2047);
      out[20 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            (((((int)in[27 + inPos]) & 255) <<  7) & 2047)
        | //                     [7654321_]
          //                 [____6543210]
            (((((int)in[28 + inPos]) & 255) >>>  1) & 2047);
      out[21 + outPos] =
          //                     [_______0]
          //                            [0__________]
            (((((int)in[28 + inPos]) & 255) <<  10) & 2047)
        | //                     [76543210]
          //                    [_98765432__]
            (((((int)in[29 + inPos]) & 255) <<  2) & 2047)
        | //                     [76______]
          //            [_________10]
            (((((int)in[30 + inPos]) & 255) >>>  6) & 2047);
      out[22 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            (((((int)in[30 + inPos]) & 255) <<  5) & 2047)
        | //                     [76543___]
          //               [______43210]
            (((((int)in[31 + inPos]) & 255) >>>  3) & 2047);
      out[23 + outPos] =
          //                     [_____210]
          //                          [098________]
            (((((int)in[31 + inPos]) & 255) <<  8) & 2047)
        | //                     [76543210]
          //                  [___76543210]
            (((((int)in[32 + inPos]) & 255) ) & 2047);
      out[24 + outPos] =
          //                     [76543210]
          //                     [09876543___]
            (((((int)in[33 + inPos]) & 255) <<  3) & 2047)
        | //                     [765_____]
          //             [________210]
            (((((int)in[34 + inPos]) & 255) >>>  5) & 2047);
      out[25 + outPos] =
          //                     [___43210]
          //                        [09876______]
            (((((int)in[34 + inPos]) & 255) <<  6) & 2047)
        | //                     [765432__]
          //                [_____543210]
            (((((int)in[35 + inPos]) & 255) >>>  2) & 2047);
      out[26 + outPos] =
          //                     [______10]
          //                           [09_________]
            (((((int)in[35 + inPos]) & 255) <<  9) & 2047)
        | //                     [76543210]
          //                   [__87654321_]
            (((((int)in[36 + inPos]) & 255) <<  1) & 2047)
        | //                     [7_______]
          //           [__________0]
            (((((int)in[37 + inPos]) & 255) >>>  7) & 2047);
      out[27 + outPos] =
          //                     [_6543210]
          //                      [0987654____]
            (((((int)in[37 + inPos]) & 255) <<  4) & 2047)
        | //                     [7654____]
          //              [_______3210]
            (((((int)in[38 + inPos]) & 255) >>>  4) & 2047);
      out[28 + outPos] =
          //                     [____3210]
          //                         [0987_______]
            (((((int)in[38 + inPos]) & 255) <<  7) & 2047)
        | //                     [7654321_]
          //                 [____6543210]
            (((((int)in[39 + inPos]) & 255) >>>  1) & 2047);
      out[29 + outPos] =
          //                     [_______0]
          //                            [0__________]
            (((((int)in[39 + inPos]) & 255) <<  10) & 2047)
        | //                     [76543210]
          //                    [_98765432__]
            (((((int)in[40 + inPos]) & 255) <<  2) & 2047)
        | //                     [76______]
          //            [_________10]
            (((((int)in[41 + inPos]) & 255) >>>  6) & 2047);
      out[30 + outPos] =
          //                     [__543210]
          //                       [098765_____]
            (((((int)in[41 + inPos]) & 255) <<  5) & 2047)
        | //                     [76543___]
          //               [______43210]
            (((((int)in[42 + inPos]) & 255) >>>  3) & 2047);
      out[31 + outPos] =
          //                     [_____210]
          //                          [098________]
            (((((int)in[42 + inPos]) & 255) <<  8) & 2047)
        | //                     [76543210]
          //                  [___76543210]
            (((((int)in[43 + inPos]) & 255) ) & 2047);
    }
  }

  private static final class Packer12 extends BytePacker {

    private Packer12() {
      super(12);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 0 + inPos] & 4095) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 0 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 1 + inPos] & 4095) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 1 + inPos] & 4095))) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 2 + inPos] & 4095) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 2 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 3 + inPos] & 4095) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 3 + inPos] & 4095))) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 4 + inPos] & 4095) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 4 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 5 + inPos] & 4095) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 5 + inPos] & 4095))) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 6 + inPos] & 4095) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 6 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 7 + inPos] & 4095) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 7 + inPos] & 4095))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 0 + inPos] & 4095) >>> 4)) & 255);
      out[ 1 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 0 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 1 + inPos] & 4095) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 1 + inPos] & 4095))) & 255);
      out[ 3 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 2 + inPos] & 4095) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 2 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 3 + inPos] & 4095) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 3 + inPos] & 4095))) & 255);
      out[ 6 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 4 + inPos] & 4095) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 4 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 5 + inPos] & 4095) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 5 + inPos] & 4095))) & 255);
      out[ 9 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 6 + inPos] & 4095) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 6 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 7 + inPos] & 4095) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 7 + inPos] & 4095))) & 255);
      out[12 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[ 8 + inPos] & 4095) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[ 8 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[ 9 + inPos] & 4095) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[ 9 + inPos] & 4095))) & 255);
      out[15 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[10 + inPos] & 4095) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[10 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[11 + inPos] & 4095) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[11 + inPos] & 4095))) & 255);
      out[18 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[12 + inPos] & 4095) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[12 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[13 + inPos] & 4095) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[13 + inPos] & 4095))) & 255);
      out[21 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[14 + inPos] & 4095) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[14 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[15 + inPos] & 4095) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[15 + inPos] & 4095))) & 255);
      out[24 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[16 + inPos] & 4095) >>> 4)) & 255);
      out[25 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[16 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[17 + inPos] & 4095) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[17 + inPos] & 4095))) & 255);
      out[27 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[18 + inPos] & 4095) >>> 4)) & 255);
      out[28 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[18 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[19 + inPos] & 4095) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[19 + inPos] & 4095))) & 255);
      out[30 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[20 + inPos] & 4095) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[20 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[21 + inPos] & 4095) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[21 + inPos] & 4095))) & 255);
      out[33 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[22 + inPos] & 4095) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[22 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[23 + inPos] & 4095) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[23 + inPos] & 4095))) & 255);
      out[36 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[24 + inPos] & 4095) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[24 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[25 + inPos] & 4095) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[25 + inPos] & 4095))) & 255);
      out[39 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[26 + inPos] & 4095) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[26 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[27 + inPos] & 4095) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[27 + inPos] & 4095))) & 255);
      out[42 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[28 + inPos] & 4095) >>> 4)) & 255);
      out[43 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[28 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[29 + inPos] & 4095) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[29 + inPos] & 4095))) & 255);
      out[45 + outPos] = (byte)((
          //                      [76543210]
          //                      [10987654____]
           ((in[30 + inPos] & 4095) >>> 4)) & 255);
      out[46 + outPos] = (byte)((
          //                      [7654____]
          //              [________3210]
           ((in[30 + inPos] & 4095) <<  4)
        | //                      [____3210]
          //                          [1098________]
           ((in[31 + inPos] & 4095) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                      [76543210]
          //                  [____76543210]
           ((in[31 + inPos] & 4095))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 0 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 4095);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 1 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 4095);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 4095);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 4095);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 4095);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 4095);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 4095);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[11 + inPos]) & 255) ) & 4095);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 0 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 1 + inPos]) & 255) >>>  4) & 4095);
      out[ 1 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 1 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 4095);
      out[ 2 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 4095);
      out[ 3 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 4095);
      out[ 4 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 4095);
      out[ 5 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 4095);
      out[ 6 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 4095);
      out[ 7 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[11 + inPos]) & 255) ) & 4095);
      out[ 8 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 4095);
      out[ 9 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[14 + inPos]) & 255) ) & 4095);
      out[10 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[15 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[16 + inPos]) & 255) >>>  4) & 4095);
      out[11 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[17 + inPos]) & 255) ) & 4095);
      out[12 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[18 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[19 + inPos]) & 255) >>>  4) & 4095);
      out[13 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[20 + inPos]) & 255) ) & 4095);
      out[14 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 4095);
      out[15 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[22 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[23 + inPos]) & 255) ) & 4095);
      out[16 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[24 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[25 + inPos]) & 255) >>>  4) & 4095);
      out[17 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[26 + inPos]) & 255) ) & 4095);
      out[18 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[27 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[28 + inPos]) & 255) >>>  4) & 4095);
      out[19 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[29 + inPos]) & 255) ) & 4095);
      out[20 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[30 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[31 + inPos]) & 255) >>>  4) & 4095);
      out[21 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[31 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[32 + inPos]) & 255) ) & 4095);
      out[22 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[33 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[34 + inPos]) & 255) >>>  4) & 4095);
      out[23 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[34 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[35 + inPos]) & 255) ) & 4095);
      out[24 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[36 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[37 + inPos]) & 255) >>>  4) & 4095);
      out[25 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[37 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[38 + inPos]) & 255) ) & 4095);
      out[26 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[39 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[40 + inPos]) & 255) >>>  4) & 4095);
      out[27 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[40 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[41 + inPos]) & 255) ) & 4095);
      out[28 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[42 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[43 + inPos]) & 255) >>>  4) & 4095);
      out[29 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[43 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[44 + inPos]) & 255) ) & 4095);
      out[30 + outPos] =
          //                      [76543210]
          //                      [10987654____]
            (((((int)in[45 + inPos]) & 255) <<  4) & 4095)
        | //                      [7654____]
          //              [________3210]
            (((((int)in[46 + inPos]) & 255) >>>  4) & 4095);
      out[31 + outPos] =
          //                      [____3210]
          //                          [1098________]
            (((((int)in[46 + inPos]) & 255) <<  8) & 4095)
        | //                      [76543210]
          //                  [____76543210]
            (((((int)in[47 + inPos]) & 255) ) & 4095);
    }
  }

  private static final class Packer13 extends BytePacker {

    private Packer13() {
      super(13);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 0 + inPos] & 8191) >>> 5)) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 0 + inPos] & 8191) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 1 + inPos] & 8191) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 1 + inPos] & 8191) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 1 + inPos] & 8191) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[ 2 + inPos] & 8191) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[ 2 + inPos] & 8191) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[ 3 + inPos] & 8191) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 3 + inPos] & 8191) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[ 3 + inPos] & 8191) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[ 4 + inPos] & 8191) >>> 9)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 4 + inPos] & 8191) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[ 4 + inPos] & 8191) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[ 5 + inPos] & 8191) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[ 5 + inPos] & 8191) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[ 6 + inPos] & 8191) >>> 11)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 6 + inPos] & 8191) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[ 6 + inPos] & 8191) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[ 7 + inPos] & 8191) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 7 + inPos] & 8191))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 0 + inPos] & 8191) >>> 5)) & 255);
      out[ 1 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 0 + inPos] & 8191) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 1 + inPos] & 8191) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 1 + inPos] & 8191) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 1 + inPos] & 8191) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[ 2 + inPos] & 8191) >>> 7)) & 255);
      out[ 4 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[ 2 + inPos] & 8191) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[ 3 + inPos] & 8191) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[ 3 + inPos] & 8191) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[ 3 + inPos] & 8191) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[ 4 + inPos] & 8191) >>> 9)) & 255);
      out[ 7 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[ 4 + inPos] & 8191) >>> 1)) & 255);
      out[ 8 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[ 4 + inPos] & 8191) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[ 5 + inPos] & 8191) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[ 5 + inPos] & 8191) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[ 6 + inPos] & 8191) >>> 11)) & 255);
      out[10 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[ 6 + inPos] & 8191) >>> 3)) & 255);
      out[11 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[ 6 + inPos] & 8191) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[ 7 + inPos] & 8191) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[ 7 + inPos] & 8191))) & 255);
      out[13 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[ 8 + inPos] & 8191) >>> 5)) & 255);
      out[14 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[ 8 + inPos] & 8191) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[ 9 + inPos] & 8191) >>> 10)) & 255);
      out[15 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[ 9 + inPos] & 8191) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[ 9 + inPos] & 8191) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[10 + inPos] & 8191) >>> 7)) & 255);
      out[17 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[10 + inPos] & 8191) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[11 + inPos] & 8191) >>> 12)) & 255);
      out[18 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[11 + inPos] & 8191) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[11 + inPos] & 8191) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[12 + inPos] & 8191) >>> 9)) & 255);
      out[20 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[12 + inPos] & 8191) >>> 1)) & 255);
      out[21 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[12 + inPos] & 8191) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[13 + inPos] & 8191) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[13 + inPos] & 8191) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[14 + inPos] & 8191) >>> 11)) & 255);
      out[23 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[14 + inPos] & 8191) >>> 3)) & 255);
      out[24 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[14 + inPos] & 8191) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[15 + inPos] & 8191) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[15 + inPos] & 8191))) & 255);
      out[26 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[16 + inPos] & 8191) >>> 5)) & 255);
      out[27 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[16 + inPos] & 8191) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[17 + inPos] & 8191) >>> 10)) & 255);
      out[28 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[17 + inPos] & 8191) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[17 + inPos] & 8191) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[18 + inPos] & 8191) >>> 7)) & 255);
      out[30 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[18 + inPos] & 8191) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[19 + inPos] & 8191) >>> 12)) & 255);
      out[31 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[19 + inPos] & 8191) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[19 + inPos] & 8191) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[20 + inPos] & 8191) >>> 9)) & 255);
      out[33 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[20 + inPos] & 8191) >>> 1)) & 255);
      out[34 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[20 + inPos] & 8191) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[21 + inPos] & 8191) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[21 + inPos] & 8191) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[22 + inPos] & 8191) >>> 11)) & 255);
      out[36 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[22 + inPos] & 8191) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[22 + inPos] & 8191) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[23 + inPos] & 8191) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[23 + inPos] & 8191))) & 255);
      out[39 + outPos] = (byte)((
          //                       [76543210]
          //                       [21098765_____]
           ((in[24 + inPos] & 8191) >>> 5)) & 255);
      out[40 + outPos] = (byte)((
          //                       [76543___]
          //               [________43210]
           ((in[24 + inPos] & 8191) <<  3)
        | //                       [_____210]
          //                            [210__________]
           ((in[25 + inPos] & 8191) >>> 10)) & 255);
      out[41 + outPos] = (byte)((
          //                       [76543210]
          //                    [___98765432__]
           ((in[25 + inPos] & 8191) >>> 2)) & 255);
      out[42 + outPos] = (byte)((
          //                       [76______]
          //            [___________10]
           ((in[25 + inPos] & 8191) <<  6)
        | //                       [__543210]
          //                         [210987_______]
           ((in[26 + inPos] & 8191) >>> 7)) & 255);
      out[43 + outPos] = (byte)((
          //                       [7654321_]
          //                 [______6543210]
           ((in[26 + inPos] & 8191) <<  1)
        | //                       [_______0]
          //                              [2____________]
           ((in[27 + inPos] & 8191) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                       [76543210]
          //                      [_10987654____]
           ((in[27 + inPos] & 8191) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                       [7654____]
          //              [_________3210]
           ((in[27 + inPos] & 8191) <<  4)
        | //                       [____3210]
          //                           [2109_________]
           ((in[28 + inPos] & 8191) >>> 9)) & 255);
      out[46 + outPos] = (byte)((
          //                       [76543210]
          //                   [____87654321_]
           ((in[28 + inPos] & 8191) >>> 1)) & 255);
      out[47 + outPos] = (byte)((
          //                       [7_______]
          //           [____________0]
           ((in[28 + inPos] & 8191) <<  7)
        | //                       [_6543210]
          //                        [2109876______]
           ((in[29 + inPos] & 8191) >>> 6)) & 255);
      out[48 + outPos] = (byte)((
          //                       [765432__]
          //                [_______543210]
           ((in[29 + inPos] & 8191) <<  2)
        | //                       [______10]
          //                             [21___________]
           ((in[30 + inPos] & 8191) >>> 11)) & 255);
      out[49 + outPos] = (byte)((
          //                       [76543210]
          //                     [__09876543___]
           ((in[30 + inPos] & 8191) >>> 3)) & 255);
      out[50 + outPos] = (byte)((
          //                       [765_____]
          //             [__________210]
           ((in[30 + inPos] & 8191) <<  5)
        | //                       [___43210]
          //                          [21098________]
           ((in[31 + inPos] & 8191) >>> 8)) & 255);
      out[51 + outPos] = (byte)((
          //                       [76543210]
          //                  [_____76543210]
           ((in[31 + inPos] & 8191))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            (((((int)in[ 0 + inPos]) & 255) <<  5) & 8191)
        | //                       [76543___]
          //               [________43210]
            (((((int)in[ 1 + inPos]) & 255) >>>  3) & 8191);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            (((((int)in[ 1 + inPos]) & 255) <<  10) & 8191)
        | //                       [76543210]
          //                    [___98765432__]
            (((((int)in[ 2 + inPos]) & 255) <<  2) & 8191)
        | //                       [76______]
          //            [___________10]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 8191);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            (((((int)in[ 3 + inPos]) & 255) <<  7) & 8191)
        | //                       [7654321_]
          //                 [______6543210]
            (((((int)in[ 4 + inPos]) & 255) >>>  1) & 8191);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            (((((int)in[ 4 + inPos]) & 255) <<  12) & 8191)
        | //                       [76543210]
          //                      [_10987654____]
            (((((int)in[ 5 + inPos]) & 255) <<  4) & 8191)
        | //                       [7654____]
          //              [_________3210]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 8191);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            (((((int)in[ 6 + inPos]) & 255) <<  9) & 8191)
        | //                       [76543210]
          //                   [____87654321_]
            (((((int)in[ 7 + inPos]) & 255) <<  1) & 8191)
        | //                       [7_______]
          //           [____________0]
            (((((int)in[ 8 + inPos]) & 255) >>>  7) & 8191);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            (((((int)in[ 8 + inPos]) & 255) <<  6) & 8191)
        | //                       [765432__]
          //                [_______543210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 8191);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            (((((int)in[ 9 + inPos]) & 255) <<  11) & 8191)
        | //                       [76543210]
          //                     [__09876543___]
            (((((int)in[10 + inPos]) & 255) <<  3) & 8191)
        | //                       [765_____]
          //             [__________210]
            (((((int)in[11 + inPos]) & 255) >>>  5) & 8191);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            (((((int)in[11 + inPos]) & 255) <<  8) & 8191)
        | //                       [76543210]
          //                  [_____76543210]
            (((((int)in[12 + inPos]) & 255) ) & 8191);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            (((((int)in[ 0 + inPos]) & 255) <<  5) & 8191)
        | //                       [76543___]
          //               [________43210]
            (((((int)in[ 1 + inPos]) & 255) >>>  3) & 8191);
      out[ 1 + outPos] =
          //                       [_____210]
          //                            [210__________]
            (((((int)in[ 1 + inPos]) & 255) <<  10) & 8191)
        | //                       [76543210]
          //                    [___98765432__]
            (((((int)in[ 2 + inPos]) & 255) <<  2) & 8191)
        | //                       [76______]
          //            [___________10]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 8191);
      out[ 2 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            (((((int)in[ 3 + inPos]) & 255) <<  7) & 8191)
        | //                       [7654321_]
          //                 [______6543210]
            (((((int)in[ 4 + inPos]) & 255) >>>  1) & 8191);
      out[ 3 + outPos] =
          //                       [_______0]
          //                              [2____________]
            (((((int)in[ 4 + inPos]) & 255) <<  12) & 8191)
        | //                       [76543210]
          //                      [_10987654____]
            (((((int)in[ 5 + inPos]) & 255) <<  4) & 8191)
        | //                       [7654____]
          //              [_________3210]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 8191);
      out[ 4 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            (((((int)in[ 6 + inPos]) & 255) <<  9) & 8191)
        | //                       [76543210]
          //                   [____87654321_]
            (((((int)in[ 7 + inPos]) & 255) <<  1) & 8191)
        | //                       [7_______]
          //           [____________0]
            (((((int)in[ 8 + inPos]) & 255) >>>  7) & 8191);
      out[ 5 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            (((((int)in[ 8 + inPos]) & 255) <<  6) & 8191)
        | //                       [765432__]
          //                [_______543210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 8191);
      out[ 6 + outPos] =
          //                       [______10]
          //                             [21___________]
            (((((int)in[ 9 + inPos]) & 255) <<  11) & 8191)
        | //                       [76543210]
          //                     [__09876543___]
            (((((int)in[10 + inPos]) & 255) <<  3) & 8191)
        | //                       [765_____]
          //             [__________210]
            (((((int)in[11 + inPos]) & 255) >>>  5) & 8191);
      out[ 7 + outPos] =
          //                       [___43210]
          //                          [21098________]
            (((((int)in[11 + inPos]) & 255) <<  8) & 8191)
        | //                       [76543210]
          //                  [_____76543210]
            (((((int)in[12 + inPos]) & 255) ) & 8191);
      out[ 8 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            (((((int)in[13 + inPos]) & 255) <<  5) & 8191)
        | //                       [76543___]
          //               [________43210]
            (((((int)in[14 + inPos]) & 255) >>>  3) & 8191);
      out[ 9 + outPos] =
          //                       [_____210]
          //                            [210__________]
            (((((int)in[14 + inPos]) & 255) <<  10) & 8191)
        | //                       [76543210]
          //                    [___98765432__]
            (((((int)in[15 + inPos]) & 255) <<  2) & 8191)
        | //                       [76______]
          //            [___________10]
            (((((int)in[16 + inPos]) & 255) >>>  6) & 8191);
      out[10 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            (((((int)in[16 + inPos]) & 255) <<  7) & 8191)
        | //                       [7654321_]
          //                 [______6543210]
            (((((int)in[17 + inPos]) & 255) >>>  1) & 8191);
      out[11 + outPos] =
          //                       [_______0]
          //                              [2____________]
            (((((int)in[17 + inPos]) & 255) <<  12) & 8191)
        | //                       [76543210]
          //                      [_10987654____]
            (((((int)in[18 + inPos]) & 255) <<  4) & 8191)
        | //                       [7654____]
          //              [_________3210]
            (((((int)in[19 + inPos]) & 255) >>>  4) & 8191);
      out[12 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            (((((int)in[19 + inPos]) & 255) <<  9) & 8191)
        | //                       [76543210]
          //                   [____87654321_]
            (((((int)in[20 + inPos]) & 255) <<  1) & 8191)
        | //                       [7_______]
          //           [____________0]
            (((((int)in[21 + inPos]) & 255) >>>  7) & 8191);
      out[13 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            (((((int)in[21 + inPos]) & 255) <<  6) & 8191)
        | //                       [765432__]
          //                [_______543210]
            (((((int)in[22 + inPos]) & 255) >>>  2) & 8191);
      out[14 + outPos] =
          //                       [______10]
          //                             [21___________]
            (((((int)in[22 + inPos]) & 255) <<  11) & 8191)
        | //                       [76543210]
          //                     [__09876543___]
            (((((int)in[23 + inPos]) & 255) <<  3) & 8191)
        | //                       [765_____]
          //             [__________210]
            (((((int)in[24 + inPos]) & 255) >>>  5) & 8191);
      out[15 + outPos] =
          //                       [___43210]
          //                          [21098________]
            (((((int)in[24 + inPos]) & 255) <<  8) & 8191)
        | //                       [76543210]
          //                  [_____76543210]
            (((((int)in[25 + inPos]) & 255) ) & 8191);
      out[16 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            (((((int)in[26 + inPos]) & 255) <<  5) & 8191)
        | //                       [76543___]
          //               [________43210]
            (((((int)in[27 + inPos]) & 255) >>>  3) & 8191);
      out[17 + outPos] =
          //                       [_____210]
          //                            [210__________]
            (((((int)in[27 + inPos]) & 255) <<  10) & 8191)
        | //                       [76543210]
          //                    [___98765432__]
            (((((int)in[28 + inPos]) & 255) <<  2) & 8191)
        | //                       [76______]
          //            [___________10]
            (((((int)in[29 + inPos]) & 255) >>>  6) & 8191);
      out[18 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            (((((int)in[29 + inPos]) & 255) <<  7) & 8191)
        | //                       [7654321_]
          //                 [______6543210]
            (((((int)in[30 + inPos]) & 255) >>>  1) & 8191);
      out[19 + outPos] =
          //                       [_______0]
          //                              [2____________]
            (((((int)in[30 + inPos]) & 255) <<  12) & 8191)
        | //                       [76543210]
          //                      [_10987654____]
            (((((int)in[31 + inPos]) & 255) <<  4) & 8191)
        | //                       [7654____]
          //              [_________3210]
            (((((int)in[32 + inPos]) & 255) >>>  4) & 8191);
      out[20 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            (((((int)in[32 + inPos]) & 255) <<  9) & 8191)
        | //                       [76543210]
          //                   [____87654321_]
            (((((int)in[33 + inPos]) & 255) <<  1) & 8191)
        | //                       [7_______]
          //           [____________0]
            (((((int)in[34 + inPos]) & 255) >>>  7) & 8191);
      out[21 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            (((((int)in[34 + inPos]) & 255) <<  6) & 8191)
        | //                       [765432__]
          //                [_______543210]
            (((((int)in[35 + inPos]) & 255) >>>  2) & 8191);
      out[22 + outPos] =
          //                       [______10]
          //                             [21___________]
            (((((int)in[35 + inPos]) & 255) <<  11) & 8191)
        | //                       [76543210]
          //                     [__09876543___]
            (((((int)in[36 + inPos]) & 255) <<  3) & 8191)
        | //                       [765_____]
          //             [__________210]
            (((((int)in[37 + inPos]) & 255) >>>  5) & 8191);
      out[23 + outPos] =
          //                       [___43210]
          //                          [21098________]
            (((((int)in[37 + inPos]) & 255) <<  8) & 8191)
        | //                       [76543210]
          //                  [_____76543210]
            (((((int)in[38 + inPos]) & 255) ) & 8191);
      out[24 + outPos] =
          //                       [76543210]
          //                       [21098765_____]
            (((((int)in[39 + inPos]) & 255) <<  5) & 8191)
        | //                       [76543___]
          //               [________43210]
            (((((int)in[40 + inPos]) & 255) >>>  3) & 8191);
      out[25 + outPos] =
          //                       [_____210]
          //                            [210__________]
            (((((int)in[40 + inPos]) & 255) <<  10) & 8191)
        | //                       [76543210]
          //                    [___98765432__]
            (((((int)in[41 + inPos]) & 255) <<  2) & 8191)
        | //                       [76______]
          //            [___________10]
            (((((int)in[42 + inPos]) & 255) >>>  6) & 8191);
      out[26 + outPos] =
          //                       [__543210]
          //                         [210987_______]
            (((((int)in[42 + inPos]) & 255) <<  7) & 8191)
        | //                       [7654321_]
          //                 [______6543210]
            (((((int)in[43 + inPos]) & 255) >>>  1) & 8191);
      out[27 + outPos] =
          //                       [_______0]
          //                              [2____________]
            (((((int)in[43 + inPos]) & 255) <<  12) & 8191)
        | //                       [76543210]
          //                      [_10987654____]
            (((((int)in[44 + inPos]) & 255) <<  4) & 8191)
        | //                       [7654____]
          //              [_________3210]
            (((((int)in[45 + inPos]) & 255) >>>  4) & 8191);
      out[28 + outPos] =
          //                       [____3210]
          //                           [2109_________]
            (((((int)in[45 + inPos]) & 255) <<  9) & 8191)
        | //                       [76543210]
          //                   [____87654321_]
            (((((int)in[46 + inPos]) & 255) <<  1) & 8191)
        | //                       [7_______]
          //           [____________0]
            (((((int)in[47 + inPos]) & 255) >>>  7) & 8191);
      out[29 + outPos] =
          //                       [_6543210]
          //                        [2109876______]
            (((((int)in[47 + inPos]) & 255) <<  6) & 8191)
        | //                       [765432__]
          //                [_______543210]
            (((((int)in[48 + inPos]) & 255) >>>  2) & 8191);
      out[30 + outPos] =
          //                       [______10]
          //                             [21___________]
            (((((int)in[48 + inPos]) & 255) <<  11) & 8191)
        | //                       [76543210]
          //                     [__09876543___]
            (((((int)in[49 + inPos]) & 255) <<  3) & 8191)
        | //                       [765_____]
          //             [__________210]
            (((((int)in[50 + inPos]) & 255) >>>  5) & 8191);
      out[31 + outPos] =
          //                       [___43210]
          //                          [21098________]
            (((((int)in[50 + inPos]) & 255) <<  8) & 8191)
        | //                       [76543210]
          //                  [_____76543210]
            (((((int)in[51 + inPos]) & 255) ) & 8191);
    }
  }

  private static final class Packer14 extends BytePacker {

    private Packer14() {
      super(14);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 0 + inPos] & 16383) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 0 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 1 + inPos] & 16383) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 1 + inPos] & 16383) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 1 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 2 + inPos] & 16383) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 2 + inPos] & 16383) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 2 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 3 + inPos] & 16383) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 3 + inPos] & 16383))) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 4 + inPos] & 16383) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 4 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 5 + inPos] & 16383) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 5 + inPos] & 16383) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 5 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 6 + inPos] & 16383) >>> 10)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 6 + inPos] & 16383) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 6 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 7 + inPos] & 16383) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 7 + inPos] & 16383))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 0 + inPos] & 16383) >>> 6)) & 255);
      out[ 1 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 0 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 1 + inPos] & 16383) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 1 + inPos] & 16383) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 1 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 2 + inPos] & 16383) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 2 + inPos] & 16383) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 2 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 3 + inPos] & 16383) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 3 + inPos] & 16383))) & 255);
      out[ 7 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 4 + inPos] & 16383) >>> 6)) & 255);
      out[ 8 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 4 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 5 + inPos] & 16383) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 5 + inPos] & 16383) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 5 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[ 6 + inPos] & 16383) >>> 10)) & 255);
      out[11 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[ 6 + inPos] & 16383) >>> 2)) & 255);
      out[12 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[ 6 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[ 7 + inPos] & 16383) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[ 7 + inPos] & 16383))) & 255);
      out[14 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[ 8 + inPos] & 16383) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[ 8 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[ 9 + inPos] & 16383) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[ 9 + inPos] & 16383) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[ 9 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[10 + inPos] & 16383) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[10 + inPos] & 16383) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[10 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[11 + inPos] & 16383) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[11 + inPos] & 16383))) & 255);
      out[21 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[12 + inPos] & 16383) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[12 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[13 + inPos] & 16383) >>> 12)) & 255);
      out[23 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[13 + inPos] & 16383) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[13 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[14 + inPos] & 16383) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[14 + inPos] & 16383) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[14 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[15 + inPos] & 16383) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[15 + inPos] & 16383))) & 255);
      out[28 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[16 + inPos] & 16383) >>> 6)) & 255);
      out[29 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[16 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[17 + inPos] & 16383) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[17 + inPos] & 16383) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[17 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[18 + inPos] & 16383) >>> 10)) & 255);
      out[32 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[18 + inPos] & 16383) >>> 2)) & 255);
      out[33 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[18 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[19 + inPos] & 16383) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[19 + inPos] & 16383))) & 255);
      out[35 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[20 + inPos] & 16383) >>> 6)) & 255);
      out[36 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[20 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[21 + inPos] & 16383) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[21 + inPos] & 16383) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[21 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[22 + inPos] & 16383) >>> 10)) & 255);
      out[39 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[22 + inPos] & 16383) >>> 2)) & 255);
      out[40 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[22 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[23 + inPos] & 16383) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[23 + inPos] & 16383))) & 255);
      out[42 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[24 + inPos] & 16383) >>> 6)) & 255);
      out[43 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[24 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[25 + inPos] & 16383) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[25 + inPos] & 16383) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[25 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[26 + inPos] & 16383) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[26 + inPos] & 16383) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[26 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[27 + inPos] & 16383) >>> 8)) & 255);
      out[48 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[27 + inPos] & 16383))) & 255);
      out[49 + outPos] = (byte)((
          //                        [76543210]
          //                        [32109876______]
           ((in[28 + inPos] & 16383) >>> 6)) & 255);
      out[50 + outPos] = (byte)((
          //                        [765432__]
          //                [________543210]
           ((in[28 + inPos] & 16383) <<  2)
        | //                        [______10]
          //                              [32____________]
           ((in[29 + inPos] & 16383) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                        [76543210]
          //                      [__10987654____]
           ((in[29 + inPos] & 16383) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                        [7654____]
          //              [__________3210]
           ((in[29 + inPos] & 16383) <<  4)
        | //                        [____3210]
          //                            [3210__________]
           ((in[30 + inPos] & 16383) >>> 10)) & 255);
      out[53 + outPos] = (byte)((
          //                        [76543210]
          //                    [____98765432__]
           ((in[30 + inPos] & 16383) >>> 2)) & 255);
      out[54 + outPos] = (byte)((
          //                        [76______]
          //            [____________10]
           ((in[30 + inPos] & 16383) <<  6)
        | //                        [__543210]
          //                          [321098________]
           ((in[31 + inPos] & 16383) >>> 8)) & 255);
      out[55 + outPos] = (byte)((
          //                        [76543210]
          //                  [______76543210]
           ((in[31 + inPos] & 16383))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[ 0 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 16383);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[ 1 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[ 2 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 16383);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[ 3 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 16383);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[ 5 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 16383);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[ 7 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 16383);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[ 8 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 16383);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[10 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[11 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[12 + inPos]) & 255) >>>  6) & 16383);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[12 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[13 + inPos]) & 255) ) & 16383);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[ 0 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  2) & 16383);
      out[ 1 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[ 1 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[ 2 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 16383);
      out[ 2 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[ 3 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 16383);
      out[ 3 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[ 5 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 16383);
      out[ 4 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[ 7 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[ 8 + inPos]) & 255) >>>  2) & 16383);
      out[ 5 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[ 8 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 16383);
      out[ 6 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[10 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[11 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[12 + inPos]) & 255) >>>  6) & 16383);
      out[ 7 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[12 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[13 + inPos]) & 255) ) & 16383);
      out[ 8 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 16383);
      out[ 9 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[15 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 16383);
      out[10 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[17 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[18 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[19 + inPos]) & 255) >>>  6) & 16383);
      out[11 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[20 + inPos]) & 255) ) & 16383);
      out[12 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[21 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[22 + inPos]) & 255) >>>  2) & 16383);
      out[13 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[22 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[23 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[24 + inPos]) & 255) >>>  4) & 16383);
      out[14 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[24 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[25 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[26 + inPos]) & 255) >>>  6) & 16383);
      out[15 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[26 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[27 + inPos]) & 255) ) & 16383);
      out[16 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[28 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[29 + inPos]) & 255) >>>  2) & 16383);
      out[17 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[29 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[30 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[31 + inPos]) & 255) >>>  4) & 16383);
      out[18 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[31 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[32 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[33 + inPos]) & 255) >>>  6) & 16383);
      out[19 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[33 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[34 + inPos]) & 255) ) & 16383);
      out[20 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[35 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[36 + inPos]) & 255) >>>  2) & 16383);
      out[21 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[36 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[37 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[38 + inPos]) & 255) >>>  4) & 16383);
      out[22 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[38 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[39 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[40 + inPos]) & 255) >>>  6) & 16383);
      out[23 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[40 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[41 + inPos]) & 255) ) & 16383);
      out[24 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[42 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[43 + inPos]) & 255) >>>  2) & 16383);
      out[25 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[43 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[44 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[45 + inPos]) & 255) >>>  4) & 16383);
      out[26 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[45 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[46 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[47 + inPos]) & 255) >>>  6) & 16383);
      out[27 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[47 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[48 + inPos]) & 255) ) & 16383);
      out[28 + outPos] =
          //                        [76543210]
          //                        [32109876______]
            (((((int)in[49 + inPos]) & 255) <<  6) & 16383)
        | //                        [765432__]
          //                [________543210]
            (((((int)in[50 + inPos]) & 255) >>>  2) & 16383);
      out[29 + outPos] =
          //                        [______10]
          //                              [32____________]
            (((((int)in[50 + inPos]) & 255) <<  12) & 16383)
        | //                        [76543210]
          //                      [__10987654____]
            (((((int)in[51 + inPos]) & 255) <<  4) & 16383)
        | //                        [7654____]
          //              [__________3210]
            (((((int)in[52 + inPos]) & 255) >>>  4) & 16383);
      out[30 + outPos] =
          //                        [____3210]
          //                            [3210__________]
            (((((int)in[52 + inPos]) & 255) <<  10) & 16383)
        | //                        [76543210]
          //                    [____98765432__]
            (((((int)in[53 + inPos]) & 255) <<  2) & 16383)
        | //                        [76______]
          //            [____________10]
            (((((int)in[54 + inPos]) & 255) >>>  6) & 16383);
      out[31 + outPos] =
          //                        [__543210]
          //                          [321098________]
            (((((int)in[54 + inPos]) & 255) <<  8) & 16383)
        | //                        [76543210]
          //                  [______76543210]
            (((((int)in[55 + inPos]) & 255) ) & 16383);
    }
  }

  private static final class Packer15 extends BytePacker {

    private Packer15() {
      super(15);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 0 + inPos] & 32767) >>> 7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 0 + inPos] & 32767) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 1 + inPos] & 32767) >>> 14)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 1 + inPos] & 32767) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 1 + inPos] & 32767) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[ 2 + inPos] & 32767) >>> 13)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 2 + inPos] & 32767) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[ 2 + inPos] & 32767) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[ 3 + inPos] & 32767) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 3 + inPos] & 32767) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[ 3 + inPos] & 32767) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[ 4 + inPos] & 32767) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 4 + inPos] & 32767) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[ 4 + inPos] & 32767) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[ 5 + inPos] & 32767) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 5 + inPos] & 32767) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[ 5 + inPos] & 32767) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[ 6 + inPos] & 32767) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 6 + inPos] & 32767) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[ 6 + inPos] & 32767) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[ 7 + inPos] & 32767) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 7 + inPos] & 32767))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 0 + inPos] & 32767) >>> 7)) & 255);
      out[ 1 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 0 + inPos] & 32767) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 1 + inPos] & 32767) >>> 14)) & 255);
      out[ 2 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 1 + inPos] & 32767) >>> 6)) & 255);
      out[ 3 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 1 + inPos] & 32767) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[ 2 + inPos] & 32767) >>> 13)) & 255);
      out[ 4 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[ 2 + inPos] & 32767) >>> 5)) & 255);
      out[ 5 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[ 2 + inPos] & 32767) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[ 3 + inPos] & 32767) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[ 3 + inPos] & 32767) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[ 3 + inPos] & 32767) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[ 4 + inPos] & 32767) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[ 4 + inPos] & 32767) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[ 4 + inPos] & 32767) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[ 5 + inPos] & 32767) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[ 5 + inPos] & 32767) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[ 5 + inPos] & 32767) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[ 6 + inPos] & 32767) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[ 6 + inPos] & 32767) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[ 6 + inPos] & 32767) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[ 7 + inPos] & 32767) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[ 7 + inPos] & 32767))) & 255);
      out[15 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[ 8 + inPos] & 32767) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[ 8 + inPos] & 32767) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[ 9 + inPos] & 32767) >>> 14)) & 255);
      out[17 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[ 9 + inPos] & 32767) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[ 9 + inPos] & 32767) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[10 + inPos] & 32767) >>> 13)) & 255);
      out[19 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[10 + inPos] & 32767) >>> 5)) & 255);
      out[20 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[10 + inPos] & 32767) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[11 + inPos] & 32767) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[11 + inPos] & 32767) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[11 + inPos] & 32767) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[12 + inPos] & 32767) >>> 11)) & 255);
      out[23 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[12 + inPos] & 32767) >>> 3)) & 255);
      out[24 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[12 + inPos] & 32767) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[13 + inPos] & 32767) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[13 + inPos] & 32767) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[13 + inPos] & 32767) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[14 + inPos] & 32767) >>> 9)) & 255);
      out[27 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[14 + inPos] & 32767) >>> 1)) & 255);
      out[28 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[14 + inPos] & 32767) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[15 + inPos] & 32767) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[15 + inPos] & 32767))) & 255);
      out[30 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[16 + inPos] & 32767) >>> 7)) & 255);
      out[31 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[16 + inPos] & 32767) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[17 + inPos] & 32767) >>> 14)) & 255);
      out[32 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[17 + inPos] & 32767) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[17 + inPos] & 32767) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[18 + inPos] & 32767) >>> 13)) & 255);
      out[34 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[18 + inPos] & 32767) >>> 5)) & 255);
      out[35 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[18 + inPos] & 32767) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[19 + inPos] & 32767) >>> 12)) & 255);
      out[36 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[19 + inPos] & 32767) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[19 + inPos] & 32767) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[20 + inPos] & 32767) >>> 11)) & 255);
      out[38 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[20 + inPos] & 32767) >>> 3)) & 255);
      out[39 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[20 + inPos] & 32767) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[21 + inPos] & 32767) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[21 + inPos] & 32767) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[21 + inPos] & 32767) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[22 + inPos] & 32767) >>> 9)) & 255);
      out[42 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[22 + inPos] & 32767) >>> 1)) & 255);
      out[43 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[22 + inPos] & 32767) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[23 + inPos] & 32767) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[23 + inPos] & 32767))) & 255);
      out[45 + outPos] = (byte)((
          //                         [76543210]
          //                         [43210987_______]
           ((in[24 + inPos] & 32767) >>> 7)) & 255);
      out[46 + outPos] = (byte)((
          //                         [7654321_]
          //                 [________6543210]
           ((in[24 + inPos] & 32767) <<  1)
        | //                         [_______0]
          //                                [4______________]
           ((in[25 + inPos] & 32767) >>> 14)) & 255);
      out[47 + outPos] = (byte)((
          //                         [76543210]
          //                        [_32109876______]
           ((in[25 + inPos] & 32767) >>> 6)) & 255);
      out[48 + outPos] = (byte)((
          //                         [765432__]
          //                [_________543210]
           ((in[25 + inPos] & 32767) <<  2)
        | //                         [______10]
          //                               [43_____________]
           ((in[26 + inPos] & 32767) >>> 13)) & 255);
      out[49 + outPos] = (byte)((
          //                         [76543210]
          //                       [__21098765_____]
           ((in[26 + inPos] & 32767) >>> 5)) & 255);
      out[50 + outPos] = (byte)((
          //                         [76543___]
          //               [__________43210]
           ((in[26 + inPos] & 32767) <<  3)
        | //                         [_____210]
          //                              [432____________]
           ((in[27 + inPos] & 32767) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                         [76543210]
          //                      [___10987654____]
           ((in[27 + inPos] & 32767) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                         [7654____]
          //              [___________3210]
           ((in[27 + inPos] & 32767) <<  4)
        | //                         [____3210]
          //                             [4321___________]
           ((in[28 + inPos] & 32767) >>> 11)) & 255);
      out[53 + outPos] = (byte)((
          //                         [76543210]
          //                     [____09876543___]
           ((in[28 + inPos] & 32767) >>> 3)) & 255);
      out[54 + outPos] = (byte)((
          //                         [765_____]
          //             [____________210]
           ((in[28 + inPos] & 32767) <<  5)
        | //                         [___43210]
          //                            [43210__________]
           ((in[29 + inPos] & 32767) >>> 10)) & 255);
      out[55 + outPos] = (byte)((
          //                         [76543210]
          //                    [_____98765432__]
           ((in[29 + inPos] & 32767) >>> 2)) & 255);
      out[56 + outPos] = (byte)((
          //                         [76______]
          //            [_____________10]
           ((in[29 + inPos] & 32767) <<  6)
        | //                         [__543210]
          //                           [432109_________]
           ((in[30 + inPos] & 32767) >>> 9)) & 255);
      out[57 + outPos] = (byte)((
          //                         [76543210]
          //                   [______87654321_]
           ((in[30 + inPos] & 32767) >>> 1)) & 255);
      out[58 + outPos] = (byte)((
          //                         [7_______]
          //           [______________0]
           ((in[30 + inPos] & 32767) <<  7)
        | //                         [_6543210]
          //                          [4321098________]
           ((in[31 + inPos] & 32767) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                         [76543210]
          //                  [_______76543210]
           ((in[31 + inPos] & 32767))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            (((((int)in[ 0 + inPos]) & 255) <<  7) & 32767)
        | //                         [7654321_]
          //                 [________6543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 32767);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            (((((int)in[ 1 + inPos]) & 255) <<  14) & 32767)
        | //                         [76543210]
          //                        [_32109876______]
            (((((int)in[ 2 + inPos]) & 255) <<  6) & 32767)
        | //                         [765432__]
          //                [_________543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 32767);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            (((((int)in[ 3 + inPos]) & 255) <<  13) & 32767)
        | //                         [76543210]
          //                       [__21098765_____]
            (((((int)in[ 4 + inPos]) & 255) <<  5) & 32767)
        | //                         [76543___]
          //               [__________43210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 32767);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            (((((int)in[ 5 + inPos]) & 255) <<  12) & 32767)
        | //                         [76543210]
          //                      [___10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 32767)
        | //                         [7654____]
          //              [___________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 32767);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            (((((int)in[ 7 + inPos]) & 255) <<  11) & 32767)
        | //                         [76543210]
          //                     [____09876543___]
            (((((int)in[ 8 + inPos]) & 255) <<  3) & 32767)
        | //                         [765_____]
          //             [____________210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 32767);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            (((((int)in[ 9 + inPos]) & 255) <<  10) & 32767)
        | //                         [76543210]
          //                    [_____98765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 32767)
        | //                         [76______]
          //            [_____________10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 32767);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            (((((int)in[11 + inPos]) & 255) <<  9) & 32767)
        | //                         [76543210]
          //                   [______87654321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 32767)
        | //                         [7_______]
          //           [______________0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 32767);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 32767)
        | //                         [76543210]
          //                  [_______76543210]
            (((((int)in[14 + inPos]) & 255) ) & 32767);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            (((((int)in[ 0 + inPos]) & 255) <<  7) & 32767)
        | //                         [7654321_]
          //                 [________6543210]
            (((((int)in[ 1 + inPos]) & 255) >>>  1) & 32767);
      out[ 1 + outPos] =
          //                         [_______0]
          //                                [4______________]
            (((((int)in[ 1 + inPos]) & 255) <<  14) & 32767)
        | //                         [76543210]
          //                        [_32109876______]
            (((((int)in[ 2 + inPos]) & 255) <<  6) & 32767)
        | //                         [765432__]
          //                [_________543210]
            (((((int)in[ 3 + inPos]) & 255) >>>  2) & 32767);
      out[ 2 + outPos] =
          //                         [______10]
          //                               [43_____________]
            (((((int)in[ 3 + inPos]) & 255) <<  13) & 32767)
        | //                         [76543210]
          //                       [__21098765_____]
            (((((int)in[ 4 + inPos]) & 255) <<  5) & 32767)
        | //                         [76543___]
          //               [__________43210]
            (((((int)in[ 5 + inPos]) & 255) >>>  3) & 32767);
      out[ 3 + outPos] =
          //                         [_____210]
          //                              [432____________]
            (((((int)in[ 5 + inPos]) & 255) <<  12) & 32767)
        | //                         [76543210]
          //                      [___10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 32767)
        | //                         [7654____]
          //              [___________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 32767);
      out[ 4 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            (((((int)in[ 7 + inPos]) & 255) <<  11) & 32767)
        | //                         [76543210]
          //                     [____09876543___]
            (((((int)in[ 8 + inPos]) & 255) <<  3) & 32767)
        | //                         [765_____]
          //             [____________210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 32767);
      out[ 5 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            (((((int)in[ 9 + inPos]) & 255) <<  10) & 32767)
        | //                         [76543210]
          //                    [_____98765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 32767)
        | //                         [76______]
          //            [_____________10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 32767);
      out[ 6 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            (((((int)in[11 + inPos]) & 255) <<  9) & 32767)
        | //                         [76543210]
          //                   [______87654321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 32767)
        | //                         [7_______]
          //           [______________0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 32767);
      out[ 7 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 32767)
        | //                         [76543210]
          //                  [_______76543210]
            (((((int)in[14 + inPos]) & 255) ) & 32767);
      out[ 8 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            (((((int)in[15 + inPos]) & 255) <<  7) & 32767)
        | //                         [7654321_]
          //                 [________6543210]
            (((((int)in[16 + inPos]) & 255) >>>  1) & 32767);
      out[ 9 + outPos] =
          //                         [_______0]
          //                                [4______________]
            (((((int)in[16 + inPos]) & 255) <<  14) & 32767)
        | //                         [76543210]
          //                        [_32109876______]
            (((((int)in[17 + inPos]) & 255) <<  6) & 32767)
        | //                         [765432__]
          //                [_________543210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 32767);
      out[10 + outPos] =
          //                         [______10]
          //                               [43_____________]
            (((((int)in[18 + inPos]) & 255) <<  13) & 32767)
        | //                         [76543210]
          //                       [__21098765_____]
            (((((int)in[19 + inPos]) & 255) <<  5) & 32767)
        | //                         [76543___]
          //               [__________43210]
            (((((int)in[20 + inPos]) & 255) >>>  3) & 32767);
      out[11 + outPos] =
          //                         [_____210]
          //                              [432____________]
            (((((int)in[20 + inPos]) & 255) <<  12) & 32767)
        | //                         [76543210]
          //                      [___10987654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 32767)
        | //                         [7654____]
          //              [___________3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 32767);
      out[12 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            (((((int)in[22 + inPos]) & 255) <<  11) & 32767)
        | //                         [76543210]
          //                     [____09876543___]
            (((((int)in[23 + inPos]) & 255) <<  3) & 32767)
        | //                         [765_____]
          //             [____________210]
            (((((int)in[24 + inPos]) & 255) >>>  5) & 32767);
      out[13 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            (((((int)in[24 + inPos]) & 255) <<  10) & 32767)
        | //                         [76543210]
          //                    [_____98765432__]
            (((((int)in[25 + inPos]) & 255) <<  2) & 32767)
        | //                         [76______]
          //            [_____________10]
            (((((int)in[26 + inPos]) & 255) >>>  6) & 32767);
      out[14 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            (((((int)in[26 + inPos]) & 255) <<  9) & 32767)
        | //                         [76543210]
          //                   [______87654321_]
            (((((int)in[27 + inPos]) & 255) <<  1) & 32767)
        | //                         [7_______]
          //           [______________0]
            (((((int)in[28 + inPos]) & 255) >>>  7) & 32767);
      out[15 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 32767)
        | //                         [76543210]
          //                  [_______76543210]
            (((((int)in[29 + inPos]) & 255) ) & 32767);
      out[16 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            (((((int)in[30 + inPos]) & 255) <<  7) & 32767)
        | //                         [7654321_]
          //                 [________6543210]
            (((((int)in[31 + inPos]) & 255) >>>  1) & 32767);
      out[17 + outPos] =
          //                         [_______0]
          //                                [4______________]
            (((((int)in[31 + inPos]) & 255) <<  14) & 32767)
        | //                         [76543210]
          //                        [_32109876______]
            (((((int)in[32 + inPos]) & 255) <<  6) & 32767)
        | //                         [765432__]
          //                [_________543210]
            (((((int)in[33 + inPos]) & 255) >>>  2) & 32767);
      out[18 + outPos] =
          //                         [______10]
          //                               [43_____________]
            (((((int)in[33 + inPos]) & 255) <<  13) & 32767)
        | //                         [76543210]
          //                       [__21098765_____]
            (((((int)in[34 + inPos]) & 255) <<  5) & 32767)
        | //                         [76543___]
          //               [__________43210]
            (((((int)in[35 + inPos]) & 255) >>>  3) & 32767);
      out[19 + outPos] =
          //                         [_____210]
          //                              [432____________]
            (((((int)in[35 + inPos]) & 255) <<  12) & 32767)
        | //                         [76543210]
          //                      [___10987654____]
            (((((int)in[36 + inPos]) & 255) <<  4) & 32767)
        | //                         [7654____]
          //              [___________3210]
            (((((int)in[37 + inPos]) & 255) >>>  4) & 32767);
      out[20 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            (((((int)in[37 + inPos]) & 255) <<  11) & 32767)
        | //                         [76543210]
          //                     [____09876543___]
            (((((int)in[38 + inPos]) & 255) <<  3) & 32767)
        | //                         [765_____]
          //             [____________210]
            (((((int)in[39 + inPos]) & 255) >>>  5) & 32767);
      out[21 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            (((((int)in[39 + inPos]) & 255) <<  10) & 32767)
        | //                         [76543210]
          //                    [_____98765432__]
            (((((int)in[40 + inPos]) & 255) <<  2) & 32767)
        | //                         [76______]
          //            [_____________10]
            (((((int)in[41 + inPos]) & 255) >>>  6) & 32767);
      out[22 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            (((((int)in[41 + inPos]) & 255) <<  9) & 32767)
        | //                         [76543210]
          //                   [______87654321_]
            (((((int)in[42 + inPos]) & 255) <<  1) & 32767)
        | //                         [7_______]
          //           [______________0]
            (((((int)in[43 + inPos]) & 255) >>>  7) & 32767);
      out[23 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            (((((int)in[43 + inPos]) & 255) <<  8) & 32767)
        | //                         [76543210]
          //                  [_______76543210]
            (((((int)in[44 + inPos]) & 255) ) & 32767);
      out[24 + outPos] =
          //                         [76543210]
          //                         [43210987_______]
            (((((int)in[45 + inPos]) & 255) <<  7) & 32767)
        | //                         [7654321_]
          //                 [________6543210]
            (((((int)in[46 + inPos]) & 255) >>>  1) & 32767);
      out[25 + outPos] =
          //                         [_______0]
          //                                [4______________]
            (((((int)in[46 + inPos]) & 255) <<  14) & 32767)
        | //                         [76543210]
          //                        [_32109876______]
            (((((int)in[47 + inPos]) & 255) <<  6) & 32767)
        | //                         [765432__]
          //                [_________543210]
            (((((int)in[48 + inPos]) & 255) >>>  2) & 32767);
      out[26 + outPos] =
          //                         [______10]
          //                               [43_____________]
            (((((int)in[48 + inPos]) & 255) <<  13) & 32767)
        | //                         [76543210]
          //                       [__21098765_____]
            (((((int)in[49 + inPos]) & 255) <<  5) & 32767)
        | //                         [76543___]
          //               [__________43210]
            (((((int)in[50 + inPos]) & 255) >>>  3) & 32767);
      out[27 + outPos] =
          //                         [_____210]
          //                              [432____________]
            (((((int)in[50 + inPos]) & 255) <<  12) & 32767)
        | //                         [76543210]
          //                      [___10987654____]
            (((((int)in[51 + inPos]) & 255) <<  4) & 32767)
        | //                         [7654____]
          //              [___________3210]
            (((((int)in[52 + inPos]) & 255) >>>  4) & 32767);
      out[28 + outPos] =
          //                         [____3210]
          //                             [4321___________]
            (((((int)in[52 + inPos]) & 255) <<  11) & 32767)
        | //                         [76543210]
          //                     [____09876543___]
            (((((int)in[53 + inPos]) & 255) <<  3) & 32767)
        | //                         [765_____]
          //             [____________210]
            (((((int)in[54 + inPos]) & 255) >>>  5) & 32767);
      out[29 + outPos] =
          //                         [___43210]
          //                            [43210__________]
            (((((int)in[54 + inPos]) & 255) <<  10) & 32767)
        | //                         [76543210]
          //                    [_____98765432__]
            (((((int)in[55 + inPos]) & 255) <<  2) & 32767)
        | //                         [76______]
          //            [_____________10]
            (((((int)in[56 + inPos]) & 255) >>>  6) & 32767);
      out[30 + outPos] =
          //                         [__543210]
          //                           [432109_________]
            (((((int)in[56 + inPos]) & 255) <<  9) & 32767)
        | //                         [76543210]
          //                   [______87654321_]
            (((((int)in[57 + inPos]) & 255) <<  1) & 32767)
        | //                         [7_______]
          //           [______________0]
            (((((int)in[58 + inPos]) & 255) >>>  7) & 32767);
      out[31 + outPos] =
          //                         [_6543210]
          //                          [4321098________]
            (((((int)in[58 + inPos]) & 255) <<  8) & 32767)
        | //                         [76543210]
          //                  [_______76543210]
            (((((int)in[59 + inPos]) & 255) ) & 32767);
    }
  }

  private static final class Packer16 extends BytePacker {

    private Packer16() {
      super(16);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535) >>> 8)) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535))) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535) >>> 8)) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535))) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535))) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535))) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535))) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535))) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535))) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535) >>> 8)) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 0 + inPos] & 65535) >>> 8)) & 255);
      out[ 1 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 0 + inPos] & 65535))) & 255);
      out[ 2 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 1 + inPos] & 65535) >>> 8)) & 255);
      out[ 3 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 1 + inPos] & 65535))) & 255);
      out[ 4 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 2 + inPos] & 65535) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 2 + inPos] & 65535))) & 255);
      out[ 6 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 3 + inPos] & 65535) >>> 8)) & 255);
      out[ 7 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 3 + inPos] & 65535))) & 255);
      out[ 8 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 4 + inPos] & 65535) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 4 + inPos] & 65535))) & 255);
      out[10 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 5 + inPos] & 65535) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 5 + inPos] & 65535))) & 255);
      out[12 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 6 + inPos] & 65535) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 6 + inPos] & 65535))) & 255);
      out[14 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 7 + inPos] & 65535) >>> 8)) & 255);
      out[15 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 7 + inPos] & 65535))) & 255);
      out[16 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 8 + inPos] & 65535) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 8 + inPos] & 65535))) & 255);
      out[18 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[ 9 + inPos] & 65535) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[ 9 + inPos] & 65535))) & 255);
      out[20 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[10 + inPos] & 65535) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[10 + inPos] & 65535))) & 255);
      out[22 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[11 + inPos] & 65535) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[11 + inPos] & 65535))) & 255);
      out[24 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[12 + inPos] & 65535) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[12 + inPos] & 65535))) & 255);
      out[26 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[13 + inPos] & 65535) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[13 + inPos] & 65535))) & 255);
      out[28 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[14 + inPos] & 65535) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[14 + inPos] & 65535))) & 255);
      out[30 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[15 + inPos] & 65535) >>> 8)) & 255);
      out[31 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[15 + inPos] & 65535))) & 255);
      out[32 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[16 + inPos] & 65535) >>> 8)) & 255);
      out[33 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[16 + inPos] & 65535))) & 255);
      out[34 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[17 + inPos] & 65535) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[17 + inPos] & 65535))) & 255);
      out[36 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[18 + inPos] & 65535) >>> 8)) & 255);
      out[37 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[18 + inPos] & 65535))) & 255);
      out[38 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[19 + inPos] & 65535) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[19 + inPos] & 65535))) & 255);
      out[40 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[20 + inPos] & 65535) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[20 + inPos] & 65535))) & 255);
      out[42 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[21 + inPos] & 65535) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[21 + inPos] & 65535))) & 255);
      out[44 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[22 + inPos] & 65535) >>> 8)) & 255);
      out[45 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[22 + inPos] & 65535))) & 255);
      out[46 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[23 + inPos] & 65535) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[23 + inPos] & 65535))) & 255);
      out[48 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[24 + inPos] & 65535) >>> 8)) & 255);
      out[49 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[24 + inPos] & 65535))) & 255);
      out[50 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[25 + inPos] & 65535) >>> 8)) & 255);
      out[51 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[25 + inPos] & 65535))) & 255);
      out[52 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[26 + inPos] & 65535) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[26 + inPos] & 65535))) & 255);
      out[54 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[27 + inPos] & 65535) >>> 8)) & 255);
      out[55 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[27 + inPos] & 65535))) & 255);
      out[56 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[28 + inPos] & 65535) >>> 8)) & 255);
      out[57 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[28 + inPos] & 65535))) & 255);
      out[58 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[29 + inPos] & 65535) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[29 + inPos] & 65535))) & 255);
      out[60 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[30 + inPos] & 65535) >>> 8)) & 255);
      out[61 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[30 + inPos] & 65535))) & 255);
      out[62 + outPos] = (byte)((
          //                          [76543210]
          //                          [54321098________]
           ((in[31 + inPos] & 65535) >>> 8)) & 255);
      out[63 + outPos] = (byte)((
          //                          [76543210]
          //                  [________76543210]
           ((in[31 + inPos] & 65535))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 0 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 1 + inPos]) & 255) ) & 65535);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 2 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 3 + inPos]) & 255) ) & 65535);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 65535);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 6 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 7 + inPos]) & 255) ) & 65535);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 65535);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[11 + inPos]) & 255) ) & 65535);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[12 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[13 + inPos]) & 255) ) & 65535);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[14 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[15 + inPos]) & 255) ) & 65535);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 0 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 1 + inPos]) & 255) ) & 65535);
      out[ 1 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 2 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 3 + inPos]) & 255) ) & 65535);
      out[ 2 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 65535);
      out[ 3 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 6 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 7 + inPos]) & 255) ) & 65535);
      out[ 4 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 65535);
      out[ 5 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[11 + inPos]) & 255) ) & 65535);
      out[ 6 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[12 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[13 + inPos]) & 255) ) & 65535);
      out[ 7 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[14 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[15 + inPos]) & 255) ) & 65535);
      out[ 8 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[17 + inPos]) & 255) ) & 65535);
      out[ 9 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[18 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[19 + inPos]) & 255) ) & 65535);
      out[10 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[20 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[21 + inPos]) & 255) ) & 65535);
      out[11 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[22 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[23 + inPos]) & 255) ) & 65535);
      out[12 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[24 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[25 + inPos]) & 255) ) & 65535);
      out[13 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[26 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[27 + inPos]) & 255) ) & 65535);
      out[14 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[29 + inPos]) & 255) ) & 65535);
      out[15 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[30 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[31 + inPos]) & 255) ) & 65535);
      out[16 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[32 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[33 + inPos]) & 255) ) & 65535);
      out[17 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[34 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[35 + inPos]) & 255) ) & 65535);
      out[18 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[36 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[37 + inPos]) & 255) ) & 65535);
      out[19 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[38 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[39 + inPos]) & 255) ) & 65535);
      out[20 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[40 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[41 + inPos]) & 255) ) & 65535);
      out[21 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[42 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[43 + inPos]) & 255) ) & 65535);
      out[22 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[44 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[45 + inPos]) & 255) ) & 65535);
      out[23 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[46 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[47 + inPos]) & 255) ) & 65535);
      out[24 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[48 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[49 + inPos]) & 255) ) & 65535);
      out[25 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[50 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[51 + inPos]) & 255) ) & 65535);
      out[26 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[52 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[53 + inPos]) & 255) ) & 65535);
      out[27 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[54 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[55 + inPos]) & 255) ) & 65535);
      out[28 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[56 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[57 + inPos]) & 255) ) & 65535);
      out[29 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[58 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[59 + inPos]) & 255) ) & 65535);
      out[30 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[60 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[61 + inPos]) & 255) ) & 65535);
      out[31 + outPos] =
          //                          [76543210]
          //                          [54321098________]
            (((((int)in[62 + inPos]) & 255) <<  8) & 65535)
        | //                          [76543210]
          //                  [________76543210]
            (((((int)in[63 + inPos]) & 255) ) & 65535);
    }
  }

  private static final class Packer17 extends BytePacker {

    private Packer17() {
      super(17);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 0 + inPos] & 131071) >>> 9)) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 0 + inPos] & 131071) >>> 1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 0 + inPos] & 131071) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 1 + inPos] & 131071) >>> 10)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 1 + inPos] & 131071) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 1 + inPos] & 131071) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[ 2 + inPos] & 131071) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 2 + inPos] & 131071) >>> 3)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[ 2 + inPos] & 131071) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[ 3 + inPos] & 131071) >>> 12)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 3 + inPos] & 131071) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[ 3 + inPos] & 131071) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[ 4 + inPos] & 131071) >>> 13)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 4 + inPos] & 131071) >>> 5)) & 255);
      out[10 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[ 4 + inPos] & 131071) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[ 5 + inPos] & 131071) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 5 + inPos] & 131071) >>> 6)) & 255);
      out[12 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[ 5 + inPos] & 131071) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[ 6 + inPos] & 131071) >>> 15)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 6 + inPos] & 131071) >>> 7)) & 255);
      out[14 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[ 6 + inPos] & 131071) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[ 7 + inPos] & 131071) >>> 16)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 7 + inPos] & 131071) >>> 8)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 7 + inPos] & 131071))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 0 + inPos] & 131071) >>> 9)) & 255);
      out[ 1 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 0 + inPos] & 131071) >>> 1)) & 255);
      out[ 2 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 0 + inPos] & 131071) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 1 + inPos] & 131071) >>> 10)) & 255);
      out[ 3 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 1 + inPos] & 131071) >>> 2)) & 255);
      out[ 4 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 1 + inPos] & 131071) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[ 2 + inPos] & 131071) >>> 11)) & 255);
      out[ 5 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[ 2 + inPos] & 131071) >>> 3)) & 255);
      out[ 6 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[ 2 + inPos] & 131071) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[ 3 + inPos] & 131071) >>> 12)) & 255);
      out[ 7 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[ 3 + inPos] & 131071) >>> 4)) & 255);
      out[ 8 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[ 3 + inPos] & 131071) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[ 4 + inPos] & 131071) >>> 13)) & 255);
      out[ 9 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[ 4 + inPos] & 131071) >>> 5)) & 255);
      out[10 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[ 4 + inPos] & 131071) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[ 5 + inPos] & 131071) >>> 14)) & 255);
      out[11 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[ 5 + inPos] & 131071) >>> 6)) & 255);
      out[12 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[ 5 + inPos] & 131071) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[ 6 + inPos] & 131071) >>> 15)) & 255);
      out[13 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[ 6 + inPos] & 131071) >>> 7)) & 255);
      out[14 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[ 6 + inPos] & 131071) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[ 7 + inPos] & 131071) >>> 16)) & 255);
      out[15 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[ 7 + inPos] & 131071) >>> 8)) & 255);
      out[16 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[ 7 + inPos] & 131071))) & 255);
      out[17 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[ 8 + inPos] & 131071) >>> 9)) & 255);
      out[18 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[ 8 + inPos] & 131071) >>> 1)) & 255);
      out[19 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[ 8 + inPos] & 131071) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[ 9 + inPos] & 131071) >>> 10)) & 255);
      out[20 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[ 9 + inPos] & 131071) >>> 2)) & 255);
      out[21 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[ 9 + inPos] & 131071) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[10 + inPos] & 131071) >>> 11)) & 255);
      out[22 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[10 + inPos] & 131071) >>> 3)) & 255);
      out[23 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[10 + inPos] & 131071) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[11 + inPos] & 131071) >>> 12)) & 255);
      out[24 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[11 + inPos] & 131071) >>> 4)) & 255);
      out[25 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[11 + inPos] & 131071) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[12 + inPos] & 131071) >>> 13)) & 255);
      out[26 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[12 + inPos] & 131071) >>> 5)) & 255);
      out[27 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[12 + inPos] & 131071) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[13 + inPos] & 131071) >>> 14)) & 255);
      out[28 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[13 + inPos] & 131071) >>> 6)) & 255);
      out[29 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[13 + inPos] & 131071) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[14 + inPos] & 131071) >>> 15)) & 255);
      out[30 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[14 + inPos] & 131071) >>> 7)) & 255);
      out[31 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[14 + inPos] & 131071) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[15 + inPos] & 131071) >>> 16)) & 255);
      out[32 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[15 + inPos] & 131071) >>> 8)) & 255);
      out[33 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[15 + inPos] & 131071))) & 255);
      out[34 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[16 + inPos] & 131071) >>> 9)) & 255);
      out[35 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[16 + inPos] & 131071) >>> 1)) & 255);
      out[36 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[16 + inPos] & 131071) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[17 + inPos] & 131071) >>> 10)) & 255);
      out[37 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[17 + inPos] & 131071) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[17 + inPos] & 131071) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[18 + inPos] & 131071) >>> 11)) & 255);
      out[39 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[18 + inPos] & 131071) >>> 3)) & 255);
      out[40 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[18 + inPos] & 131071) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[19 + inPos] & 131071) >>> 12)) & 255);
      out[41 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[19 + inPos] & 131071) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[19 + inPos] & 131071) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[20 + inPos] & 131071) >>> 13)) & 255);
      out[43 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[20 + inPos] & 131071) >>> 5)) & 255);
      out[44 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[20 + inPos] & 131071) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[21 + inPos] & 131071) >>> 14)) & 255);
      out[45 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[21 + inPos] & 131071) >>> 6)) & 255);
      out[46 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[21 + inPos] & 131071) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[22 + inPos] & 131071) >>> 15)) & 255);
      out[47 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[22 + inPos] & 131071) >>> 7)) & 255);
      out[48 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[22 + inPos] & 131071) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[23 + inPos] & 131071) >>> 16)) & 255);
      out[49 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[23 + inPos] & 131071) >>> 8)) & 255);
      out[50 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[23 + inPos] & 131071))) & 255);
      out[51 + outPos] = (byte)((
          //                           [76543210]
          //                           [65432109_________]
           ((in[24 + inPos] & 131071) >>> 9)) & 255);
      out[52 + outPos] = (byte)((
          //                           [76543210]
          //                   [________87654321_]
           ((in[24 + inPos] & 131071) >>> 1)) & 255);
      out[53 + outPos] = (byte)((
          //                           [7_______]
          //           [________________0]
           ((in[24 + inPos] & 131071) <<  7)
        | //                           [_6543210]
          //                            [6543210__________]
           ((in[25 + inPos] & 131071) >>> 10)) & 255);
      out[54 + outPos] = (byte)((
          //                           [76543210]
          //                    [_______98765432__]
           ((in[25 + inPos] & 131071) >>> 2)) & 255);
      out[55 + outPos] = (byte)((
          //                           [76______]
          //            [_______________10]
           ((in[25 + inPos] & 131071) <<  6)
        | //                           [__543210]
          //                             [654321___________]
           ((in[26 + inPos] & 131071) >>> 11)) & 255);
      out[56 + outPos] = (byte)((
          //                           [76543210]
          //                     [______09876543___]
           ((in[26 + inPos] & 131071) >>> 3)) & 255);
      out[57 + outPos] = (byte)((
          //                           [765_____]
          //             [______________210]
           ((in[26 + inPos] & 131071) <<  5)
        | //                           [___43210]
          //                              [65432____________]
           ((in[27 + inPos] & 131071) >>> 12)) & 255);
      out[58 + outPos] = (byte)((
          //                           [76543210]
          //                      [_____10987654____]
           ((in[27 + inPos] & 131071) >>> 4)) & 255);
      out[59 + outPos] = (byte)((
          //                           [7654____]
          //              [_____________3210]
           ((in[27 + inPos] & 131071) <<  4)
        | //                           [____3210]
          //                               [6543_____________]
           ((in[28 + inPos] & 131071) >>> 13)) & 255);
      out[60 + outPos] = (byte)((
          //                           [76543210]
          //                       [____21098765_____]
           ((in[28 + inPos] & 131071) >>> 5)) & 255);
      out[61 + outPos] = (byte)((
          //                           [76543___]
          //               [____________43210]
           ((in[28 + inPos] & 131071) <<  3)
        | //                           [_____210]
          //                                [654______________]
           ((in[29 + inPos] & 131071) >>> 14)) & 255);
      out[62 + outPos] = (byte)((
          //                           [76543210]
          //                        [___32109876______]
           ((in[29 + inPos] & 131071) >>> 6)) & 255);
      out[63 + outPos] = (byte)((
          //                           [765432__]
          //                [___________543210]
           ((in[29 + inPos] & 131071) <<  2)
        | //                           [______10]
          //                                 [65_______________]
           ((in[30 + inPos] & 131071) >>> 15)) & 255);
      out[64 + outPos] = (byte)((
          //                           [76543210]
          //                         [__43210987_______]
           ((in[30 + inPos] & 131071) >>> 7)) & 255);
      out[65 + outPos] = (byte)((
          //                           [7654321_]
          //                 [__________6543210]
           ((in[30 + inPos] & 131071) <<  1)
        | //                           [_______0]
          //                                  [6________________]
           ((in[31 + inPos] & 131071) >>> 16)) & 255);
      out[66 + outPos] = (byte)((
          //                           [76543210]
          //                          [_54321098________]
           ((in[31 + inPos] & 131071) >>> 8)) & 255);
      out[67 + outPos] = (byte)((
          //                           [76543210]
          //                  [_________76543210]
           ((in[31 + inPos] & 131071))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            (((((int)in[ 0 + inPos]) & 255) <<  9) & 131071)
        | //                           [76543210]
          //                   [________87654321_]
            (((((int)in[ 1 + inPos]) & 255) <<  1) & 131071)
        | //                           [7_______]
          //           [________________0]
            (((((int)in[ 2 + inPos]) & 255) >>>  7) & 131071);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            (((((int)in[ 2 + inPos]) & 255) <<  10) & 131071)
        | //                           [76543210]
          //                    [_______98765432__]
            (((((int)in[ 3 + inPos]) & 255) <<  2) & 131071)
        | //                           [76______]
          //            [_______________10]
            (((((int)in[ 4 + inPos]) & 255) >>>  6) & 131071);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            (((((int)in[ 4 + inPos]) & 255) <<  11) & 131071)
        | //                           [76543210]
          //                     [______09876543___]
            (((((int)in[ 5 + inPos]) & 255) <<  3) & 131071)
        | //                           [765_____]
          //             [______________210]
            (((((int)in[ 6 + inPos]) & 255) >>>  5) & 131071);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            (((((int)in[ 6 + inPos]) & 255) <<  12) & 131071)
        | //                           [76543210]
          //                      [_____10987654____]
            (((((int)in[ 7 + inPos]) & 255) <<  4) & 131071)
        | //                           [7654____]
          //              [_____________3210]
            (((((int)in[ 8 + inPos]) & 255) >>>  4) & 131071);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            (((((int)in[ 8 + inPos]) & 255) <<  13) & 131071)
        | //                           [76543210]
          //                       [____21098765_____]
            (((((int)in[ 9 + inPos]) & 255) <<  5) & 131071)
        | //                           [76543___]
          //               [____________43210]
            (((((int)in[10 + inPos]) & 255) >>>  3) & 131071);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            (((((int)in[10 + inPos]) & 255) <<  14) & 131071)
        | //                           [76543210]
          //                        [___32109876______]
            (((((int)in[11 + inPos]) & 255) <<  6) & 131071)
        | //                           [765432__]
          //                [___________543210]
            (((((int)in[12 + inPos]) & 255) >>>  2) & 131071);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            (((((int)in[12 + inPos]) & 255) <<  15) & 131071)
        | //                           [76543210]
          //                         [__43210987_______]
            (((((int)in[13 + inPos]) & 255) <<  7) & 131071)
        | //                           [7654321_]
          //                 [__________6543210]
            (((((int)in[14 + inPos]) & 255) >>>  1) & 131071);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            (((((int)in[14 + inPos]) & 255) <<  16) & 131071)
        | //                           [76543210]
          //                          [_54321098________]
            (((((int)in[15 + inPos]) & 255) <<  8) & 131071)
        | //                           [76543210]
          //                  [_________76543210]
            (((((int)in[16 + inPos]) & 255) ) & 131071);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            (((((int)in[ 0 + inPos]) & 255) <<  9) & 131071)
        | //                           [76543210]
          //                   [________87654321_]
            (((((int)in[ 1 + inPos]) & 255) <<  1) & 131071)
        | //                           [7_______]
          //           [________________0]
            (((((int)in[ 2 + inPos]) & 255) >>>  7) & 131071);
      out[ 1 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            (((((int)in[ 2 + inPos]) & 255) <<  10) & 131071)
        | //                           [76543210]
          //                    [_______98765432__]
            (((((int)in[ 3 + inPos]) & 255) <<  2) & 131071)
        | //                           [76______]
          //            [_______________10]
            (((((int)in[ 4 + inPos]) & 255) >>>  6) & 131071);
      out[ 2 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            (((((int)in[ 4 + inPos]) & 255) <<  11) & 131071)
        | //                           [76543210]
          //                     [______09876543___]
            (((((int)in[ 5 + inPos]) & 255) <<  3) & 131071)
        | //                           [765_____]
          //             [______________210]
            (((((int)in[ 6 + inPos]) & 255) >>>  5) & 131071);
      out[ 3 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            (((((int)in[ 6 + inPos]) & 255) <<  12) & 131071)
        | //                           [76543210]
          //                      [_____10987654____]
            (((((int)in[ 7 + inPos]) & 255) <<  4) & 131071)
        | //                           [7654____]
          //              [_____________3210]
            (((((int)in[ 8 + inPos]) & 255) >>>  4) & 131071);
      out[ 4 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            (((((int)in[ 8 + inPos]) & 255) <<  13) & 131071)
        | //                           [76543210]
          //                       [____21098765_____]
            (((((int)in[ 9 + inPos]) & 255) <<  5) & 131071)
        | //                           [76543___]
          //               [____________43210]
            (((((int)in[10 + inPos]) & 255) >>>  3) & 131071);
      out[ 5 + outPos] =
          //                           [_____210]
          //                                [654______________]
            (((((int)in[10 + inPos]) & 255) <<  14) & 131071)
        | //                           [76543210]
          //                        [___32109876______]
            (((((int)in[11 + inPos]) & 255) <<  6) & 131071)
        | //                           [765432__]
          //                [___________543210]
            (((((int)in[12 + inPos]) & 255) >>>  2) & 131071);
      out[ 6 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            (((((int)in[12 + inPos]) & 255) <<  15) & 131071)
        | //                           [76543210]
          //                         [__43210987_______]
            (((((int)in[13 + inPos]) & 255) <<  7) & 131071)
        | //                           [7654321_]
          //                 [__________6543210]
            (((((int)in[14 + inPos]) & 255) >>>  1) & 131071);
      out[ 7 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            (((((int)in[14 + inPos]) & 255) <<  16) & 131071)
        | //                           [76543210]
          //                          [_54321098________]
            (((((int)in[15 + inPos]) & 255) <<  8) & 131071)
        | //                           [76543210]
          //                  [_________76543210]
            (((((int)in[16 + inPos]) & 255) ) & 131071);
      out[ 8 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            (((((int)in[17 + inPos]) & 255) <<  9) & 131071)
        | //                           [76543210]
          //                   [________87654321_]
            (((((int)in[18 + inPos]) & 255) <<  1) & 131071)
        | //                           [7_______]
          //           [________________0]
            (((((int)in[19 + inPos]) & 255) >>>  7) & 131071);
      out[ 9 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            (((((int)in[19 + inPos]) & 255) <<  10) & 131071)
        | //                           [76543210]
          //                    [_______98765432__]
            (((((int)in[20 + inPos]) & 255) <<  2) & 131071)
        | //                           [76______]
          //            [_______________10]
            (((((int)in[21 + inPos]) & 255) >>>  6) & 131071);
      out[10 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            (((((int)in[21 + inPos]) & 255) <<  11) & 131071)
        | //                           [76543210]
          //                     [______09876543___]
            (((((int)in[22 + inPos]) & 255) <<  3) & 131071)
        | //                           [765_____]
          //             [______________210]
            (((((int)in[23 + inPos]) & 255) >>>  5) & 131071);
      out[11 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            (((((int)in[23 + inPos]) & 255) <<  12) & 131071)
        | //                           [76543210]
          //                      [_____10987654____]
            (((((int)in[24 + inPos]) & 255) <<  4) & 131071)
        | //                           [7654____]
          //              [_____________3210]
            (((((int)in[25 + inPos]) & 255) >>>  4) & 131071);
      out[12 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            (((((int)in[25 + inPos]) & 255) <<  13) & 131071)
        | //                           [76543210]
          //                       [____21098765_____]
            (((((int)in[26 + inPos]) & 255) <<  5) & 131071)
        | //                           [76543___]
          //               [____________43210]
            (((((int)in[27 + inPos]) & 255) >>>  3) & 131071);
      out[13 + outPos] =
          //                           [_____210]
          //                                [654______________]
            (((((int)in[27 + inPos]) & 255) <<  14) & 131071)
        | //                           [76543210]
          //                        [___32109876______]
            (((((int)in[28 + inPos]) & 255) <<  6) & 131071)
        | //                           [765432__]
          //                [___________543210]
            (((((int)in[29 + inPos]) & 255) >>>  2) & 131071);
      out[14 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            (((((int)in[29 + inPos]) & 255) <<  15) & 131071)
        | //                           [76543210]
          //                         [__43210987_______]
            (((((int)in[30 + inPos]) & 255) <<  7) & 131071)
        | //                           [7654321_]
          //                 [__________6543210]
            (((((int)in[31 + inPos]) & 255) >>>  1) & 131071);
      out[15 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            (((((int)in[31 + inPos]) & 255) <<  16) & 131071)
        | //                           [76543210]
          //                          [_54321098________]
            (((((int)in[32 + inPos]) & 255) <<  8) & 131071)
        | //                           [76543210]
          //                  [_________76543210]
            (((((int)in[33 + inPos]) & 255) ) & 131071);
      out[16 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            (((((int)in[34 + inPos]) & 255) <<  9) & 131071)
        | //                           [76543210]
          //                   [________87654321_]
            (((((int)in[35 + inPos]) & 255) <<  1) & 131071)
        | //                           [7_______]
          //           [________________0]
            (((((int)in[36 + inPos]) & 255) >>>  7) & 131071);
      out[17 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            (((((int)in[36 + inPos]) & 255) <<  10) & 131071)
        | //                           [76543210]
          //                    [_______98765432__]
            (((((int)in[37 + inPos]) & 255) <<  2) & 131071)
        | //                           [76______]
          //            [_______________10]
            (((((int)in[38 + inPos]) & 255) >>>  6) & 131071);
      out[18 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            (((((int)in[38 + inPos]) & 255) <<  11) & 131071)
        | //                           [76543210]
          //                     [______09876543___]
            (((((int)in[39 + inPos]) & 255) <<  3) & 131071)
        | //                           [765_____]
          //             [______________210]
            (((((int)in[40 + inPos]) & 255) >>>  5) & 131071);
      out[19 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            (((((int)in[40 + inPos]) & 255) <<  12) & 131071)
        | //                           [76543210]
          //                      [_____10987654____]
            (((((int)in[41 + inPos]) & 255) <<  4) & 131071)
        | //                           [7654____]
          //              [_____________3210]
            (((((int)in[42 + inPos]) & 255) >>>  4) & 131071);
      out[20 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            (((((int)in[42 + inPos]) & 255) <<  13) & 131071)
        | //                           [76543210]
          //                       [____21098765_____]
            (((((int)in[43 + inPos]) & 255) <<  5) & 131071)
        | //                           [76543___]
          //               [____________43210]
            (((((int)in[44 + inPos]) & 255) >>>  3) & 131071);
      out[21 + outPos] =
          //                           [_____210]
          //                                [654______________]
            (((((int)in[44 + inPos]) & 255) <<  14) & 131071)
        | //                           [76543210]
          //                        [___32109876______]
            (((((int)in[45 + inPos]) & 255) <<  6) & 131071)
        | //                           [765432__]
          //                [___________543210]
            (((((int)in[46 + inPos]) & 255) >>>  2) & 131071);
      out[22 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            (((((int)in[46 + inPos]) & 255) <<  15) & 131071)
        | //                           [76543210]
          //                         [__43210987_______]
            (((((int)in[47 + inPos]) & 255) <<  7) & 131071)
        | //                           [7654321_]
          //                 [__________6543210]
            (((((int)in[48 + inPos]) & 255) >>>  1) & 131071);
      out[23 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            (((((int)in[48 + inPos]) & 255) <<  16) & 131071)
        | //                           [76543210]
          //                          [_54321098________]
            (((((int)in[49 + inPos]) & 255) <<  8) & 131071)
        | //                           [76543210]
          //                  [_________76543210]
            (((((int)in[50 + inPos]) & 255) ) & 131071);
      out[24 + outPos] =
          //                           [76543210]
          //                           [65432109_________]
            (((((int)in[51 + inPos]) & 255) <<  9) & 131071)
        | //                           [76543210]
          //                   [________87654321_]
            (((((int)in[52 + inPos]) & 255) <<  1) & 131071)
        | //                           [7_______]
          //           [________________0]
            (((((int)in[53 + inPos]) & 255) >>>  7) & 131071);
      out[25 + outPos] =
          //                           [_6543210]
          //                            [6543210__________]
            (((((int)in[53 + inPos]) & 255) <<  10) & 131071)
        | //                           [76543210]
          //                    [_______98765432__]
            (((((int)in[54 + inPos]) & 255) <<  2) & 131071)
        | //                           [76______]
          //            [_______________10]
            (((((int)in[55 + inPos]) & 255) >>>  6) & 131071);
      out[26 + outPos] =
          //                           [__543210]
          //                             [654321___________]
            (((((int)in[55 + inPos]) & 255) <<  11) & 131071)
        | //                           [76543210]
          //                     [______09876543___]
            (((((int)in[56 + inPos]) & 255) <<  3) & 131071)
        | //                           [765_____]
          //             [______________210]
            (((((int)in[57 + inPos]) & 255) >>>  5) & 131071);
      out[27 + outPos] =
          //                           [___43210]
          //                              [65432____________]
            (((((int)in[57 + inPos]) & 255) <<  12) & 131071)
        | //                           [76543210]
          //                      [_____10987654____]
            (((((int)in[58 + inPos]) & 255) <<  4) & 131071)
        | //                           [7654____]
          //              [_____________3210]
            (((((int)in[59 + inPos]) & 255) >>>  4) & 131071);
      out[28 + outPos] =
          //                           [____3210]
          //                               [6543_____________]
            (((((int)in[59 + inPos]) & 255) <<  13) & 131071)
        | //                           [76543210]
          //                       [____21098765_____]
            (((((int)in[60 + inPos]) & 255) <<  5) & 131071)
        | //                           [76543___]
          //               [____________43210]
            (((((int)in[61 + inPos]) & 255) >>>  3) & 131071);
      out[29 + outPos] =
          //                           [_____210]
          //                                [654______________]
            (((((int)in[61 + inPos]) & 255) <<  14) & 131071)
        | //                           [76543210]
          //                        [___32109876______]
            (((((int)in[62 + inPos]) & 255) <<  6) & 131071)
        | //                           [765432__]
          //                [___________543210]
            (((((int)in[63 + inPos]) & 255) >>>  2) & 131071);
      out[30 + outPos] =
          //                           [______10]
          //                                 [65_______________]
            (((((int)in[63 + inPos]) & 255) <<  15) & 131071)
        | //                           [76543210]
          //                         [__43210987_______]
            (((((int)in[64 + inPos]) & 255) <<  7) & 131071)
        | //                           [7654321_]
          //                 [__________6543210]
            (((((int)in[65 + inPos]) & 255) >>>  1) & 131071);
      out[31 + outPos] =
          //                           [_______0]
          //                                  [6________________]
            (((((int)in[65 + inPos]) & 255) <<  16) & 131071)
        | //                           [76543210]
          //                          [_54321098________]
            (((((int)in[66 + inPos]) & 255) <<  8) & 131071)
        | //                           [76543210]
          //                  [_________76543210]
            (((((int)in[67 + inPos]) & 255) ) & 131071);
    }
  }

  private static final class Packer18 extends BytePacker {

    private Packer18() {
      super(18);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 0 + inPos] & 262143) >>> 10)) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 0 + inPos] & 262143) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 0 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 1 + inPos] & 262143) >>> 12)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 1 + inPos] & 262143) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 1 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 2 + inPos] & 262143) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 2 + inPos] & 262143) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 2 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 3 + inPos] & 262143) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 3 + inPos] & 262143) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 3 + inPos] & 262143))) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 4 + inPos] & 262143) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 4 + inPos] & 262143) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 4 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 5 + inPos] & 262143) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 5 + inPos] & 262143) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 5 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 6 + inPos] & 262143) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 6 + inPos] & 262143) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 6 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 7 + inPos] & 262143) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 7 + inPos] & 262143) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 7 + inPos] & 262143))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 0 + inPos] & 262143) >>> 10)) & 255);
      out[ 1 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 0 + inPos] & 262143) >>> 2)) & 255);
      out[ 2 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 0 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 1 + inPos] & 262143) >>> 12)) & 255);
      out[ 3 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 1 + inPos] & 262143) >>> 4)) & 255);
      out[ 4 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 1 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 2 + inPos] & 262143) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 2 + inPos] & 262143) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 2 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 3 + inPos] & 262143) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 3 + inPos] & 262143) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 3 + inPos] & 262143))) & 255);
      out[ 9 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 4 + inPos] & 262143) >>> 10)) & 255);
      out[10 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 4 + inPos] & 262143) >>> 2)) & 255);
      out[11 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 4 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 5 + inPos] & 262143) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 5 + inPos] & 262143) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 5 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[ 6 + inPos] & 262143) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[ 6 + inPos] & 262143) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[ 6 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[ 7 + inPos] & 262143) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[ 7 + inPos] & 262143) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[ 7 + inPos] & 262143))) & 255);
      out[18 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[ 8 + inPos] & 262143) >>> 10)) & 255);
      out[19 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[ 8 + inPos] & 262143) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[ 8 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[ 9 + inPos] & 262143) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[ 9 + inPos] & 262143) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[ 9 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[10 + inPos] & 262143) >>> 14)) & 255);
      out[23 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[10 + inPos] & 262143) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[10 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[11 + inPos] & 262143) >>> 16)) & 255);
      out[25 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[11 + inPos] & 262143) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[11 + inPos] & 262143))) & 255);
      out[27 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[12 + inPos] & 262143) >>> 10)) & 255);
      out[28 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[12 + inPos] & 262143) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[12 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[13 + inPos] & 262143) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[13 + inPos] & 262143) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[13 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[14 + inPos] & 262143) >>> 14)) & 255);
      out[32 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[14 + inPos] & 262143) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[14 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[15 + inPos] & 262143) >>> 16)) & 255);
      out[34 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[15 + inPos] & 262143) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[15 + inPos] & 262143))) & 255);
      out[36 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[16 + inPos] & 262143) >>> 10)) & 255);
      out[37 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[16 + inPos] & 262143) >>> 2)) & 255);
      out[38 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[16 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[17 + inPos] & 262143) >>> 12)) & 255);
      out[39 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[17 + inPos] & 262143) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[17 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[18 + inPos] & 262143) >>> 14)) & 255);
      out[41 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[18 + inPos] & 262143) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[18 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[19 + inPos] & 262143) >>> 16)) & 255);
      out[43 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[19 + inPos] & 262143) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[19 + inPos] & 262143))) & 255);
      out[45 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[20 + inPos] & 262143) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[20 + inPos] & 262143) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[20 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[21 + inPos] & 262143) >>> 12)) & 255);
      out[48 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[21 + inPos] & 262143) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[21 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[22 + inPos] & 262143) >>> 14)) & 255);
      out[50 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[22 + inPos] & 262143) >>> 6)) & 255);
      out[51 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[22 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[23 + inPos] & 262143) >>> 16)) & 255);
      out[52 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[23 + inPos] & 262143) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[23 + inPos] & 262143))) & 255);
      out[54 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[24 + inPos] & 262143) >>> 10)) & 255);
      out[55 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[24 + inPos] & 262143) >>> 2)) & 255);
      out[56 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[24 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[25 + inPos] & 262143) >>> 12)) & 255);
      out[57 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[25 + inPos] & 262143) >>> 4)) & 255);
      out[58 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[25 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[26 + inPos] & 262143) >>> 14)) & 255);
      out[59 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[26 + inPos] & 262143) >>> 6)) & 255);
      out[60 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[26 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[27 + inPos] & 262143) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[27 + inPos] & 262143) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[27 + inPos] & 262143))) & 255);
      out[63 + outPos] = (byte)((
          //                            [76543210]
          //                            [76543210__________]
           ((in[28 + inPos] & 262143) >>> 10)) & 255);
      out[64 + outPos] = (byte)((
          //                            [76543210]
          //                    [________98765432__]
           ((in[28 + inPos] & 262143) >>> 2)) & 255);
      out[65 + outPos] = (byte)((
          //                            [76______]
          //            [________________10]
           ((in[28 + inPos] & 262143) <<  6)
        | //                            [__543210]
          //                              [765432____________]
           ((in[29 + inPos] & 262143) >>> 12)) & 255);
      out[66 + outPos] = (byte)((
          //                            [76543210]
          //                      [______10987654____]
           ((in[29 + inPos] & 262143) >>> 4)) & 255);
      out[67 + outPos] = (byte)((
          //                            [7654____]
          //              [______________3210]
           ((in[29 + inPos] & 262143) <<  4)
        | //                            [____3210]
          //                                [7654______________]
           ((in[30 + inPos] & 262143) >>> 14)) & 255);
      out[68 + outPos] = (byte)((
          //                            [76543210]
          //                        [____32109876______]
           ((in[30 + inPos] & 262143) >>> 6)) & 255);
      out[69 + outPos] = (byte)((
          //                            [765432__]
          //                [____________543210]
           ((in[30 + inPos] & 262143) <<  2)
        | //                            [______10]
          //                                  [76________________]
           ((in[31 + inPos] & 262143) >>> 16)) & 255);
      out[70 + outPos] = (byte)((
          //                            [76543210]
          //                          [__54321098________]
           ((in[31 + inPos] & 262143) >>> 8)) & 255);
      out[71 + outPos] = (byte)((
          //                            [76543210]
          //                  [__________76543210]
           ((in[31 + inPos] & 262143))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[ 0 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 262143);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[ 2 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 262143);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[ 4 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 262143);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[ 6 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 262143);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[ 9 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 262143);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[11 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 262143);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[13 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 262143);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[15 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[17 + inPos]) & 255) ) & 262143);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[ 0 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[ 1 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[ 2 + inPos]) & 255) >>>  6) & 262143);
      out[ 1 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[ 2 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[ 3 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[ 4 + inPos]) & 255) >>>  4) & 262143);
      out[ 2 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[ 4 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 262143);
      out[ 3 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[ 6 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 262143);
      out[ 4 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[ 9 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[10 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[11 + inPos]) & 255) >>>  6) & 262143);
      out[ 5 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[11 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 262143);
      out[ 6 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[13 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 262143);
      out[ 7 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[15 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[17 + inPos]) & 255) ) & 262143);
      out[ 8 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[18 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[19 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[20 + inPos]) & 255) >>>  6) & 262143);
      out[ 9 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[20 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 262143);
      out[10 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[22 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[23 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[24 + inPos]) & 255) >>>  2) & 262143);
      out[11 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[24 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[26 + inPos]) & 255) ) & 262143);
      out[12 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[27 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[28 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[29 + inPos]) & 255) >>>  6) & 262143);
      out[13 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[29 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[30 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[31 + inPos]) & 255) >>>  4) & 262143);
      out[14 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[31 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[32 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[33 + inPos]) & 255) >>>  2) & 262143);
      out[15 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[33 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[34 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[35 + inPos]) & 255) ) & 262143);
      out[16 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[36 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[37 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[38 + inPos]) & 255) >>>  6) & 262143);
      out[17 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[38 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[39 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[40 + inPos]) & 255) >>>  4) & 262143);
      out[18 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[40 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[41 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[42 + inPos]) & 255) >>>  2) & 262143);
      out[19 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[42 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[43 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[44 + inPos]) & 255) ) & 262143);
      out[20 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[45 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[46 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[47 + inPos]) & 255) >>>  6) & 262143);
      out[21 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[47 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[48 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[49 + inPos]) & 255) >>>  4) & 262143);
      out[22 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[49 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[50 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[51 + inPos]) & 255) >>>  2) & 262143);
      out[23 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[51 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[52 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[53 + inPos]) & 255) ) & 262143);
      out[24 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[54 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[55 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[56 + inPos]) & 255) >>>  6) & 262143);
      out[25 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[56 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[57 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[58 + inPos]) & 255) >>>  4) & 262143);
      out[26 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[58 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[59 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[60 + inPos]) & 255) >>>  2) & 262143);
      out[27 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[60 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[61 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[62 + inPos]) & 255) ) & 262143);
      out[28 + outPos] =
          //                            [76543210]
          //                            [76543210__________]
            (((((int)in[63 + inPos]) & 255) <<  10) & 262143)
        | //                            [76543210]
          //                    [________98765432__]
            (((((int)in[64 + inPos]) & 255) <<  2) & 262143)
        | //                            [76______]
          //            [________________10]
            (((((int)in[65 + inPos]) & 255) >>>  6) & 262143);
      out[29 + outPos] =
          //                            [__543210]
          //                              [765432____________]
            (((((int)in[65 + inPos]) & 255) <<  12) & 262143)
        | //                            [76543210]
          //                      [______10987654____]
            (((((int)in[66 + inPos]) & 255) <<  4) & 262143)
        | //                            [7654____]
          //              [______________3210]
            (((((int)in[67 + inPos]) & 255) >>>  4) & 262143);
      out[30 + outPos] =
          //                            [____3210]
          //                                [7654______________]
            (((((int)in[67 + inPos]) & 255) <<  14) & 262143)
        | //                            [76543210]
          //                        [____32109876______]
            (((((int)in[68 + inPos]) & 255) <<  6) & 262143)
        | //                            [765432__]
          //                [____________543210]
            (((((int)in[69 + inPos]) & 255) >>>  2) & 262143);
      out[31 + outPos] =
          //                            [______10]
          //                                  [76________________]
            (((((int)in[69 + inPos]) & 255) <<  16) & 262143)
        | //                            [76543210]
          //                          [__54321098________]
            (((((int)in[70 + inPos]) & 255) <<  8) & 262143)
        | //                            [76543210]
          //                  [__________76543210]
            (((((int)in[71 + inPos]) & 255) ) & 262143);
    }
  }

  private static final class Packer19 extends BytePacker {

    private Packer19() {
      super(19);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 0 + inPos] & 524287) >>> 11)) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 0 + inPos] & 524287) >>> 3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 0 + inPos] & 524287) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 1 + inPos] & 524287) >>> 14)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 1 + inPos] & 524287) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 1 + inPos] & 524287) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[ 2 + inPos] & 524287) >>> 17)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 2 + inPos] & 524287) >>> 9)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 2 + inPos] & 524287) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[ 2 + inPos] & 524287) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[ 3 + inPos] & 524287) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 3 + inPos] & 524287) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[ 3 + inPos] & 524287) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[ 4 + inPos] & 524287) >>> 15)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 4 + inPos] & 524287) >>> 7)) & 255);
      out[11 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[ 4 + inPos] & 524287) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[ 5 + inPos] & 524287) >>> 18)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 5 + inPos] & 524287) >>> 10)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 5 + inPos] & 524287) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[ 5 + inPos] & 524287) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[ 6 + inPos] & 524287) >>> 13)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 6 + inPos] & 524287) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[ 6 + inPos] & 524287) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[ 7 + inPos] & 524287) >>> 16)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 7 + inPos] & 524287) >>> 8)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 7 + inPos] & 524287))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 0 + inPos] & 524287) >>> 11)) & 255);
      out[ 1 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 0 + inPos] & 524287) >>> 3)) & 255);
      out[ 2 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 0 + inPos] & 524287) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 1 + inPos] & 524287) >>> 14)) & 255);
      out[ 3 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 1 + inPos] & 524287) >>> 6)) & 255);
      out[ 4 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 1 + inPos] & 524287) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[ 2 + inPos] & 524287) >>> 17)) & 255);
      out[ 5 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[ 2 + inPos] & 524287) >>> 9)) & 255);
      out[ 6 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[ 2 + inPos] & 524287) >>> 1)) & 255);
      out[ 7 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[ 2 + inPos] & 524287) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[ 3 + inPos] & 524287) >>> 12)) & 255);
      out[ 8 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[ 3 + inPos] & 524287) >>> 4)) & 255);
      out[ 9 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[ 3 + inPos] & 524287) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[ 4 + inPos] & 524287) >>> 15)) & 255);
      out[10 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[ 4 + inPos] & 524287) >>> 7)) & 255);
      out[11 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[ 4 + inPos] & 524287) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[ 5 + inPos] & 524287) >>> 18)) & 255);
      out[12 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[ 5 + inPos] & 524287) >>> 10)) & 255);
      out[13 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[ 5 + inPos] & 524287) >>> 2)) & 255);
      out[14 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[ 5 + inPos] & 524287) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[ 6 + inPos] & 524287) >>> 13)) & 255);
      out[15 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[ 6 + inPos] & 524287) >>> 5)) & 255);
      out[16 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[ 6 + inPos] & 524287) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[ 7 + inPos] & 524287) >>> 16)) & 255);
      out[17 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[ 7 + inPos] & 524287) >>> 8)) & 255);
      out[18 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[ 7 + inPos] & 524287))) & 255);
      out[19 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[ 8 + inPos] & 524287) >>> 11)) & 255);
      out[20 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[ 8 + inPos] & 524287) >>> 3)) & 255);
      out[21 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[ 8 + inPos] & 524287) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[ 9 + inPos] & 524287) >>> 14)) & 255);
      out[22 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[ 9 + inPos] & 524287) >>> 6)) & 255);
      out[23 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[ 9 + inPos] & 524287) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[10 + inPos] & 524287) >>> 17)) & 255);
      out[24 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[10 + inPos] & 524287) >>> 9)) & 255);
      out[25 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[10 + inPos] & 524287) >>> 1)) & 255);
      out[26 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[10 + inPos] & 524287) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[11 + inPos] & 524287) >>> 12)) & 255);
      out[27 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[11 + inPos] & 524287) >>> 4)) & 255);
      out[28 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[11 + inPos] & 524287) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[12 + inPos] & 524287) >>> 15)) & 255);
      out[29 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[12 + inPos] & 524287) >>> 7)) & 255);
      out[30 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[12 + inPos] & 524287) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[13 + inPos] & 524287) >>> 18)) & 255);
      out[31 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[13 + inPos] & 524287) >>> 10)) & 255);
      out[32 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[13 + inPos] & 524287) >>> 2)) & 255);
      out[33 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[13 + inPos] & 524287) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[14 + inPos] & 524287) >>> 13)) & 255);
      out[34 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[14 + inPos] & 524287) >>> 5)) & 255);
      out[35 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[14 + inPos] & 524287) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[15 + inPos] & 524287) >>> 16)) & 255);
      out[36 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[15 + inPos] & 524287) >>> 8)) & 255);
      out[37 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[15 + inPos] & 524287))) & 255);
      out[38 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[16 + inPos] & 524287) >>> 11)) & 255);
      out[39 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[16 + inPos] & 524287) >>> 3)) & 255);
      out[40 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[16 + inPos] & 524287) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[17 + inPos] & 524287) >>> 14)) & 255);
      out[41 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[17 + inPos] & 524287) >>> 6)) & 255);
      out[42 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[17 + inPos] & 524287) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[18 + inPos] & 524287) >>> 17)) & 255);
      out[43 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[18 + inPos] & 524287) >>> 9)) & 255);
      out[44 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[18 + inPos] & 524287) >>> 1)) & 255);
      out[45 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[18 + inPos] & 524287) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[19 + inPos] & 524287) >>> 12)) & 255);
      out[46 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[19 + inPos] & 524287) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[19 + inPos] & 524287) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[20 + inPos] & 524287) >>> 15)) & 255);
      out[48 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[20 + inPos] & 524287) >>> 7)) & 255);
      out[49 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[20 + inPos] & 524287) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[21 + inPos] & 524287) >>> 18)) & 255);
      out[50 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[21 + inPos] & 524287) >>> 10)) & 255);
      out[51 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[21 + inPos] & 524287) >>> 2)) & 255);
      out[52 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[21 + inPos] & 524287) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[22 + inPos] & 524287) >>> 13)) & 255);
      out[53 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[22 + inPos] & 524287) >>> 5)) & 255);
      out[54 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[22 + inPos] & 524287) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[23 + inPos] & 524287) >>> 16)) & 255);
      out[55 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[23 + inPos] & 524287) >>> 8)) & 255);
      out[56 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[23 + inPos] & 524287))) & 255);
      out[57 + outPos] = (byte)((
          //                             [76543210]
          //                             [87654321___________]
           ((in[24 + inPos] & 524287) >>> 11)) & 255);
      out[58 + outPos] = (byte)((
          //                             [76543210]
          //                     [________09876543___]
           ((in[24 + inPos] & 524287) >>> 3)) & 255);
      out[59 + outPos] = (byte)((
          //                             [765_____]
          //             [________________210]
           ((in[24 + inPos] & 524287) <<  5)
        | //                             [___43210]
          //                                [87654______________]
           ((in[25 + inPos] & 524287) >>> 14)) & 255);
      out[60 + outPos] = (byte)((
          //                             [76543210]
          //                        [_____32109876______]
           ((in[25 + inPos] & 524287) >>> 6)) & 255);
      out[61 + outPos] = (byte)((
          //                             [765432__]
          //                [_____________543210]
           ((in[25 + inPos] & 524287) <<  2)
        | //                             [______10]
          //                                   [87_________________]
           ((in[26 + inPos] & 524287) >>> 17)) & 255);
      out[62 + outPos] = (byte)((
          //                             [76543210]
          //                           [__65432109_________]
           ((in[26 + inPos] & 524287) >>> 9)) & 255);
      out[63 + outPos] = (byte)((
          //                             [76543210]
          //                   [__________87654321_]
           ((in[26 + inPos] & 524287) >>> 1)) & 255);
      out[64 + outPos] = (byte)((
          //                             [7_______]
          //           [__________________0]
           ((in[26 + inPos] & 524287) <<  7)
        | //                             [_6543210]
          //                              [8765432____________]
           ((in[27 + inPos] & 524287) >>> 12)) & 255);
      out[65 + outPos] = (byte)((
          //                             [76543210]
          //                      [_______10987654____]
           ((in[27 + inPos] & 524287) >>> 4)) & 255);
      out[66 + outPos] = (byte)((
          //                             [7654____]
          //              [_______________3210]
           ((in[27 + inPos] & 524287) <<  4)
        | //                             [____3210]
          //                                 [8765_______________]
           ((in[28 + inPos] & 524287) >>> 15)) & 255);
      out[67 + outPos] = (byte)((
          //                             [76543210]
          //                         [____43210987_______]
           ((in[28 + inPos] & 524287) >>> 7)) & 255);
      out[68 + outPos] = (byte)((
          //                             [7654321_]
          //                 [____________6543210]
           ((in[28 + inPos] & 524287) <<  1)
        | //                             [_______0]
          //                                    [8__________________]
           ((in[29 + inPos] & 524287) >>> 18)) & 255);
      out[69 + outPos] = (byte)((
          //                             [76543210]
          //                            [_76543210__________]
           ((in[29 + inPos] & 524287) >>> 10)) & 255);
      out[70 + outPos] = (byte)((
          //                             [76543210]
          //                    [_________98765432__]
           ((in[29 + inPos] & 524287) >>> 2)) & 255);
      out[71 + outPos] = (byte)((
          //                             [76______]
          //            [_________________10]
           ((in[29 + inPos] & 524287) <<  6)
        | //                             [__543210]
          //                               [876543_____________]
           ((in[30 + inPos] & 524287) >>> 13)) & 255);
      out[72 + outPos] = (byte)((
          //                             [76543210]
          //                       [______21098765_____]
           ((in[30 + inPos] & 524287) >>> 5)) & 255);
      out[73 + outPos] = (byte)((
          //                             [76543___]
          //               [______________43210]
           ((in[30 + inPos] & 524287) <<  3)
        | //                             [_____210]
          //                                  [876________________]
           ((in[31 + inPos] & 524287) >>> 16)) & 255);
      out[74 + outPos] = (byte)((
          //                             [76543210]
          //                          [___54321098________]
           ((in[31 + inPos] & 524287) >>> 8)) & 255);
      out[75 + outPos] = (byte)((
          //                             [76543210]
          //                  [___________76543210]
           ((in[31 + inPos] & 524287))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            (((((int)in[ 0 + inPos]) & 255) <<  11) & 524287)
        | //                             [76543210]
          //                     [________09876543___]
            (((((int)in[ 1 + inPos]) & 255) <<  3) & 524287)
        | //                             [765_____]
          //             [________________210]
            (((((int)in[ 2 + inPos]) & 255) >>>  5) & 524287);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            (((((int)in[ 2 + inPos]) & 255) <<  14) & 524287)
        | //                             [76543210]
          //                        [_____32109876______]
            (((((int)in[ 3 + inPos]) & 255) <<  6) & 524287)
        | //                             [765432__]
          //                [_____________543210]
            (((((int)in[ 4 + inPos]) & 255) >>>  2) & 524287);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            (((((int)in[ 4 + inPos]) & 255) <<  17) & 524287)
        | //                             [76543210]
          //                           [__65432109_________]
            (((((int)in[ 5 + inPos]) & 255) <<  9) & 524287)
        | //                             [76543210]
          //                   [__________87654321_]
            (((((int)in[ 6 + inPos]) & 255) <<  1) & 524287)
        | //                             [7_______]
          //           [__________________0]
            (((((int)in[ 7 + inPos]) & 255) >>>  7) & 524287);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            (((((int)in[ 7 + inPos]) & 255) <<  12) & 524287)
        | //                             [76543210]
          //                      [_______10987654____]
            (((((int)in[ 8 + inPos]) & 255) <<  4) & 524287)
        | //                             [7654____]
          //              [_______________3210]
            (((((int)in[ 9 + inPos]) & 255) >>>  4) & 524287);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            (((((int)in[ 9 + inPos]) & 255) <<  15) & 524287)
        | //                             [76543210]
          //                         [____43210987_______]
            (((((int)in[10 + inPos]) & 255) <<  7) & 524287)
        | //                             [7654321_]
          //                 [____________6543210]
            (((((int)in[11 + inPos]) & 255) >>>  1) & 524287);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            (((((int)in[11 + inPos]) & 255) <<  18) & 524287)
        | //                             [76543210]
          //                            [_76543210__________]
            (((((int)in[12 + inPos]) & 255) <<  10) & 524287)
        | //                             [76543210]
          //                    [_________98765432__]
            (((((int)in[13 + inPos]) & 255) <<  2) & 524287)
        | //                             [76______]
          //            [_________________10]
            (((((int)in[14 + inPos]) & 255) >>>  6) & 524287);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            (((((int)in[14 + inPos]) & 255) <<  13) & 524287)
        | //                             [76543210]
          //                       [______21098765_____]
            (((((int)in[15 + inPos]) & 255) <<  5) & 524287)
        | //                             [76543___]
          //               [______________43210]
            (((((int)in[16 + inPos]) & 255) >>>  3) & 524287);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            (((((int)in[16 + inPos]) & 255) <<  16) & 524287)
        | //                             [76543210]
          //                          [___54321098________]
            (((((int)in[17 + inPos]) & 255) <<  8) & 524287)
        | //                             [76543210]
          //                  [___________76543210]
            (((((int)in[18 + inPos]) & 255) ) & 524287);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            (((((int)in[ 0 + inPos]) & 255) <<  11) & 524287)
        | //                             [76543210]
          //                     [________09876543___]
            (((((int)in[ 1 + inPos]) & 255) <<  3) & 524287)
        | //                             [765_____]
          //             [________________210]
            (((((int)in[ 2 + inPos]) & 255) >>>  5) & 524287);
      out[ 1 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            (((((int)in[ 2 + inPos]) & 255) <<  14) & 524287)
        | //                             [76543210]
          //                        [_____32109876______]
            (((((int)in[ 3 + inPos]) & 255) <<  6) & 524287)
        | //                             [765432__]
          //                [_____________543210]
            (((((int)in[ 4 + inPos]) & 255) >>>  2) & 524287);
      out[ 2 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            (((((int)in[ 4 + inPos]) & 255) <<  17) & 524287)
        | //                             [76543210]
          //                           [__65432109_________]
            (((((int)in[ 5 + inPos]) & 255) <<  9) & 524287)
        | //                             [76543210]
          //                   [__________87654321_]
            (((((int)in[ 6 + inPos]) & 255) <<  1) & 524287)
        | //                             [7_______]
          //           [__________________0]
            (((((int)in[ 7 + inPos]) & 255) >>>  7) & 524287);
      out[ 3 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            (((((int)in[ 7 + inPos]) & 255) <<  12) & 524287)
        | //                             [76543210]
          //                      [_______10987654____]
            (((((int)in[ 8 + inPos]) & 255) <<  4) & 524287)
        | //                             [7654____]
          //              [_______________3210]
            (((((int)in[ 9 + inPos]) & 255) >>>  4) & 524287);
      out[ 4 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            (((((int)in[ 9 + inPos]) & 255) <<  15) & 524287)
        | //                             [76543210]
          //                         [____43210987_______]
            (((((int)in[10 + inPos]) & 255) <<  7) & 524287)
        | //                             [7654321_]
          //                 [____________6543210]
            (((((int)in[11 + inPos]) & 255) >>>  1) & 524287);
      out[ 5 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            (((((int)in[11 + inPos]) & 255) <<  18) & 524287)
        | //                             [76543210]
          //                            [_76543210__________]
            (((((int)in[12 + inPos]) & 255) <<  10) & 524287)
        | //                             [76543210]
          //                    [_________98765432__]
            (((((int)in[13 + inPos]) & 255) <<  2) & 524287)
        | //                             [76______]
          //            [_________________10]
            (((((int)in[14 + inPos]) & 255) >>>  6) & 524287);
      out[ 6 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            (((((int)in[14 + inPos]) & 255) <<  13) & 524287)
        | //                             [76543210]
          //                       [______21098765_____]
            (((((int)in[15 + inPos]) & 255) <<  5) & 524287)
        | //                             [76543___]
          //               [______________43210]
            (((((int)in[16 + inPos]) & 255) >>>  3) & 524287);
      out[ 7 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            (((((int)in[16 + inPos]) & 255) <<  16) & 524287)
        | //                             [76543210]
          //                          [___54321098________]
            (((((int)in[17 + inPos]) & 255) <<  8) & 524287)
        | //                             [76543210]
          //                  [___________76543210]
            (((((int)in[18 + inPos]) & 255) ) & 524287);
      out[ 8 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            (((((int)in[19 + inPos]) & 255) <<  11) & 524287)
        | //                             [76543210]
          //                     [________09876543___]
            (((((int)in[20 + inPos]) & 255) <<  3) & 524287)
        | //                             [765_____]
          //             [________________210]
            (((((int)in[21 + inPos]) & 255) >>>  5) & 524287);
      out[ 9 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            (((((int)in[21 + inPos]) & 255) <<  14) & 524287)
        | //                             [76543210]
          //                        [_____32109876______]
            (((((int)in[22 + inPos]) & 255) <<  6) & 524287)
        | //                             [765432__]
          //                [_____________543210]
            (((((int)in[23 + inPos]) & 255) >>>  2) & 524287);
      out[10 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            (((((int)in[23 + inPos]) & 255) <<  17) & 524287)
        | //                             [76543210]
          //                           [__65432109_________]
            (((((int)in[24 + inPos]) & 255) <<  9) & 524287)
        | //                             [76543210]
          //                   [__________87654321_]
            (((((int)in[25 + inPos]) & 255) <<  1) & 524287)
        | //                             [7_______]
          //           [__________________0]
            (((((int)in[26 + inPos]) & 255) >>>  7) & 524287);
      out[11 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            (((((int)in[26 + inPos]) & 255) <<  12) & 524287)
        | //                             [76543210]
          //                      [_______10987654____]
            (((((int)in[27 + inPos]) & 255) <<  4) & 524287)
        | //                             [7654____]
          //              [_______________3210]
            (((((int)in[28 + inPos]) & 255) >>>  4) & 524287);
      out[12 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            (((((int)in[28 + inPos]) & 255) <<  15) & 524287)
        | //                             [76543210]
          //                         [____43210987_______]
            (((((int)in[29 + inPos]) & 255) <<  7) & 524287)
        | //                             [7654321_]
          //                 [____________6543210]
            (((((int)in[30 + inPos]) & 255) >>>  1) & 524287);
      out[13 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            (((((int)in[30 + inPos]) & 255) <<  18) & 524287)
        | //                             [76543210]
          //                            [_76543210__________]
            (((((int)in[31 + inPos]) & 255) <<  10) & 524287)
        | //                             [76543210]
          //                    [_________98765432__]
            (((((int)in[32 + inPos]) & 255) <<  2) & 524287)
        | //                             [76______]
          //            [_________________10]
            (((((int)in[33 + inPos]) & 255) >>>  6) & 524287);
      out[14 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            (((((int)in[33 + inPos]) & 255) <<  13) & 524287)
        | //                             [76543210]
          //                       [______21098765_____]
            (((((int)in[34 + inPos]) & 255) <<  5) & 524287)
        | //                             [76543___]
          //               [______________43210]
            (((((int)in[35 + inPos]) & 255) >>>  3) & 524287);
      out[15 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            (((((int)in[35 + inPos]) & 255) <<  16) & 524287)
        | //                             [76543210]
          //                          [___54321098________]
            (((((int)in[36 + inPos]) & 255) <<  8) & 524287)
        | //                             [76543210]
          //                  [___________76543210]
            (((((int)in[37 + inPos]) & 255) ) & 524287);
      out[16 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            (((((int)in[38 + inPos]) & 255) <<  11) & 524287)
        | //                             [76543210]
          //                     [________09876543___]
            (((((int)in[39 + inPos]) & 255) <<  3) & 524287)
        | //                             [765_____]
          //             [________________210]
            (((((int)in[40 + inPos]) & 255) >>>  5) & 524287);
      out[17 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            (((((int)in[40 + inPos]) & 255) <<  14) & 524287)
        | //                             [76543210]
          //                        [_____32109876______]
            (((((int)in[41 + inPos]) & 255) <<  6) & 524287)
        | //                             [765432__]
          //                [_____________543210]
            (((((int)in[42 + inPos]) & 255) >>>  2) & 524287);
      out[18 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            (((((int)in[42 + inPos]) & 255) <<  17) & 524287)
        | //                             [76543210]
          //                           [__65432109_________]
            (((((int)in[43 + inPos]) & 255) <<  9) & 524287)
        | //                             [76543210]
          //                   [__________87654321_]
            (((((int)in[44 + inPos]) & 255) <<  1) & 524287)
        | //                             [7_______]
          //           [__________________0]
            (((((int)in[45 + inPos]) & 255) >>>  7) & 524287);
      out[19 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            (((((int)in[45 + inPos]) & 255) <<  12) & 524287)
        | //                             [76543210]
          //                      [_______10987654____]
            (((((int)in[46 + inPos]) & 255) <<  4) & 524287)
        | //                             [7654____]
          //              [_______________3210]
            (((((int)in[47 + inPos]) & 255) >>>  4) & 524287);
      out[20 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            (((((int)in[47 + inPos]) & 255) <<  15) & 524287)
        | //                             [76543210]
          //                         [____43210987_______]
            (((((int)in[48 + inPos]) & 255) <<  7) & 524287)
        | //                             [7654321_]
          //                 [____________6543210]
            (((((int)in[49 + inPos]) & 255) >>>  1) & 524287);
      out[21 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            (((((int)in[49 + inPos]) & 255) <<  18) & 524287)
        | //                             [76543210]
          //                            [_76543210__________]
            (((((int)in[50 + inPos]) & 255) <<  10) & 524287)
        | //                             [76543210]
          //                    [_________98765432__]
            (((((int)in[51 + inPos]) & 255) <<  2) & 524287)
        | //                             [76______]
          //            [_________________10]
            (((((int)in[52 + inPos]) & 255) >>>  6) & 524287);
      out[22 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            (((((int)in[52 + inPos]) & 255) <<  13) & 524287)
        | //                             [76543210]
          //                       [______21098765_____]
            (((((int)in[53 + inPos]) & 255) <<  5) & 524287)
        | //                             [76543___]
          //               [______________43210]
            (((((int)in[54 + inPos]) & 255) >>>  3) & 524287);
      out[23 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            (((((int)in[54 + inPos]) & 255) <<  16) & 524287)
        | //                             [76543210]
          //                          [___54321098________]
            (((((int)in[55 + inPos]) & 255) <<  8) & 524287)
        | //                             [76543210]
          //                  [___________76543210]
            (((((int)in[56 + inPos]) & 255) ) & 524287);
      out[24 + outPos] =
          //                             [76543210]
          //                             [87654321___________]
            (((((int)in[57 + inPos]) & 255) <<  11) & 524287)
        | //                             [76543210]
          //                     [________09876543___]
            (((((int)in[58 + inPos]) & 255) <<  3) & 524287)
        | //                             [765_____]
          //             [________________210]
            (((((int)in[59 + inPos]) & 255) >>>  5) & 524287);
      out[25 + outPos] =
          //                             [___43210]
          //                                [87654______________]
            (((((int)in[59 + inPos]) & 255) <<  14) & 524287)
        | //                             [76543210]
          //                        [_____32109876______]
            (((((int)in[60 + inPos]) & 255) <<  6) & 524287)
        | //                             [765432__]
          //                [_____________543210]
            (((((int)in[61 + inPos]) & 255) >>>  2) & 524287);
      out[26 + outPos] =
          //                             [______10]
          //                                   [87_________________]
            (((((int)in[61 + inPos]) & 255) <<  17) & 524287)
        | //                             [76543210]
          //                           [__65432109_________]
            (((((int)in[62 + inPos]) & 255) <<  9) & 524287)
        | //                             [76543210]
          //                   [__________87654321_]
            (((((int)in[63 + inPos]) & 255) <<  1) & 524287)
        | //                             [7_______]
          //           [__________________0]
            (((((int)in[64 + inPos]) & 255) >>>  7) & 524287);
      out[27 + outPos] =
          //                             [_6543210]
          //                              [8765432____________]
            (((((int)in[64 + inPos]) & 255) <<  12) & 524287)
        | //                             [76543210]
          //                      [_______10987654____]
            (((((int)in[65 + inPos]) & 255) <<  4) & 524287)
        | //                             [7654____]
          //              [_______________3210]
            (((((int)in[66 + inPos]) & 255) >>>  4) & 524287);
      out[28 + outPos] =
          //                             [____3210]
          //                                 [8765_______________]
            (((((int)in[66 + inPos]) & 255) <<  15) & 524287)
        | //                             [76543210]
          //                         [____43210987_______]
            (((((int)in[67 + inPos]) & 255) <<  7) & 524287)
        | //                             [7654321_]
          //                 [____________6543210]
            (((((int)in[68 + inPos]) & 255) >>>  1) & 524287);
      out[29 + outPos] =
          //                             [_______0]
          //                                    [8__________________]
            (((((int)in[68 + inPos]) & 255) <<  18) & 524287)
        | //                             [76543210]
          //                            [_76543210__________]
            (((((int)in[69 + inPos]) & 255) <<  10) & 524287)
        | //                             [76543210]
          //                    [_________98765432__]
            (((((int)in[70 + inPos]) & 255) <<  2) & 524287)
        | //                             [76______]
          //            [_________________10]
            (((((int)in[71 + inPos]) & 255) >>>  6) & 524287);
      out[30 + outPos] =
          //                             [__543210]
          //                               [876543_____________]
            (((((int)in[71 + inPos]) & 255) <<  13) & 524287)
        | //                             [76543210]
          //                       [______21098765_____]
            (((((int)in[72 + inPos]) & 255) <<  5) & 524287)
        | //                             [76543___]
          //               [______________43210]
            (((((int)in[73 + inPos]) & 255) >>>  3) & 524287);
      out[31 + outPos] =
          //                             [_____210]
          //                                  [876________________]
            (((((int)in[73 + inPos]) & 255) <<  16) & 524287)
        | //                             [76543210]
          //                          [___54321098________]
            (((((int)in[74 + inPos]) & 255) <<  8) & 524287)
        | //                             [76543210]
          //                  [___________76543210]
            (((((int)in[75 + inPos]) & 255) ) & 524287);
    }
  }

  private static final class Packer20 extends BytePacker {

    private Packer20() {
      super(20);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 0 + inPos] & 1048575) >>> 12)) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 0 + inPos] & 1048575) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 0 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 1 + inPos] & 1048575) >>> 16)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 1 + inPos] & 1048575) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 1 + inPos] & 1048575))) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 2 + inPos] & 1048575) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 2 + inPos] & 1048575) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 2 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 3 + inPos] & 1048575) >>> 16)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 3 + inPos] & 1048575) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 3 + inPos] & 1048575))) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 4 + inPos] & 1048575) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 4 + inPos] & 1048575) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 4 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 5 + inPos] & 1048575) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 5 + inPos] & 1048575) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 5 + inPos] & 1048575))) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 6 + inPos] & 1048575) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 6 + inPos] & 1048575) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 6 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 7 + inPos] & 1048575) >>> 16)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 7 + inPos] & 1048575) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 7 + inPos] & 1048575))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 0 + inPos] & 1048575) >>> 12)) & 255);
      out[ 1 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 0 + inPos] & 1048575) >>> 4)) & 255);
      out[ 2 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 0 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 1 + inPos] & 1048575) >>> 16)) & 255);
      out[ 3 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 1 + inPos] & 1048575) >>> 8)) & 255);
      out[ 4 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 1 + inPos] & 1048575))) & 255);
      out[ 5 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 2 + inPos] & 1048575) >>> 12)) & 255);
      out[ 6 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 2 + inPos] & 1048575) >>> 4)) & 255);
      out[ 7 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 2 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 3 + inPos] & 1048575) >>> 16)) & 255);
      out[ 8 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 3 + inPos] & 1048575) >>> 8)) & 255);
      out[ 9 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 3 + inPos] & 1048575))) & 255);
      out[10 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 4 + inPos] & 1048575) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 4 + inPos] & 1048575) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 4 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 5 + inPos] & 1048575) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 5 + inPos] & 1048575) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 5 + inPos] & 1048575))) & 255);
      out[15 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 6 + inPos] & 1048575) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 6 + inPos] & 1048575) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 6 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 7 + inPos] & 1048575) >>> 16)) & 255);
      out[18 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 7 + inPos] & 1048575) >>> 8)) & 255);
      out[19 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 7 + inPos] & 1048575))) & 255);
      out[20 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[ 8 + inPos] & 1048575) >>> 12)) & 255);
      out[21 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[ 8 + inPos] & 1048575) >>> 4)) & 255);
      out[22 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[ 8 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[ 9 + inPos] & 1048575) >>> 16)) & 255);
      out[23 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[ 9 + inPos] & 1048575) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[ 9 + inPos] & 1048575))) & 255);
      out[25 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[10 + inPos] & 1048575) >>> 12)) & 255);
      out[26 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[10 + inPos] & 1048575) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[10 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[11 + inPos] & 1048575) >>> 16)) & 255);
      out[28 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[11 + inPos] & 1048575) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[11 + inPos] & 1048575))) & 255);
      out[30 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[12 + inPos] & 1048575) >>> 12)) & 255);
      out[31 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[12 + inPos] & 1048575) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[12 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[13 + inPos] & 1048575) >>> 16)) & 255);
      out[33 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[13 + inPos] & 1048575) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[13 + inPos] & 1048575))) & 255);
      out[35 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[14 + inPos] & 1048575) >>> 12)) & 255);
      out[36 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[14 + inPos] & 1048575) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[14 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[15 + inPos] & 1048575) >>> 16)) & 255);
      out[38 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[15 + inPos] & 1048575) >>> 8)) & 255);
      out[39 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[15 + inPos] & 1048575))) & 255);
      out[40 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[16 + inPos] & 1048575) >>> 12)) & 255);
      out[41 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[16 + inPos] & 1048575) >>> 4)) & 255);
      out[42 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[16 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[17 + inPos] & 1048575) >>> 16)) & 255);
      out[43 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[17 + inPos] & 1048575) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[17 + inPos] & 1048575))) & 255);
      out[45 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[18 + inPos] & 1048575) >>> 12)) & 255);
      out[46 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[18 + inPos] & 1048575) >>> 4)) & 255);
      out[47 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[18 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[19 + inPos] & 1048575) >>> 16)) & 255);
      out[48 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[19 + inPos] & 1048575) >>> 8)) & 255);
      out[49 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[19 + inPos] & 1048575))) & 255);
      out[50 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[20 + inPos] & 1048575) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[20 + inPos] & 1048575) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[20 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[21 + inPos] & 1048575) >>> 16)) & 255);
      out[53 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[21 + inPos] & 1048575) >>> 8)) & 255);
      out[54 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[21 + inPos] & 1048575))) & 255);
      out[55 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[22 + inPos] & 1048575) >>> 12)) & 255);
      out[56 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[22 + inPos] & 1048575) >>> 4)) & 255);
      out[57 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[22 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[23 + inPos] & 1048575) >>> 16)) & 255);
      out[58 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[23 + inPos] & 1048575) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[23 + inPos] & 1048575))) & 255);
      out[60 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[24 + inPos] & 1048575) >>> 12)) & 255);
      out[61 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[24 + inPos] & 1048575) >>> 4)) & 255);
      out[62 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[24 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[25 + inPos] & 1048575) >>> 16)) & 255);
      out[63 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[25 + inPos] & 1048575) >>> 8)) & 255);
      out[64 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[25 + inPos] & 1048575))) & 255);
      out[65 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[26 + inPos] & 1048575) >>> 12)) & 255);
      out[66 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[26 + inPos] & 1048575) >>> 4)) & 255);
      out[67 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[26 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[27 + inPos] & 1048575) >>> 16)) & 255);
      out[68 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[27 + inPos] & 1048575) >>> 8)) & 255);
      out[69 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[27 + inPos] & 1048575))) & 255);
      out[70 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[28 + inPos] & 1048575) >>> 12)) & 255);
      out[71 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[28 + inPos] & 1048575) >>> 4)) & 255);
      out[72 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[28 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[29 + inPos] & 1048575) >>> 16)) & 255);
      out[73 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[29 + inPos] & 1048575) >>> 8)) & 255);
      out[74 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[29 + inPos] & 1048575))) & 255);
      out[75 + outPos] = (byte)((
          //                              [76543210]
          //                              [98765432____________]
           ((in[30 + inPos] & 1048575) >>> 12)) & 255);
      out[76 + outPos] = (byte)((
          //                              [76543210]
          //                      [________10987654____]
           ((in[30 + inPos] & 1048575) >>> 4)) & 255);
      out[77 + outPos] = (byte)((
          //                              [7654____]
          //              [________________3210]
           ((in[30 + inPos] & 1048575) <<  4)
        | //                              [____3210]
          //                                  [9876________________]
           ((in[31 + inPos] & 1048575) >>> 16)) & 255);
      out[78 + outPos] = (byte)((
          //                              [76543210]
          //                          [____54321098________]
           ((in[31 + inPos] & 1048575) >>> 8)) & 255);
      out[79 + outPos] = (byte)((
          //                              [76543210]
          //                  [____________76543210]
           ((in[31 + inPos] & 1048575))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[ 0 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 1048575);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[ 2 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[ 3 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 1048575);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[ 5 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 1048575);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[ 7 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 1048575);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[10 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 1048575);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[12 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[14 + inPos]) & 255) ) & 1048575);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[15 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 1048575);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[17 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[18 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[19 + inPos]) & 255) ) & 1048575);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[ 0 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[ 1 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[ 2 + inPos]) & 255) >>>  4) & 1048575);
      out[ 1 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[ 2 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[ 3 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[ 4 + inPos]) & 255) ) & 1048575);
      out[ 2 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[ 5 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[ 6 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[ 7 + inPos]) & 255) >>>  4) & 1048575);
      out[ 3 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[ 7 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[ 8 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[ 9 + inPos]) & 255) ) & 1048575);
      out[ 4 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[10 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 1048575);
      out[ 5 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[12 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[14 + inPos]) & 255) ) & 1048575);
      out[ 6 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[15 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 1048575);
      out[ 7 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[17 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[18 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[19 + inPos]) & 255) ) & 1048575);
      out[ 8 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[20 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[21 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[22 + inPos]) & 255) >>>  4) & 1048575);
      out[ 9 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[22 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[23 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[24 + inPos]) & 255) ) & 1048575);
      out[10 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[25 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[26 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[27 + inPos]) & 255) >>>  4) & 1048575);
      out[11 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[27 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[29 + inPos]) & 255) ) & 1048575);
      out[12 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[30 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[31 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[32 + inPos]) & 255) >>>  4) & 1048575);
      out[13 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[32 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[33 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[34 + inPos]) & 255) ) & 1048575);
      out[14 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[35 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[36 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[37 + inPos]) & 255) >>>  4) & 1048575);
      out[15 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[37 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[38 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[39 + inPos]) & 255) ) & 1048575);
      out[16 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[40 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[41 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[42 + inPos]) & 255) >>>  4) & 1048575);
      out[17 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[42 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[43 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[44 + inPos]) & 255) ) & 1048575);
      out[18 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[45 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[46 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[47 + inPos]) & 255) >>>  4) & 1048575);
      out[19 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[47 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[48 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[49 + inPos]) & 255) ) & 1048575);
      out[20 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[50 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[51 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[52 + inPos]) & 255) >>>  4) & 1048575);
      out[21 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[52 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[53 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[54 + inPos]) & 255) ) & 1048575);
      out[22 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[55 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[56 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[57 + inPos]) & 255) >>>  4) & 1048575);
      out[23 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[57 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[58 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[59 + inPos]) & 255) ) & 1048575);
      out[24 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[60 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[61 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[62 + inPos]) & 255) >>>  4) & 1048575);
      out[25 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[62 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[63 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[64 + inPos]) & 255) ) & 1048575);
      out[26 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[65 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[66 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[67 + inPos]) & 255) >>>  4) & 1048575);
      out[27 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[67 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[68 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[69 + inPos]) & 255) ) & 1048575);
      out[28 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[70 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[71 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[72 + inPos]) & 255) >>>  4) & 1048575);
      out[29 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[72 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[73 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[74 + inPos]) & 255) ) & 1048575);
      out[30 + outPos] =
          //                              [76543210]
          //                              [98765432____________]
            (((((int)in[75 + inPos]) & 255) <<  12) & 1048575)
        | //                              [76543210]
          //                      [________10987654____]
            (((((int)in[76 + inPos]) & 255) <<  4) & 1048575)
        | //                              [7654____]
          //              [________________3210]
            (((((int)in[77 + inPos]) & 255) >>>  4) & 1048575);
      out[31 + outPos] =
          //                              [____3210]
          //                                  [9876________________]
            (((((int)in[77 + inPos]) & 255) <<  16) & 1048575)
        | //                              [76543210]
          //                          [____54321098________]
            (((((int)in[78 + inPos]) & 255) <<  8) & 1048575)
        | //                              [76543210]
          //                  [____________76543210]
            (((((int)in[79 + inPos]) & 255) ) & 1048575);
    }
  }

  private static final class Packer21 extends BytePacker {

    private Packer21() {
      super(21);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 0 + inPos] & 2097151) >>> 13)) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 0 + inPos] & 2097151) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 0 + inPos] & 2097151) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 1 + inPos] & 2097151) >>> 18)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 1 + inPos] & 2097151) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 1 + inPos] & 2097151) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 1 + inPos] & 2097151) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[ 2 + inPos] & 2097151) >>> 15)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 2 + inPos] & 2097151) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[ 2 + inPos] & 2097151) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[ 3 + inPos] & 2097151) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 3 + inPos] & 2097151) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 3 + inPos] & 2097151) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[ 3 + inPos] & 2097151) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[ 4 + inPos] & 2097151) >>> 17)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 4 + inPos] & 2097151) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 4 + inPos] & 2097151) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[ 4 + inPos] & 2097151) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[ 5 + inPos] & 2097151) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 5 + inPos] & 2097151) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[ 5 + inPos] & 2097151) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[ 6 + inPos] & 2097151) >>> 19)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 6 + inPos] & 2097151) >>> 11)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 6 + inPos] & 2097151) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[ 6 + inPos] & 2097151) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[ 7 + inPos] & 2097151) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 7 + inPos] & 2097151) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 7 + inPos] & 2097151))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 0 + inPos] & 2097151) >>> 13)) & 255);
      out[ 1 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 0 + inPos] & 2097151) >>> 5)) & 255);
      out[ 2 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 0 + inPos] & 2097151) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 1 + inPos] & 2097151) >>> 18)) & 255);
      out[ 3 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 1 + inPos] & 2097151) >>> 10)) & 255);
      out[ 4 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 1 + inPos] & 2097151) >>> 2)) & 255);
      out[ 5 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 1 + inPos] & 2097151) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[ 2 + inPos] & 2097151) >>> 15)) & 255);
      out[ 6 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[ 2 + inPos] & 2097151) >>> 7)) & 255);
      out[ 7 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[ 2 + inPos] & 2097151) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[ 3 + inPos] & 2097151) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[ 3 + inPos] & 2097151) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[ 3 + inPos] & 2097151) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[ 3 + inPos] & 2097151) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[ 4 + inPos] & 2097151) >>> 17)) & 255);
      out[11 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[ 4 + inPos] & 2097151) >>> 9)) & 255);
      out[12 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[ 4 + inPos] & 2097151) >>> 1)) & 255);
      out[13 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[ 4 + inPos] & 2097151) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[ 5 + inPos] & 2097151) >>> 14)) & 255);
      out[14 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[ 5 + inPos] & 2097151) >>> 6)) & 255);
      out[15 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[ 5 + inPos] & 2097151) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[ 6 + inPos] & 2097151) >>> 19)) & 255);
      out[16 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[ 6 + inPos] & 2097151) >>> 11)) & 255);
      out[17 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[ 6 + inPos] & 2097151) >>> 3)) & 255);
      out[18 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[ 6 + inPos] & 2097151) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[ 7 + inPos] & 2097151) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[ 7 + inPos] & 2097151) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[ 7 + inPos] & 2097151))) & 255);
      out[21 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[ 8 + inPos] & 2097151) >>> 13)) & 255);
      out[22 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[ 8 + inPos] & 2097151) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[ 8 + inPos] & 2097151) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[ 9 + inPos] & 2097151) >>> 18)) & 255);
      out[24 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[ 9 + inPos] & 2097151) >>> 10)) & 255);
      out[25 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[ 9 + inPos] & 2097151) >>> 2)) & 255);
      out[26 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[ 9 + inPos] & 2097151) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[10 + inPos] & 2097151) >>> 15)) & 255);
      out[27 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[10 + inPos] & 2097151) >>> 7)) & 255);
      out[28 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[10 + inPos] & 2097151) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[11 + inPos] & 2097151) >>> 20)) & 255);
      out[29 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[11 + inPos] & 2097151) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[11 + inPos] & 2097151) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[11 + inPos] & 2097151) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[12 + inPos] & 2097151) >>> 17)) & 255);
      out[32 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[12 + inPos] & 2097151) >>> 9)) & 255);
      out[33 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[12 + inPos] & 2097151) >>> 1)) & 255);
      out[34 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[12 + inPos] & 2097151) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[13 + inPos] & 2097151) >>> 14)) & 255);
      out[35 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[13 + inPos] & 2097151) >>> 6)) & 255);
      out[36 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[13 + inPos] & 2097151) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[14 + inPos] & 2097151) >>> 19)) & 255);
      out[37 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[14 + inPos] & 2097151) >>> 11)) & 255);
      out[38 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[14 + inPos] & 2097151) >>> 3)) & 255);
      out[39 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[14 + inPos] & 2097151) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[15 + inPos] & 2097151) >>> 16)) & 255);
      out[40 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[15 + inPos] & 2097151) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[15 + inPos] & 2097151))) & 255);
      out[42 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[16 + inPos] & 2097151) >>> 13)) & 255);
      out[43 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[16 + inPos] & 2097151) >>> 5)) & 255);
      out[44 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[16 + inPos] & 2097151) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[17 + inPos] & 2097151) >>> 18)) & 255);
      out[45 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[17 + inPos] & 2097151) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[17 + inPos] & 2097151) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[17 + inPos] & 2097151) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[18 + inPos] & 2097151) >>> 15)) & 255);
      out[48 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[18 + inPos] & 2097151) >>> 7)) & 255);
      out[49 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[18 + inPos] & 2097151) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[19 + inPos] & 2097151) >>> 20)) & 255);
      out[50 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[19 + inPos] & 2097151) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[19 + inPos] & 2097151) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[19 + inPos] & 2097151) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[20 + inPos] & 2097151) >>> 17)) & 255);
      out[53 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[20 + inPos] & 2097151) >>> 9)) & 255);
      out[54 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[20 + inPos] & 2097151) >>> 1)) & 255);
      out[55 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[20 + inPos] & 2097151) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[21 + inPos] & 2097151) >>> 14)) & 255);
      out[56 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[21 + inPos] & 2097151) >>> 6)) & 255);
      out[57 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[21 + inPos] & 2097151) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[22 + inPos] & 2097151) >>> 19)) & 255);
      out[58 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[22 + inPos] & 2097151) >>> 11)) & 255);
      out[59 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[22 + inPos] & 2097151) >>> 3)) & 255);
      out[60 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[22 + inPos] & 2097151) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[23 + inPos] & 2097151) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[23 + inPos] & 2097151) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[23 + inPos] & 2097151))) & 255);
      out[63 + outPos] = (byte)((
          //                               [76543210]
          //                               [09876543_____________]
           ((in[24 + inPos] & 2097151) >>> 13)) & 255);
      out[64 + outPos] = (byte)((
          //                               [76543210]
          //                       [________21098765_____]
           ((in[24 + inPos] & 2097151) >>> 5)) & 255);
      out[65 + outPos] = (byte)((
          //                               [76543___]
          //               [________________43210]
           ((in[24 + inPos] & 2097151) <<  3)
        | //                               [_____210]
          //                                    [098__________________]
           ((in[25 + inPos] & 2097151) >>> 18)) & 255);
      out[66 + outPos] = (byte)((
          //                               [76543210]
          //                            [___76543210__________]
           ((in[25 + inPos] & 2097151) >>> 10)) & 255);
      out[67 + outPos] = (byte)((
          //                               [76543210]
          //                    [___________98765432__]
           ((in[25 + inPos] & 2097151) >>> 2)) & 255);
      out[68 + outPos] = (byte)((
          //                               [76______]
          //            [___________________10]
           ((in[25 + inPos] & 2097151) <<  6)
        | //                               [__543210]
          //                                 [098765_______________]
           ((in[26 + inPos] & 2097151) >>> 15)) & 255);
      out[69 + outPos] = (byte)((
          //                               [76543210]
          //                         [______43210987_______]
           ((in[26 + inPos] & 2097151) >>> 7)) & 255);
      out[70 + outPos] = (byte)((
          //                               [7654321_]
          //                 [______________6543210]
           ((in[26 + inPos] & 2097151) <<  1)
        | //                               [_______0]
          //                                      [0____________________]
           ((in[27 + inPos] & 2097151) >>> 20)) & 255);
      out[71 + outPos] = (byte)((
          //                               [76543210]
          //                              [_98765432____________]
           ((in[27 + inPos] & 2097151) >>> 12)) & 255);
      out[72 + outPos] = (byte)((
          //                               [76543210]
          //                      [_________10987654____]
           ((in[27 + inPos] & 2097151) >>> 4)) & 255);
      out[73 + outPos] = (byte)((
          //                               [7654____]
          //              [_________________3210]
           ((in[27 + inPos] & 2097151) <<  4)
        | //                               [____3210]
          //                                   [0987_________________]
           ((in[28 + inPos] & 2097151) >>> 17)) & 255);
      out[74 + outPos] = (byte)((
          //                               [76543210]
          //                           [____65432109_________]
           ((in[28 + inPos] & 2097151) >>> 9)) & 255);
      out[75 + outPos] = (byte)((
          //                               [76543210]
          //                   [____________87654321_]
           ((in[28 + inPos] & 2097151) >>> 1)) & 255);
      out[76 + outPos] = (byte)((
          //                               [7_______]
          //           [____________________0]
           ((in[28 + inPos] & 2097151) <<  7)
        | //                               [_6543210]
          //                                [0987654______________]
           ((in[29 + inPos] & 2097151) >>> 14)) & 255);
      out[77 + outPos] = (byte)((
          //                               [76543210]
          //                        [_______32109876______]
           ((in[29 + inPos] & 2097151) >>> 6)) & 255);
      out[78 + outPos] = (byte)((
          //                               [765432__]
          //                [_______________543210]
           ((in[29 + inPos] & 2097151) <<  2)
        | //                               [______10]
          //                                     [09___________________]
           ((in[30 + inPos] & 2097151) >>> 19)) & 255);
      out[79 + outPos] = (byte)((
          //                               [76543210]
          //                             [__87654321___________]
           ((in[30 + inPos] & 2097151) >>> 11)) & 255);
      out[80 + outPos] = (byte)((
          //                               [76543210]
          //                     [__________09876543___]
           ((in[30 + inPos] & 2097151) >>> 3)) & 255);
      out[81 + outPos] = (byte)((
          //                               [765_____]
          //             [__________________210]
           ((in[30 + inPos] & 2097151) <<  5)
        | //                               [___43210]
          //                                  [09876________________]
           ((in[31 + inPos] & 2097151) >>> 16)) & 255);
      out[82 + outPos] = (byte)((
          //                               [76543210]
          //                          [_____54321098________]
           ((in[31 + inPos] & 2097151) >>> 8)) & 255);
      out[83 + outPos] = (byte)((
          //                               [76543210]
          //                  [_____________76543210]
           ((in[31 + inPos] & 2097151))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            (((((int)in[ 0 + inPos]) & 255) <<  13) & 2097151)
        | //                               [76543210]
          //                       [________21098765_____]
            (((((int)in[ 1 + inPos]) & 255) <<  5) & 2097151)
        | //                               [76543___]
          //               [________________43210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 2097151);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            (((((int)in[ 2 + inPos]) & 255) <<  18) & 2097151)
        | //                               [76543210]
          //                            [___76543210__________]
            (((((int)in[ 3 + inPos]) & 255) <<  10) & 2097151)
        | //                               [76543210]
          //                    [___________98765432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 2097151)
        | //                               [76______]
          //            [___________________10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 2097151);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            (((((int)in[ 5 + inPos]) & 255) <<  15) & 2097151)
        | //                               [76543210]
          //                         [______43210987_______]
            (((((int)in[ 6 + inPos]) & 255) <<  7) & 2097151)
        | //                               [7654321_]
          //                 [______________6543210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 2097151);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            (((((int)in[ 7 + inPos]) & 255) <<  20) & 2097151)
        | //                               [76543210]
          //                              [_98765432____________]
            (((((int)in[ 8 + inPos]) & 255) <<  12) & 2097151)
        | //                               [76543210]
          //                      [_________10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 2097151)
        | //                               [7654____]
          //              [_________________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 2097151);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            (((((int)in[10 + inPos]) & 255) <<  17) & 2097151)
        | //                               [76543210]
          //                           [____65432109_________]
            (((((int)in[11 + inPos]) & 255) <<  9) & 2097151)
        | //                               [76543210]
          //                   [____________87654321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 2097151)
        | //                               [7_______]
          //           [____________________0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 2097151);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            (((((int)in[13 + inPos]) & 255) <<  14) & 2097151)
        | //                               [76543210]
          //                        [_______32109876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 2097151)
        | //                               [765432__]
          //                [_______________543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 2097151);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            (((((int)in[15 + inPos]) & 255) <<  19) & 2097151)
        | //                               [76543210]
          //                             [__87654321___________]
            (((((int)in[16 + inPos]) & 255) <<  11) & 2097151)
        | //                               [76543210]
          //                     [__________09876543___]
            (((((int)in[17 + inPos]) & 255) <<  3) & 2097151)
        | //                               [765_____]
          //             [__________________210]
            (((((int)in[18 + inPos]) & 255) >>>  5) & 2097151);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            (((((int)in[18 + inPos]) & 255) <<  16) & 2097151)
        | //                               [76543210]
          //                          [_____54321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 2097151)
        | //                               [76543210]
          //                  [_____________76543210]
            (((((int)in[20 + inPos]) & 255) ) & 2097151);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            (((((int)in[ 0 + inPos]) & 255) <<  13) & 2097151)
        | //                               [76543210]
          //                       [________21098765_____]
            (((((int)in[ 1 + inPos]) & 255) <<  5) & 2097151)
        | //                               [76543___]
          //               [________________43210]
            (((((int)in[ 2 + inPos]) & 255) >>>  3) & 2097151);
      out[ 1 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            (((((int)in[ 2 + inPos]) & 255) <<  18) & 2097151)
        | //                               [76543210]
          //                            [___76543210__________]
            (((((int)in[ 3 + inPos]) & 255) <<  10) & 2097151)
        | //                               [76543210]
          //                    [___________98765432__]
            (((((int)in[ 4 + inPos]) & 255) <<  2) & 2097151)
        | //                               [76______]
          //            [___________________10]
            (((((int)in[ 5 + inPos]) & 255) >>>  6) & 2097151);
      out[ 2 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            (((((int)in[ 5 + inPos]) & 255) <<  15) & 2097151)
        | //                               [76543210]
          //                         [______43210987_______]
            (((((int)in[ 6 + inPos]) & 255) <<  7) & 2097151)
        | //                               [7654321_]
          //                 [______________6543210]
            (((((int)in[ 7 + inPos]) & 255) >>>  1) & 2097151);
      out[ 3 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            (((((int)in[ 7 + inPos]) & 255) <<  20) & 2097151)
        | //                               [76543210]
          //                              [_98765432____________]
            (((((int)in[ 8 + inPos]) & 255) <<  12) & 2097151)
        | //                               [76543210]
          //                      [_________10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 2097151)
        | //                               [7654____]
          //              [_________________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 2097151);
      out[ 4 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            (((((int)in[10 + inPos]) & 255) <<  17) & 2097151)
        | //                               [76543210]
          //                           [____65432109_________]
            (((((int)in[11 + inPos]) & 255) <<  9) & 2097151)
        | //                               [76543210]
          //                   [____________87654321_]
            (((((int)in[12 + inPos]) & 255) <<  1) & 2097151)
        | //                               [7_______]
          //           [____________________0]
            (((((int)in[13 + inPos]) & 255) >>>  7) & 2097151);
      out[ 5 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            (((((int)in[13 + inPos]) & 255) <<  14) & 2097151)
        | //                               [76543210]
          //                        [_______32109876______]
            (((((int)in[14 + inPos]) & 255) <<  6) & 2097151)
        | //                               [765432__]
          //                [_______________543210]
            (((((int)in[15 + inPos]) & 255) >>>  2) & 2097151);
      out[ 6 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            (((((int)in[15 + inPos]) & 255) <<  19) & 2097151)
        | //                               [76543210]
          //                             [__87654321___________]
            (((((int)in[16 + inPos]) & 255) <<  11) & 2097151)
        | //                               [76543210]
          //                     [__________09876543___]
            (((((int)in[17 + inPos]) & 255) <<  3) & 2097151)
        | //                               [765_____]
          //             [__________________210]
            (((((int)in[18 + inPos]) & 255) >>>  5) & 2097151);
      out[ 7 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            (((((int)in[18 + inPos]) & 255) <<  16) & 2097151)
        | //                               [76543210]
          //                          [_____54321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 2097151)
        | //                               [76543210]
          //                  [_____________76543210]
            (((((int)in[20 + inPos]) & 255) ) & 2097151);
      out[ 8 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            (((((int)in[21 + inPos]) & 255) <<  13) & 2097151)
        | //                               [76543210]
          //                       [________21098765_____]
            (((((int)in[22 + inPos]) & 255) <<  5) & 2097151)
        | //                               [76543___]
          //               [________________43210]
            (((((int)in[23 + inPos]) & 255) >>>  3) & 2097151);
      out[ 9 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            (((((int)in[23 + inPos]) & 255) <<  18) & 2097151)
        | //                               [76543210]
          //                            [___76543210__________]
            (((((int)in[24 + inPos]) & 255) <<  10) & 2097151)
        | //                               [76543210]
          //                    [___________98765432__]
            (((((int)in[25 + inPos]) & 255) <<  2) & 2097151)
        | //                               [76______]
          //            [___________________10]
            (((((int)in[26 + inPos]) & 255) >>>  6) & 2097151);
      out[10 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            (((((int)in[26 + inPos]) & 255) <<  15) & 2097151)
        | //                               [76543210]
          //                         [______43210987_______]
            (((((int)in[27 + inPos]) & 255) <<  7) & 2097151)
        | //                               [7654321_]
          //                 [______________6543210]
            (((((int)in[28 + inPos]) & 255) >>>  1) & 2097151);
      out[11 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            (((((int)in[28 + inPos]) & 255) <<  20) & 2097151)
        | //                               [76543210]
          //                              [_98765432____________]
            (((((int)in[29 + inPos]) & 255) <<  12) & 2097151)
        | //                               [76543210]
          //                      [_________10987654____]
            (((((int)in[30 + inPos]) & 255) <<  4) & 2097151)
        | //                               [7654____]
          //              [_________________3210]
            (((((int)in[31 + inPos]) & 255) >>>  4) & 2097151);
      out[12 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            (((((int)in[31 + inPos]) & 255) <<  17) & 2097151)
        | //                               [76543210]
          //                           [____65432109_________]
            (((((int)in[32 + inPos]) & 255) <<  9) & 2097151)
        | //                               [76543210]
          //                   [____________87654321_]
            (((((int)in[33 + inPos]) & 255) <<  1) & 2097151)
        | //                               [7_______]
          //           [____________________0]
            (((((int)in[34 + inPos]) & 255) >>>  7) & 2097151);
      out[13 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            (((((int)in[34 + inPos]) & 255) <<  14) & 2097151)
        | //                               [76543210]
          //                        [_______32109876______]
            (((((int)in[35 + inPos]) & 255) <<  6) & 2097151)
        | //                               [765432__]
          //                [_______________543210]
            (((((int)in[36 + inPos]) & 255) >>>  2) & 2097151);
      out[14 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            (((((int)in[36 + inPos]) & 255) <<  19) & 2097151)
        | //                               [76543210]
          //                             [__87654321___________]
            (((((int)in[37 + inPos]) & 255) <<  11) & 2097151)
        | //                               [76543210]
          //                     [__________09876543___]
            (((((int)in[38 + inPos]) & 255) <<  3) & 2097151)
        | //                               [765_____]
          //             [__________________210]
            (((((int)in[39 + inPos]) & 255) >>>  5) & 2097151);
      out[15 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            (((((int)in[39 + inPos]) & 255) <<  16) & 2097151)
        | //                               [76543210]
          //                          [_____54321098________]
            (((((int)in[40 + inPos]) & 255) <<  8) & 2097151)
        | //                               [76543210]
          //                  [_____________76543210]
            (((((int)in[41 + inPos]) & 255) ) & 2097151);
      out[16 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            (((((int)in[42 + inPos]) & 255) <<  13) & 2097151)
        | //                               [76543210]
          //                       [________21098765_____]
            (((((int)in[43 + inPos]) & 255) <<  5) & 2097151)
        | //                               [76543___]
          //               [________________43210]
            (((((int)in[44 + inPos]) & 255) >>>  3) & 2097151);
      out[17 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            (((((int)in[44 + inPos]) & 255) <<  18) & 2097151)
        | //                               [76543210]
          //                            [___76543210__________]
            (((((int)in[45 + inPos]) & 255) <<  10) & 2097151)
        | //                               [76543210]
          //                    [___________98765432__]
            (((((int)in[46 + inPos]) & 255) <<  2) & 2097151)
        | //                               [76______]
          //            [___________________10]
            (((((int)in[47 + inPos]) & 255) >>>  6) & 2097151);
      out[18 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            (((((int)in[47 + inPos]) & 255) <<  15) & 2097151)
        | //                               [76543210]
          //                         [______43210987_______]
            (((((int)in[48 + inPos]) & 255) <<  7) & 2097151)
        | //                               [7654321_]
          //                 [______________6543210]
            (((((int)in[49 + inPos]) & 255) >>>  1) & 2097151);
      out[19 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            (((((int)in[49 + inPos]) & 255) <<  20) & 2097151)
        | //                               [76543210]
          //                              [_98765432____________]
            (((((int)in[50 + inPos]) & 255) <<  12) & 2097151)
        | //                               [76543210]
          //                      [_________10987654____]
            (((((int)in[51 + inPos]) & 255) <<  4) & 2097151)
        | //                               [7654____]
          //              [_________________3210]
            (((((int)in[52 + inPos]) & 255) >>>  4) & 2097151);
      out[20 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            (((((int)in[52 + inPos]) & 255) <<  17) & 2097151)
        | //                               [76543210]
          //                           [____65432109_________]
            (((((int)in[53 + inPos]) & 255) <<  9) & 2097151)
        | //                               [76543210]
          //                   [____________87654321_]
            (((((int)in[54 + inPos]) & 255) <<  1) & 2097151)
        | //                               [7_______]
          //           [____________________0]
            (((((int)in[55 + inPos]) & 255) >>>  7) & 2097151);
      out[21 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            (((((int)in[55 + inPos]) & 255) <<  14) & 2097151)
        | //                               [76543210]
          //                        [_______32109876______]
            (((((int)in[56 + inPos]) & 255) <<  6) & 2097151)
        | //                               [765432__]
          //                [_______________543210]
            (((((int)in[57 + inPos]) & 255) >>>  2) & 2097151);
      out[22 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            (((((int)in[57 + inPos]) & 255) <<  19) & 2097151)
        | //                               [76543210]
          //                             [__87654321___________]
            (((((int)in[58 + inPos]) & 255) <<  11) & 2097151)
        | //                               [76543210]
          //                     [__________09876543___]
            (((((int)in[59 + inPos]) & 255) <<  3) & 2097151)
        | //                               [765_____]
          //             [__________________210]
            (((((int)in[60 + inPos]) & 255) >>>  5) & 2097151);
      out[23 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            (((((int)in[60 + inPos]) & 255) <<  16) & 2097151)
        | //                               [76543210]
          //                          [_____54321098________]
            (((((int)in[61 + inPos]) & 255) <<  8) & 2097151)
        | //                               [76543210]
          //                  [_____________76543210]
            (((((int)in[62 + inPos]) & 255) ) & 2097151);
      out[24 + outPos] =
          //                               [76543210]
          //                               [09876543_____________]
            (((((int)in[63 + inPos]) & 255) <<  13) & 2097151)
        | //                               [76543210]
          //                       [________21098765_____]
            (((((int)in[64 + inPos]) & 255) <<  5) & 2097151)
        | //                               [76543___]
          //               [________________43210]
            (((((int)in[65 + inPos]) & 255) >>>  3) & 2097151);
      out[25 + outPos] =
          //                               [_____210]
          //                                    [098__________________]
            (((((int)in[65 + inPos]) & 255) <<  18) & 2097151)
        | //                               [76543210]
          //                            [___76543210__________]
            (((((int)in[66 + inPos]) & 255) <<  10) & 2097151)
        | //                               [76543210]
          //                    [___________98765432__]
            (((((int)in[67 + inPos]) & 255) <<  2) & 2097151)
        | //                               [76______]
          //            [___________________10]
            (((((int)in[68 + inPos]) & 255) >>>  6) & 2097151);
      out[26 + outPos] =
          //                               [__543210]
          //                                 [098765_______________]
            (((((int)in[68 + inPos]) & 255) <<  15) & 2097151)
        | //                               [76543210]
          //                         [______43210987_______]
            (((((int)in[69 + inPos]) & 255) <<  7) & 2097151)
        | //                               [7654321_]
          //                 [______________6543210]
            (((((int)in[70 + inPos]) & 255) >>>  1) & 2097151);
      out[27 + outPos] =
          //                               [_______0]
          //                                      [0____________________]
            (((((int)in[70 + inPos]) & 255) <<  20) & 2097151)
        | //                               [76543210]
          //                              [_98765432____________]
            (((((int)in[71 + inPos]) & 255) <<  12) & 2097151)
        | //                               [76543210]
          //                      [_________10987654____]
            (((((int)in[72 + inPos]) & 255) <<  4) & 2097151)
        | //                               [7654____]
          //              [_________________3210]
            (((((int)in[73 + inPos]) & 255) >>>  4) & 2097151);
      out[28 + outPos] =
          //                               [____3210]
          //                                   [0987_________________]
            (((((int)in[73 + inPos]) & 255) <<  17) & 2097151)
        | //                               [76543210]
          //                           [____65432109_________]
            (((((int)in[74 + inPos]) & 255) <<  9) & 2097151)
        | //                               [76543210]
          //                   [____________87654321_]
            (((((int)in[75 + inPos]) & 255) <<  1) & 2097151)
        | //                               [7_______]
          //           [____________________0]
            (((((int)in[76 + inPos]) & 255) >>>  7) & 2097151);
      out[29 + outPos] =
          //                               [_6543210]
          //                                [0987654______________]
            (((((int)in[76 + inPos]) & 255) <<  14) & 2097151)
        | //                               [76543210]
          //                        [_______32109876______]
            (((((int)in[77 + inPos]) & 255) <<  6) & 2097151)
        | //                               [765432__]
          //                [_______________543210]
            (((((int)in[78 + inPos]) & 255) >>>  2) & 2097151);
      out[30 + outPos] =
          //                               [______10]
          //                                     [09___________________]
            (((((int)in[78 + inPos]) & 255) <<  19) & 2097151)
        | //                               [76543210]
          //                             [__87654321___________]
            (((((int)in[79 + inPos]) & 255) <<  11) & 2097151)
        | //                               [76543210]
          //                     [__________09876543___]
            (((((int)in[80 + inPos]) & 255) <<  3) & 2097151)
        | //                               [765_____]
          //             [__________________210]
            (((((int)in[81 + inPos]) & 255) >>>  5) & 2097151);
      out[31 + outPos] =
          //                               [___43210]
          //                                  [09876________________]
            (((((int)in[81 + inPos]) & 255) <<  16) & 2097151)
        | //                               [76543210]
          //                          [_____54321098________]
            (((((int)in[82 + inPos]) & 255) <<  8) & 2097151)
        | //                               [76543210]
          //                  [_____________76543210]
            (((((int)in[83 + inPos]) & 255) ) & 2097151);
    }
  }

  private static final class Packer22 extends BytePacker {

    private Packer22() {
      super(22);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 0 + inPos] & 4194303) >>> 14)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 0 + inPos] & 4194303) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 0 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 1 + inPos] & 4194303) >>> 20)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 1 + inPos] & 4194303) >>> 12)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 1 + inPos] & 4194303) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 1 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 2 + inPos] & 4194303) >>> 18)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 2 + inPos] & 4194303) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 2 + inPos] & 4194303) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 2 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 3 + inPos] & 4194303) >>> 16)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 3 + inPos] & 4194303) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 3 + inPos] & 4194303))) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 4 + inPos] & 4194303) >>> 14)) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 4 + inPos] & 4194303) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 4 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 5 + inPos] & 4194303) >>> 20)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 5 + inPos] & 4194303) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 5 + inPos] & 4194303) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 5 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 6 + inPos] & 4194303) >>> 18)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 6 + inPos] & 4194303) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 6 + inPos] & 4194303) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 6 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 7 + inPos] & 4194303) >>> 16)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 7 + inPos] & 4194303) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 7 + inPos] & 4194303))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 0 + inPos] & 4194303) >>> 14)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 0 + inPos] & 4194303) >>> 6)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 0 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 1 + inPos] & 4194303) >>> 20)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 1 + inPos] & 4194303) >>> 12)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 1 + inPos] & 4194303) >>> 4)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 1 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 2 + inPos] & 4194303) >>> 18)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 2 + inPos] & 4194303) >>> 10)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 2 + inPos] & 4194303) >>> 2)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 2 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 3 + inPos] & 4194303) >>> 16)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 3 + inPos] & 4194303) >>> 8)) & 255);
      out[10 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 3 + inPos] & 4194303))) & 255);
      out[11 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 4 + inPos] & 4194303) >>> 14)) & 255);
      out[12 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 4 + inPos] & 4194303) >>> 6)) & 255);
      out[13 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 4 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 5 + inPos] & 4194303) >>> 20)) & 255);
      out[14 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 5 + inPos] & 4194303) >>> 12)) & 255);
      out[15 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 5 + inPos] & 4194303) >>> 4)) & 255);
      out[16 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 5 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[ 6 + inPos] & 4194303) >>> 18)) & 255);
      out[17 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[ 6 + inPos] & 4194303) >>> 10)) & 255);
      out[18 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[ 6 + inPos] & 4194303) >>> 2)) & 255);
      out[19 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[ 6 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[ 7 + inPos] & 4194303) >>> 16)) & 255);
      out[20 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[ 7 + inPos] & 4194303) >>> 8)) & 255);
      out[21 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[ 7 + inPos] & 4194303))) & 255);
      out[22 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[ 8 + inPos] & 4194303) >>> 14)) & 255);
      out[23 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[ 8 + inPos] & 4194303) >>> 6)) & 255);
      out[24 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[ 8 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[ 9 + inPos] & 4194303) >>> 20)) & 255);
      out[25 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[ 9 + inPos] & 4194303) >>> 12)) & 255);
      out[26 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[ 9 + inPos] & 4194303) >>> 4)) & 255);
      out[27 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[ 9 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[10 + inPos] & 4194303) >>> 18)) & 255);
      out[28 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[10 + inPos] & 4194303) >>> 10)) & 255);
      out[29 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[10 + inPos] & 4194303) >>> 2)) & 255);
      out[30 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[10 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[11 + inPos] & 4194303) >>> 16)) & 255);
      out[31 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[11 + inPos] & 4194303) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[11 + inPos] & 4194303))) & 255);
      out[33 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[12 + inPos] & 4194303) >>> 14)) & 255);
      out[34 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[12 + inPos] & 4194303) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[12 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[13 + inPos] & 4194303) >>> 20)) & 255);
      out[36 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[13 + inPos] & 4194303) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[13 + inPos] & 4194303) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[13 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[14 + inPos] & 4194303) >>> 18)) & 255);
      out[39 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[14 + inPos] & 4194303) >>> 10)) & 255);
      out[40 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[14 + inPos] & 4194303) >>> 2)) & 255);
      out[41 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[14 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[15 + inPos] & 4194303) >>> 16)) & 255);
      out[42 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[15 + inPos] & 4194303) >>> 8)) & 255);
      out[43 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[15 + inPos] & 4194303))) & 255);
      out[44 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[16 + inPos] & 4194303) >>> 14)) & 255);
      out[45 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[16 + inPos] & 4194303) >>> 6)) & 255);
      out[46 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[16 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[17 + inPos] & 4194303) >>> 20)) & 255);
      out[47 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[17 + inPos] & 4194303) >>> 12)) & 255);
      out[48 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[17 + inPos] & 4194303) >>> 4)) & 255);
      out[49 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[17 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[18 + inPos] & 4194303) >>> 18)) & 255);
      out[50 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[18 + inPos] & 4194303) >>> 10)) & 255);
      out[51 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[18 + inPos] & 4194303) >>> 2)) & 255);
      out[52 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[18 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[19 + inPos] & 4194303) >>> 16)) & 255);
      out[53 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[19 + inPos] & 4194303) >>> 8)) & 255);
      out[54 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[19 + inPos] & 4194303))) & 255);
      out[55 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[20 + inPos] & 4194303) >>> 14)) & 255);
      out[56 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[20 + inPos] & 4194303) >>> 6)) & 255);
      out[57 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[20 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[21 + inPos] & 4194303) >>> 20)) & 255);
      out[58 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[21 + inPos] & 4194303) >>> 12)) & 255);
      out[59 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[21 + inPos] & 4194303) >>> 4)) & 255);
      out[60 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[21 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[22 + inPos] & 4194303) >>> 18)) & 255);
      out[61 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[22 + inPos] & 4194303) >>> 10)) & 255);
      out[62 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[22 + inPos] & 4194303) >>> 2)) & 255);
      out[63 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[22 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[23 + inPos] & 4194303) >>> 16)) & 255);
      out[64 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[23 + inPos] & 4194303) >>> 8)) & 255);
      out[65 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[23 + inPos] & 4194303))) & 255);
      out[66 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[24 + inPos] & 4194303) >>> 14)) & 255);
      out[67 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[24 + inPos] & 4194303) >>> 6)) & 255);
      out[68 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[24 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[25 + inPos] & 4194303) >>> 20)) & 255);
      out[69 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[25 + inPos] & 4194303) >>> 12)) & 255);
      out[70 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[25 + inPos] & 4194303) >>> 4)) & 255);
      out[71 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[25 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[26 + inPos] & 4194303) >>> 18)) & 255);
      out[72 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[26 + inPos] & 4194303) >>> 10)) & 255);
      out[73 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[26 + inPos] & 4194303) >>> 2)) & 255);
      out[74 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[26 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[27 + inPos] & 4194303) >>> 16)) & 255);
      out[75 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[27 + inPos] & 4194303) >>> 8)) & 255);
      out[76 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[27 + inPos] & 4194303))) & 255);
      out[77 + outPos] = (byte)((
          //                                [76543210]
          //                                [10987654______________]
           ((in[28 + inPos] & 4194303) >>> 14)) & 255);
      out[78 + outPos] = (byte)((
          //                                [76543210]
          //                        [________32109876______]
           ((in[28 + inPos] & 4194303) >>> 6)) & 255);
      out[79 + outPos] = (byte)((
          //                                [765432__]
          //                [________________543210]
           ((in[28 + inPos] & 4194303) <<  2)
        | //                                [______10]
          //                                      [10____________________]
           ((in[29 + inPos] & 4194303) >>> 20)) & 255);
      out[80 + outPos] = (byte)((
          //                                [76543210]
          //                              [__98765432____________]
           ((in[29 + inPos] & 4194303) >>> 12)) & 255);
      out[81 + outPos] = (byte)((
          //                                [76543210]
          //                      [__________10987654____]
           ((in[29 + inPos] & 4194303) >>> 4)) & 255);
      out[82 + outPos] = (byte)((
          //                                [7654____]
          //              [__________________3210]
           ((in[29 + inPos] & 4194303) <<  4)
        | //                                [____3210]
          //                                    [1098__________________]
           ((in[30 + inPos] & 4194303) >>> 18)) & 255);
      out[83 + outPos] = (byte)((
          //                                [76543210]
          //                            [____76543210__________]
           ((in[30 + inPos] & 4194303) >>> 10)) & 255);
      out[84 + outPos] = (byte)((
          //                                [76543210]
          //                    [____________98765432__]
           ((in[30 + inPos] & 4194303) >>> 2)) & 255);
      out[85 + outPos] = (byte)((
          //                                [76______]
          //            [____________________10]
           ((in[30 + inPos] & 4194303) <<  6)
        | //                                [__543210]
          //                                  [109876________________]
           ((in[31 + inPos] & 4194303) >>> 16)) & 255);
      out[86 + outPos] = (byte)((
          //                                [76543210]
          //                          [______54321098________]
           ((in[31 + inPos] & 4194303) >>> 8)) & 255);
      out[87 + outPos] = (byte)((
          //                                [76543210]
          //                  [______________76543210]
           ((in[31 + inPos] & 4194303))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[ 0 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[ 1 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 4194303);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[ 2 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[ 3 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[ 4 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 4194303);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[ 5 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[ 6 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 4194303);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[ 8 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[ 9 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[10 + inPos]) & 255) ) & 4194303);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[11 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[12 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[13 + inPos]) & 255) >>>  2) & 4194303);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[13 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[14 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[15 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[16 + inPos]) & 255) >>>  4) & 4194303);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[16 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[17 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[18 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[19 + inPos]) & 255) >>>  6) & 4194303);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[19 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[20 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[21 + inPos]) & 255) ) & 4194303);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[ 0 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[ 1 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  2) & 4194303);
      out[ 1 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[ 2 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[ 3 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[ 4 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[ 5 + inPos]) & 255) >>>  4) & 4194303);
      out[ 2 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[ 5 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[ 6 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[ 7 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[ 8 + inPos]) & 255) >>>  6) & 4194303);
      out[ 3 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[ 8 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[ 9 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[10 + inPos]) & 255) ) & 4194303);
      out[ 4 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[11 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[12 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[13 + inPos]) & 255) >>>  2) & 4194303);
      out[ 5 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[13 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[14 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[15 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[16 + inPos]) & 255) >>>  4) & 4194303);
      out[ 6 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[16 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[17 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[18 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[19 + inPos]) & 255) >>>  6) & 4194303);
      out[ 7 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[19 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[20 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[21 + inPos]) & 255) ) & 4194303);
      out[ 8 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[22 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[23 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[24 + inPos]) & 255) >>>  2) & 4194303);
      out[ 9 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[24 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[25 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[26 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[27 + inPos]) & 255) >>>  4) & 4194303);
      out[10 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[27 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[28 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[29 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[30 + inPos]) & 255) >>>  6) & 4194303);
      out[11 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[30 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[31 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[32 + inPos]) & 255) ) & 4194303);
      out[12 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[33 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[34 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[35 + inPos]) & 255) >>>  2) & 4194303);
      out[13 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[35 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[36 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[37 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[38 + inPos]) & 255) >>>  4) & 4194303);
      out[14 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[38 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[39 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[40 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[41 + inPos]) & 255) >>>  6) & 4194303);
      out[15 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[41 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[42 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[43 + inPos]) & 255) ) & 4194303);
      out[16 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[44 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[45 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[46 + inPos]) & 255) >>>  2) & 4194303);
      out[17 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[46 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[47 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[48 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[49 + inPos]) & 255) >>>  4) & 4194303);
      out[18 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[49 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[50 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[51 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[52 + inPos]) & 255) >>>  6) & 4194303);
      out[19 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[52 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[53 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[54 + inPos]) & 255) ) & 4194303);
      out[20 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[55 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[56 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[57 + inPos]) & 255) >>>  2) & 4194303);
      out[21 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[57 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[58 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[59 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[60 + inPos]) & 255) >>>  4) & 4194303);
      out[22 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[60 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[61 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[62 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[63 + inPos]) & 255) >>>  6) & 4194303);
      out[23 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[63 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[64 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[65 + inPos]) & 255) ) & 4194303);
      out[24 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[66 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[67 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[68 + inPos]) & 255) >>>  2) & 4194303);
      out[25 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[68 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[69 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[70 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[71 + inPos]) & 255) >>>  4) & 4194303);
      out[26 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[71 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[72 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[73 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[74 + inPos]) & 255) >>>  6) & 4194303);
      out[27 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[74 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[75 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[76 + inPos]) & 255) ) & 4194303);
      out[28 + outPos] =
          //                                [76543210]
          //                                [10987654______________]
            (((((int)in[77 + inPos]) & 255) <<  14) & 4194303)
        | //                                [76543210]
          //                        [________32109876______]
            (((((int)in[78 + inPos]) & 255) <<  6) & 4194303)
        | //                                [765432__]
          //                [________________543210]
            (((((int)in[79 + inPos]) & 255) >>>  2) & 4194303);
      out[29 + outPos] =
          //                                [______10]
          //                                      [10____________________]
            (((((int)in[79 + inPos]) & 255) <<  20) & 4194303)
        | //                                [76543210]
          //                              [__98765432____________]
            (((((int)in[80 + inPos]) & 255) <<  12) & 4194303)
        | //                                [76543210]
          //                      [__________10987654____]
            (((((int)in[81 + inPos]) & 255) <<  4) & 4194303)
        | //                                [7654____]
          //              [__________________3210]
            (((((int)in[82 + inPos]) & 255) >>>  4) & 4194303);
      out[30 + outPos] =
          //                                [____3210]
          //                                    [1098__________________]
            (((((int)in[82 + inPos]) & 255) <<  18) & 4194303)
        | //                                [76543210]
          //                            [____76543210__________]
            (((((int)in[83 + inPos]) & 255) <<  10) & 4194303)
        | //                                [76543210]
          //                    [____________98765432__]
            (((((int)in[84 + inPos]) & 255) <<  2) & 4194303)
        | //                                [76______]
          //            [____________________10]
            (((((int)in[85 + inPos]) & 255) >>>  6) & 4194303);
      out[31 + outPos] =
          //                                [__543210]
          //                                  [109876________________]
            (((((int)in[85 + inPos]) & 255) <<  16) & 4194303)
        | //                                [76543210]
          //                          [______54321098________]
            (((((int)in[86 + inPos]) & 255) <<  8) & 4194303)
        | //                                [76543210]
          //                  [______________76543210]
            (((((int)in[87 + inPos]) & 255) ) & 4194303);
    }
  }

  private static final class Packer23 extends BytePacker {

    private Packer23() {
      super(23);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 0 + inPos] & 8388607) >>> 15)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 0 + inPos] & 8388607) >>> 7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 0 + inPos] & 8388607) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 1 + inPos] & 8388607) >>> 22)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 1 + inPos] & 8388607) >>> 14)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 1 + inPos] & 8388607) >>> 6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 1 + inPos] & 8388607) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[ 2 + inPos] & 8388607) >>> 21)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 2 + inPos] & 8388607) >>> 13)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 2 + inPos] & 8388607) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[ 2 + inPos] & 8388607) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[ 3 + inPos] & 8388607) >>> 20)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 3 + inPos] & 8388607) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 3 + inPos] & 8388607) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[ 3 + inPos] & 8388607) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 4 + inPos] & 8388607) >>> 19)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 4 + inPos] & 8388607) >>> 11)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 4 + inPos] & 8388607) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[ 4 + inPos] & 8388607) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 5 + inPos] & 8388607) >>> 18)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 5 + inPos] & 8388607) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 5 + inPos] & 8388607) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[ 5 + inPos] & 8388607) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 6 + inPos] & 8388607) >>> 17)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 6 + inPos] & 8388607) >>> 9)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 6 + inPos] & 8388607) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[ 6 + inPos] & 8388607) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 7 + inPos] & 8388607) >>> 16)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 7 + inPos] & 8388607) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 7 + inPos] & 8388607))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 0 + inPos] & 8388607) >>> 15)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 0 + inPos] & 8388607) >>> 7)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 0 + inPos] & 8388607) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 1 + inPos] & 8388607) >>> 22)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 1 + inPos] & 8388607) >>> 14)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 1 + inPos] & 8388607) >>> 6)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 1 + inPos] & 8388607) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[ 2 + inPos] & 8388607) >>> 21)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[ 2 + inPos] & 8388607) >>> 13)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[ 2 + inPos] & 8388607) >>> 5)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[ 2 + inPos] & 8388607) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[ 3 + inPos] & 8388607) >>> 20)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[ 3 + inPos] & 8388607) >>> 12)) & 255);
      out[10 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[ 3 + inPos] & 8388607) >>> 4)) & 255);
      out[11 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[ 3 + inPos] & 8388607) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[ 4 + inPos] & 8388607) >>> 19)) & 255);
      out[12 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[ 4 + inPos] & 8388607) >>> 11)) & 255);
      out[13 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[ 4 + inPos] & 8388607) >>> 3)) & 255);
      out[14 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[ 4 + inPos] & 8388607) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[ 5 + inPos] & 8388607) >>> 18)) & 255);
      out[15 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[ 5 + inPos] & 8388607) >>> 10)) & 255);
      out[16 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[ 5 + inPos] & 8388607) >>> 2)) & 255);
      out[17 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[ 5 + inPos] & 8388607) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[ 6 + inPos] & 8388607) >>> 17)) & 255);
      out[18 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[ 6 + inPos] & 8388607) >>> 9)) & 255);
      out[19 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[ 6 + inPos] & 8388607) >>> 1)) & 255);
      out[20 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[ 6 + inPos] & 8388607) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[ 7 + inPos] & 8388607) >>> 16)) & 255);
      out[21 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[ 7 + inPos] & 8388607) >>> 8)) & 255);
      out[22 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[ 7 + inPos] & 8388607))) & 255);
      out[23 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[ 8 + inPos] & 8388607) >>> 15)) & 255);
      out[24 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[ 8 + inPos] & 8388607) >>> 7)) & 255);
      out[25 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[ 8 + inPos] & 8388607) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[ 9 + inPos] & 8388607) >>> 22)) & 255);
      out[26 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[ 9 + inPos] & 8388607) >>> 14)) & 255);
      out[27 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[ 9 + inPos] & 8388607) >>> 6)) & 255);
      out[28 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[ 9 + inPos] & 8388607) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[10 + inPos] & 8388607) >>> 21)) & 255);
      out[29 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[10 + inPos] & 8388607) >>> 13)) & 255);
      out[30 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[10 + inPos] & 8388607) >>> 5)) & 255);
      out[31 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[10 + inPos] & 8388607) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[11 + inPos] & 8388607) >>> 20)) & 255);
      out[32 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[11 + inPos] & 8388607) >>> 12)) & 255);
      out[33 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[11 + inPos] & 8388607) >>> 4)) & 255);
      out[34 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[11 + inPos] & 8388607) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[12 + inPos] & 8388607) >>> 19)) & 255);
      out[35 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[12 + inPos] & 8388607) >>> 11)) & 255);
      out[36 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[12 + inPos] & 8388607) >>> 3)) & 255);
      out[37 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[12 + inPos] & 8388607) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[13 + inPos] & 8388607) >>> 18)) & 255);
      out[38 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[13 + inPos] & 8388607) >>> 10)) & 255);
      out[39 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[13 + inPos] & 8388607) >>> 2)) & 255);
      out[40 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[13 + inPos] & 8388607) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[14 + inPos] & 8388607) >>> 17)) & 255);
      out[41 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[14 + inPos] & 8388607) >>> 9)) & 255);
      out[42 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[14 + inPos] & 8388607) >>> 1)) & 255);
      out[43 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[14 + inPos] & 8388607) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[15 + inPos] & 8388607) >>> 16)) & 255);
      out[44 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[15 + inPos] & 8388607) >>> 8)) & 255);
      out[45 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[15 + inPos] & 8388607))) & 255);
      out[46 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[16 + inPos] & 8388607) >>> 15)) & 255);
      out[47 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[16 + inPos] & 8388607) >>> 7)) & 255);
      out[48 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[16 + inPos] & 8388607) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[17 + inPos] & 8388607) >>> 22)) & 255);
      out[49 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[17 + inPos] & 8388607) >>> 14)) & 255);
      out[50 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[17 + inPos] & 8388607) >>> 6)) & 255);
      out[51 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[17 + inPos] & 8388607) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[18 + inPos] & 8388607) >>> 21)) & 255);
      out[52 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[18 + inPos] & 8388607) >>> 13)) & 255);
      out[53 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[18 + inPos] & 8388607) >>> 5)) & 255);
      out[54 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[18 + inPos] & 8388607) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[19 + inPos] & 8388607) >>> 20)) & 255);
      out[55 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[19 + inPos] & 8388607) >>> 12)) & 255);
      out[56 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[19 + inPos] & 8388607) >>> 4)) & 255);
      out[57 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[19 + inPos] & 8388607) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[20 + inPos] & 8388607) >>> 19)) & 255);
      out[58 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[20 + inPos] & 8388607) >>> 11)) & 255);
      out[59 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[20 + inPos] & 8388607) >>> 3)) & 255);
      out[60 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[20 + inPos] & 8388607) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[21 + inPos] & 8388607) >>> 18)) & 255);
      out[61 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[21 + inPos] & 8388607) >>> 10)) & 255);
      out[62 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[21 + inPos] & 8388607) >>> 2)) & 255);
      out[63 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[21 + inPos] & 8388607) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[22 + inPos] & 8388607) >>> 17)) & 255);
      out[64 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[22 + inPos] & 8388607) >>> 9)) & 255);
      out[65 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[22 + inPos] & 8388607) >>> 1)) & 255);
      out[66 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[22 + inPos] & 8388607) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[23 + inPos] & 8388607) >>> 16)) & 255);
      out[67 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[23 + inPos] & 8388607) >>> 8)) & 255);
      out[68 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[23 + inPos] & 8388607))) & 255);
      out[69 + outPos] = (byte)((
          //                                 [76543210]
          //                                 [21098765_______________]
           ((in[24 + inPos] & 8388607) >>> 15)) & 255);
      out[70 + outPos] = (byte)((
          //                                 [76543210]
          //                         [________43210987_______]
           ((in[24 + inPos] & 8388607) >>> 7)) & 255);
      out[71 + outPos] = (byte)((
          //                                 [7654321_]
          //                 [________________6543210]
           ((in[24 + inPos] & 8388607) <<  1)
        | //                                 [_______0]
          //                                        [2______________________]
           ((in[25 + inPos] & 8388607) >>> 22)) & 255);
      out[72 + outPos] = (byte)((
          //                                 [76543210]
          //                                [_10987654______________]
           ((in[25 + inPos] & 8388607) >>> 14)) & 255);
      out[73 + outPos] = (byte)((
          //                                 [76543210]
          //                        [_________32109876______]
           ((in[25 + inPos] & 8388607) >>> 6)) & 255);
      out[74 + outPos] = (byte)((
          //                                 [765432__]
          //                [_________________543210]
           ((in[25 + inPos] & 8388607) <<  2)
        | //                                 [______10]
          //                                       [21_____________________]
           ((in[26 + inPos] & 8388607) >>> 21)) & 255);
      out[75 + outPos] = (byte)((
          //                                 [76543210]
          //                               [__09876543_____________]
           ((in[26 + inPos] & 8388607) >>> 13)) & 255);
      out[76 + outPos] = (byte)((
          //                                 [76543210]
          //                       [__________21098765_____]
           ((in[26 + inPos] & 8388607) >>> 5)) & 255);
      out[77 + outPos] = (byte)((
          //                                 [76543___]
          //               [__________________43210]
           ((in[26 + inPos] & 8388607) <<  3)
        | //                                 [_____210]
          //                                      [210____________________]
           ((in[27 + inPos] & 8388607) >>> 20)) & 255);
      out[78 + outPos] = (byte)((
          //                                 [76543210]
          //                              [___98765432____________]
           ((in[27 + inPos] & 8388607) >>> 12)) & 255);
      out[79 + outPos] = (byte)((
          //                                 [76543210]
          //                      [___________10987654____]
           ((in[27 + inPos] & 8388607) >>> 4)) & 255);
      out[80 + outPos] = (byte)((
          //                                 [7654____]
          //              [___________________3210]
           ((in[27 + inPos] & 8388607) <<  4)
        | //                                 [____3210]
          //                                     [2109___________________]
           ((in[28 + inPos] & 8388607) >>> 19)) & 255);
      out[81 + outPos] = (byte)((
          //                                 [76543210]
          //                             [____87654321___________]
           ((in[28 + inPos] & 8388607) >>> 11)) & 255);
      out[82 + outPos] = (byte)((
          //                                 [76543210]
          //                     [____________09876543___]
           ((in[28 + inPos] & 8388607) >>> 3)) & 255);
      out[83 + outPos] = (byte)((
          //                                 [765_____]
          //             [____________________210]
           ((in[28 + inPos] & 8388607) <<  5)
        | //                                 [___43210]
          //                                    [21098__________________]
           ((in[29 + inPos] & 8388607) >>> 18)) & 255);
      out[84 + outPos] = (byte)((
          //                                 [76543210]
          //                            [_____76543210__________]
           ((in[29 + inPos] & 8388607) >>> 10)) & 255);
      out[85 + outPos] = (byte)((
          //                                 [76543210]
          //                    [_____________98765432__]
           ((in[29 + inPos] & 8388607) >>> 2)) & 255);
      out[86 + outPos] = (byte)((
          //                                 [76______]
          //            [_____________________10]
           ((in[29 + inPos] & 8388607) <<  6)
        | //                                 [__543210]
          //                                   [210987_________________]
           ((in[30 + inPos] & 8388607) >>> 17)) & 255);
      out[87 + outPos] = (byte)((
          //                                 [76543210]
          //                           [______65432109_________]
           ((in[30 + inPos] & 8388607) >>> 9)) & 255);
      out[88 + outPos] = (byte)((
          //                                 [76543210]
          //                   [______________87654321_]
           ((in[30 + inPos] & 8388607) >>> 1)) & 255);
      out[89 + outPos] = (byte)((
          //                                 [7_______]
          //           [______________________0]
           ((in[30 + inPos] & 8388607) <<  7)
        | //                                 [_6543210]
          //                                  [2109876________________]
           ((in[31 + inPos] & 8388607) >>> 16)) & 255);
      out[90 + outPos] = (byte)((
          //                                 [76543210]
          //                          [_______54321098________]
           ((in[31 + inPos] & 8388607) >>> 8)) & 255);
      out[91 + outPos] = (byte)((
          //                                 [76543210]
          //                  [_______________76543210]
           ((in[31 + inPos] & 8388607))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            (((((int)in[ 0 + inPos]) & 255) <<  15) & 8388607)
        | //                                 [76543210]
          //                         [________43210987_______]
            (((((int)in[ 1 + inPos]) & 255) <<  7) & 8388607)
        | //                                 [7654321_]
          //                 [________________6543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  1) & 8388607);
      out[ 1 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            (((((int)in[ 2 + inPos]) & 255) <<  22) & 8388607)
        | //                                 [76543210]
          //                                [_10987654______________]
            (((((int)in[ 3 + inPos]) & 255) <<  14) & 8388607)
        | //                                 [76543210]
          //                        [_________32109876______]
            (((((int)in[ 4 + inPos]) & 255) <<  6) & 8388607)
        | //                                 [765432__]
          //                [_________________543210]
            (((((int)in[ 5 + inPos]) & 255) >>>  2) & 8388607);
      out[ 2 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            (((((int)in[ 5 + inPos]) & 255) <<  21) & 8388607)
        | //                                 [76543210]
          //                               [__09876543_____________]
            (((((int)in[ 6 + inPos]) & 255) <<  13) & 8388607)
        | //                                 [76543210]
          //                       [__________21098765_____]
            (((((int)in[ 7 + inPos]) & 255) <<  5) & 8388607)
        | //                                 [76543___]
          //               [__________________43210]
            (((((int)in[ 8 + inPos]) & 255) >>>  3) & 8388607);
      out[ 3 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            (((((int)in[ 8 + inPos]) & 255) <<  20) & 8388607)
        | //                                 [76543210]
          //                              [___98765432____________]
            (((((int)in[ 9 + inPos]) & 255) <<  12) & 8388607)
        | //                                 [76543210]
          //                      [___________10987654____]
            (((((int)in[10 + inPos]) & 255) <<  4) & 8388607)
        | //                                 [7654____]
          //              [___________________3210]
            (((((int)in[11 + inPos]) & 255) >>>  4) & 8388607);
      out[ 4 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            (((((int)in[11 + inPos]) & 255) <<  19) & 8388607)
        | //                                 [76543210]
          //                             [____87654321___________]
            (((((int)in[12 + inPos]) & 255) <<  11) & 8388607)
        | //                                 [76543210]
          //                     [____________09876543___]
            (((((int)in[13 + inPos]) & 255) <<  3) & 8388607)
        | //                                 [765_____]
          //             [____________________210]
            (((((int)in[14 + inPos]) & 255) >>>  5) & 8388607);
      out[ 5 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            (((((int)in[14 + inPos]) & 255) <<  18) & 8388607)
        | //                                 [76543210]
          //                            [_____76543210__________]
            (((((int)in[15 + inPos]) & 255) <<  10) & 8388607)
        | //                                 [76543210]
          //                    [_____________98765432__]
            (((((int)in[16 + inPos]) & 255) <<  2) & 8388607)
        | //                                 [76______]
          //            [_____________________10]
            (((((int)in[17 + inPos]) & 255) >>>  6) & 8388607);
      out[ 6 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            (((((int)in[17 + inPos]) & 255) <<  17) & 8388607)
        | //                                 [76543210]
          //                           [______65432109_________]
            (((((int)in[18 + inPos]) & 255) <<  9) & 8388607)
        | //                                 [76543210]
          //                   [______________87654321_]
            (((((int)in[19 + inPos]) & 255) <<  1) & 8388607)
        | //                                 [7_______]
          //           [______________________0]
            (((((int)in[20 + inPos]) & 255) >>>  7) & 8388607);
      out[ 7 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            (((((int)in[20 + inPos]) & 255) <<  16) & 8388607)
        | //                                 [76543210]
          //                          [_______54321098________]
            (((((int)in[21 + inPos]) & 255) <<  8) & 8388607)
        | //                                 [76543210]
          //                  [_______________76543210]
            (((((int)in[22 + inPos]) & 255) ) & 8388607);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            (((((int)in[ 0 + inPos]) & 255) <<  15) & 8388607)
        | //                                 [76543210]
          //                         [________43210987_______]
            (((((int)in[ 1 + inPos]) & 255) <<  7) & 8388607)
        | //                                 [7654321_]
          //                 [________________6543210]
            (((((int)in[ 2 + inPos]) & 255) >>>  1) & 8388607);
      out[ 1 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            (((((int)in[ 2 + inPos]) & 255) <<  22) & 8388607)
        | //                                 [76543210]
          //                                [_10987654______________]
            (((((int)in[ 3 + inPos]) & 255) <<  14) & 8388607)
        | //                                 [76543210]
          //                        [_________32109876______]
            (((((int)in[ 4 + inPos]) & 255) <<  6) & 8388607)
        | //                                 [765432__]
          //                [_________________543210]
            (((((int)in[ 5 + inPos]) & 255) >>>  2) & 8388607);
      out[ 2 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            (((((int)in[ 5 + inPos]) & 255) <<  21) & 8388607)
        | //                                 [76543210]
          //                               [__09876543_____________]
            (((((int)in[ 6 + inPos]) & 255) <<  13) & 8388607)
        | //                                 [76543210]
          //                       [__________21098765_____]
            (((((int)in[ 7 + inPos]) & 255) <<  5) & 8388607)
        | //                                 [76543___]
          //               [__________________43210]
            (((((int)in[ 8 + inPos]) & 255) >>>  3) & 8388607);
      out[ 3 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            (((((int)in[ 8 + inPos]) & 255) <<  20) & 8388607)
        | //                                 [76543210]
          //                              [___98765432____________]
            (((((int)in[ 9 + inPos]) & 255) <<  12) & 8388607)
        | //                                 [76543210]
          //                      [___________10987654____]
            (((((int)in[10 + inPos]) & 255) <<  4) & 8388607)
        | //                                 [7654____]
          //              [___________________3210]
            (((((int)in[11 + inPos]) & 255) >>>  4) & 8388607);
      out[ 4 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            (((((int)in[11 + inPos]) & 255) <<  19) & 8388607)
        | //                                 [76543210]
          //                             [____87654321___________]
            (((((int)in[12 + inPos]) & 255) <<  11) & 8388607)
        | //                                 [76543210]
          //                     [____________09876543___]
            (((((int)in[13 + inPos]) & 255) <<  3) & 8388607)
        | //                                 [765_____]
          //             [____________________210]
            (((((int)in[14 + inPos]) & 255) >>>  5) & 8388607);
      out[ 5 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            (((((int)in[14 + inPos]) & 255) <<  18) & 8388607)
        | //                                 [76543210]
          //                            [_____76543210__________]
            (((((int)in[15 + inPos]) & 255) <<  10) & 8388607)
        | //                                 [76543210]
          //                    [_____________98765432__]
            (((((int)in[16 + inPos]) & 255) <<  2) & 8388607)
        | //                                 [76______]
          //            [_____________________10]
            (((((int)in[17 + inPos]) & 255) >>>  6) & 8388607);
      out[ 6 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            (((((int)in[17 + inPos]) & 255) <<  17) & 8388607)
        | //                                 [76543210]
          //                           [______65432109_________]
            (((((int)in[18 + inPos]) & 255) <<  9) & 8388607)
        | //                                 [76543210]
          //                   [______________87654321_]
            (((((int)in[19 + inPos]) & 255) <<  1) & 8388607)
        | //                                 [7_______]
          //           [______________________0]
            (((((int)in[20 + inPos]) & 255) >>>  7) & 8388607);
      out[ 7 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            (((((int)in[20 + inPos]) & 255) <<  16) & 8388607)
        | //                                 [76543210]
          //                          [_______54321098________]
            (((((int)in[21 + inPos]) & 255) <<  8) & 8388607)
        | //                                 [76543210]
          //                  [_______________76543210]
            (((((int)in[22 + inPos]) & 255) ) & 8388607);
      out[ 8 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            (((((int)in[23 + inPos]) & 255) <<  15) & 8388607)
        | //                                 [76543210]
          //                         [________43210987_______]
            (((((int)in[24 + inPos]) & 255) <<  7) & 8388607)
        | //                                 [7654321_]
          //                 [________________6543210]
            (((((int)in[25 + inPos]) & 255) >>>  1) & 8388607);
      out[ 9 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            (((((int)in[25 + inPos]) & 255) <<  22) & 8388607)
        | //                                 [76543210]
          //                                [_10987654______________]
            (((((int)in[26 + inPos]) & 255) <<  14) & 8388607)
        | //                                 [76543210]
          //                        [_________32109876______]
            (((((int)in[27 + inPos]) & 255) <<  6) & 8388607)
        | //                                 [765432__]
          //                [_________________543210]
            (((((int)in[28 + inPos]) & 255) >>>  2) & 8388607);
      out[10 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            (((((int)in[28 + inPos]) & 255) <<  21) & 8388607)
        | //                                 [76543210]
          //                               [__09876543_____________]
            (((((int)in[29 + inPos]) & 255) <<  13) & 8388607)
        | //                                 [76543210]
          //                       [__________21098765_____]
            (((((int)in[30 + inPos]) & 255) <<  5) & 8388607)
        | //                                 [76543___]
          //               [__________________43210]
            (((((int)in[31 + inPos]) & 255) >>>  3) & 8388607);
      out[11 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            (((((int)in[31 + inPos]) & 255) <<  20) & 8388607)
        | //                                 [76543210]
          //                              [___98765432____________]
            (((((int)in[32 + inPos]) & 255) <<  12) & 8388607)
        | //                                 [76543210]
          //                      [___________10987654____]
            (((((int)in[33 + inPos]) & 255) <<  4) & 8388607)
        | //                                 [7654____]
          //              [___________________3210]
            (((((int)in[34 + inPos]) & 255) >>>  4) & 8388607);
      out[12 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            (((((int)in[34 + inPos]) & 255) <<  19) & 8388607)
        | //                                 [76543210]
          //                             [____87654321___________]
            (((((int)in[35 + inPos]) & 255) <<  11) & 8388607)
        | //                                 [76543210]
          //                     [____________09876543___]
            (((((int)in[36 + inPos]) & 255) <<  3) & 8388607)
        | //                                 [765_____]
          //             [____________________210]
            (((((int)in[37 + inPos]) & 255) >>>  5) & 8388607);
      out[13 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            (((((int)in[37 + inPos]) & 255) <<  18) & 8388607)
        | //                                 [76543210]
          //                            [_____76543210__________]
            (((((int)in[38 + inPos]) & 255) <<  10) & 8388607)
        | //                                 [76543210]
          //                    [_____________98765432__]
            (((((int)in[39 + inPos]) & 255) <<  2) & 8388607)
        | //                                 [76______]
          //            [_____________________10]
            (((((int)in[40 + inPos]) & 255) >>>  6) & 8388607);
      out[14 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            (((((int)in[40 + inPos]) & 255) <<  17) & 8388607)
        | //                                 [76543210]
          //                           [______65432109_________]
            (((((int)in[41 + inPos]) & 255) <<  9) & 8388607)
        | //                                 [76543210]
          //                   [______________87654321_]
            (((((int)in[42 + inPos]) & 255) <<  1) & 8388607)
        | //                                 [7_______]
          //           [______________________0]
            (((((int)in[43 + inPos]) & 255) >>>  7) & 8388607);
      out[15 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            (((((int)in[43 + inPos]) & 255) <<  16) & 8388607)
        | //                                 [76543210]
          //                          [_______54321098________]
            (((((int)in[44 + inPos]) & 255) <<  8) & 8388607)
        | //                                 [76543210]
          //                  [_______________76543210]
            (((((int)in[45 + inPos]) & 255) ) & 8388607);
      out[16 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            (((((int)in[46 + inPos]) & 255) <<  15) & 8388607)
        | //                                 [76543210]
          //                         [________43210987_______]
            (((((int)in[47 + inPos]) & 255) <<  7) & 8388607)
        | //                                 [7654321_]
          //                 [________________6543210]
            (((((int)in[48 + inPos]) & 255) >>>  1) & 8388607);
      out[17 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            (((((int)in[48 + inPos]) & 255) <<  22) & 8388607)
        | //                                 [76543210]
          //                                [_10987654______________]
            (((((int)in[49 + inPos]) & 255) <<  14) & 8388607)
        | //                                 [76543210]
          //                        [_________32109876______]
            (((((int)in[50 + inPos]) & 255) <<  6) & 8388607)
        | //                                 [765432__]
          //                [_________________543210]
            (((((int)in[51 + inPos]) & 255) >>>  2) & 8388607);
      out[18 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            (((((int)in[51 + inPos]) & 255) <<  21) & 8388607)
        | //                                 [76543210]
          //                               [__09876543_____________]
            (((((int)in[52 + inPos]) & 255) <<  13) & 8388607)
        | //                                 [76543210]
          //                       [__________21098765_____]
            (((((int)in[53 + inPos]) & 255) <<  5) & 8388607)
        | //                                 [76543___]
          //               [__________________43210]
            (((((int)in[54 + inPos]) & 255) >>>  3) & 8388607);
      out[19 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            (((((int)in[54 + inPos]) & 255) <<  20) & 8388607)
        | //                                 [76543210]
          //                              [___98765432____________]
            (((((int)in[55 + inPos]) & 255) <<  12) & 8388607)
        | //                                 [76543210]
          //                      [___________10987654____]
            (((((int)in[56 + inPos]) & 255) <<  4) & 8388607)
        | //                                 [7654____]
          //              [___________________3210]
            (((((int)in[57 + inPos]) & 255) >>>  4) & 8388607);
      out[20 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            (((((int)in[57 + inPos]) & 255) <<  19) & 8388607)
        | //                                 [76543210]
          //                             [____87654321___________]
            (((((int)in[58 + inPos]) & 255) <<  11) & 8388607)
        | //                                 [76543210]
          //                     [____________09876543___]
            (((((int)in[59 + inPos]) & 255) <<  3) & 8388607)
        | //                                 [765_____]
          //             [____________________210]
            (((((int)in[60 + inPos]) & 255) >>>  5) & 8388607);
      out[21 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            (((((int)in[60 + inPos]) & 255) <<  18) & 8388607)
        | //                                 [76543210]
          //                            [_____76543210__________]
            (((((int)in[61 + inPos]) & 255) <<  10) & 8388607)
        | //                                 [76543210]
          //                    [_____________98765432__]
            (((((int)in[62 + inPos]) & 255) <<  2) & 8388607)
        | //                                 [76______]
          //            [_____________________10]
            (((((int)in[63 + inPos]) & 255) >>>  6) & 8388607);
      out[22 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            (((((int)in[63 + inPos]) & 255) <<  17) & 8388607)
        | //                                 [76543210]
          //                           [______65432109_________]
            (((((int)in[64 + inPos]) & 255) <<  9) & 8388607)
        | //                                 [76543210]
          //                   [______________87654321_]
            (((((int)in[65 + inPos]) & 255) <<  1) & 8388607)
        | //                                 [7_______]
          //           [______________________0]
            (((((int)in[66 + inPos]) & 255) >>>  7) & 8388607);
      out[23 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            (((((int)in[66 + inPos]) & 255) <<  16) & 8388607)
        | //                                 [76543210]
          //                          [_______54321098________]
            (((((int)in[67 + inPos]) & 255) <<  8) & 8388607)
        | //                                 [76543210]
          //                  [_______________76543210]
            (((((int)in[68 + inPos]) & 255) ) & 8388607);
      out[24 + outPos] =
          //                                 [76543210]
          //                                 [21098765_______________]
            (((((int)in[69 + inPos]) & 255) <<  15) & 8388607)
        | //                                 [76543210]
          //                         [________43210987_______]
            (((((int)in[70 + inPos]) & 255) <<  7) & 8388607)
        | //                                 [7654321_]
          //                 [________________6543210]
            (((((int)in[71 + inPos]) & 255) >>>  1) & 8388607);
      out[25 + outPos] =
          //                                 [_______0]
          //                                        [2______________________]
            (((((int)in[71 + inPos]) & 255) <<  22) & 8388607)
        | //                                 [76543210]
          //                                [_10987654______________]
            (((((int)in[72 + inPos]) & 255) <<  14) & 8388607)
        | //                                 [76543210]
          //                        [_________32109876______]
            (((((int)in[73 + inPos]) & 255) <<  6) & 8388607)
        | //                                 [765432__]
          //                [_________________543210]
            (((((int)in[74 + inPos]) & 255) >>>  2) & 8388607);
      out[26 + outPos] =
          //                                 [______10]
          //                                       [21_____________________]
            (((((int)in[74 + inPos]) & 255) <<  21) & 8388607)
        | //                                 [76543210]
          //                               [__09876543_____________]
            (((((int)in[75 + inPos]) & 255) <<  13) & 8388607)
        | //                                 [76543210]
          //                       [__________21098765_____]
            (((((int)in[76 + inPos]) & 255) <<  5) & 8388607)
        | //                                 [76543___]
          //               [__________________43210]
            (((((int)in[77 + inPos]) & 255) >>>  3) & 8388607);
      out[27 + outPos] =
          //                                 [_____210]
          //                                      [210____________________]
            (((((int)in[77 + inPos]) & 255) <<  20) & 8388607)
        | //                                 [76543210]
          //                              [___98765432____________]
            (((((int)in[78 + inPos]) & 255) <<  12) & 8388607)
        | //                                 [76543210]
          //                      [___________10987654____]
            (((((int)in[79 + inPos]) & 255) <<  4) & 8388607)
        | //                                 [7654____]
          //              [___________________3210]
            (((((int)in[80 + inPos]) & 255) >>>  4) & 8388607);
      out[28 + outPos] =
          //                                 [____3210]
          //                                     [2109___________________]
            (((((int)in[80 + inPos]) & 255) <<  19) & 8388607)
        | //                                 [76543210]
          //                             [____87654321___________]
            (((((int)in[81 + inPos]) & 255) <<  11) & 8388607)
        | //                                 [76543210]
          //                     [____________09876543___]
            (((((int)in[82 + inPos]) & 255) <<  3) & 8388607)
        | //                                 [765_____]
          //             [____________________210]
            (((((int)in[83 + inPos]) & 255) >>>  5) & 8388607);
      out[29 + outPos] =
          //                                 [___43210]
          //                                    [21098__________________]
            (((((int)in[83 + inPos]) & 255) <<  18) & 8388607)
        | //                                 [76543210]
          //                            [_____76543210__________]
            (((((int)in[84 + inPos]) & 255) <<  10) & 8388607)
        | //                                 [76543210]
          //                    [_____________98765432__]
            (((((int)in[85 + inPos]) & 255) <<  2) & 8388607)
        | //                                 [76______]
          //            [_____________________10]
            (((((int)in[86 + inPos]) & 255) >>>  6) & 8388607);
      out[30 + outPos] =
          //                                 [__543210]
          //                                   [210987_________________]
            (((((int)in[86 + inPos]) & 255) <<  17) & 8388607)
        | //                                 [76543210]
          //                           [______65432109_________]
            (((((int)in[87 + inPos]) & 255) <<  9) & 8388607)
        | //                                 [76543210]
          //                   [______________87654321_]
            (((((int)in[88 + inPos]) & 255) <<  1) & 8388607)
        | //                                 [7_______]
          //           [______________________0]
            (((((int)in[89 + inPos]) & 255) >>>  7) & 8388607);
      out[31 + outPos] =
          //                                 [_6543210]
          //                                  [2109876________________]
            (((((int)in[89 + inPos]) & 255) <<  16) & 8388607)
        | //                                 [76543210]
          //                          [_______54321098________]
            (((((int)in[90 + inPos]) & 255) <<  8) & 8388607)
        | //                                 [76543210]
          //                  [_______________76543210]
            (((((int)in[91 + inPos]) & 255) ) & 8388607);
    }
  }

  private static final class Packer24 extends BytePacker {

    private Packer24() {
      super(24);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 0 + inPos] & 16777215) >>> 16)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 0 + inPos] & 16777215) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 0 + inPos] & 16777215))) & 255);
      out[ 3 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 1 + inPos] & 16777215) >>> 16)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 1 + inPos] & 16777215) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 1 + inPos] & 16777215))) & 255);
      out[ 6 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 2 + inPos] & 16777215) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 2 + inPos] & 16777215) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 2 + inPos] & 16777215))) & 255);
      out[ 9 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 3 + inPos] & 16777215) >>> 16)) & 255);
      out[10 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 3 + inPos] & 16777215) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 3 + inPos] & 16777215))) & 255);
      out[12 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 4 + inPos] & 16777215) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 4 + inPos] & 16777215) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 4 + inPos] & 16777215))) & 255);
      out[15 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 5 + inPos] & 16777215) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 5 + inPos] & 16777215) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 5 + inPos] & 16777215))) & 255);
      out[18 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 6 + inPos] & 16777215) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 6 + inPos] & 16777215) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 6 + inPos] & 16777215))) & 255);
      out[21 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 7 + inPos] & 16777215) >>> 16)) & 255);
      out[22 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 7 + inPos] & 16777215) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 7 + inPos] & 16777215))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 0 + inPos] & 16777215) >>> 16)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 0 + inPos] & 16777215) >>> 8)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 0 + inPos] & 16777215))) & 255);
      out[ 3 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 1 + inPos] & 16777215) >>> 16)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 1 + inPos] & 16777215) >>> 8)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 1 + inPos] & 16777215))) & 255);
      out[ 6 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 2 + inPos] & 16777215) >>> 16)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 2 + inPos] & 16777215) >>> 8)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 2 + inPos] & 16777215))) & 255);
      out[ 9 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 3 + inPos] & 16777215) >>> 16)) & 255);
      out[10 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 3 + inPos] & 16777215) >>> 8)) & 255);
      out[11 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 3 + inPos] & 16777215))) & 255);
      out[12 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 4 + inPos] & 16777215) >>> 16)) & 255);
      out[13 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 4 + inPos] & 16777215) >>> 8)) & 255);
      out[14 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 4 + inPos] & 16777215))) & 255);
      out[15 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 5 + inPos] & 16777215) >>> 16)) & 255);
      out[16 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 5 + inPos] & 16777215) >>> 8)) & 255);
      out[17 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 5 + inPos] & 16777215))) & 255);
      out[18 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 6 + inPos] & 16777215) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 6 + inPos] & 16777215) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 6 + inPos] & 16777215))) & 255);
      out[21 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 7 + inPos] & 16777215) >>> 16)) & 255);
      out[22 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 7 + inPos] & 16777215) >>> 8)) & 255);
      out[23 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 7 + inPos] & 16777215))) & 255);
      out[24 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 8 + inPos] & 16777215) >>> 16)) & 255);
      out[25 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 8 + inPos] & 16777215) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 8 + inPos] & 16777215))) & 255);
      out[27 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[ 9 + inPos] & 16777215) >>> 16)) & 255);
      out[28 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[ 9 + inPos] & 16777215) >>> 8)) & 255);
      out[29 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[ 9 + inPos] & 16777215))) & 255);
      out[30 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[10 + inPos] & 16777215) >>> 16)) & 255);
      out[31 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[10 + inPos] & 16777215) >>> 8)) & 255);
      out[32 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[10 + inPos] & 16777215))) & 255);
      out[33 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[11 + inPos] & 16777215) >>> 16)) & 255);
      out[34 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[11 + inPos] & 16777215) >>> 8)) & 255);
      out[35 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[11 + inPos] & 16777215))) & 255);
      out[36 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[12 + inPos] & 16777215) >>> 16)) & 255);
      out[37 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[12 + inPos] & 16777215) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[12 + inPos] & 16777215))) & 255);
      out[39 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[13 + inPos] & 16777215) >>> 16)) & 255);
      out[40 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[13 + inPos] & 16777215) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[13 + inPos] & 16777215))) & 255);
      out[42 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[14 + inPos] & 16777215) >>> 16)) & 255);
      out[43 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[14 + inPos] & 16777215) >>> 8)) & 255);
      out[44 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[14 + inPos] & 16777215))) & 255);
      out[45 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[15 + inPos] & 16777215) >>> 16)) & 255);
      out[46 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[15 + inPos] & 16777215) >>> 8)) & 255);
      out[47 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[15 + inPos] & 16777215))) & 255);
      out[48 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[16 + inPos] & 16777215) >>> 16)) & 255);
      out[49 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[16 + inPos] & 16777215) >>> 8)) & 255);
      out[50 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[16 + inPos] & 16777215))) & 255);
      out[51 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[17 + inPos] & 16777215) >>> 16)) & 255);
      out[52 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[17 + inPos] & 16777215) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[17 + inPos] & 16777215))) & 255);
      out[54 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[18 + inPos] & 16777215) >>> 16)) & 255);
      out[55 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[18 + inPos] & 16777215) >>> 8)) & 255);
      out[56 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[18 + inPos] & 16777215))) & 255);
      out[57 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[19 + inPos] & 16777215) >>> 16)) & 255);
      out[58 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[19 + inPos] & 16777215) >>> 8)) & 255);
      out[59 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[19 + inPos] & 16777215))) & 255);
      out[60 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[20 + inPos] & 16777215) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[20 + inPos] & 16777215) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[20 + inPos] & 16777215))) & 255);
      out[63 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[21 + inPos] & 16777215) >>> 16)) & 255);
      out[64 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[21 + inPos] & 16777215) >>> 8)) & 255);
      out[65 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[21 + inPos] & 16777215))) & 255);
      out[66 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[22 + inPos] & 16777215) >>> 16)) & 255);
      out[67 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[22 + inPos] & 16777215) >>> 8)) & 255);
      out[68 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[22 + inPos] & 16777215))) & 255);
      out[69 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[23 + inPos] & 16777215) >>> 16)) & 255);
      out[70 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[23 + inPos] & 16777215) >>> 8)) & 255);
      out[71 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[23 + inPos] & 16777215))) & 255);
      out[72 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[24 + inPos] & 16777215) >>> 16)) & 255);
      out[73 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[24 + inPos] & 16777215) >>> 8)) & 255);
      out[74 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[24 + inPos] & 16777215))) & 255);
      out[75 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[25 + inPos] & 16777215) >>> 16)) & 255);
      out[76 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[25 + inPos] & 16777215) >>> 8)) & 255);
      out[77 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[25 + inPos] & 16777215))) & 255);
      out[78 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[26 + inPos] & 16777215) >>> 16)) & 255);
      out[79 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[26 + inPos] & 16777215) >>> 8)) & 255);
      out[80 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[26 + inPos] & 16777215))) & 255);
      out[81 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[27 + inPos] & 16777215) >>> 16)) & 255);
      out[82 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[27 + inPos] & 16777215) >>> 8)) & 255);
      out[83 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[27 + inPos] & 16777215))) & 255);
      out[84 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[28 + inPos] & 16777215) >>> 16)) & 255);
      out[85 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[28 + inPos] & 16777215) >>> 8)) & 255);
      out[86 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[28 + inPos] & 16777215))) & 255);
      out[87 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[29 + inPos] & 16777215) >>> 16)) & 255);
      out[88 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[29 + inPos] & 16777215) >>> 8)) & 255);
      out[89 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[29 + inPos] & 16777215))) & 255);
      out[90 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[30 + inPos] & 16777215) >>> 16)) & 255);
      out[91 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[30 + inPos] & 16777215) >>> 8)) & 255);
      out[92 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[30 + inPos] & 16777215))) & 255);
      out[93 + outPos] = (byte)((
          //                                  [76543210]
          //                                  [32109876________________]
           ((in[31 + inPos] & 16777215) >>> 16)) & 255);
      out[94 + outPos] = (byte)((
          //                                  [76543210]
          //                          [________54321098________]
           ((in[31 + inPos] & 16777215) >>> 8)) & 255);
      out[95 + outPos] = (byte)((
          //                                  [76543210]
          //                  [________________76543210]
           ((in[31 + inPos] & 16777215))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 0 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 1 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 16777215);
      out[ 1 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 3 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 16777215);
      out[ 2 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 6 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 16777215);
      out[ 3 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 9 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[11 + inPos]) & 255) ) & 16777215);
      out[ 4 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[12 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[14 + inPos]) & 255) ) & 16777215);
      out[ 5 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[15 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[17 + inPos]) & 255) ) & 16777215);
      out[ 6 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[18 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[20 + inPos]) & 255) ) & 16777215);
      out[ 7 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[21 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[22 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[23 + inPos]) & 255) ) & 16777215);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 0 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 1 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 2 + inPos]) & 255) ) & 16777215);
      out[ 1 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 3 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 4 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 5 + inPos]) & 255) ) & 16777215);
      out[ 2 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 6 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[ 7 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[ 8 + inPos]) & 255) ) & 16777215);
      out[ 3 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[ 9 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[10 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[11 + inPos]) & 255) ) & 16777215);
      out[ 4 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[12 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[13 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[14 + inPos]) & 255) ) & 16777215);
      out[ 5 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[15 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[16 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[17 + inPos]) & 255) ) & 16777215);
      out[ 6 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[18 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[20 + inPos]) & 255) ) & 16777215);
      out[ 7 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[21 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[22 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[23 + inPos]) & 255) ) & 16777215);
      out[ 8 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[24 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[26 + inPos]) & 255) ) & 16777215);
      out[ 9 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[27 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[28 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[29 + inPos]) & 255) ) & 16777215);
      out[10 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[30 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[31 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[32 + inPos]) & 255) ) & 16777215);
      out[11 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[33 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[34 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[35 + inPos]) & 255) ) & 16777215);
      out[12 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[36 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[37 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[38 + inPos]) & 255) ) & 16777215);
      out[13 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[39 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[40 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[41 + inPos]) & 255) ) & 16777215);
      out[14 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[42 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[43 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[44 + inPos]) & 255) ) & 16777215);
      out[15 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[45 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[46 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[47 + inPos]) & 255) ) & 16777215);
      out[16 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[48 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[49 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[50 + inPos]) & 255) ) & 16777215);
      out[17 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[51 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[52 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[53 + inPos]) & 255) ) & 16777215);
      out[18 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[54 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[55 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[56 + inPos]) & 255) ) & 16777215);
      out[19 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[57 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[58 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[59 + inPos]) & 255) ) & 16777215);
      out[20 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[60 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[61 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[62 + inPos]) & 255) ) & 16777215);
      out[21 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[63 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[64 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[65 + inPos]) & 255) ) & 16777215);
      out[22 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[66 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[67 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[68 + inPos]) & 255) ) & 16777215);
      out[23 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[69 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[70 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[71 + inPos]) & 255) ) & 16777215);
      out[24 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[72 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[73 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[74 + inPos]) & 255) ) & 16777215);
      out[25 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[75 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[76 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[77 + inPos]) & 255) ) & 16777215);
      out[26 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[78 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[79 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[80 + inPos]) & 255) ) & 16777215);
      out[27 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[81 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[82 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[83 + inPos]) & 255) ) & 16777215);
      out[28 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[84 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[85 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[86 + inPos]) & 255) ) & 16777215);
      out[29 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[87 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[88 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[89 + inPos]) & 255) ) & 16777215);
      out[30 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[90 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[91 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[92 + inPos]) & 255) ) & 16777215);
      out[31 + outPos] =
          //                                  [76543210]
          //                                  [32109876________________]
            (((((int)in[93 + inPos]) & 255) <<  16) & 16777215)
        | //                                  [76543210]
          //                          [________54321098________]
            (((((int)in[94 + inPos]) & 255) <<  8) & 16777215)
        | //                                  [76543210]
          //                  [________________76543210]
            (((((int)in[95 + inPos]) & 255) ) & 16777215);
    }
  }

  private static final class Packer25 extends BytePacker {

    private Packer25() {
      super(25);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                   [76543210]
          //                                   [43210987_________________]
           ((in[ 0 + inPos] & 33554431) >>> 17)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                   [76543210]
          //                           [________65432109_________]
           ((in[ 0 + inPos] & 33554431) >>> 9)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                   [76543210]
          //                   [________________87654321_]
           ((in[ 0 + inPos] & 33554431) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                   [7_______]
          //           [________________________0]
           ((in[ 0 + inPos] & 33554431) <<  7)
        | //                                   [_6543210]
          //                                    [4321098__________________]
           ((in[ 1 + inPos] & 33554431) >>> 18)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                   [76543210]
          //                            [_______76543210__________]
           ((in[ 1 + inPos] & 33554431) >>> 10)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                   [76543210]
          //                    [_______________98765432__]
           ((in[ 1 + inPos] & 33554431) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                   [76______]
          //            [_______________________10]
           ((in[ 1 + inPos] & 33554431) <<  6)
        | //                                   [__543210]
          //                                     [432109___________________]
           ((in[ 2 + inPos] & 33554431) >>> 19)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                   [76543210]
          //                             [______87654321___________]
           ((in[ 2 + inPos] & 33554431) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                   [76543210]
          //                     [______________09876543___]
           ((in[ 2 + inPos] & 33554431) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                   [765_____]
          //             [______________________210]
           ((in[ 2 + inPos] & 33554431) <<  5)
        | //                                   [___43210]
          //                                      [43210____________________]
           ((in[ 3 + inPos] & 33554431) >>> 20)) & 255);
      out[10 + outPos] = (byte)((
          //                                   [76543210]
          //                              [_____98765432____________]
           ((in[ 3 + inPos] & 33554431) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                                   [76543210]
          //                      [_____________10987654____]
           ((in[ 3 + inPos] & 33554431) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                                   [7654____]
          //              [_____________________3210]
           ((in[ 3 + inPos] & 33554431) <<  4)
        | //                                   [____3210]
          //                                       [4321_____________________]
           ((in[ 4 + inPos] & 33554431) >>> 21)) & 255);
      out[13 + outPos] = (byte)((
          //                                   [76543210]
          //                               [____09876543_____________]
           ((in[ 4 + inPos] & 33554431) >>> 13)) & 255);
      out[14 + outPos] = (byte)((
          //                                   [76543210]
          //                       [____________21098765_____]
           ((in[ 4 + inPos] & 33554431) >>> 5)) & 255);
      out[15 + outPos] = (byte)((
          //                                   [76543___]
          //               [____________________43210]
           ((in[ 4 + inPos] & 33554431) <<  3)
        | //                                   [_____210]
          //                                        [432______________________]
           ((in[ 5 + inPos] & 33554431) >>> 22)) & 255);
      out[16 + outPos] = (byte)((
          //                                   [76543210]
          //                                [___10987654______________]
           ((in[ 5 + inPos] & 33554431) >>> 14)) & 255);
      out[17 + outPos] = (byte)((
          //                                   [76543210]
          //                        [___________32109876______]
           ((in[ 5 + inPos] & 33554431) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                                   [765432__]
          //                [___________________543210]
           ((in[ 5 + inPos] & 33554431) <<  2)
        | //                                   [______10]
          //                                         [43_______________________]
           ((in[ 6 + inPos] & 33554431) >>> 23)) & 255);
      out[19 + outPos] = (byte)((
          //                                   [76543210]
          //                                 [__21098765_______________]
           ((in[ 6 + inPos] & 33554431) >>> 15)) & 255);
      out[20 + outPos] = (byte)((
          //                                   [76543210]
          //                         [__________43210987_______]
           ((in[ 6 + inPos] & 33554431) >>> 7)) & 255);
      out[21 + outPos] = (byte)((
          //                                   [7654321_]
          //                 [__________________6543210]
           ((in[ 6 + inPos] & 33554431) <<  1)
        | //                                   [_______0]
          //                                          [4________________________]
           ((in[ 7 + inPos] & 33554431) >>> 24)) & 255);
      out[22 + outPos] = (byte)((
          //                                   [76543210]
          //                                  [_32109876________________]
           ((in[ 7 + inPos] & 33554431) >>> 16)) & 255);
      out[23 + outPos] = (byte)((
          //                                   [76543210]
          //                          [_________54321098________]
           ((in[ 7 + inPos] & 33554431) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                                   [76543210]
          //                  [_________________76543210]
           ((in[ 7 + inPos] & 33554431))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                   [76543210]
          //                                   [43210987_________________]
           ((in[ 0 + inPos] & 33554431) >>> 17)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                   [76543210]
          //                           [________65432109_________]
           ((in[ 0 + inPos] & 33554431) >>> 9)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                   [76543210]
          //                   [________________87654321_]
           ((in[ 0 + inPos] & 33554431) >>> 1)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                   [7_______]
          //           [________________________0]
           ((in[ 0 + inPos] & 33554431) <<  7)
        | //                                   [_6543210]
          //                                    [4321098__________________]
           ((in[ 1 + inPos] & 33554431) >>> 18)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                   [76543210]
          //                            [_______76543210__________]
           ((in[ 1 + inPos] & 33554431) >>> 10)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                   [76543210]
          //                    [_______________98765432__]
           ((in[ 1 + inPos] & 33554431) >>> 2)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                   [76______]
          //            [_______________________10]
           ((in[ 1 + inPos] & 33554431) <<  6)
        | //                                   [__543210]
          //                                     [432109___________________]
           ((in[ 2 + inPos] & 33554431) >>> 19)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                   [76543210]
          //                             [______87654321___________]
           ((in[ 2 + inPos] & 33554431) >>> 11)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                   [76543210]
          //                     [______________09876543___]
           ((in[ 2 + inPos] & 33554431) >>> 3)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                   [765_____]
          //             [______________________210]
           ((in[ 2 + inPos] & 33554431) <<  5)
        | //                                   [___43210]
          //                                      [43210____________________]
           ((in[ 3 + inPos] & 33554431) >>> 20)) & 255);
      out[10 + outPos] = (byte)((
          //                                   [76543210]
          //                              [_____98765432____________]
           ((in[ 3 + inPos] & 33554431) >>> 12)) & 255);
      out[11 + outPos] = (byte)((
          //                                   [76543210]
          //                      [_____________10987654____]
           ((in[ 3 + inPos] & 33554431) >>> 4)) & 255);
      out[12 + outPos] = (byte)((
          //                                   [7654____]
          //              [_____________________3210]
           ((in[ 3 + inPos] & 33554431) <<  4)
        | //                                   [____3210]
          //                                       [4321_____________________]
           ((in[ 4 + inPos] & 33554431) >>> 21)) & 255);
      out[13 + outPos] = (byte)((
          //                                   [76543210]
          //                               [____09876543_____________]
           ((in[ 4 + inPos] & 33554431) >>> 13)) & 255);
      out[14 + outPos] = (byte)((
          //                                   [76543210]
          //                       [____________21098765_____]
           ((in[ 4 + inPos] & 33554431) >>> 5)) & 255);
      out[15 + outPos] = (byte)((
          //                                   [76543___]
          //               [____________________43210]
           ((in[ 4 + inPos] & 33554431) <<  3)
        | //                                   [_____210]
          //                                        [432______________________]
           ((in[ 5 + inPos] & 33554431) >>> 22)) & 255);
      out[16 + outPos] = (byte)((
          //                                   [76543210]
          //                                [___10987654______________]
           ((in[ 5 + inPos] & 33554431) >>> 14)) & 255);
      out[17 + outPos] = (byte)((
          //                                   [76543210]
          //                        [___________32109876______]
           ((in[ 5 + inPos] & 33554431) >>> 6)) & 255);
      out[18 + outPos] = (byte)((
          //                                   [765432__]
          //                [___________________543210]
           ((in[ 5 + inPos] & 33554431) <<  2)
        | //                                   [______10]
          //                                         [43_______________________]
           ((in[ 6 + inPos] & 33554431) >>> 23)) & 255);
      out[19 + outPos] = (byte)((
          //                                   [76543210]
          //                                 [__21098765_______________]
           ((in[ 6 + inPos] & 33554431) >>> 15)) & 255);
      out[20 + outPos] = (byte)((
          //                                   [76543210]
          //                         [__________43210987_______]
           ((in[ 6 + inPos] & 33554431) >>> 7)) & 255);
      out[21 + outPos] = (byte)((
          //                                   [7654321_]
          //                 [__________________6543210]
           ((in[ 6 + inPos] & 33554431) <<  1)
        | //                                   [_______0]
          //                                          [4________________________]
           ((in[ 7 + inPos] & 33554431) >>> 24)) & 255);
      out[22 + outPos] = (byte)((
          //                                   [76543210]
          //                                  [_32109876________________]
           ((in[ 7 + inPos] & 33554431) >>> 16)) & 255);
      out[23 + outPos] = (byte)((
          //                                   [76543210]
          //                          [_________54321098________]
           ((in[ 7 + inPos] & 33554431) >>> 8)) & 255);
      out[24 + outPos] = (byte)((
          //                                   [76543210]
          //                  [_________________76543210]
           ((in[ 7 + inPos] & 33554431))) & 255);
      out[25 + outPos] = (byte)((
          //                                   [76543210]
          //                                   [43210987_________________]
           ((in[ 8 + inPos] & 33554431) >>> 17)) & 255);
      out[26 + outPos] = (byte)((
          //                                   [76543210]
          //                           [________65432109_________]
           ((in[ 8 + inPos] & 33554431) >>> 9)) & 255);
      out[27 + outPos] = (byte)((
          //                                   [76543210]
          //                   [________________87654321_]
           ((in[ 8 + inPos] & 33554431) >>> 1)) & 255);
      out[28 + outPos] = (byte)((
          //                                   [7_______]
          //           [________________________0]
           ((in[ 8 + inPos] & 33554431) <<  7)
        | //                                   [_6543210]
          //                                    [4321098__________________]
           ((in[ 9 + inPos] & 33554431) >>> 18)) & 255);
      out[29 + outPos] = (byte)((
          //                                   [76543210]
          //                            [_______76543210__________]
           ((in[ 9 + inPos] & 33554431) >>> 10)) & 255);
      out[30 + outPos] = (byte)((
          //                                   [76543210]
          //                    [_______________98765432__]
           ((in[ 9 + inPos] & 33554431) >>> 2)) & 255);
      out[31 + outPos] = (byte)((
          //                                   [76______]
          //            [_______________________10]
           ((in[ 9 + inPos] & 33554431) <<  6)
        | //                                   [__543210]
          //                                     [432109___________________]
           ((in[10 + inPos] & 33554431) >>> 19)) & 255);
      out[32 + outPos] = (byte)((
          //                                   [76543210]
          //                             [______87654321___________]
           ((in[10 + inPos] & 33554431) >>> 11)) & 255);
      out[33 + outPos] = (byte)((
          //                                   [76543210]
          //                     [______________09876543___]
           ((in[10 + inPos] & 33554431) >>> 3)) & 255);
      out[34 + outPos] = (byte)((
          //                                   [765_____]
          //             [______________________210]
           ((in[10 + inPos] & 33554431) <<  5)
        | //                                   [___43210]
          //                                      [43210____________________]
           ((in[11 + inPos] & 33554431) >>> 20)) & 255);
      out[35 + outPos] = (byte)((
          //                                   [76543210]
          //                              [_____98765432____________]
           ((in[11 + inPos] & 33554431) >>> 12)) & 255);
      out[36 + outPos] = (byte)((
          //                                   [76543210]
          //                      [_____________10987654____]
           ((in[11 + inPos] & 33554431) >>> 4)) & 255);
      out[37 + outPos] = (byte)((
          //                                   [7654____]
          //              [_____________________3210]
           ((in[11 + inPos] & 33554431) <<  4)
        | //                                   [____3210]
          //                                       [4321_____________________]
           ((in[12 + inPos] & 33554431) >>> 21)) & 255);
      out[38 + outPos] = (byte)((
          //                                   [76543210]
          //                               [____09876543_____________]
           ((in[12 + inPos] & 33554431) >>> 13)) & 255);
      out[39 + outPos] = (byte)((
          //                                   [76543210]
          //                       [____________21098765_____]
           ((in[12 + inPos] & 33554431) >>> 5)) & 255);
      out[40 + outPos] = (byte)((
          //                                   [76543___]
          //               [____________________43210]
           ((in[12 + inPos] & 33554431) <<  3)
        | //                                   [_____210]
          //                                        [432______________________]
           ((in[13 + inPos] & 33554431) >>> 22)) & 255);
      out[41 + outPos] = (byte)((
          //                                   [76543210]
          //                                [___10987654______________]
           ((in[13 + inPos] & 33554431) >>> 14)) & 255);
      out[42 + outPos] = (byte)((
          //                                   [76543210]
          //                        [___________32109876______]
           ((in[13 + inPos] & 33554431) >>> 6)) & 255);
      out[43 + outPos] = (byte)((
          //                                   [765432__]
          //                [___________________543210]
           ((in[13 + inPos] & 33554431) <<  2)
        | //                                   [______10]
          //                                         [43_______________________]
           ((in[14 + inPos] & 33554431) >>> 23)) & 255);
      out[44 + outPos] = (byte)((
          //                                   [76543210]
          //                                 [__21098765_______________]
           ((in[14 + inPos] & 33554431) >>> 15)) & 255);
      out[45 + outPos] = (byte)((
          //                                   [76543210]
          //                         [__________43210987_______]
           ((in[14 + inPos] & 33554431) >>> 7)) & 255);
      out[46 + outPos] = (byte)((
          //                                   [7654321_]
          //                 [__________________6543210]
           ((in[14 + inPos] & 33554431) <<  1)
        | //                                   [_______0]
          //                                          [4________________________]
           ((in[15 + inPos] & 33554431) >>> 24)) & 255);
      out[47 + outPos] = (byte)((
          //                                   [76543210]
          //                                  [_32109876________________]
           ((in[15 + inPos] & 33554431) >>> 16)) & 255);
      out[48 + outPos] = (byte)((
          //                                   [76543210]
          //                          [_________54321098________]
           ((in[15 + inPos] & 33554431) >>> 8)) & 255);
      out[49 + outPos] = (byte)((
          //                                   [76543210]
          //                  [_________________76543210]
           ((in[15 + inPos] & 33554431))) & 255);
      out[50 + outPos] = (byte)((
          //                                   [76543210]
          //                                   [43210987_________________]
           ((in[16 + inPos] & 33554431) >>> 17)) & 255);
      out[51 + outPos] = (byte)((
          //                                   [76543210]
          //                           [________65432109_________]
           ((in[16 + inPos] & 33554431) >>> 9)) & 255);
      out[52 + outPos] = (byte)((
          //                                   [76543210]
          //                   [________________87654321_]
           ((in[16 + inPos] & 33554431) >>> 1)) & 255);
      out[53 + outPos] = (byte)((
          //                                   [7_______]
          //           [________________________0]
           ((in[16 + inPos] & 33554431) <<  7)
        | //                                   [_6543210]
          //                                    [4321098__________________]
           ((in[17 + inPos] & 33554431) >>> 18)) & 255);
      out[54 + outPos] = (byte)((
          //                                   [76543210]
          //                            [_______76543210__________]
           ((in[17 + inPos] & 33554431) >>> 10)) & 255);
      out[55 + outPos] = (byte)((
          //                                   [76543210]
          //                    [_______________98765432__]
           ((in[17 + inPos] & 33554431) >>> 2)) & 255);
      out[56 + outPos] = (byte)((
          //                                   [76______]
          //            [_______________________10]
           ((in[17 + inPos] & 33554431) <<  6)
        | //                                   [__543210]
          //                                     [432109___________________]
           ((in[18 + inPos] & 33554431) >>> 19)) & 255);
      out[57 + outPos] = (byte)((
          //                                   [76543210]
          //                             [______87654321___________]
           ((in[18 + inPos] & 33554431) >>> 11)) & 255);
      out[58 + outPos] = (byte)((
          //                                   [76543210]
          //                     [______________09876543___]
           ((in[18 + inPos] & 33554431) >>> 3)) & 255);
      out[59 + outPos] = (byte)((
          //                                   [765_____]
          //             [______________________210]
           ((in[18 + inPos] & 33554431) <<  5)
        | //                                   [___43210]
          //                                      [43210____________________]
           ((in[19 + inPos] & 33554431) >>> 20)) & 255);
      out[60 + outPos] = (byte)((
          //                                   [76543210]
          //                              [_____98765432____________]
           ((in[19 + inPos] & 33554431) >>> 12)) & 255);
      out[61 + outPos] = (byte)((
          //                                   [76543210]
          //                      [_____________10987654____]
           ((in[19 + inPos] & 33554431) >>> 4)) & 255);
      out[62 + outPos] = (byte)((
          //                                   [7654____]
          //              [_____________________3210]
           ((in[19 + inPos] & 33554431) <<  4)
        | //                                   [____3210]
          //                                       [4321_____________________]
           ((in[20 + inPos] & 33554431) >>> 21)) & 255);
      out[63 + outPos] = (byte)((
          //                                   [76543210]
          //                               [____09876543_____________]
           ((in[20 + inPos] & 33554431) >>> 13)) & 255);
      out[64 + outPos] = (byte)((
          //                                   [76543210]
          //                       [____________21098765_____]
           ((in[20 + inPos] & 33554431) >>> 5)) & 255);
      out[65 + outPos] = (byte)((
          //                                   [76543___]
          //               [____________________43210]
           ((in[20 + inPos] & 33554431) <<  3)
        | //                                   [_____210]
          //                                        [432______________________]
           ((in[21 + inPos] & 33554431) >>> 22)) & 255);
      out[66 + outPos] = (byte)((
          //                                   [76543210]
          //                                [___10987654______________]
           ((in[21 + inPos] & 33554431) >>> 14)) & 255);
      out[67 + outPos] = (byte)((
          //                                   [76543210]
          //                        [___________32109876______]
           ((in[21 + inPos] & 33554431) >>> 6)) & 255);
      out[68 + outPos] = (byte)((
          //                                   [765432__]
          //                [___________________543210]
           ((in[21 + inPos] & 33554431) <<  2)
        | //                                   [______10]
          //                                         [43_______________________]
           ((in[22 + inPos] & 33554431) >>> 23)) & 255);
      out[69 + outPos] = (byte)((
          //                                   [76543210]
          //                                 [__21098765_______________]
           ((in[22 + inPos] & 33554431) >>> 15)) & 255);
      out[70 + outPos] = (byte)((
          //                                   [76543210]
          //                         [__________43210987_______]
           ((in[22 + inPos] & 33554431) >>> 7)) & 255);
      out[71 + outPos] = (byte)((
          //                                   [7654321_]
          //                 [__________________6543210]
           ((in[22 + inPos] & 33554431) <<  1)
        | //                                   [_______0]
          //                                          [4________________________]
           ((in[23 + inPos] & 33554431) >>> 24)) & 255);
      out[72 + outPos] = (byte)((
          //                                   [76543210]
          //                                  [_32109876________________]
           ((in[23 + inPos] & 33554431) >>> 16)) & 255);
      out[73 + outPos] = (byte)((
          //                                   [76543210]
          //                          [_________54321098________]
           ((in[23 + inPos] & 33554431) >>> 8)) & 255);
      out[74 + outPos] = (byte)((
          //                                   [76543210]
          //                  [_________________76543210]
           ((in[23 + inPos] & 33554431))) & 255);
      out[75 + outPos] = (byte)((
          //                                   [76543210]
          //                                   [43210987_________________]
           ((in[24 + inPos] & 33554431) >>> 17)) & 255);
      out[76 + outPos] = (byte)((
          //                                   [76543210]
          //                           [________65432109_________]
           ((in[24 + inPos] & 33554431) >>> 9)) & 255);
      out[77 + outPos] = (byte)((
          //                                   [76543210]
          //                   [________________87654321_]
           ((in[24 + inPos] & 33554431) >>> 1)) & 255);
      out[78 + outPos] = (byte)((
          //                                   [7_______]
          //           [________________________0]
           ((in[24 + inPos] & 33554431) <<  7)
        | //                                   [_6543210]
          //                                    [4321098__________________]
           ((in[25 + inPos] & 33554431) >>> 18)) & 255);
      out[79 + outPos] = (byte)((
          //                                   [76543210]
          //                            [_______76543210__________]
           ((in[25 + inPos] & 33554431) >>> 10)) & 255);
      out[80 + outPos] = (byte)((
          //                                   [76543210]
          //                    [_______________98765432__]
           ((in[25 + inPos] & 33554431) >>> 2)) & 255);
      out[81 + outPos] = (byte)((
          //                                   [76______]
          //            [_______________________10]
           ((in[25 + inPos] & 33554431) <<  6)
        | //                                   [__543210]
          //                                     [432109___________________]
           ((in[26 + inPos] & 33554431) >>> 19)) & 255);
      out[82 + outPos] = (byte)((
          //                                   [76543210]
          //                             [______87654321___________]
           ((in[26 + inPos] & 33554431) >>> 11)) & 255);
      out[83 + outPos] = (byte)((
          //                                   [76543210]
          //                     [______________09876543___]
           ((in[26 + inPos] & 33554431) >>> 3)) & 255);
      out[84 + outPos] = (byte)((
          //                                   [765_____]
          //             [______________________210]
           ((in[26 + inPos] & 33554431) <<  5)
        | //                                   [___43210]
          //                                      [43210____________________]
           ((in[27 + inPos] & 33554431) >>> 20)) & 255);
      out[85 + outPos] = (byte)((
          //                                   [76543210]
          //                              [_____98765432____________]
           ((in[27 + inPos] & 33554431) >>> 12)) & 255);
      out[86 + outPos] = (byte)((
          //                                   [76543210]
          //                      [_____________10987654____]
           ((in[27 + inPos] & 33554431) >>> 4)) & 255);
      out[87 + outPos] = (byte)((
          //                                   [7654____]
          //              [_____________________3210]
           ((in[27 + inPos] & 33554431) <<  4)
        | //                                   [____3210]
          //                                       [4321_____________________]
           ((in[28 + inPos] & 33554431) >>> 21)) & 255);
      out[88 + outPos] = (byte)((
          //                                   [76543210]
          //                               [____09876543_____________]
           ((in[28 + inPos] & 33554431) >>> 13)) & 255);
      out[89 + outPos] = (byte)((
          //                                   [76543210]
          //                       [____________21098765_____]
           ((in[28 + inPos] & 33554431) >>> 5)) & 255);
      out[90 + outPos] = (byte)((
          //                                   [76543___]
          //               [____________________43210]
           ((in[28 + inPos] & 33554431) <<  3)
        | //                                   [_____210]
          //                                        [432______________________]
           ((in[29 + inPos] & 33554431) >>> 22)) & 255);
      out[91 + outPos] = (byte)((
          //                                   [76543210]
          //                                [___10987654______________]
           ((in[29 + inPos] & 33554431) >>> 14)) & 255);
      out[92 + outPos] = (byte)((
          //                                   [76543210]
          //                        [___________32109876______]
           ((in[29 + inPos] & 33554431) >>> 6)) & 255);
      out[93 + outPos] = (byte)((
          //                                   [765432__]
          //                [___________________543210]
           ((in[29 + inPos] & 33554431) <<  2)
        | //                                   [______10]
          //                                         [43_______________________]
           ((in[30 + inPos] & 33554431) >>> 23)) & 255);
      out[94 + outPos] = (byte)((
          //                                   [76543210]
          //                                 [__21098765_______________]
           ((in[30 + inPos] & 33554431) >>> 15)) & 255);
      out[95 + outPos] = (byte)((
          //                                   [76543210]
          //                         [__________43210987_______]
           ((in[30 + inPos] & 33554431) >>> 7)) & 255);
      out[96 + outPos] = (byte)((
          //                                   [7654321_]
          //                 [__________________6543210]
           ((in[30 + inPos] & 33554431) <<  1)
        | //                                   [_______0]
          //                                          [4________________________]
           ((in[31 + inPos] & 33554431) >>> 24)) & 255);
      out[97 + outPos] = (byte)((
          //                                   [76543210]
          //                                  [_32109876________________]
           ((in[31 + inPos] & 33554431) >>> 16)) & 255);
      out[98 + outPos] = (byte)((
          //                                   [76543210]
          //                          [_________54321098________]
           ((in[31 + inPos] & 33554431) >>> 8)) & 255);
      out[99 + outPos] = (byte)((
          //                                   [76543210]
          //                  [_________________76543210]
           ((in[31 + inPos] & 33554431))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                   [76543210]
          //                                   [43210987_________________]
            (((((int)in[ 0 + inPos]) & 255) <<  17) & 33554431)
        | //                                   [76543210]
          //                           [________65432109_________]
            (((((int)in[ 1 + inPos]) & 255) <<  9) & 33554431)
        | //                                   [76543210]
          //                   [________________87654321_]
            (((((int)in[ 2 + inPos]) & 255) <<  1) & 33554431)
        | //                                   [7_______]
          //           [________________________0]
            (((((int)in[ 3 + inPos]) & 255) >>>  7) & 33554431);
      out[ 1 + outPos] =
          //                                   [_6543210]
          //                                    [4321098__________________]
            (((((int)in[ 3 + inPos]) & 255) <<  18) & 33554431)
        | //                                   [76543210]
          //                            [_______76543210__________]
            (((((int)in[ 4 + inPos]) & 255) <<  10) & 33554431)
        | //                                   [76543210]
          //                    [_______________98765432__]
            (((((int)in[ 5 + inPos]) & 255) <<  2) & 33554431)
        | //                                   [76______]
          //            [_______________________10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 33554431);
      out[ 2 + outPos] =
          //                                   [__543210]
          //                                     [432109___________________]
            (((((int)in[ 6 + inPos]) & 255) <<  19) & 33554431)
        | //                                   [76543210]
          //                             [______87654321___________]
            (((((int)in[ 7 + inPos]) & 255) <<  11) & 33554431)
        | //                                   [76543210]
          //                     [______________09876543___]
            (((((int)in[ 8 + inPos]) & 255) <<  3) & 33554431)
        | //                                   [765_____]
          //             [______________________210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 33554431);
      out[ 3 + outPos] =
          //                                   [___43210]
          //                                      [43210____________________]
            (((((int)in[ 9 + inPos]) & 255) <<  20) & 33554431)
        | //                                   [76543210]
          //                              [_____98765432____________]
            (((((int)in[10 + inPos]) & 255) <<  12) & 33554431)
        | //                                   [76543210]
          //                      [_____________10987654____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 33554431)
        | //                                   [7654____]
          //              [_____________________3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 33554431);
      out[ 4 + outPos] =
          //                                   [____3210]
          //                                       [4321_____________________]
            (((((int)in[12 + inPos]) & 255) <<  21) & 33554431)
        | //                                   [76543210]
          //                               [____09876543_____________]
            (((((int)in[13 + inPos]) & 255) <<  13) & 33554431)
        | //                                   [76543210]
          //                       [____________21098765_____]
            (((((int)in[14 + inPos]) & 255) <<  5) & 33554431)
        | //                                   [76543___]
          //               [____________________43210]
            (((((int)in[15 + inPos]) & 255) >>>  3) & 33554431);
      out[ 5 + outPos] =
          //                                   [_____210]
          //                                        [432______________________]
            (((((int)in[15 + inPos]) & 255) <<  22) & 33554431)
        | //                                   [76543210]
          //                                [___10987654______________]
            (((((int)in[16 + inPos]) & 255) <<  14) & 33554431)
        | //                                   [76543210]
          //                        [___________32109876______]
            (((((int)in[17 + inPos]) & 255) <<  6) & 33554431)
        | //                                   [765432__]
          //                [___________________543210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 33554431);
      out[ 6 + outPos] =
          //                                   [______10]
          //                                         [43_______________________]
            (((((int)in[18 + inPos]) & 255) <<  23) & 33554431)
        | //                                   [76543210]
          //                                 [__21098765_______________]
            (((((int)in[19 + inPos]) & 255) <<  15) & 33554431)
        | //                                   [76543210]
          //                         [__________43210987_______]
            (((((int)in[20 + inPos]) & 255) <<  7) & 33554431)
        | //                                   [7654321_]
          //                 [__________________6543210]
            (((((int)in[21 + inPos]) & 255) >>>  1) & 33554431);
      out[ 7 + outPos] =
          //                                   [_______0]
          //                                          [4________________________]
            (((((int)in[21 + inPos]) & 255) <<  24) & 33554431)
        | //                                   [76543210]
          //                                  [_32109876________________]
            (((((int)in[22 + inPos]) & 255) <<  16) & 33554431)
        | //                                   [76543210]
          //                          [_________54321098________]
            (((((int)in[23 + inPos]) & 255) <<  8) & 33554431)
        | //                                   [76543210]
          //                  [_________________76543210]
            (((((int)in[24 + inPos]) & 255) ) & 33554431);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                   [76543210]
          //                                   [43210987_________________]
            (((((int)in[ 0 + inPos]) & 255) <<  17) & 33554431)
        | //                                   [76543210]
          //                           [________65432109_________]
            (((((int)in[ 1 + inPos]) & 255) <<  9) & 33554431)
        | //                                   [76543210]
          //                   [________________87654321_]
            (((((int)in[ 2 + inPos]) & 255) <<  1) & 33554431)
        | //                                   [7_______]
          //           [________________________0]
            (((((int)in[ 3 + inPos]) & 255) >>>  7) & 33554431);
      out[ 1 + outPos] =
          //                                   [_6543210]
          //                                    [4321098__________________]
            (((((int)in[ 3 + inPos]) & 255) <<  18) & 33554431)
        | //                                   [76543210]
          //                            [_______76543210__________]
            (((((int)in[ 4 + inPos]) & 255) <<  10) & 33554431)
        | //                                   [76543210]
          //                    [_______________98765432__]
            (((((int)in[ 5 + inPos]) & 255) <<  2) & 33554431)
        | //                                   [76______]
          //            [_______________________10]
            (((((int)in[ 6 + inPos]) & 255) >>>  6) & 33554431);
      out[ 2 + outPos] =
          //                                   [__543210]
          //                                     [432109___________________]
            (((((int)in[ 6 + inPos]) & 255) <<  19) & 33554431)
        | //                                   [76543210]
          //                             [______87654321___________]
            (((((int)in[ 7 + inPos]) & 255) <<  11) & 33554431)
        | //                                   [76543210]
          //                     [______________09876543___]
            (((((int)in[ 8 + inPos]) & 255) <<  3) & 33554431)
        | //                                   [765_____]
          //             [______________________210]
            (((((int)in[ 9 + inPos]) & 255) >>>  5) & 33554431);
      out[ 3 + outPos] =
          //                                   [___43210]
          //                                      [43210____________________]
            (((((int)in[ 9 + inPos]) & 255) <<  20) & 33554431)
        | //                                   [76543210]
          //                              [_____98765432____________]
            (((((int)in[10 + inPos]) & 255) <<  12) & 33554431)
        | //                                   [76543210]
          //                      [_____________10987654____]
            (((((int)in[11 + inPos]) & 255) <<  4) & 33554431)
        | //                                   [7654____]
          //              [_____________________3210]
            (((((int)in[12 + inPos]) & 255) >>>  4) & 33554431);
      out[ 4 + outPos] =
          //                                   [____3210]
          //                                       [4321_____________________]
            (((((int)in[12 + inPos]) & 255) <<  21) & 33554431)
        | //                                   [76543210]
          //                               [____09876543_____________]
            (((((int)in[13 + inPos]) & 255) <<  13) & 33554431)
        | //                                   [76543210]
          //                       [____________21098765_____]
            (((((int)in[14 + inPos]) & 255) <<  5) & 33554431)
        | //                                   [76543___]
          //               [____________________43210]
            (((((int)in[15 + inPos]) & 255) >>>  3) & 33554431);
      out[ 5 + outPos] =
          //                                   [_____210]
          //                                        [432______________________]
            (((((int)in[15 + inPos]) & 255) <<  22) & 33554431)
        | //                                   [76543210]
          //                                [___10987654______________]
            (((((int)in[16 + inPos]) & 255) <<  14) & 33554431)
        | //                                   [76543210]
          //                        [___________32109876______]
            (((((int)in[17 + inPos]) & 255) <<  6) & 33554431)
        | //                                   [765432__]
          //                [___________________543210]
            (((((int)in[18 + inPos]) & 255) >>>  2) & 33554431);
      out[ 6 + outPos] =
          //                                   [______10]
          //                                         [43_______________________]
            (((((int)in[18 + inPos]) & 255) <<  23) & 33554431)
        | //                                   [76543210]
          //                                 [__21098765_______________]
            (((((int)in[19 + inPos]) & 255) <<  15) & 33554431)
        | //                                   [76543210]
          //                         [__________43210987_______]
            (((((int)in[20 + inPos]) & 255) <<  7) & 33554431)
        | //                                   [7654321_]
          //                 [__________________6543210]
            (((((int)in[21 + inPos]) & 255) >>>  1) & 33554431);
      out[ 7 + outPos] =
          //                                   [_______0]
          //                                          [4________________________]
            (((((int)in[21 + inPos]) & 255) <<  24) & 33554431)
        | //                                   [76543210]
          //                                  [_32109876________________]
            (((((int)in[22 + inPos]) & 255) <<  16) & 33554431)
        | //                                   [76543210]
          //                          [_________54321098________]
            (((((int)in[23 + inPos]) & 255) <<  8) & 33554431)
        | //                                   [76543210]
          //                  [_________________76543210]
            (((((int)in[24 + inPos]) & 255) ) & 33554431);
      out[ 8 + outPos] =
          //                                   [76543210]
          //                                   [43210987_________________]
            (((((int)in[25 + inPos]) & 255) <<  17) & 33554431)
        | //                                   [76543210]
          //                           [________65432109_________]
            (((((int)in[26 + inPos]) & 255) <<  9) & 33554431)
        | //                                   [76543210]
          //                   [________________87654321_]
            (((((int)in[27 + inPos]) & 255) <<  1) & 33554431)
        | //                                   [7_______]
          //           [________________________0]
            (((((int)in[28 + inPos]) & 255) >>>  7) & 33554431);
      out[ 9 + outPos] =
          //                                   [_6543210]
          //                                    [4321098__________________]
            (((((int)in[28 + inPos]) & 255) <<  18) & 33554431)
        | //                                   [76543210]
          //                            [_______76543210__________]
            (((((int)in[29 + inPos]) & 255) <<  10) & 33554431)
        | //                                   [76543210]
          //                    [_______________98765432__]
            (((((int)in[30 + inPos]) & 255) <<  2) & 33554431)
        | //                                   [76______]
          //            [_______________________10]
            (((((int)in[31 + inPos]) & 255) >>>  6) & 33554431);
      out[10 + outPos] =
          //                                   [__543210]
          //                                     [432109___________________]
            (((((int)in[31 + inPos]) & 255) <<  19) & 33554431)
        | //                                   [76543210]
          //                             [______87654321___________]
            (((((int)in[32 + inPos]) & 255) <<  11) & 33554431)
        | //                                   [76543210]
          //                     [______________09876543___]
            (((((int)in[33 + inPos]) & 255) <<  3) & 33554431)
        | //                                   [765_____]
          //             [______________________210]
            (((((int)in[34 + inPos]) & 255) >>>  5) & 33554431);
      out[11 + outPos] =
          //                                   [___43210]
          //                                      [43210____________________]
            (((((int)in[34 + inPos]) & 255) <<  20) & 33554431)
        | //                                   [76543210]
          //                              [_____98765432____________]
            (((((int)in[35 + inPos]) & 255) <<  12) & 33554431)
        | //                                   [76543210]
          //                      [_____________10987654____]
            (((((int)in[36 + inPos]) & 255) <<  4) & 33554431)
        | //                                   [7654____]
          //              [_____________________3210]
            (((((int)in[37 + inPos]) & 255) >>>  4) & 33554431);
      out[12 + outPos] =
          //                                   [____3210]
          //                                       [4321_____________________]
            (((((int)in[37 + inPos]) & 255) <<  21) & 33554431)
        | //                                   [76543210]
          //                               [____09876543_____________]
            (((((int)in[38 + inPos]) & 255) <<  13) & 33554431)
        | //                                   [76543210]
          //                       [____________21098765_____]
            (((((int)in[39 + inPos]) & 255) <<  5) & 33554431)
        | //                                   [76543___]
          //               [____________________43210]
            (((((int)in[40 + inPos]) & 255) >>>  3) & 33554431);
      out[13 + outPos] =
          //                                   [_____210]
          //                                        [432______________________]
            (((((int)in[40 + inPos]) & 255) <<  22) & 33554431)
        | //                                   [76543210]
          //                                [___10987654______________]
            (((((int)in[41 + inPos]) & 255) <<  14) & 33554431)
        | //                                   [76543210]
          //                        [___________32109876______]
            (((((int)in[42 + inPos]) & 255) <<  6) & 33554431)
        | //                                   [765432__]
          //                [___________________543210]
            (((((int)in[43 + inPos]) & 255) >>>  2) & 33554431);
      out[14 + outPos] =
          //                                   [______10]
          //                                         [43_______________________]
            (((((int)in[43 + inPos]) & 255) <<  23) & 33554431)
        | //                                   [76543210]
          //                                 [__21098765_______________]
            (((((int)in[44 + inPos]) & 255) <<  15) & 33554431)
        | //                                   [76543210]
          //                         [__________43210987_______]
            (((((int)in[45 + inPos]) & 255) <<  7) & 33554431)
        | //                                   [7654321_]
          //                 [__________________6543210]
            (((((int)in[46 + inPos]) & 255) >>>  1) & 33554431);
      out[15 + outPos] =
          //                                   [_______0]
          //                                          [4________________________]
            (((((int)in[46 + inPos]) & 255) <<  24) & 33554431)
        | //                                   [76543210]
          //                                  [_32109876________________]
            (((((int)in[47 + inPos]) & 255) <<  16) & 33554431)
        | //                                   [76543210]
          //                          [_________54321098________]
            (((((int)in[48 + inPos]) & 255) <<  8) & 33554431)
        | //                                   [76543210]
          //                  [_________________76543210]
            (((((int)in[49 + inPos]) & 255) ) & 33554431);
      out[16 + outPos] =
          //                                   [76543210]
          //                                   [43210987_________________]
            (((((int)in[50 + inPos]) & 255) <<  17) & 33554431)
        | //                                   [76543210]
          //                           [________65432109_________]
            (((((int)in[51 + inPos]) & 255) <<  9) & 33554431)
        | //                                   [76543210]
          //                   [________________87654321_]
            (((((int)in[52 + inPos]) & 255) <<  1) & 33554431)
        | //                                   [7_______]
          //           [________________________0]
            (((((int)in[53 + inPos]) & 255) >>>  7) & 33554431);
      out[17 + outPos] =
          //                                   [_6543210]
          //                                    [4321098__________________]
            (((((int)in[53 + inPos]) & 255) <<  18) & 33554431)
        | //                                   [76543210]
          //                            [_______76543210__________]
            (((((int)in[54 + inPos]) & 255) <<  10) & 33554431)
        | //                                   [76543210]
          //                    [_______________98765432__]
            (((((int)in[55 + inPos]) & 255) <<  2) & 33554431)
        | //                                   [76______]
          //            [_______________________10]
            (((((int)in[56 + inPos]) & 255) >>>  6) & 33554431);
      out[18 + outPos] =
          //                                   [__543210]
          //                                     [432109___________________]
            (((((int)in[56 + inPos]) & 255) <<  19) & 33554431)
        | //                                   [76543210]
          //                             [______87654321___________]
            (((((int)in[57 + inPos]) & 255) <<  11) & 33554431)
        | //                                   [76543210]
          //                     [______________09876543___]
            (((((int)in[58 + inPos]) & 255) <<  3) & 33554431)
        | //                                   [765_____]
          //             [______________________210]
            (((((int)in[59 + inPos]) & 255) >>>  5) & 33554431);
      out[19 + outPos] =
          //                                   [___43210]
          //                                      [43210____________________]
            (((((int)in[59 + inPos]) & 255) <<  20) & 33554431)
        | //                                   [76543210]
          //                              [_____98765432____________]
            (((((int)in[60 + inPos]) & 255) <<  12) & 33554431)
        | //                                   [76543210]
          //                      [_____________10987654____]
            (((((int)in[61 + inPos]) & 255) <<  4) & 33554431)
        | //                                   [7654____]
          //              [_____________________3210]
            (((((int)in[62 + inPos]) & 255) >>>  4) & 33554431);
      out[20 + outPos] =
          //                                   [____3210]
          //                                       [4321_____________________]
            (((((int)in[62 + inPos]) & 255) <<  21) & 33554431)
        | //                                   [76543210]
          //                               [____09876543_____________]
            (((((int)in[63 + inPos]) & 255) <<  13) & 33554431)
        | //                                   [76543210]
          //                       [____________21098765_____]
            (((((int)in[64 + inPos]) & 255) <<  5) & 33554431)
        | //                                   [76543___]
          //               [____________________43210]
            (((((int)in[65 + inPos]) & 255) >>>  3) & 33554431);
      out[21 + outPos] =
          //                                   [_____210]
          //                                        [432______________________]
            (((((int)in[65 + inPos]) & 255) <<  22) & 33554431)
        | //                                   [76543210]
          //                                [___10987654______________]
            (((((int)in[66 + inPos]) & 255) <<  14) & 33554431)
        | //                                   [76543210]
          //                        [___________32109876______]
            (((((int)in[67 + inPos]) & 255) <<  6) & 33554431)
        | //                                   [765432__]
          //                [___________________543210]
            (((((int)in[68 + inPos]) & 255) >>>  2) & 33554431);
      out[22 + outPos] =
          //                                   [______10]
          //                                         [43_______________________]
            (((((int)in[68 + inPos]) & 255) <<  23) & 33554431)
        | //                                   [76543210]
          //                                 [__21098765_______________]
            (((((int)in[69 + inPos]) & 255) <<  15) & 33554431)
        | //                                   [76543210]
          //                         [__________43210987_______]
            (((((int)in[70 + inPos]) & 255) <<  7) & 33554431)
        | //                                   [7654321_]
          //                 [__________________6543210]
            (((((int)in[71 + inPos]) & 255) >>>  1) & 33554431);
      out[23 + outPos] =
          //                                   [_______0]
          //                                          [4________________________]
            (((((int)in[71 + inPos]) & 255) <<  24) & 33554431)
        | //                                   [76543210]
          //                                  [_32109876________________]
            (((((int)in[72 + inPos]) & 255) <<  16) & 33554431)
        | //                                   [76543210]
          //                          [_________54321098________]
            (((((int)in[73 + inPos]) & 255) <<  8) & 33554431)
        | //                                   [76543210]
          //                  [_________________76543210]
            (((((int)in[74 + inPos]) & 255) ) & 33554431);
      out[24 + outPos] =
          //                                   [76543210]
          //                                   [43210987_________________]
            (((((int)in[75 + inPos]) & 255) <<  17) & 33554431)
        | //                                   [76543210]
          //                           [________65432109_________]
            (((((int)in[76 + inPos]) & 255) <<  9) & 33554431)
        | //                                   [76543210]
          //                   [________________87654321_]
            (((((int)in[77 + inPos]) & 255) <<  1) & 33554431)
        | //                                   [7_______]
          //           [________________________0]
            (((((int)in[78 + inPos]) & 255) >>>  7) & 33554431);
      out[25 + outPos] =
          //                                   [_6543210]
          //                                    [4321098__________________]
            (((((int)in[78 + inPos]) & 255) <<  18) & 33554431)
        | //                                   [76543210]
          //                            [_______76543210__________]
            (((((int)in[79 + inPos]) & 255) <<  10) & 33554431)
        | //                                   [76543210]
          //                    [_______________98765432__]
            (((((int)in[80 + inPos]) & 255) <<  2) & 33554431)
        | //                                   [76______]
          //            [_______________________10]
            (((((int)in[81 + inPos]) & 255) >>>  6) & 33554431);
      out[26 + outPos] =
          //                                   [__543210]
          //                                     [432109___________________]
            (((((int)in[81 + inPos]) & 255) <<  19) & 33554431)
        | //                                   [76543210]
          //                             [______87654321___________]
            (((((int)in[82 + inPos]) & 255) <<  11) & 33554431)
        | //                                   [76543210]
          //                     [______________09876543___]
            (((((int)in[83 + inPos]) & 255) <<  3) & 33554431)
        | //                                   [765_____]
          //             [______________________210]
            (((((int)in[84 + inPos]) & 255) >>>  5) & 33554431);
      out[27 + outPos] =
          //                                   [___43210]
          //                                      [43210____________________]
            (((((int)in[84 + inPos]) & 255) <<  20) & 33554431)
        | //                                   [76543210]
          //                              [_____98765432____________]
            (((((int)in[85 + inPos]) & 255) <<  12) & 33554431)
        | //                                   [76543210]
          //                      [_____________10987654____]
            (((((int)in[86 + inPos]) & 255) <<  4) & 33554431)
        | //                                   [7654____]
          //              [_____________________3210]
            (((((int)in[87 + inPos]) & 255) >>>  4) & 33554431);
      out[28 + outPos] =
          //                                   [____3210]
          //                                       [4321_____________________]
            (((((int)in[87 + inPos]) & 255) <<  21) & 33554431)
        | //                                   [76543210]
          //                               [____09876543_____________]
            (((((int)in[88 + inPos]) & 255) <<  13) & 33554431)
        | //                                   [76543210]
          //                       [____________21098765_____]
            (((((int)in[89 + inPos]) & 255) <<  5) & 33554431)
        | //                                   [76543___]
          //               [____________________43210]
            (((((int)in[90 + inPos]) & 255) >>>  3) & 33554431);
      out[29 + outPos] =
          //                                   [_____210]
          //                                        [432______________________]
            (((((int)in[90 + inPos]) & 255) <<  22) & 33554431)
        | //                                   [76543210]
          //                                [___10987654______________]
            (((((int)in[91 + inPos]) & 255) <<  14) & 33554431)
        | //                                   [76543210]
          //                        [___________32109876______]
            (((((int)in[92 + inPos]) & 255) <<  6) & 33554431)
        | //                                   [765432__]
          //                [___________________543210]
            (((((int)in[93 + inPos]) & 255) >>>  2) & 33554431);
      out[30 + outPos] =
          //                                   [______10]
          //                                         [43_______________________]
            (((((int)in[93 + inPos]) & 255) <<  23) & 33554431)
        | //                                   [76543210]
          //                                 [__21098765_______________]
            (((((int)in[94 + inPos]) & 255) <<  15) & 33554431)
        | //                                   [76543210]
          //                         [__________43210987_______]
            (((((int)in[95 + inPos]) & 255) <<  7) & 33554431)
        | //                                   [7654321_]
          //                 [__________________6543210]
            (((((int)in[96 + inPos]) & 255) >>>  1) & 33554431);
      out[31 + outPos] =
          //                                   [_______0]
          //                                          [4________________________]
            (((((int)in[96 + inPos]) & 255) <<  24) & 33554431)
        | //                                   [76543210]
          //                                  [_32109876________________]
            (((((int)in[97 + inPos]) & 255) <<  16) & 33554431)
        | //                                   [76543210]
          //                          [_________54321098________]
            (((((int)in[98 + inPos]) & 255) <<  8) & 33554431)
        | //                                   [76543210]
          //                  [_________________76543210]
            (((((int)in[99 + inPos]) & 255) ) & 33554431);
    }
  }

  private static final class Packer26 extends BytePacker {

    private Packer26() {
      super(26);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[ 0 + inPos] & 67108863) >>> 18)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[ 0 + inPos] & 67108863) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[ 0 + inPos] & 67108863) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[ 0 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[ 1 + inPos] & 67108863) >>> 20)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[ 1 + inPos] & 67108863) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[ 1 + inPos] & 67108863) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[ 1 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[ 2 + inPos] & 67108863) >>> 22)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[ 2 + inPos] & 67108863) >>> 14)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[ 2 + inPos] & 67108863) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[ 2 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[ 3 + inPos] & 67108863) >>> 24)) & 255);
      out[10 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[ 3 + inPos] & 67108863) >>> 16)) & 255);
      out[11 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[ 3 + inPos] & 67108863) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[ 3 + inPos] & 67108863))) & 255);
      out[13 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[ 4 + inPos] & 67108863) >>> 18)) & 255);
      out[14 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[ 4 + inPos] & 67108863) >>> 10)) & 255);
      out[15 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[ 4 + inPos] & 67108863) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[ 4 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[ 5 + inPos] & 67108863) >>> 20)) & 255);
      out[17 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[ 5 + inPos] & 67108863) >>> 12)) & 255);
      out[18 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[ 5 + inPos] & 67108863) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[ 5 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[ 6 + inPos] & 67108863) >>> 22)) & 255);
      out[20 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[ 6 + inPos] & 67108863) >>> 14)) & 255);
      out[21 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[ 6 + inPos] & 67108863) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[ 6 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[ 7 + inPos] & 67108863) >>> 24)) & 255);
      out[23 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[ 7 + inPos] & 67108863) >>> 16)) & 255);
      out[24 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[ 7 + inPos] & 67108863) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[ 7 + inPos] & 67108863))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[ 0 + inPos] & 67108863) >>> 18)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[ 0 + inPos] & 67108863) >>> 10)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[ 0 + inPos] & 67108863) >>> 2)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[ 0 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[ 1 + inPos] & 67108863) >>> 20)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[ 1 + inPos] & 67108863) >>> 12)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[ 1 + inPos] & 67108863) >>> 4)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[ 1 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[ 2 + inPos] & 67108863) >>> 22)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[ 2 + inPos] & 67108863) >>> 14)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[ 2 + inPos] & 67108863) >>> 6)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[ 2 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[ 3 + inPos] & 67108863) >>> 24)) & 255);
      out[10 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[ 3 + inPos] & 67108863) >>> 16)) & 255);
      out[11 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[ 3 + inPos] & 67108863) >>> 8)) & 255);
      out[12 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[ 3 + inPos] & 67108863))) & 255);
      out[13 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[ 4 + inPos] & 67108863) >>> 18)) & 255);
      out[14 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[ 4 + inPos] & 67108863) >>> 10)) & 255);
      out[15 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[ 4 + inPos] & 67108863) >>> 2)) & 255);
      out[16 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[ 4 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[ 5 + inPos] & 67108863) >>> 20)) & 255);
      out[17 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[ 5 + inPos] & 67108863) >>> 12)) & 255);
      out[18 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[ 5 + inPos] & 67108863) >>> 4)) & 255);
      out[19 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[ 5 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[ 6 + inPos] & 67108863) >>> 22)) & 255);
      out[20 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[ 6 + inPos] & 67108863) >>> 14)) & 255);
      out[21 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[ 6 + inPos] & 67108863) >>> 6)) & 255);
      out[22 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[ 6 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[ 7 + inPos] & 67108863) >>> 24)) & 255);
      out[23 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[ 7 + inPos] & 67108863) >>> 16)) & 255);
      out[24 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[ 7 + inPos] & 67108863) >>> 8)) & 255);
      out[25 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[ 7 + inPos] & 67108863))) & 255);
      out[26 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[ 8 + inPos] & 67108863) >>> 18)) & 255);
      out[27 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[ 8 + inPos] & 67108863) >>> 10)) & 255);
      out[28 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[ 8 + inPos] & 67108863) >>> 2)) & 255);
      out[29 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[ 8 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[ 9 + inPos] & 67108863) >>> 20)) & 255);
      out[30 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[ 9 + inPos] & 67108863) >>> 12)) & 255);
      out[31 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[ 9 + inPos] & 67108863) >>> 4)) & 255);
      out[32 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[ 9 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[10 + inPos] & 67108863) >>> 22)) & 255);
      out[33 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[10 + inPos] & 67108863) >>> 14)) & 255);
      out[34 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[10 + inPos] & 67108863) >>> 6)) & 255);
      out[35 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[10 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[11 + inPos] & 67108863) >>> 24)) & 255);
      out[36 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[11 + inPos] & 67108863) >>> 16)) & 255);
      out[37 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[11 + inPos] & 67108863) >>> 8)) & 255);
      out[38 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[11 + inPos] & 67108863))) & 255);
      out[39 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[12 + inPos] & 67108863) >>> 18)) & 255);
      out[40 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[12 + inPos] & 67108863) >>> 10)) & 255);
      out[41 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[12 + inPos] & 67108863) >>> 2)) & 255);
      out[42 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[12 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[13 + inPos] & 67108863) >>> 20)) & 255);
      out[43 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[13 + inPos] & 67108863) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[13 + inPos] & 67108863) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[13 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[14 + inPos] & 67108863) >>> 22)) & 255);
      out[46 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[14 + inPos] & 67108863) >>> 14)) & 255);
      out[47 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[14 + inPos] & 67108863) >>> 6)) & 255);
      out[48 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[14 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[15 + inPos] & 67108863) >>> 24)) & 255);
      out[49 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[15 + inPos] & 67108863) >>> 16)) & 255);
      out[50 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[15 + inPos] & 67108863) >>> 8)) & 255);
      out[51 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[15 + inPos] & 67108863))) & 255);
      out[52 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[16 + inPos] & 67108863) >>> 18)) & 255);
      out[53 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[16 + inPos] & 67108863) >>> 10)) & 255);
      out[54 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[16 + inPos] & 67108863) >>> 2)) & 255);
      out[55 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[16 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[17 + inPos] & 67108863) >>> 20)) & 255);
      out[56 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[17 + inPos] & 67108863) >>> 12)) & 255);
      out[57 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[17 + inPos] & 67108863) >>> 4)) & 255);
      out[58 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[17 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[18 + inPos] & 67108863) >>> 22)) & 255);
      out[59 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[18 + inPos] & 67108863) >>> 14)) & 255);
      out[60 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[18 + inPos] & 67108863) >>> 6)) & 255);
      out[61 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[18 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[19 + inPos] & 67108863) >>> 24)) & 255);
      out[62 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[19 + inPos] & 67108863) >>> 16)) & 255);
      out[63 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[19 + inPos] & 67108863) >>> 8)) & 255);
      out[64 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[19 + inPos] & 67108863))) & 255);
      out[65 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[20 + inPos] & 67108863) >>> 18)) & 255);
      out[66 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[20 + inPos] & 67108863) >>> 10)) & 255);
      out[67 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[20 + inPos] & 67108863) >>> 2)) & 255);
      out[68 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[20 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[21 + inPos] & 67108863) >>> 20)) & 255);
      out[69 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[21 + inPos] & 67108863) >>> 12)) & 255);
      out[70 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[21 + inPos] & 67108863) >>> 4)) & 255);
      out[71 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[21 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[22 + inPos] & 67108863) >>> 22)) & 255);
      out[72 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[22 + inPos] & 67108863) >>> 14)) & 255);
      out[73 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[22 + inPos] & 67108863) >>> 6)) & 255);
      out[74 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[22 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[23 + inPos] & 67108863) >>> 24)) & 255);
      out[75 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[23 + inPos] & 67108863) >>> 16)) & 255);
      out[76 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[23 + inPos] & 67108863) >>> 8)) & 255);
      out[77 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[23 + inPos] & 67108863))) & 255);
      out[78 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[24 + inPos] & 67108863) >>> 18)) & 255);
      out[79 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[24 + inPos] & 67108863) >>> 10)) & 255);
      out[80 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[24 + inPos] & 67108863) >>> 2)) & 255);
      out[81 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[24 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[25 + inPos] & 67108863) >>> 20)) & 255);
      out[82 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[25 + inPos] & 67108863) >>> 12)) & 255);
      out[83 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[25 + inPos] & 67108863) >>> 4)) & 255);
      out[84 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[25 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[26 + inPos] & 67108863) >>> 22)) & 255);
      out[85 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[26 + inPos] & 67108863) >>> 14)) & 255);
      out[86 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[26 + inPos] & 67108863) >>> 6)) & 255);
      out[87 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[26 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[27 + inPos] & 67108863) >>> 24)) & 255);
      out[88 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[27 + inPos] & 67108863) >>> 16)) & 255);
      out[89 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[27 + inPos] & 67108863) >>> 8)) & 255);
      out[90 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[27 + inPos] & 67108863))) & 255);
      out[91 + outPos] = (byte)((
          //                                    [76543210]
          //                                    [54321098__________________]
           ((in[28 + inPos] & 67108863) >>> 18)) & 255);
      out[92 + outPos] = (byte)((
          //                                    [76543210]
          //                            [________76543210__________]
           ((in[28 + inPos] & 67108863) >>> 10)) & 255);
      out[93 + outPos] = (byte)((
          //                                    [76543210]
          //                    [________________98765432__]
           ((in[28 + inPos] & 67108863) >>> 2)) & 255);
      out[94 + outPos] = (byte)((
          //                                    [76______]
          //            [________________________10]
           ((in[28 + inPos] & 67108863) <<  6)
        | //                                    [__543210]
          //                                      [543210____________________]
           ((in[29 + inPos] & 67108863) >>> 20)) & 255);
      out[95 + outPos] = (byte)((
          //                                    [76543210]
          //                              [______98765432____________]
           ((in[29 + inPos] & 67108863) >>> 12)) & 255);
      out[96 + outPos] = (byte)((
          //                                    [76543210]
          //                      [______________10987654____]
           ((in[29 + inPos] & 67108863) >>> 4)) & 255);
      out[97 + outPos] = (byte)((
          //                                    [7654____]
          //              [______________________3210]
           ((in[29 + inPos] & 67108863) <<  4)
        | //                                    [____3210]
          //                                        [5432______________________]
           ((in[30 + inPos] & 67108863) >>> 22)) & 255);
      out[98 + outPos] = (byte)((
          //                                    [76543210]
          //                                [____10987654______________]
           ((in[30 + inPos] & 67108863) >>> 14)) & 255);
      out[99 + outPos] = (byte)((
          //                                    [76543210]
          //                        [____________32109876______]
           ((in[30 + inPos] & 67108863) >>> 6)) & 255);
      out[100 + outPos] = (byte)((
          //                                    [765432__]
          //                [____________________543210]
           ((in[30 + inPos] & 67108863) <<  2)
        | //                                    [______10]
          //                                          [54________________________]
           ((in[31 + inPos] & 67108863) >>> 24)) & 255);
      out[101 + outPos] = (byte)((
          //                                    [76543210]
          //                                  [__32109876________________]
           ((in[31 + inPos] & 67108863) >>> 16)) & 255);
      out[102 + outPos] = (byte)((
          //                                    [76543210]
          //                          [__________54321098________]
           ((in[31 + inPos] & 67108863) >>> 8)) & 255);
      out[103 + outPos] = (byte)((
          //                                    [76543210]
          //                  [__________________76543210]
           ((in[31 + inPos] & 67108863))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[ 0 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[ 1 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[ 2 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 67108863);
      out[ 1 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[ 3 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[ 4 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[ 5 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 67108863);
      out[ 2 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[ 6 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[ 7 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[ 8 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 67108863);
      out[ 3 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[ 9 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[10 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[11 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[12 + inPos]) & 255) ) & 67108863);
      out[ 4 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[13 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[14 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[15 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[16 + inPos]) & 255) >>>  6) & 67108863);
      out[ 5 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[16 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[17 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[18 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[19 + inPos]) & 255) >>>  4) & 67108863);
      out[ 6 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[19 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[20 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[21 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[22 + inPos]) & 255) >>>  2) & 67108863);
      out[ 7 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[22 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[23 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[24 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[25 + inPos]) & 255) ) & 67108863);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[ 0 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[ 1 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[ 2 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[ 3 + inPos]) & 255) >>>  6) & 67108863);
      out[ 1 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[ 3 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[ 4 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[ 5 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[ 6 + inPos]) & 255) >>>  4) & 67108863);
      out[ 2 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[ 6 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[ 7 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[ 8 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[ 9 + inPos]) & 255) >>>  2) & 67108863);
      out[ 3 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[ 9 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[10 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[11 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[12 + inPos]) & 255) ) & 67108863);
      out[ 4 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[13 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[14 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[15 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[16 + inPos]) & 255) >>>  6) & 67108863);
      out[ 5 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[16 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[17 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[18 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[19 + inPos]) & 255) >>>  4) & 67108863);
      out[ 6 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[19 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[20 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[21 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[22 + inPos]) & 255) >>>  2) & 67108863);
      out[ 7 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[22 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[23 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[24 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[25 + inPos]) & 255) ) & 67108863);
      out[ 8 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[26 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[27 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[28 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[29 + inPos]) & 255) >>>  6) & 67108863);
      out[ 9 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[29 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[30 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[31 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[32 + inPos]) & 255) >>>  4) & 67108863);
      out[10 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[32 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[33 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[34 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[35 + inPos]) & 255) >>>  2) & 67108863);
      out[11 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[35 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[36 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[37 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[38 + inPos]) & 255) ) & 67108863);
      out[12 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[39 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[40 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[41 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[42 + inPos]) & 255) >>>  6) & 67108863);
      out[13 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[42 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[43 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[44 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[45 + inPos]) & 255) >>>  4) & 67108863);
      out[14 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[45 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[46 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[47 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[48 + inPos]) & 255) >>>  2) & 67108863);
      out[15 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[48 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[49 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[50 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[51 + inPos]) & 255) ) & 67108863);
      out[16 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[52 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[53 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[54 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[55 + inPos]) & 255) >>>  6) & 67108863);
      out[17 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[55 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[56 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[57 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[58 + inPos]) & 255) >>>  4) & 67108863);
      out[18 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[58 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[59 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[60 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[61 + inPos]) & 255) >>>  2) & 67108863);
      out[19 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[61 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[62 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[63 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[64 + inPos]) & 255) ) & 67108863);
      out[20 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[65 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[66 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[67 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[68 + inPos]) & 255) >>>  6) & 67108863);
      out[21 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[68 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[69 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[70 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[71 + inPos]) & 255) >>>  4) & 67108863);
      out[22 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[71 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[72 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[73 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[74 + inPos]) & 255) >>>  2) & 67108863);
      out[23 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[74 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[75 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[76 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[77 + inPos]) & 255) ) & 67108863);
      out[24 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[78 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[79 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[80 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[81 + inPos]) & 255) >>>  6) & 67108863);
      out[25 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[81 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[82 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[83 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[84 + inPos]) & 255) >>>  4) & 67108863);
      out[26 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[84 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[85 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[86 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[87 + inPos]) & 255) >>>  2) & 67108863);
      out[27 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[87 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[88 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[89 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[90 + inPos]) & 255) ) & 67108863);
      out[28 + outPos] =
          //                                    [76543210]
          //                                    [54321098__________________]
            (((((int)in[91 + inPos]) & 255) <<  18) & 67108863)
        | //                                    [76543210]
          //                            [________76543210__________]
            (((((int)in[92 + inPos]) & 255) <<  10) & 67108863)
        | //                                    [76543210]
          //                    [________________98765432__]
            (((((int)in[93 + inPos]) & 255) <<  2) & 67108863)
        | //                                    [76______]
          //            [________________________10]
            (((((int)in[94 + inPos]) & 255) >>>  6) & 67108863);
      out[29 + outPos] =
          //                                    [__543210]
          //                                      [543210____________________]
            (((((int)in[94 + inPos]) & 255) <<  20) & 67108863)
        | //                                    [76543210]
          //                              [______98765432____________]
            (((((int)in[95 + inPos]) & 255) <<  12) & 67108863)
        | //                                    [76543210]
          //                      [______________10987654____]
            (((((int)in[96 + inPos]) & 255) <<  4) & 67108863)
        | //                                    [7654____]
          //              [______________________3210]
            (((((int)in[97 + inPos]) & 255) >>>  4) & 67108863);
      out[30 + outPos] =
          //                                    [____3210]
          //                                        [5432______________________]
            (((((int)in[97 + inPos]) & 255) <<  22) & 67108863)
        | //                                    [76543210]
          //                                [____10987654______________]
            (((((int)in[98 + inPos]) & 255) <<  14) & 67108863)
        | //                                    [76543210]
          //                        [____________32109876______]
            (((((int)in[99 + inPos]) & 255) <<  6) & 67108863)
        | //                                    [765432__]
          //                [____________________543210]
            (((((int)in[100 + inPos]) & 255) >>>  2) & 67108863);
      out[31 + outPos] =
          //                                    [______10]
          //                                          [54________________________]
            (((((int)in[100 + inPos]) & 255) <<  24) & 67108863)
        | //                                    [76543210]
          //                                  [__32109876________________]
            (((((int)in[101 + inPos]) & 255) <<  16) & 67108863)
        | //                                    [76543210]
          //                          [__________54321098________]
            (((((int)in[102 + inPos]) & 255) <<  8) & 67108863)
        | //                                    [76543210]
          //                  [__________________76543210]
            (((((int)in[103 + inPos]) & 255) ) & 67108863);
    }
  }

  private static final class Packer27 extends BytePacker {

    private Packer27() {
      super(27);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                     [76543210]
          //                                     [65432109___________________]
           ((in[ 0 + inPos] & 134217727) >>> 19)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                     [76543210]
          //                             [________87654321___________]
           ((in[ 0 + inPos] & 134217727) >>> 11)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                     [76543210]
          //                     [________________09876543___]
           ((in[ 0 + inPos] & 134217727) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                     [765_____]
          //             [________________________210]
           ((in[ 0 + inPos] & 134217727) <<  5)
        | //                                     [___43210]
          //                                        [65432______________________]
           ((in[ 1 + inPos] & 134217727) >>> 22)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                     [76543210]
          //                                [_____10987654______________]
           ((in[ 1 + inPos] & 134217727) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                     [76543210]
          //                        [_____________32109876______]
           ((in[ 1 + inPos] & 134217727) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                     [765432__]
          //                [_____________________543210]
           ((in[ 1 + inPos] & 134217727) <<  2)
        | //                                     [______10]
          //                                           [65_________________________]
           ((in[ 2 + inPos] & 134217727) >>> 25)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                     [76543210]
          //                                   [__43210987_________________]
           ((in[ 2 + inPos] & 134217727) >>> 17)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                     [76543210]
          //                           [__________65432109_________]
           ((in[ 2 + inPos] & 134217727) >>> 9)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                     [76543210]
          //                   [__________________87654321_]
           ((in[ 2 + inPos] & 134217727) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //                                     [7_______]
          //           [__________________________0]
           ((in[ 2 + inPos] & 134217727) <<  7)
        | //                                     [_6543210]
          //                                      [6543210____________________]
           ((in[ 3 + inPos] & 134217727) >>> 20)) & 255);
      out[11 + outPos] = (byte)((
          //                                     [76543210]
          //                              [_______98765432____________]
           ((in[ 3 + inPos] & 134217727) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                                     [76543210]
          //                      [_______________10987654____]
           ((in[ 3 + inPos] & 134217727) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                                     [7654____]
          //              [_______________________3210]
           ((in[ 3 + inPos] & 134217727) <<  4)
        | //                                     [____3210]
          //                                         [6543_______________________]
           ((in[ 4 + inPos] & 134217727) >>> 23)) & 255);
      out[14 + outPos] = (byte)((
          //                                     [76543210]
          //                                 [____21098765_______________]
           ((in[ 4 + inPos] & 134217727) >>> 15)) & 255);
      out[15 + outPos] = (byte)((
          //                                     [76543210]
          //                         [____________43210987_______]
           ((in[ 4 + inPos] & 134217727) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                                     [7654321_]
          //                 [____________________6543210]
           ((in[ 4 + inPos] & 134217727) <<  1)
        | //                                     [_______0]
          //                                            [6__________________________]
           ((in[ 5 + inPos] & 134217727) >>> 26)) & 255);
      out[17 + outPos] = (byte)((
          //                                     [76543210]
          //                                    [_54321098__________________]
           ((in[ 5 + inPos] & 134217727) >>> 18)) & 255);
      out[18 + outPos] = (byte)((
          //                                     [76543210]
          //                            [_________76543210__________]
           ((in[ 5 + inPos] & 134217727) >>> 10)) & 255);
      out[19 + outPos] = (byte)((
          //                                     [76543210]
          //                    [_________________98765432__]
           ((in[ 5 + inPos] & 134217727) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                                     [76______]
          //            [_________________________10]
           ((in[ 5 + inPos] & 134217727) <<  6)
        | //                                     [__543210]
          //                                       [654321_____________________]
           ((in[ 6 + inPos] & 134217727) >>> 21)) & 255);
      out[21 + outPos] = (byte)((
          //                                     [76543210]
          //                               [______09876543_____________]
           ((in[ 6 + inPos] & 134217727) >>> 13)) & 255);
      out[22 + outPos] = (byte)((
          //                                     [76543210]
          //                       [______________21098765_____]
           ((in[ 6 + inPos] & 134217727) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                                     [76543___]
          //               [______________________43210]
           ((in[ 6 + inPos] & 134217727) <<  3)
        | //                                     [_____210]
          //                                          [654________________________]
           ((in[ 7 + inPos] & 134217727) >>> 24)) & 255);
      out[24 + outPos] = (byte)((
          //                                     [76543210]
          //                                  [___32109876________________]
           ((in[ 7 + inPos] & 134217727) >>> 16)) & 255);
      out[25 + outPos] = (byte)((
          //                                     [76543210]
          //                          [___________54321098________]
           ((in[ 7 + inPos] & 134217727) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                                     [76543210]
          //                  [___________________76543210]
           ((in[ 7 + inPos] & 134217727))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                     [76543210]
          //                                     [65432109___________________]
           ((in[ 0 + inPos] & 134217727) >>> 19)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                     [76543210]
          //                             [________87654321___________]
           ((in[ 0 + inPos] & 134217727) >>> 11)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                     [76543210]
          //                     [________________09876543___]
           ((in[ 0 + inPos] & 134217727) >>> 3)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                     [765_____]
          //             [________________________210]
           ((in[ 0 + inPos] & 134217727) <<  5)
        | //                                     [___43210]
          //                                        [65432______________________]
           ((in[ 1 + inPos] & 134217727) >>> 22)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                     [76543210]
          //                                [_____10987654______________]
           ((in[ 1 + inPos] & 134217727) >>> 14)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                     [76543210]
          //                        [_____________32109876______]
           ((in[ 1 + inPos] & 134217727) >>> 6)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                     [765432__]
          //                [_____________________543210]
           ((in[ 1 + inPos] & 134217727) <<  2)
        | //                                     [______10]
          //                                           [65_________________________]
           ((in[ 2 + inPos] & 134217727) >>> 25)) & 255);
      out[ 7 + outPos] = (byte)((
          //                                     [76543210]
          //                                   [__43210987_________________]
           ((in[ 2 + inPos] & 134217727) >>> 17)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                     [76543210]
          //                           [__________65432109_________]
           ((in[ 2 + inPos] & 134217727) >>> 9)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                     [76543210]
          //                   [__________________87654321_]
           ((in[ 2 + inPos] & 134217727) >>> 1)) & 255);
      out[10 + outPos] = (byte)((
          //                                     [7_______]
          //           [__________________________0]
           ((in[ 2 + inPos] & 134217727) <<  7)
        | //                                     [_6543210]
          //                                      [6543210____________________]
           ((in[ 3 + inPos] & 134217727) >>> 20)) & 255);
      out[11 + outPos] = (byte)((
          //                                     [76543210]
          //                              [_______98765432____________]
           ((in[ 3 + inPos] & 134217727) >>> 12)) & 255);
      out[12 + outPos] = (byte)((
          //                                     [76543210]
          //                      [_______________10987654____]
           ((in[ 3 + inPos] & 134217727) >>> 4)) & 255);
      out[13 + outPos] = (byte)((
          //                                     [7654____]
          //              [_______________________3210]
           ((in[ 3 + inPos] & 134217727) <<  4)
        | //                                     [____3210]
          //                                         [6543_______________________]
           ((in[ 4 + inPos] & 134217727) >>> 23)) & 255);
      out[14 + outPos] = (byte)((
          //                                     [76543210]
          //                                 [____21098765_______________]
           ((in[ 4 + inPos] & 134217727) >>> 15)) & 255);
      out[15 + outPos] = (byte)((
          //                                     [76543210]
          //                         [____________43210987_______]
           ((in[ 4 + inPos] & 134217727) >>> 7)) & 255);
      out[16 + outPos] = (byte)((
          //                                     [7654321_]
          //                 [____________________6543210]
           ((in[ 4 + inPos] & 134217727) <<  1)
        | //                                     [_______0]
          //                                            [6__________________________]
           ((in[ 5 + inPos] & 134217727) >>> 26)) & 255);
      out[17 + outPos] = (byte)((
          //                                     [76543210]
          //                                    [_54321098__________________]
           ((in[ 5 + inPos] & 134217727) >>> 18)) & 255);
      out[18 + outPos] = (byte)((
          //                                     [76543210]
          //                            [_________76543210__________]
           ((in[ 5 + inPos] & 134217727) >>> 10)) & 255);
      out[19 + outPos] = (byte)((
          //                                     [76543210]
          //                    [_________________98765432__]
           ((in[ 5 + inPos] & 134217727) >>> 2)) & 255);
      out[20 + outPos] = (byte)((
          //                                     [76______]
          //            [_________________________10]
           ((in[ 5 + inPos] & 134217727) <<  6)
        | //                                     [__543210]
          //                                       [654321_____________________]
           ((in[ 6 + inPos] & 134217727) >>> 21)) & 255);
      out[21 + outPos] = (byte)((
          //                                     [76543210]
          //                               [______09876543_____________]
           ((in[ 6 + inPos] & 134217727) >>> 13)) & 255);
      out[22 + outPos] = (byte)((
          //                                     [76543210]
          //                       [______________21098765_____]
           ((in[ 6 + inPos] & 134217727) >>> 5)) & 255);
      out[23 + outPos] = (byte)((
          //                                     [76543___]
          //               [______________________43210]
           ((in[ 6 + inPos] & 134217727) <<  3)
        | //                                     [_____210]
          //                                          [654________________________]
           ((in[ 7 + inPos] & 134217727) >>> 24)) & 255);
      out[24 + outPos] = (byte)((
          //                                     [76543210]
          //                                  [___32109876________________]
           ((in[ 7 + inPos] & 134217727) >>> 16)) & 255);
      out[25 + outPos] = (byte)((
          //                                     [76543210]
          //                          [___________54321098________]
           ((in[ 7 + inPos] & 134217727) >>> 8)) & 255);
      out[26 + outPos] = (byte)((
          //                                     [76543210]
          //                  [___________________76543210]
           ((in[ 7 + inPos] & 134217727))) & 255);
      out[27 + outPos] = (byte)((
          //                                     [76543210]
          //                                     [65432109___________________]
           ((in[ 8 + inPos] & 134217727) >>> 19)) & 255);
      out[28 + outPos] = (byte)((
          //                                     [76543210]
          //                             [________87654321___________]
           ((in[ 8 + inPos] & 134217727) >>> 11)) & 255);
      out[29 + outPos] = (byte)((
          //                                     [76543210]
          //                     [________________09876543___]
           ((in[ 8 + inPos] & 134217727) >>> 3)) & 255);
      out[30 + outPos] = (byte)((
          //                                     [765_____]
          //             [________________________210]
           ((in[ 8 + inPos] & 134217727) <<  5)
        | //                                     [___43210]
          //                                        [65432______________________]
           ((in[ 9 + inPos] & 134217727) >>> 22)) & 255);
      out[31 + outPos] = (byte)((
          //                                     [76543210]
          //                                [_____10987654______________]
           ((in[ 9 + inPos] & 134217727) >>> 14)) & 255);
      out[32 + outPos] = (byte)((
          //                                     [76543210]
          //                        [_____________32109876______]
           ((in[ 9 + inPos] & 134217727) >>> 6)) & 255);
      out[33 + outPos] = (byte)((
          //                                     [765432__]
          //                [_____________________543210]
           ((in[ 9 + inPos] & 134217727) <<  2)
        | //                                     [______10]
          //                                           [65_________________________]
           ((in[10 + inPos] & 134217727) >>> 25)) & 255);
      out[34 + outPos] = (byte)((
          //                                     [76543210]
          //                                   [__43210987_________________]
           ((in[10 + inPos] & 134217727) >>> 17)) & 255);
      out[35 + outPos] = (byte)((
          //                                     [76543210]
          //                           [__________65432109_________]
           ((in[10 + inPos] & 134217727) >>> 9)) & 255);
      out[36 + outPos] = (byte)((
          //                                     [76543210]
          //                   [__________________87654321_]
           ((in[10 + inPos] & 134217727) >>> 1)) & 255);
      out[37 + outPos] = (byte)((
          //                                     [7_______]
          //           [__________________________0]
           ((in[10 + inPos] & 134217727) <<  7)
        | //                                     [_6543210]
          //                                      [6543210____________________]
           ((in[11 + inPos] & 134217727) >>> 20)) & 255);
      out[38 + outPos] = (byte)((
          //                                     [76543210]
          //                              [_______98765432____________]
           ((in[11 + inPos] & 134217727) >>> 12)) & 255);
      out[39 + outPos] = (byte)((
          //                                     [76543210]
          //                      [_______________10987654____]
           ((in[11 + inPos] & 134217727) >>> 4)) & 255);
      out[40 + outPos] = (byte)((
          //                                     [7654____]
          //              [_______________________3210]
           ((in[11 + inPos] & 134217727) <<  4)
        | //                                     [____3210]
          //                                         [6543_______________________]
           ((in[12 + inPos] & 134217727) >>> 23)) & 255);
      out[41 + outPos] = (byte)((
          //                                     [76543210]
          //                                 [____21098765_______________]
           ((in[12 + inPos] & 134217727) >>> 15)) & 255);
      out[42 + outPos] = (byte)((
          //                                     [76543210]
          //                         [____________43210987_______]
           ((in[12 + inPos] & 134217727) >>> 7)) & 255);
      out[43 + outPos] = (byte)((
          //                                     [7654321_]
          //                 [____________________6543210]
           ((in[12 + inPos] & 134217727) <<  1)
        | //                                     [_______0]
          //                                            [6__________________________]
           ((in[13 + inPos] & 134217727) >>> 26)) & 255);
      out[44 + outPos] = (byte)((
          //                                     [76543210]
          //                                    [_54321098__________________]
           ((in[13 + inPos] & 134217727) >>> 18)) & 255);
      out[45 + outPos] = (byte)((
          //                                     [76543210]
          //                            [_________76543210__________]
           ((in[13 + inPos] & 134217727) >>> 10)) & 255);
      out[46 + outPos] = (byte)((
          //                                     [76543210]
          //                    [_________________98765432__]
           ((in[13 + inPos] & 134217727) >>> 2)) & 255);
      out[47 + outPos] = (byte)((
          //                                     [76______]
          //            [_________________________10]
           ((in[13 + inPos] & 134217727) <<  6)
        | //                                     [__543210]
          //                                       [654321_____________________]
           ((in[14 + inPos] & 134217727) >>> 21)) & 255);
      out[48 + outPos] = (byte)((
          //                                     [76543210]
          //                               [______09876543_____________]
           ((in[14 + inPos] & 134217727) >>> 13)) & 255);
      out[49 + outPos] = (byte)((
          //                                     [76543210]
          //                       [______________21098765_____]
           ((in[14 + inPos] & 134217727) >>> 5)) & 255);
      out[50 + outPos] = (byte)((
          //                                     [76543___]
          //               [______________________43210]
           ((in[14 + inPos] & 134217727) <<  3)
        | //                                     [_____210]
          //                                          [654________________________]
           ((in[15 + inPos] & 134217727) >>> 24)) & 255);
      out[51 + outPos] = (byte)((
          //                                     [76543210]
          //                                  [___32109876________________]
           ((in[15 + inPos] & 134217727) >>> 16)) & 255);
      out[52 + outPos] = (byte)((
          //                                     [76543210]
          //                          [___________54321098________]
           ((in[15 + inPos] & 134217727) >>> 8)) & 255);
      out[53 + outPos] = (byte)((
          //                                     [76543210]
          //                  [___________________76543210]
           ((in[15 + inPos] & 134217727))) & 255);
      out[54 + outPos] = (byte)((
          //                                     [76543210]
          //                                     [65432109___________________]
           ((in[16 + inPos] & 134217727) >>> 19)) & 255);
      out[55 + outPos] = (byte)((
          //                                     [76543210]
          //                             [________87654321___________]
           ((in[16 + inPos] & 134217727) >>> 11)) & 255);
      out[56 + outPos] = (byte)((
          //                                     [76543210]
          //                     [________________09876543___]
           ((in[16 + inPos] & 134217727) >>> 3)) & 255);
      out[57 + outPos] = (byte)((
          //                                     [765_____]
          //             [________________________210]
           ((in[16 + inPos] & 134217727) <<  5)
        | //                                     [___43210]
          //                                        [65432______________________]
           ((in[17 + inPos] & 134217727) >>> 22)) & 255);
      out[58 + outPos] = (byte)((
          //                                     [76543210]
          //                                [_____10987654______________]
           ((in[17 + inPos] & 134217727) >>> 14)) & 255);
      out[59 + outPos] = (byte)((
          //                                     [76543210]
          //                        [_____________32109876______]
           ((in[17 + inPos] & 134217727) >>> 6)) & 255);
      out[60 + outPos] = (byte)((
          //                                     [765432__]
          //                [_____________________543210]
           ((in[17 + inPos] & 134217727) <<  2)
        | //                                     [______10]
          //                                           [65_________________________]
           ((in[18 + inPos] & 134217727) >>> 25)) & 255);
      out[61 + outPos] = (byte)((
          //                                     [76543210]
          //                                   [__43210987_________________]
           ((in[18 + inPos] & 134217727) >>> 17)) & 255);
      out[62 + outPos] = (byte)((
          //                                     [76543210]
          //                           [__________65432109_________]
           ((in[18 + inPos] & 134217727) >>> 9)) & 255);
      out[63 + outPos] = (byte)((
          //                                     [76543210]
          //                   [__________________87654321_]
           ((in[18 + inPos] & 134217727) >>> 1)) & 255);
      out[64 + outPos] = (byte)((
          //                                     [7_______]
          //           [__________________________0]
           ((in[18 + inPos] & 134217727) <<  7)
        | //                                     [_6543210]
          //                                      [6543210____________________]
           ((in[19 + inPos] & 134217727) >>> 20)) & 255);
      out[65 + outPos] = (byte)((
          //                                     [76543210]
          //                              [_______98765432____________]
           ((in[19 + inPos] & 134217727) >>> 12)) & 255);
      out[66 + outPos] = (byte)((
          //                                     [76543210]
          //                      [_______________10987654____]
           ((in[19 + inPos] & 134217727) >>> 4)) & 255);
      out[67 + outPos] = (byte)((
          //                                     [7654____]
          //              [_______________________3210]
           ((in[19 + inPos] & 134217727) <<  4)
        | //                                     [____3210]
          //                                         [6543_______________________]
           ((in[20 + inPos] & 134217727) >>> 23)) & 255);
      out[68 + outPos] = (byte)((
          //                                     [76543210]
          //                                 [____21098765_______________]
           ((in[20 + inPos] & 134217727) >>> 15)) & 255);
      out[69 + outPos] = (byte)((
          //                                     [76543210]
          //                         [____________43210987_______]
           ((in[20 + inPos] & 134217727) >>> 7)) & 255);
      out[70 + outPos] = (byte)((
          //                                     [7654321_]
          //                 [____________________6543210]
           ((in[20 + inPos] & 134217727) <<  1)
        | //                                     [_______0]
          //                                            [6__________________________]
           ((in[21 + inPos] & 134217727) >>> 26)) & 255);
      out[71 + outPos] = (byte)((
          //                                     [76543210]
          //                                    [_54321098__________________]
           ((in[21 + inPos] & 134217727) >>> 18)) & 255);
      out[72 + outPos] = (byte)((
          //                                     [76543210]
          //                            [_________76543210__________]
           ((in[21 + inPos] & 134217727) >>> 10)) & 255);
      out[73 + outPos] = (byte)((
          //                                     [76543210]
          //                    [_________________98765432__]
           ((in[21 + inPos] & 134217727) >>> 2)) & 255);
      out[74 + outPos] = (byte)((
          //                                     [76______]
          //            [_________________________10]
           ((in[21 + inPos] & 134217727) <<  6)
        | //                                     [__543210]
          //                                       [654321_____________________]
           ((in[22 + inPos] & 134217727) >>> 21)) & 255);
      out[75 + outPos] = (byte)((
          //                                     [76543210]
          //                               [______09876543_____________]
           ((in[22 + inPos] & 134217727) >>> 13)) & 255);
      out[76 + outPos] = (byte)((
          //                                     [76543210]
          //                       [______________21098765_____]
           ((in[22 + inPos] & 134217727) >>> 5)) & 255);
      out[77 + outPos] = (byte)((
          //                                     [76543___]
          //               [______________________43210]
           ((in[22 + inPos] & 134217727) <<  3)
        | //                                     [_____210]
          //                                          [654________________________]
           ((in[23 + inPos] & 134217727) >>> 24)) & 255);
      out[78 + outPos] = (byte)((
          //                                     [76543210]
          //                                  [___32109876________________]
           ((in[23 + inPos] & 134217727) >>> 16)) & 255);
      out[79 + outPos] = (byte)((
          //                                     [76543210]
          //                          [___________54321098________]
           ((in[23 + inPos] & 134217727) >>> 8)) & 255);
      out[80 + outPos] = (byte)((
          //                                     [76543210]
          //                  [___________________76543210]
           ((in[23 + inPos] & 134217727))) & 255);
      out[81 + outPos] = (byte)((
          //                                     [76543210]
          //                                     [65432109___________________]
           ((in[24 + inPos] & 134217727) >>> 19)) & 255);
      out[82 + outPos] = (byte)((
          //                                     [76543210]
          //                             [________87654321___________]
           ((in[24 + inPos] & 134217727) >>> 11)) & 255);
      out[83 + outPos] = (byte)((
          //                                     [76543210]
          //                     [________________09876543___]
           ((in[24 + inPos] & 134217727) >>> 3)) & 255);
      out[84 + outPos] = (byte)((
          //                                     [765_____]
          //             [________________________210]
           ((in[24 + inPos] & 134217727) <<  5)
        | //                                     [___43210]
          //                                        [65432______________________]
           ((in[25 + inPos] & 134217727) >>> 22)) & 255);
      out[85 + outPos] = (byte)((
          //                                     [76543210]
          //                                [_____10987654______________]
           ((in[25 + inPos] & 134217727) >>> 14)) & 255);
      out[86 + outPos] = (byte)((
          //                                     [76543210]
          //                        [_____________32109876______]
           ((in[25 + inPos] & 134217727) >>> 6)) & 255);
      out[87 + outPos] = (byte)((
          //                                     [765432__]
          //                [_____________________543210]
           ((in[25 + inPos] & 134217727) <<  2)
        | //                                     [______10]
          //                                           [65_________________________]
           ((in[26 + inPos] & 134217727) >>> 25)) & 255);
      out[88 + outPos] = (byte)((
          //                                     [76543210]
          //                                   [__43210987_________________]
           ((in[26 + inPos] & 134217727) >>> 17)) & 255);
      out[89 + outPos] = (byte)((
          //                                     [76543210]
          //                           [__________65432109_________]
           ((in[26 + inPos] & 134217727) >>> 9)) & 255);
      out[90 + outPos] = (byte)((
          //                                     [76543210]
          //                   [__________________87654321_]
           ((in[26 + inPos] & 134217727) >>> 1)) & 255);
      out[91 + outPos] = (byte)((
          //                                     [7_______]
          //           [__________________________0]
           ((in[26 + inPos] & 134217727) <<  7)
        | //                                     [_6543210]
          //                                      [6543210____________________]
           ((in[27 + inPos] & 134217727) >>> 20)) & 255);
      out[92 + outPos] = (byte)((
          //                                     [76543210]
          //                              [_______98765432____________]
           ((in[27 + inPos] & 134217727) >>> 12)) & 255);
      out[93 + outPos] = (byte)((
          //                                     [76543210]
          //                      [_______________10987654____]
           ((in[27 + inPos] & 134217727) >>> 4)) & 255);
      out[94 + outPos] = (byte)((
          //                                     [7654____]
          //              [_______________________3210]
           ((in[27 + inPos] & 134217727) <<  4)
        | //                                     [____3210]
          //                                         [6543_______________________]
           ((in[28 + inPos] & 134217727) >>> 23)) & 255);
      out[95 + outPos] = (byte)((
          //                                     [76543210]
          //                                 [____21098765_______________]
           ((in[28 + inPos] & 134217727) >>> 15)) & 255);
      out[96 + outPos] = (byte)((
          //                                     [76543210]
          //                         [____________43210987_______]
           ((in[28 + inPos] & 134217727) >>> 7)) & 255);
      out[97 + outPos] = (byte)((
          //                                     [7654321_]
          //                 [____________________6543210]
           ((in[28 + inPos] & 134217727) <<  1)
        | //                                     [_______0]
          //                                            [6__________________________]
           ((in[29 + inPos] & 134217727) >>> 26)) & 255);
      out[98 + outPos] = (byte)((
          //                                     [76543210]
          //                                    [_54321098__________________]
           ((in[29 + inPos] & 134217727) >>> 18)) & 255);
      out[99 + outPos] = (byte)((
          //                                     [76543210]
          //                            [_________76543210__________]
           ((in[29 + inPos] & 134217727) >>> 10)) & 255);
      out[100 + outPos] = (byte)((
          //                                     [76543210]
          //                    [_________________98765432__]
           ((in[29 + inPos] & 134217727) >>> 2)) & 255);
      out[101 + outPos] = (byte)((
          //                                     [76______]
          //            [_________________________10]
           ((in[29 + inPos] & 134217727) <<  6)
        | //                                     [__543210]
          //                                       [654321_____________________]
           ((in[30 + inPos] & 134217727) >>> 21)) & 255);
      out[102 + outPos] = (byte)((
          //                                     [76543210]
          //                               [______09876543_____________]
           ((in[30 + inPos] & 134217727) >>> 13)) & 255);
      out[103 + outPos] = (byte)((
          //                                     [76543210]
          //                       [______________21098765_____]
           ((in[30 + inPos] & 134217727) >>> 5)) & 255);
      out[104 + outPos] = (byte)((
          //                                     [76543___]
          //               [______________________43210]
           ((in[30 + inPos] & 134217727) <<  3)
        | //                                     [_____210]
          //                                          [654________________________]
           ((in[31 + inPos] & 134217727) >>> 24)) & 255);
      out[105 + outPos] = (byte)((
          //                                     [76543210]
          //                                  [___32109876________________]
           ((in[31 + inPos] & 134217727) >>> 16)) & 255);
      out[106 + outPos] = (byte)((
          //                                     [76543210]
          //                          [___________54321098________]
           ((in[31 + inPos] & 134217727) >>> 8)) & 255);
      out[107 + outPos] = (byte)((
          //                                     [76543210]
          //                  [___________________76543210]
           ((in[31 + inPos] & 134217727))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                     [76543210]
          //                                     [65432109___________________]
            (((((int)in[ 0 + inPos]) & 255) <<  19) & 134217727)
        | //                                     [76543210]
          //                             [________87654321___________]
            (((((int)in[ 1 + inPos]) & 255) <<  11) & 134217727)
        | //                                     [76543210]
          //                     [________________09876543___]
            (((((int)in[ 2 + inPos]) & 255) <<  3) & 134217727)
        | //                                     [765_____]
          //             [________________________210]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 134217727);
      out[ 1 + outPos] =
          //                                     [___43210]
          //                                        [65432______________________]
            (((((int)in[ 3 + inPos]) & 255) <<  22) & 134217727)
        | //                                     [76543210]
          //                                [_____10987654______________]
            (((((int)in[ 4 + inPos]) & 255) <<  14) & 134217727)
        | //                                     [76543210]
          //                        [_____________32109876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 134217727)
        | //                                     [765432__]
          //                [_____________________543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 134217727);
      out[ 2 + outPos] =
          //                                     [______10]
          //                                           [65_________________________]
            (((((int)in[ 6 + inPos]) & 255) <<  25) & 134217727)
        | //                                     [76543210]
          //                                   [__43210987_________________]
            (((((int)in[ 7 + inPos]) & 255) <<  17) & 134217727)
        | //                                     [76543210]
          //                           [__________65432109_________]
            (((((int)in[ 8 + inPos]) & 255) <<  9) & 134217727)
        | //                                     [76543210]
          //                   [__________________87654321_]
            (((((int)in[ 9 + inPos]) & 255) <<  1) & 134217727)
        | //                                     [7_______]
          //           [__________________________0]
            (((((int)in[10 + inPos]) & 255) >>>  7) & 134217727);
      out[ 3 + outPos] =
          //                                     [_6543210]
          //                                      [6543210____________________]
            (((((int)in[10 + inPos]) & 255) <<  20) & 134217727)
        | //                                     [76543210]
          //                              [_______98765432____________]
            (((((int)in[11 + inPos]) & 255) <<  12) & 134217727)
        | //                                     [76543210]
          //                      [_______________10987654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 134217727)
        | //                                     [7654____]
          //              [_______________________3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 134217727);
      out[ 4 + outPos] =
          //                                     [____3210]
          //                                         [6543_______________________]
            (((((int)in[13 + inPos]) & 255) <<  23) & 134217727)
        | //                                     [76543210]
          //                                 [____21098765_______________]
            (((((int)in[14 + inPos]) & 255) <<  15) & 134217727)
        | //                                     [76543210]
          //                         [____________43210987_______]
            (((((int)in[15 + inPos]) & 255) <<  7) & 134217727)
        | //                                     [7654321_]
          //                 [____________________6543210]
            (((((int)in[16 + inPos]) & 255) >>>  1) & 134217727);
      out[ 5 + outPos] =
          //                                     [_______0]
          //                                            [6__________________________]
            (((((int)in[16 + inPos]) & 255) <<  26) & 134217727)
        | //                                     [76543210]
          //                                    [_54321098__________________]
            (((((int)in[17 + inPos]) & 255) <<  18) & 134217727)
        | //                                     [76543210]
          //                            [_________76543210__________]
            (((((int)in[18 + inPos]) & 255) <<  10) & 134217727)
        | //                                     [76543210]
          //                    [_________________98765432__]
            (((((int)in[19 + inPos]) & 255) <<  2) & 134217727)
        | //                                     [76______]
          //            [_________________________10]
            (((((int)in[20 + inPos]) & 255) >>>  6) & 134217727);
      out[ 6 + outPos] =
          //                                     [__543210]
          //                                       [654321_____________________]
            (((((int)in[20 + inPos]) & 255) <<  21) & 134217727)
        | //                                     [76543210]
          //                               [______09876543_____________]
            (((((int)in[21 + inPos]) & 255) <<  13) & 134217727)
        | //                                     [76543210]
          //                       [______________21098765_____]
            (((((int)in[22 + inPos]) & 255) <<  5) & 134217727)
        | //                                     [76543___]
          //               [______________________43210]
            (((((int)in[23 + inPos]) & 255) >>>  3) & 134217727);
      out[ 7 + outPos] =
          //                                     [_____210]
          //                                          [654________________________]
            (((((int)in[23 + inPos]) & 255) <<  24) & 134217727)
        | //                                     [76543210]
          //                                  [___32109876________________]
            (((((int)in[24 + inPos]) & 255) <<  16) & 134217727)
        | //                                     [76543210]
          //                          [___________54321098________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 134217727)
        | //                                     [76543210]
          //                  [___________________76543210]
            (((((int)in[26 + inPos]) & 255) ) & 134217727);
    }
    public final void unpack32Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                     [76543210]
          //                                     [65432109___________________]
            (((((int)in[ 0 + inPos]) & 255) <<  19) & 134217727)
        | //                                     [76543210]
          //                             [________87654321___________]
            (((((int)in[ 1 + inPos]) & 255) <<  11) & 134217727)
        | //                                     [76543210]
          //                     [________________09876543___]
            (((((int)in[ 2 + inPos]) & 255) <<  3) & 134217727)
        | //                                     [765_____]
          //             [________________________210]
            (((((int)in[ 3 + inPos]) & 255) >>>  5) & 134217727);
      out[ 1 + outPos] =
          //                                     [___43210]
          //                                        [65432______________________]
            (((((int)in[ 3 + inPos]) & 255) <<  22) & 134217727)
        | //                                     [76543210]
          //                                [_____10987654______________]
            (((((int)in[ 4 + inPos]) & 255) <<  14) & 134217727)
        | //                                     [76543210]
          //                        [_____________32109876______]
            (((((int)in[ 5 + inPos]) & 255) <<  6) & 134217727)
        | //                                     [765432__]
          //                [_____________________543210]
            (((((int)in[ 6 + inPos]) & 255) >>>  2) & 134217727);
      out[ 2 + outPos] =
          //                                     [______10]
          //                                           [65_________________________]
            (((((int)in[ 6 + inPos]) & 255) <<  25) & 134217727)
        | //                                     [76543210]
          //                                   [__43210987_________________]
            (((((int)in[ 7 + inPos]) & 255) <<  17) & 134217727)
        | //                                     [76543210]
          //                           [__________65432109_________]
            (((((int)in[ 8 + inPos]) & 255) <<  9) & 134217727)
        | //                                     [76543210]
          //                   [__________________87654321_]
            (((((int)in[ 9 + inPos]) & 255) <<  1) & 134217727)
        | //                                     [7_______]
          //           [__________________________0]
            (((((int)in[10 + inPos]) & 255) >>>  7) & 134217727);
      out[ 3 + outPos] =
          //                                     [_6543210]
          //                                      [6543210____________________]
            (((((int)in[10 + inPos]) & 255) <<  20) & 134217727)
        | //                                     [76543210]
          //                              [_______98765432____________]
            (((((int)in[11 + inPos]) & 255) <<  12) & 134217727)
        | //                                     [76543210]
          //                      [_______________10987654____]
            (((((int)in[12 + inPos]) & 255) <<  4) & 134217727)
        | //                                     [7654____]
          //              [_______________________3210]
            (((((int)in[13 + inPos]) & 255) >>>  4) & 134217727);
      out[ 4 + outPos] =
          //                                     [____3210]
          //                                         [6543_______________________]
            (((((int)in[13 + inPos]) & 255) <<  23) & 134217727)
        | //                                     [76543210]
          //                                 [____21098765_______________]
            (((((int)in[14 + inPos]) & 255) <<  15) & 134217727)
        | //                                     [76543210]
          //                         [____________43210987_______]
            (((((int)in[15 + inPos]) & 255) <<  7) & 134217727)
        | //                                     [7654321_]
          //                 [____________________6543210]
            (((((int)in[16 + inPos]) & 255) >>>  1) & 134217727);
      out[ 5 + outPos] =
          //                                     [_______0]
          //                                            [6__________________________]
            (((((int)in[16 + inPos]) & 255) <<  26) & 134217727)
        | //                                     [76543210]
          //                                    [_54321098__________________]
            (((((int)in[17 + inPos]) & 255) <<  18) & 134217727)
        | //                                     [76543210]
          //                            [_________76543210__________]
            (((((int)in[18 + inPos]) & 255) <<  10) & 134217727)
        | //                                     [76543210]
          //                    [_________________98765432__]
            (((((int)in[19 + inPos]) & 255) <<  2) & 134217727)
        | //                                     [76______]
          //            [_________________________10]
            (((((int)in[20 + inPos]) & 255) >>>  6) & 134217727);
      out[ 6 + outPos] =
          //                                     [__543210]
          //                                       [654321_____________________]
            (((((int)in[20 + inPos]) & 255) <<  21) & 134217727)
        | //                                     [76543210]
          //                               [______09876543_____________]
            (((((int)in[21 + inPos]) & 255) <<  13) & 134217727)
        | //                                     [76543210]
          //                       [______________21098765_____]
            (((((int)in[22 + inPos]) & 255) <<  5) & 134217727)
        | //                                     [76543___]
          //               [______________________43210]
            (((((int)in[23 + inPos]) & 255) >>>  3) & 134217727);
      out[ 7 + outPos] =
          //                                     [_____210]
          //                                          [654________________________]
            (((((int)in[23 + inPos]) & 255) <<  24) & 134217727)
        | //                                     [76543210]
          //                                  [___32109876________________]
            (((((int)in[24 + inPos]) & 255) <<  16) & 134217727)
        | //                                     [76543210]
          //                          [___________54321098________]
            (((((int)in[25 + inPos]) & 255) <<  8) & 134217727)
        | //                                     [76543210]
          //                  [___________________76543210]
            (((((int)in[26 + inPos]) & 255) ) & 134217727);
      out[ 8 + outPos] =
          //                                     [76543210]
          //                                     [65432109___________________]
            (((((int)in[27 + inPos]) & 255) <<  19) & 134217727)
        | //                                     [76543210]
          //                             [________87654321___________]
            (((((int)in[28 + inPos]) & 255) <<  11) & 134217727)
        | //                                     [76543210]
          //                     [________________09876543___]
            (((((int)in[29 + inPos]) & 255) <<  3) & 134217727)
        | //                                     [765_____]
          //             [________________________210]
            (((((int)in[30 + inPos]) & 255) >>>  5) & 134217727);
      out[ 9 + outPos] =
          //                                     [___43210]
          //                                        [65432______________________]
            (((((int)in[30 + inPos]) & 255) <<  22) & 134217727)
        | //                                     [76543210]
          //                                [_____10987654______________]
            (((((int)in[31 + inPos]) & 255) <<  14) & 134217727)
        | //                                     [76543210]
          //                        [_____________32109876______]
            (((((int)in[32 + inPos]) & 255) <<  6) & 134217727)
        | //                                     [765432__]
          //                [_____________________543210]
            (((((int)in[33 + inPos]) & 255) >>>  2) & 134217727);
      out[10 + outPos] =
          //                                     [______10]
          //                                           [65_________________________]
            (((((int)in[33 + inPos]) & 255) <<  25) & 134217727)
        | //                                     [76543210]
          //                                   [__43210987_________________]
            (((((int)in[34 + inPos]) & 255) <<  17) & 134217727)
        | //                                     [76543210]
          //                           [__________65432109_________]
            (((((int)in[35 + inPos]) & 255) <<  9) & 134217727)
        | //                                     [76543210]
          //                   [__________________87654321_]
            (((((int)in[36 + inPos]) & 255) <<  1) & 134217727)
        | //                                     [7_______]
          //           [__________________________0]
            (((((int)in[37 + inPos]) & 255) >>>  7) & 134217727);
      out[11 + outPos] =
          //                                     [_6543210]
          //                                      [6543210____________________]
            (((((int)in[37 + inPos]) & 255) <<  20) & 134217727)
        | //                                     [76543210]
          //                              [_______98765432____________]
            (((((int)in[38 + inPos]) & 255) <<  12) & 134217727)
        | //                                     [76543210]
          //                      [_______________10987654____]
            (((((int)in[39 + inPos]) & 255) <<  4) & 134217727)
        | //                                     [7654____]
          //              [_______________________3210]
            (((((int)in[40 + inPos]) & 255) >>>  4) & 134217727);
      out[12 + outPos] =
          //                                     [____3210]
          //                                         [6543_______________________]
            (((((int)in[40 + inPos]) & 255) <<  23) & 134217727)
        | //                                     [76543210]
          //                                 [____21098765_______________]
            (((((int)in[41 + inPos]) & 255) <<  15) & 134217727)
        | //                                     [76543210]
          //                         [____________43210987_______]
            (((((int)in[42 + inPos]) & 255) <<  7) & 134217727)
        | //                                     [7654321_]
          //                 [____________________6543210]
            (((((int)in[43 + inPos]) & 255) >>>  1) & 134217727);
      out[13 + outPos] =
          //                                     [_______0]
          //                                            [6__________________________]
            (((((int)in[43 + inPos]) & 255) <<  26) & 134217727)
        | //                                     [76543210]
          //                                    [_54321098__________________]
            (((((int)in[44 + inPos]) & 255) <<  18) & 134217727)
        | //                                     [76543210]
          //                            [_________76543210__________]
            (((((int)in[45 + inPos]) & 255) <<  10) & 134217727)
        | //                                     [76543210]
          //                    [_________________98765432__]
            (((((int)in[46 + inPos]) & 255) <<  2) & 134217727)
        | //                                     [76______]
          //            [_________________________10]
            (((((int)in[47 + inPos]) & 255) >>>  6) & 134217727);
      out[14 + outPos] =
          //                                     [__543210]
          //                                       [654321_____________________]
            (((((int)in[47 + inPos]) & 255) <<  21) & 134217727)
        | //                                     [76543210]
          //                               [______09876543_____________]
            (((((int)in[48 + inPos]) & 255) <<  13) & 134217727)
        | //                                     [76543210]
          //                       [______________21098765_____]
            (((((int)in[49 + inPos]) & 255) <<  5) & 134217727)
        | //                                     [76543___]
          //               [______________________43210]
            (((((int)in[50 + inPos]) & 255) >>>  3) & 134217727);
      out[15 + outPos] =
          //                                     [_____210]
          //                                          [654________________________]
            (((((int)in[50 + inPos]) & 255) <<  24) & 134217727)
        | //                                     [76543210]
          //                                  [___32109876________________]
            (((((int)in[51 + inPos]) & 255) <<  16) & 134217727)
        | //                                     [76543210]
          //                          [___________54321098________]
            (((((int)in[52 + inPos]) & 255) <<  8) & 134217727)
        | //                                     [76543210]
          //                  [___________________76543210]
            (((((int)in[53 + inPos]) & 255) ) & 134217727);
      out[16 + outPos] =
          //                                     [76543210]
          //                                     [65432109___________________]
            (((((int)in[54 + inPos]) & 255) <<  19) & 134217727)
        | //                                     [76543210]
          //                             [________87654321___________]
            (((((int)in[55 + inPos]) & 255) <<  11) & 134217727)
        | //                                     [76543210]
          //                     [________________09876543___]
            (((((int)in[56 + inPos]) & 255) <<  3) & 134217727)
        | //                                     [765_____]
          //             [________________________210]
            (((((int)in[57 + inPos]) & 255) >>>  5) & 134217727);
      out[17 + outPos] =
          //                                     [___43210]
          //                                        [65432______________________]
            (((((int)in[57 + inPos]) & 255) <<  22) & 134217727)
        | //                                     [76543210]
          //                                [_____10987654______________]
            (((((int)in[58 + inPos]) & 255) <<  14) & 134217727)
        | //                                     [76543210]
          //                        [_____________32109876______]
            (((((int)in[59 + inPos]) & 255) <<  6) & 134217727)
        | //                                     [765432__]
          //                [_____________________543210]
            (((((int)in[60 + inPos]) & 255) >>>  2) & 134217727);
      out[18 + outPos] =
          //                                     [______10]
          //                                           [65_________________________]
            (((((int)in[60 + inPos]) & 255) <<  25) & 134217727)
        | //                                     [76543210]
          //                                   [__43210987_________________]
            (((((int)in[61 + inPos]) & 255) <<  17) & 134217727)
        | //                                     [76543210]
          //                           [__________65432109_________]
            (((((int)in[62 + inPos]) & 255) <<  9) & 134217727)
        | //                                     [76543210]
          //                   [__________________87654321_]
            (((((int)in[63 + inPos]) & 255) <<  1) & 134217727)
        | //                                     [7_______]
          //           [__________________________0]
            (((((int)in[64 + inPos]) & 255) >>>  7) & 134217727);
      out[19 + outPos] =
          //                                     [_6543210]
          //                                      [6543210____________________]
            (((((int)in[64 + inPos]) & 255) <<  20) & 134217727)
        | //                                     [76543210]
          //                              [_______98765432____________]
            (((((int)in[65 + inPos]) & 255) <<  12) & 134217727)
        | //                                     [76543210]
          //                      [_______________10987654____]
            (((((int)in[66 + inPos]) & 255) <<  4) & 134217727)
        | //                                     [7654____]
          //              [_______________________3210]
            (((((int)in[67 + inPos]) & 255) >>>  4) & 134217727);
      out[20 + outPos] =
          //                                     [____3210]
          //                                         [6543_______________________]
            (((((int)in[67 + inPos]) & 255) <<  23) & 134217727)
        | //                                     [76543210]
          //                                 [____21098765_______________]
            (((((int)in[68 + inPos]) & 255) <<  15) & 134217727)
        | //                                     [76543210]
          //                         [____________43210987_______]
            (((((int)in[69 + inPos]) & 255) <<  7) & 134217727)
        | //                                     [7654321_]
          //                 [____________________6543210]
            (((((int)in[70 + inPos]) & 255) >>>  1) & 134217727);
      out[21 + outPos] =
          //                                     [_______0]
          //                                            [6__________________________]
            (((((int)in[70 + inPos]) & 255) <<  26) & 134217727)
        | //                                     [76543210]
          //                                    [_54321098__________________]
            (((((int)in[71 + inPos]) & 255) <<  18) & 134217727)
        | //                                     [76543210]
          //                            [_________76543210__________]
            (((((int)in[72 + inPos]) & 255) <<  10) & 134217727)
        | //                                     [76543210]
          //                    [_________________98765432__]
            (((((int)in[73 + inPos]) & 255) <<  2) & 134217727)
        | //                                     [76______]
          //            [_________________________10]
            (((((int)in[74 + inPos]) & 255) >>>  6) & 134217727);
      out[22 + outPos] =
          //                                     [__543210]
          //                                       [654321_____________________]
            (((((int)in[74 + inPos]) & 255) <<  21) & 134217727)
        | //                                     [76543210]
          //                               [______09876543_____________]
            (((((int)in[75 + inPos]) & 255) <<  13) & 134217727)
        | //                                     [76543210]
          //                       [______________21098765_____]
            (((((int)in[76 + inPos]) & 255) <<  5) & 134217727)
        | //                                     [76543___]
          //               [______________________43210]
            (((((int)in[77 + inPos]) & 255) >>>  3) & 134217727);
      out[23 + outPos] =
          //                                     [_____210]
          //                                          [654________________________]
            (((((int)in[77 + inPos]) & 255) <<  24) & 134217727)
        | //                                     [76543210]
          //                                  [___32109876________________]
            (((((int)in[78 + inPos]) & 255) <<  16) & 134217727)
        | //                                     [76543210]
          //                          [___________54321098________]
            (((((int)in[79 + inPos]) & 255) <<  8) & 134217727)
        | //                                     [76543210]
          //                  [___________________76543210]
            (((((int)in[80 + inPos]) & 255) ) & 134217727);
      out[24 + outPos] =
          //                                     [76543210]
          //                                     [65432109___________________]
            (((((int)in[81 + inPos]) & 255) <<  19) & 134217727)
        | //                                     [76543210]
          //                             [________87654321___________]
            (((((int)in[82 + inPos]) & 255) <<  11) & 134217727)
        | //                                     [76543210]
          //                     [________________09876543___]
            (((((int)in[83 + inPos]) & 255) <<  3) & 134217727)
        | //                                     [765_____]
          //             [________________________210]
            (((((int)in[84 + inPos]) & 255) >>>  5) & 134217727);
      out[25 + outPos] =
          //                                     [___43210]
          //                                        [65432______________________]
            (((((int)in[84 + inPos]) & 255) <<  22) & 134217727)
        | //                                     [76543210]
          //                                [_____10987654______________]
            (((((int)in[85 + inPos]) & 255) <<  14) & 134217727)
        | //                                     [76543210]
          //                        [_____________32109876______]
            (((((int)in[86 + inPos]) & 255) <<  6) & 134217727)
        | //                                     [765432__]
          //                [_____________________543210]
            (((((int)in[87 + inPos]) & 255) >>>  2) & 134217727);
      out[26 + outPos] =
          //                                     [______10]
          //                                           [65_________________________]
            (((((int)in[87 + inPos]) & 255) <<  25) & 134217727)
        | //                                     [76543210]
          //                                   [__43210987_________________]
            (((((int)in[88 + inPos]) & 255) <<  17) & 134217727)
        | //                                     [76543210]
          //                           [__________65432109_________]
            (((((int)in[89 + inPos]) & 255) <<  9) & 134217727)
        | //                                     [76543210]
          //                   [__________________87654321_]
            (((((int)in[90 + inPos]) & 255) <<  1) & 134217727)
        | //                                     [7_______]
          //           [__________________________0]
            (((((int)in[91 + inPos]) & 255) >>>  7) & 134217727);
      out[27 + outPos] =
          //                                     [_6543210]
          //                                      [6543210____________________]
            (((((int)in[91 + inPos]) & 255) <<  20) & 134217727)
        | //                                     [76543210]
          //                              [_______98765432____________]
            (((((int)in[92 + inPos]) & 255) <<  12) & 134217727)
        | //                                     [76543210]
          //                      [_______________10987654____]
            (((((int)in[93 + inPos]) & 255) <<  4) & 134217727)
        | //                                     [7654____]
          //              [_______________________3210]
            (((((int)in[94 + inPos]) & 255) >>>  4) & 134217727);
      out[28 + outPos] =
          //                                     [____3210]
          //                                         [6543_______________________]
            (((((int)in[94 + inPos]) & 255) <<  23) & 134217727)
        | //                                     [76543210]
          //                                 [____21098765_______________]
            (((((int)in[95 + inPos]) & 255) <<  15) & 134217727)
        | //                                     [76543210]
          //                         [____________43210987_______]
            (((((int)in[96 + inPos]) & 255) <<  7) & 134217727)
        | //                                     [7654321_]
          //                 [____________________6543210]
            (((((int)in[97 + inPos]) & 255) >>>  1) & 134217727);
      out[29 + outPos] =
          //                                     [_______0]
          //                                            [6__________________________]
            (((((int)in[97 + inPos]) & 255) <<  26) & 134217727)
        | //                                     [76543210]
          //                                    [_54321098__________________]
            (((((int)in[98 + inPos]) & 255) <<  18) & 134217727)
        | //                                     [76543210]
          //                            [_________76543210__________]
            (((((int)in[99 + inPos]) & 255) <<  10) & 134217727)
        | //                                     [76543210]
          //                    [_________________98765432__]
            (((((int)in[100 + inPos]) & 255) <<  2) & 134217727)
        | //                                     [76______]
          //            [_________________________10]
            (((((int)in[101 + inPos]) & 255) >>>  6) & 134217727);
      out[30 + outPos] =
          //                                     [__543210]
          //                                       [654321_____________________]
            (((((int)in[101 + inPos]) & 255) <<  21) & 134217727)
        | //                                     [76543210]
          //                               [______09876543_____________]
            (((((int)in[102 + inPos]) & 255) <<  13) & 134217727)
        | //                                     [76543210]
          //                       [______________21098765_____]
            (((((int)in[103 + inPos]) & 255) <<  5) & 134217727)
        | //                                     [76543___]
          //               [______________________43210]
            (((((int)in[104 + inPos]) & 255) >>>  3) & 134217727);
      out[31 + outPos] =
          //                                     [_____210]
          //                                          [654________________________]
            (((((int)in[104 + inPos]) & 255) <<  24) & 134217727)
        | //                                     [76543210]
          //                                  [___32109876________________]
            (((((int)in[105 + inPos]) & 255) <<  16) & 134217727)
        | //                                     [76543210]
          //                          [___________54321098________]
            (((((int)in[106 + inPos]) & 255) <<  8) & 134217727)
        | //                                     [76543210]
          //                  [___________________76543210]
            (((((int)in[107 + inPos]) & 255) ) & 134217727);
    }
  }

  private static final class Packer28 extends BytePacker {

    private Packer28() {
      super(28);
    }

    public final void pack8Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 0 + inPos] & 268435455) >>> 20)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 0 + inPos] & 268435455) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 0 + inPos] & 268435455) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 0 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 1 + inPos] & 268435455) >>> 24)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 1 + inPos] & 268435455) >>> 16)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 1 + inPos] & 268435455) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 1 + inPos] & 268435455))) & 255);
      out[ 7 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 2 + inPos] & 268435455) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 2 + inPos] & 268435455) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 2 + inPos] & 268435455) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 2 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 3 + inPos] & 268435455) >>> 24)) & 255);
      out[11 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 3 + inPos] & 268435455) >>> 16)) & 255);
      out[12 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 3 + inPos] & 268435455) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 3 + inPos] & 268435455))) & 255);
      out[14 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 4 + inPos] & 268435455) >>> 20)) & 255);
      out[15 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 4 + inPos] & 268435455) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 4 + inPos] & 268435455) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 4 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 5 + inPos] & 268435455) >>> 24)) & 255);
      out[18 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 5 + inPos] & 268435455) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 5 + inPos] & 268435455) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 5 + inPos] & 268435455))) & 255);
      out[21 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 6 + inPos] & 268435455) >>> 20)) & 255);
      out[22 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 6 + inPos] & 268435455) >>> 12)) & 255);
      out[23 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 6 + inPos] & 268435455) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 6 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 7 + inPos] & 268435455) >>> 24)) & 255);
      out[25 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 7 + inPos] & 268435455) >>> 16)) & 255);
      out[26 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 7 + inPos] & 268435455) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 7 + inPos] & 268435455))) & 255);
    }
    public final void pack32Values(final int[] in, final int inPos, final byte[] out, final int outPos) {
      out[ 0 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 0 + inPos] & 268435455) >>> 20)) & 255);
      out[ 1 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 0 + inPos] & 268435455) >>> 12)) & 255);
      out[ 2 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 0 + inPos] & 268435455) >>> 4)) & 255);
      out[ 3 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 0 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 1 + inPos] & 268435455) >>> 24)) & 255);
      out[ 4 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 1 + inPos] & 268435455) >>> 16)) & 255);
      out[ 5 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 1 + inPos] & 268435455) >>> 8)) & 255);
      out[ 6 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 1 + inPos] & 268435455))) & 255);
      out[ 7 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 2 + inPos] & 268435455) >>> 20)) & 255);
      out[ 8 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 2 + inPos] & 268435455) >>> 12)) & 255);
      out[ 9 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 2 + inPos] & 268435455) >>> 4)) & 255);
      out[10 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 2 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 3 + inPos] & 268435455) >>> 24)) & 255);
      out[11 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 3 + inPos] & 268435455) >>> 16)) & 255);
      out[12 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 3 + inPos] & 268435455) >>> 8)) & 255);
      out[13 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 3 + inPos] & 268435455))) & 255);
      out[14 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 4 + inPos] & 268435455) >>> 20)) & 255);
      out[15 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 4 + inPos] & 268435455) >>> 12)) & 255);
      out[16 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 4 + inPos] & 268435455) >>> 4)) & 255);
      out[17 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 4 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 5 + inPos] & 268435455) >>> 24)) & 255);
      out[18 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 5 + inPos] & 268435455) >>> 16)) & 255);
      out[19 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 5 + inPos] & 268435455) >>> 8)) & 255);
      out[20 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 5 + inPos] & 268435455))) & 255);
      out[21 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 6 + inPos] & 268435455) >>> 20)) & 255);
      out[22 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 6 + inPos] & 268435455) >>> 12)) & 255);
      out[23 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 6 + inPos] & 268435455) >>> 4)) & 255);
      out[24 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 6 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 7 + inPos] & 268435455) >>> 24)) & 255);
      out[25 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 7 + inPos] & 268435455) >>> 16)) & 255);
      out[26 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 7 + inPos] & 268435455) >>> 8)) & 255);
      out[27 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 7 + inPos] & 268435455))) & 255);
      out[28 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[ 8 + inPos] & 268435455) >>> 20)) & 255);
      out[29 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[ 8 + inPos] & 268435455) >>> 12)) & 255);
      out[30 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[ 8 + inPos] & 268435455) >>> 4)) & 255);
      out[31 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[ 8 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[ 9 + inPos] & 268435455) >>> 24)) & 255);
      out[32 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[ 9 + inPos] & 268435455) >>> 16)) & 255);
      out[33 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[ 9 + inPos] & 268435455) >>> 8)) & 255);
      out[34 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[ 9 + inPos] & 268435455))) & 255);
      out[35 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[10 + inPos] & 268435455) >>> 20)) & 255);
      out[36 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[10 + inPos] & 268435455) >>> 12)) & 255);
      out[37 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[10 + inPos] & 268435455) >>> 4)) & 255);
      out[38 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[10 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[11 + inPos] & 268435455) >>> 24)) & 255);
      out[39 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[11 + inPos] & 268435455) >>> 16)) & 255);
      out[40 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[11 + inPos] & 268435455) >>> 8)) & 255);
      out[41 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[11 + inPos] & 268435455))) & 255);
      out[42 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[12 + inPos] & 268435455) >>> 20)) & 255);
      out[43 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[12 + inPos] & 268435455) >>> 12)) & 255);
      out[44 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[12 + inPos] & 268435455) >>> 4)) & 255);
      out[45 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[12 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[13 + inPos] & 268435455) >>> 24)) & 255);
      out[46 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[13 + inPos] & 268435455) >>> 16)) & 255);
      out[47 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[13 + inPos] & 268435455) >>> 8)) & 255);
      out[48 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[13 + inPos] & 268435455))) & 255);
      out[49 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[14 + inPos] & 268435455) >>> 20)) & 255);
      out[50 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[14 + inPos] & 268435455) >>> 12)) & 255);
      out[51 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[14 + inPos] & 268435455) >>> 4)) & 255);
      out[52 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[14 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[15 + inPos] & 268435455) >>> 24)) & 255);
      out[53 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[15 + inPos] & 268435455) >>> 16)) & 255);
      out[54 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[15 + inPos] & 268435455) >>> 8)) & 255);
      out[55 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[15 + inPos] & 268435455))) & 255);
      out[56 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[16 + inPos] & 268435455) >>> 20)) & 255);
      out[57 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[16 + inPos] & 268435455) >>> 12)) & 255);
      out[58 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[16 + inPos] & 268435455) >>> 4)) & 255);
      out[59 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[16 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[17 + inPos] & 268435455) >>> 24)) & 255);
      out[60 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[17 + inPos] & 268435455) >>> 16)) & 255);
      out[61 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[17 + inPos] & 268435455) >>> 8)) & 255);
      out[62 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[17 + inPos] & 268435455))) & 255);
      out[63 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[18 + inPos] & 268435455) >>> 20)) & 255);
      out[64 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[18 + inPos] & 268435455) >>> 12)) & 255);
      out[65 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[18 + inPos] & 268435455) >>> 4)) & 255);
      out[66 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[18 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[19 + inPos] & 268435455) >>> 24)) & 255);
      out[67 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[19 + inPos] & 268435455) >>> 16)) & 255);
      out[68 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[19 + inPos] & 268435455) >>> 8)) & 255);
      out[69 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[19 + inPos] & 268435455))) & 255);
      out[70 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[20 + inPos] & 268435455) >>> 20)) & 255);
      out[71 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[20 + inPos] & 268435455) >>> 12)) & 255);
      out[72 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[20 + inPos] & 268435455) >>> 4)) & 255);
      out[73 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[20 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[21 + inPos] & 268435455) >>> 24)) & 255);
      out[74 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[21 + inPos] & 268435455) >>> 16)) & 255);
      out[75 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[21 + inPos] & 268435455) >>> 8)) & 255);
      out[76 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[21 + inPos] & 268435455))) & 255);
      out[77 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[22 + inPos] & 268435455) >>> 20)) & 255);
      out[78 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[22 + inPos] & 268435455) >>> 12)) & 255);
      out[79 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[22 + inPos] & 268435455) >>> 4)) & 255);
      out[80 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[22 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[23 + inPos] & 268435455) >>> 24)) & 255);
      out[81 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[23 + inPos] & 268435455) >>> 16)) & 255);
      out[82 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[23 + inPos] & 268435455) >>> 8)) & 255);
      out[83 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[23 + inPos] & 268435455))) & 255);
      out[84 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[24 + inPos] & 268435455) >>> 20)) & 255);
      out[85 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[24 + inPos] & 268435455) >>> 12)) & 255);
      out[86 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[24 + inPos] & 268435455) >>> 4)) & 255);
      out[87 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[24 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[25 + inPos] & 268435455) >>> 24)) & 255);
      out[88 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[25 + inPos] & 268435455) >>> 16)) & 255);
      out[89 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[25 + inPos] & 268435455) >>> 8)) & 255);
      out[90 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[25 + inPos] & 268435455))) & 255);
      out[91 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[26 + inPos] & 268435455) >>> 20)) & 255);
      out[92 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[26 + inPos] & 268435455) >>> 12)) & 255);
      out[93 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[26 + inPos] & 268435455) >>> 4)) & 255);
      out[94 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[26 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[27 + inPos] & 268435455) >>> 24)) & 255);
      out[95 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[27 + inPos] & 268435455) >>> 16)) & 255);
      out[96 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[27 + inPos] & 268435455) >>> 8)) & 255);
      out[97 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[27 + inPos] & 268435455))) & 255);
      out[98 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[28 + inPos] & 268435455) >>> 20)) & 255);
      out[99 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[28 + inPos] & 268435455) >>> 12)) & 255);
      out[100 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[28 + inPos] & 268435455) >>> 4)) & 255);
      out[101 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[28 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[29 + inPos] & 268435455) >>> 24)) & 255);
      out[102 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[29 + inPos] & 268435455) >>> 16)) & 255);
      out[103 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[29 + inPos] & 268435455) >>> 8)) & 255);
      out[104 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[29 + inPos] & 268435455))) & 255);
      out[105 + outPos] = (byte)((
          //                                      [76543210]
          //                                      [76543210____________________]
           ((in[30 + inPos] & 268435455) >>> 20)) & 255);
      out[106 + outPos] = (byte)((
          //                                      [76543210]
          //                              [________98765432____________]
           ((in[30 + inPos] & 268435455) >>> 12)) & 255);
      out[107 + outPos] = (byte)((
          //                                      [76543210]
          //                      [________________10987654____]
           ((in[30 + inPos] & 268435455) >>> 4)) & 255);
      out[108 + outPos] = (byte)((
          //                                      [7654____]
          //              [________________________3210]
           ((in[30 + inPos] & 268435455) <<  4)
        | //                                      [____3210]
          //                                          [7654________________________]
           ((in[31 + inPos] & 268435455) >>> 24)) & 255);
      out[109 + outPos] = (byte)((
          //                                      [76543210]
          //                                  [____32109876________________]
           ((in[31 + inPos] & 268435455) >>> 16)) & 255);
      out[110 + outPos] = (byte)((
          //                                      [76543210]
          //                          [____________54321098________]
           ((in[31 + inPos] & 268435455) >>> 8)) & 255);
      out[111 + outPos] = (byte)((
          //                                      [76543210]
          //                  [____________________76543210]
           ((in[31 + inPos] & 268435455))) & 255);
    }
    public final void unpack8Values(final byte[] in, final int inPos, final int[] out, final int outPos) {
      out[ 0 + outPos] =
          //                                      [76543210]
          //                                      [76543210____________________]
            (((((int)in[ 0 + inPos]) & 255) <<  20) & 268435455)
        | //                                      [76543210]
          //                              [________98765432____________]
            (((((int)in[ 1 + inPos]) & 255) <<  12) & 268435455)
        | //                                      [76543210]
          //                      [________________10987654____]
            (((((int)in[ 2 + inPos]) & 255) <<  4) & 268435455)
        | //                                      [7654____]
          //              [________________________3210]
            (((((int)in[ 3 + inPos]) & 255) >>>  4) & 268435455);
      out[ 1 + outPos] =
          //                                      [____3210]
          //                                          [7654________________________]
            (((((int)in[ 3 + inPos]) & 255) <<  24) & 268435455)
        | //                                      [76543210]
          //                                  [____32109876________________]
            (((((int)in[ 4 + inPos]) & 255) <<  16) & 268435455)
        | //                                      [76543210]
          //                          [____________54321098________]
            (((((int)in[ 5 + inPos]) & 255) <<  8) & 268435455)
        | //                                      [76543210]
          //                  [____________________76543210]
            (((((int)in[ 6 + inPos]) & 255) ) & 268435455);
      out[ 2 + outPos] =
          //                                      [76543210]
          //                                      [76543210____________________]
            (((((int)in[ 7 + inPos]) & 255) <<  20) & 268435455)
        | //                                      [76543210]
          //                              [________98765432____________]
            (((((int)in[ 8 + inPos]) & 255) <<  12) & 268435455)
        | //                                      [76543210]
          //                      [________________10987654____]
            (((((int)in[ 9 + inPos]) & 255) <<  4) & 268435455)
        | //                                      [7654____]
          //              [________________________3210]
            (((((int)in[10 + inPos]) & 255) >>>  4) & 268435455);
      out[ 3 + outPos] =
          //                                      [____3210]
          //                                          [7654________________________]
            (((((int)in[10 + inPos]) & 255) <<  24) & 268435455)
        | //                                      [76543210]
          //                                  [____32109876________________]
            (((((int)in[11 + inPos]) & 255) <<  16) & 268435455)
        | //                                      [76543210]
          //                          [____________54321098________]
            (((((int)in[12 + inPos]) & 255) <<  8) & 268435455)
        | //                                      [76543210]
          //                  [____________________76543210]
            (((((int)in[13 + inPos]) & 255) ) & 268435455);
      out[ 4 + outPos] =
          //                                      [76543210]
          //                                      [76543210____________________]
            (((((int)in[14 + inPos]) & 255) <<  20) & 268435455)
        | //                                      [76543210]
          //                              [________98765432____________]
            (((((int)in[15 + inPos]) & 255) <<  12) & 268435455)
        | //                                      [76543210]
          //                      [________________10987654____]
            (((((int)in[16 + inPos]) & 255) <<  4) & 268435455)
        | //                                      [7654____]
          //              [________________________3210]
            (((((int)in[17 + inPos]) & 255) >>>  4) & 268435455);
      out[ 5 + outPos] =
          //                                      [____3210]
          //                                          [7654________________________]
            (((((int)in[17 + inPos]) & 255) <<  24) & 268435455)
        | //                                      [76543210]
          //                                  [____32109876________________]
            (((((int)in[18 + inPos]) & 255) <<  16) & 268435455)
        | //                                      [76543210]
          //                          [____________54321098________]
            (((((int)in[19 + inPos]) & 255) <<  8) & 268435455)
        | //                                      [76543210]
          //                  [____________________76543210]
            (((((int)in[20 + inPos]) & 255) ) & 268435455);
      out[ 6 + outPos] =
          //                                      [76543210]
          //                                      [76543210____________________]
            (((((int)in[21 + inPos]) & 255) <<  20) & 268435455)
        | //                                      [76543210]
          //                              [________98765432____________]
            (((((int)in[22 + inPos]) & 255) <<  12) & 268435455)
        | //                                      [76543210]
          //                      [________________10987654____]
            (((((int)in[23 + inPos]) & 255) <<  4) & 268435455)
        | //                                      [7654____]
          //              [________________________3210]
            (((((int)in[24 + inPos]) & 255) >>>  4) & 268435455);
      out[ 7 + outPos] =
          //                                      [____3210]
          //                                          [7654________________________]
            (((((int)in[24 + inPos]) & 255) <<  24) & 268435455)
     