/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.writebehind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.writebehind.AbstractWriteBehindCache;
import org.apache.openjpa.writebehind.SimpleWriteBehindCacheKey;
import org.apache.openjpa.writebehind.WriteBehindCacheKey;
import org.apache.openjpa.writebehind.WriteBehindCacheManager;
import org.apache.openjpa.writebehind.WriteBehindException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWriteBehindCache
extends AbstractWriteBehindCache {
    private Map<WriteBehindCacheKey, OpenJPAStateManager> _cache = new HashMap<WriteBehindCacheKey, OpenJPAStateManager>();

    @Override
    public List<Exception> add(Collection<OpenJPAStateManager> sms) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (OpenJPAStateManager sm : sms) {
            try {
                this.add(sm);
            }
            catch (WriteBehindException wbe) {
                exceptions.add(wbe);
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(OpenJPAStateManager sm) {
        WriteBehindCacheKey key = this.getKey(sm);
        Map<WriteBehindCacheKey, OpenJPAStateManager> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(key) && this._cache.get(key) != sm) {
                this._cache.put(key, this.merge(this._cache.get(key), sm));
            } else {
                this._cache.put(key, sm);
            }
        }
    }

    @Override
    public boolean contains(Object o) {
        boolean rval = false;
        StateManagerImpl sm = this.getStateManager(o);
        if (sm != null) {
            rval = this._cache.containsKey(this.getKey(sm));
        }
        return rval;
    }

    @Override
    public WriteBehindCacheKey getKey(OpenJPAStateManager sm) {
        ClassMetaData md = sm.getMetaData();
        Class<?> cls = md.getDescribedType();
        String className = cls.getCanonicalName();
        Object id = sm.getId();
        SimpleWriteBehindCacheKey key = new SimpleWriteBehindCacheKey(className, id);
        return key;
    }

    @Override
    public int getSize() {
        return this._cache.size();
    }

    @Override
    public Collection<OpenJPAStateManager> getStateManagers() {
        return new ArrayList<OpenJPAStateManager>(this._cache.values());
    }

    @Override
    public void initialize(WriteBehindCacheManager manager) {
    }

    protected StateManagerImpl getStateManager(Object o) {
        StateManagerImpl rval = null;
        if (o instanceof StateManagerImpl) {
            rval = (StateManagerImpl)o;
        } else if (o instanceof PersistenceCapable) {
            rval = (StateManagerImpl)((PersistenceCapable)o).pcGetStateManager();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<WriteBehindCacheKey, OpenJPAStateManager> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        return this._cache.isEmpty();
    }

    protected OpenJPAStateManager merge(OpenJPAStateManager from, OpenJPAStateManager into) {
        for (int i = 0; i < into.getMetaData().getFields().length; ++i) {
            if (!from.getDirty().get(i)) continue;
            into.dirty(i);
        }
        return into;
    }
}

