/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PredicateImpl
extends ExpressionImpl<Boolean>
implements Predicate {
    private static final ExpressionImpl<Integer> ONE = new Expressions.Constant<Integer>(1);
    public static final Predicate TRUE = new Expressions.Equal(ONE, ONE);
    public static final Predicate FALSE = new Expressions.NotEqual(ONE, ONE);
    protected final List<Predicate> _exps = new ArrayList<Predicate>();
    private final Predicate.BooleanOperator _op;
    private boolean _negated = false;

    protected PredicateImpl() {
        this(Predicate.BooleanOperator.AND);
    }

    protected PredicateImpl(Predicate.BooleanOperator op) {
        super(Boolean.class);
        this._op = op;
    }

    protected PredicateImpl(Predicate.BooleanOperator op, Predicate ... restrictions) {
        this(op);
        if (restrictions != null) {
            for (Predicate p : restrictions) {
                this.add(p);
            }
        }
    }

    public PredicateImpl add(Expression<Boolean> s) {
        this._exps.add((Predicate)s);
        return this;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        CopyOnWriteArrayList<Expression<Boolean>> result = new CopyOnWriteArrayList<Expression<Boolean>>();
        if (this._exps.isEmpty()) {
            return result;
        }
        result.addAll(this._exps);
        return result;
    }

    @Override
    public final Predicate.BooleanOperator getOperator() {
        return this._op;
    }

    @Override
    public final boolean isNegated() {
        return this._negated;
    }

    @Override
    public PredicateImpl negate() {
        return new Expressions.Not(this).markNegated();
    }

    protected PredicateImpl markNegated() {
        this._negated = true;
        return this;
    }

    @Override
    Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        throw new AbstractMethodError(this.getClass().getName());
    }

    @Override
    org.apache.openjpa.kernel.exps.Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        if (this._exps.isEmpty()) {
            Predicate nil = this._op == Predicate.BooleanOperator.AND ? TRUE : FALSE;
            return ((PredicateImpl)nil).toKernelExpression(factory, q);
        }
        if (this._exps.size() == 1) {
            Predicate e0 = this._exps.get(0);
            if (this.isNegated()) {
                e0 = e0.negate();
            }
            return ((PredicateImpl)e0).toKernelExpression(factory, q);
        }
        ExpressionImpl e1 = (ExpressionImpl)((Object)this._exps.get(0));
        ExpressionImpl e2 = (ExpressionImpl)((Object)this._exps.get(1));
        org.apache.openjpa.kernel.exps.Expression ke1 = e1.toKernelExpression(factory, q);
        org.apache.openjpa.kernel.exps.Expression ke2 = e2.toKernelExpression(factory, q);
        org.apache.openjpa.kernel.exps.Expression result = this._op == Predicate.BooleanOperator.AND ? factory.and(ke1, ke2) : factory.or(ke1, ke2);
        for (int i = 2; i < this._exps.size(); ++i) {
            PredicateImpl p = (PredicateImpl)this._exps.get(i);
            result = this._op == Predicate.BooleanOperator.AND ? factory.and(result, p.toKernelExpression(factory, q)) : factory.or(result, p.toKernelExpression(factory, q));
        }
        return this._negated ? factory.not(result) : result;
    }

    @Override
    public void acceptVisit(CriteriaExpressionVisitor visitor) {
        Expressions.acceptVisit(visitor, this, this._exps.toArray(new Expression[this._exps.size()]));
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        boolean braces = this._exps.size() > 1;
        StringBuilder buffer = Expressions.asValue(q, this._exps.toArray(new Expression[this._exps.size()]), " " + (Object)((Object)this._op) + " ");
        if (braces) {
            buffer.insert(0, "(").append(")");
        }
        if (this.isNegated()) {
            buffer.insert(0, "NOT ");
        }
        return buffer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Or
    extends PredicateImpl {
        public Or(Expression<Boolean> x, Expression<Boolean> y) {
            super(Predicate.BooleanOperator.OR);
            this.add(x).add(y);
        }

        public Or(Predicate ... restrictions) {
            super(Predicate.BooleanOperator.OR, restrictions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class And
    extends PredicateImpl {
        public And(Expression<Boolean> x, Expression<Boolean> y) {
            super(Predicate.BooleanOperator.AND);
            this.add(x).add(y);
        }

        public And(Predicate ... restrictions) {
            super(Predicate.BooleanOperator.AND, restrictions);
        }
    }
}

