/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.persistence.spi.ValidationMode;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.XMLMetaDataParser;
import org.apache.openjpa.lib.meta.XMLVersionParser;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    public static final Specification SPEC_JPA = new Specification("jpa 2");
    public static final Specification ALIAS_EJB = new Specification("ejb 3");
    public static final String RSRC_GLOBAL = "META-INF/openjpa.xml";
    public static final String RSRC_DEFAULT = "META-INF/persistence.xml";
    public static final BigDecimal VERSION_1_0 = BigDecimal.valueOf(1.0);
    private static final Localizer _loc = Localizer.forPackage(PersistenceProductDerivation.class);
    private HashMap<String, PUNameCollision> _puNameCollisions = new HashMap();

    @Override
    public void putBrokerFactoryAliases(Map m) {
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getConfigurationPrefix() {
        return "javax.persistence";
    }

    @Override
    public void validate() throws Exception {
        AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(EntityManagerFactory.class));
    }

    @Override
    public boolean beforeConfigurationLoad(Configuration c) {
        if (!(c instanceof OpenJPAConfigurationImpl)) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setAlias(ALIAS_EJB.getName(), PersistenceMetaDataFactory.class.getName());
        conf.metaFactoryPlugin.setAlias(SPEC_JPA.getName(), PersistenceMetaDataFactory.class.getName());
        conf.addValue(new EntityManagerFactoryValue());
        conf.readLockLevel.setAlias("optimistic", String.valueOf(15));
        conf.readLockLevel.setAlias("optimistic-force-increment", String.valueOf(25));
        conf.readLockLevel.setAlias("pessimistic-read", String.valueOf(30));
        conf.readLockLevel.setAlias("pessimistic-write", String.valueOf(40));
        conf.readLockLevel.setAlias("pessimistic-force-increment", String.valueOf(50));
        conf.writeLockLevel.setAlias("optimistic", String.valueOf(15));
        conf.writeLockLevel.setAlias("optimistic-force-increment", String.valueOf(25));
        conf.writeLockLevel.setAlias("pessimistic-read", String.valueOf(30));
        conf.writeLockLevel.setAlias("pessimistic-write", String.valueOf(40));
        conf.writeLockLevel.setAlias("pessimistic-force-increment", String.valueOf(50));
        conf.lockManagerPlugin.setAlias("mixed", "org.apache.openjpa.jdbc.kernel.MixedLockManager");
        String[] aliases = new String[]{String.valueOf((Object)ValidationMode.AUTO), String.valueOf((Object)ValidationMode.AUTO).toLowerCase(), String.valueOf((Object)ValidationMode.CALLBACK), String.valueOf((Object)ValidationMode.CALLBACK).toLowerCase(), String.valueOf((Object)ValidationMode.NONE), String.valueOf((Object)ValidationMode.NONE).toLowerCase()};
        conf.validationMode.setAliases(aliases);
        conf.validationMode.setAliasListComprehensive(true);
        conf.validationMode.setDefault(aliases[0]);
        return true;
    }

    @Override
    public boolean afterSpecificationSet(Configuration c) {
        if (!OpenJPAConfigurationImpl.class.isInstance(c) && !SPEC_JPA.isSame(((OpenJPAConfiguration)c).getSpecification())) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setDefault(SPEC_JPA.getName());
        conf.metaFactoryPlugin.setString(SPEC_JPA.getName());
        conf.lockManagerPlugin.setDefault("mixed");
        conf.lockManagerPlugin.setString("mixed");
        conf.nontransactionalWrite.setDefault("true");
        conf.nontransactionalWrite.set(true);
        int specVersion = ((OpenJPAConfiguration)c).getSpecificationInstance().getVersion();
        Compatibility compatibility = conf.getCompatibilityInstance();
        if (specVersion < 2) {
            compatibility.setFlushBeforeDetach(true);
            compatibility.setCopyOnDetach(true);
            compatibility.setPrivatePersistentProperties(true);
            conf.validationMode.set(String.valueOf((Object)ValidationMode.NONE));
        } else {
            compatibility.setAbstractMappingUniDirectional(true);
            compatibility.setNonDefaultMappingAllowed(true);
        }
        return true;
    }

    public ConfigurationProvider load(PersistenceUnitInfo pinfo, Map m) throws IOException {
        PersistenceUnitInfoImpl impl;
        if (pinfo == null) {
            return null;
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        cp.addProperties(PersistenceUnitInfoImpl.toOpenJPAProperties(pinfo));
        cp.addProperties(m);
        if (pinfo instanceof PersistenceUnitInfoImpl && (impl = (PersistenceUnitInfoImpl)pinfo).getPersistenceXmlFileUrl() != null) {
            cp.setSource(impl.getPersistenceXmlFileUrl().toString());
        }
        return cp;
    }

    public ConfigurationProvider load(String rsrc, String name, Map m) throws IOException {
        ConfigurationProviderImpl cp;
        Boolean ret;
        boolean explicit;
        boolean bl = explicit = !StringUtils.isEmpty(rsrc);
        if (!explicit) {
            rsrc = RSRC_DEFAULT;
        }
        if ((ret = this.load(cp = new ConfigurationProviderImpl(), rsrc, name, m, null, explicit)) != null) {
            return ret != false ? cp : null;
        }
        if (explicit) {
            return null;
        }
        PersistenceUnitInfoImpl pinfo = new PersistenceUnitInfoImpl();
        pinfo.fromUserProperties(m);
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        return cp;
    }

    @Override
    public ConfigurationProvider load(String rsrc, String anchor, ClassLoader loader) throws IOException {
        if (rsrc != null && !rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, true) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    @Override
    public ConfigurationProvider load(File file, String anchor) throws IOException {
        if (!file.getName().endsWith(".xml")) {
            return null;
        }
        ConfigurationParser parser = new ConfigurationParser(null);
        parser.parse(file);
        return this.load(this.findUnit(parser.getResults(), anchor, null), null);
    }

    @Override
    public String getDefaultResourceLocation() {
        return RSRC_DEFAULT;
    }

    public List getAnchorsInFile(File file) throws IOException {
        ConfigurationParser parser = new ConfigurationParser(null);
        try {
            parser.parse(file);
            return this.getUnitNames(parser);
        }
        catch (IOException e) {
            return null;
        }
    }

    private List<String> getUnitNames(ConfigurationParser parser) {
        List units = parser.getResults();
        ArrayList<String> names = new ArrayList<String>();
        for (PersistenceUnitInfoImpl unit : units) {
            names.add(unit.getPersistenceUnitName());
        }
        return names;
    }

    public List getAnchorsInResource(String resource) throws Exception {
        ConfigurationParser parser = new ConfigurationParser(null);
        try {
            ArrayList<String> results = new ArrayList<String>();
            ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            List<URL> urls = PersistenceProductDerivation.getResourceURLs(resource, loader);
            if (urls != null) {
                for (URL url : urls) {
                    parser.parse(url);
                    results.addAll(this.getUnitNames(parser));
                }
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ConfigurationProvider loadGlobals(ClassLoader loader) throws IOException {
        int idx;
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        String rsrc = null;
        for (int i = 0; i < prefixes.length && StringUtils.isEmpty(rsrc); ++i) {
            rsrc = AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction(prefixes[i] + ".properties"));
        }
        boolean explicit = !StringUtils.isEmpty(rsrc);
        String anchor = null;
        int n = idx = !explicit ? -1 : rsrc.lastIndexOf(35);
        if (idx != -1) {
            if (idx < rsrc.length() - 1) {
                anchor = rsrc.substring(idx + 1);
            }
            rsrc = rsrc.substring(0, idx);
        }
        if (StringUtils.isEmpty(rsrc)) {
            rsrc = RSRC_GLOBAL;
        } else if (!rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, explicit) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    @Override
    public ConfigurationProvider loadDefaults(ClassLoader loader) throws IOException {
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, RSRC_DEFAULT, null, null, loader, false) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public boolean checkPuNameCollisions(Log logger, String puName) {
        PUNameCollision p = this._puNameCollisions.get(puName);
        if (p != null) {
            p.logCollision(logger);
            return true;
        }
        return false;
    }

    private static List<URL> getResourceURLs(String rsrc, ClassLoader loader) throws IOException {
        Enumeration<URL> urls = null;
        try {
            urls = AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, rsrc));
            if (!urls.hasMoreElements()) {
                if (!rsrc.startsWith("META-INF")) {
                    urls = AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(loader, "META-INF/" + rsrc));
                }
                if (!urls.hasMoreElements()) {
                    return null;
                }
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return Collections.list(urls);
    }

    private Boolean load(ConfigurationProviderImpl cp, String rsrc, String name, Map m, ClassLoader loader, boolean explicit) throws IOException {
        List<URL> urls;
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        if ((urls = PersistenceProductDerivation.getResourceURLs(rsrc, loader)) == null || urls.size() == 0) {
            return null;
        }
        ConfigurationParser parser = new ConfigurationParser(m);
        PersistenceUnitInfoImpl pinfo = this.parseResources(parser, urls, name, loader);
        if (pinfo == null) {
            if (!explicit) {
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("missing-xml-config", rsrc, String.valueOf(name)).getMessage(), this.getClass().getName(), rsrc);
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) {
            if (!explicit) {
                PersistenceProductDerivation.warnUnknownProvider(pinfo);
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("unknown-provider", rsrc, name, pinfo.getPersistenceProviderClassName()).getMessage(), this.getClass().getName(), rsrc);
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        cp.setSource(pinfo.getPersistenceXmlFileUrl().toString());
        return Boolean.TRUE;
    }

    private PersistenceUnitInfoImpl parseResources(ConfigurationParser parser, List<URL> urls, String name, ClassLoader loader) throws IOException {
        ArrayList<PersistenceUnitInfoImpl> pinfos = new ArrayList<PersistenceUnitInfoImpl>();
        for (URL url : urls) {
            parser.parse(url);
            pinfos.addAll(parser.getResults());
        }
        return this.findUnit(pinfos, name, loader);
    }

    private PersistenceUnitInfoImpl findUnit(List<PersistenceUnitInfoImpl> pinfos, String name, ClassLoader loader) {
        PersistenceUnitInfoImpl ojpa = null;
        PersistenceUnitInfoImpl result = null;
        for (PersistenceUnitInfoImpl pinfo : pinfos) {
            if (name != null) {
                if (!name.equals(pinfo.getPersistenceUnitName())) continue;
                if (result != null) {
                    this.addPuNameCollision(name, result.getPersistenceXmlFileUrl().toString(), pinfo.getPersistenceXmlFileUrl().toString());
                    continue;
                }
                result = pinfo;
                continue;
            }
            if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) continue;
            if (StringUtils.isEmpty(pinfo.getPersistenceUnitName())) {
                return pinfo;
            }
            if (ojpa != null) continue;
            ojpa = pinfo;
        }
        if (result != null) {
            return result;
        }
        return ojpa;
    }

    private static boolean isOpenJPAPersistenceProvider(PersistenceUnitInfo pinfo, ClassLoader loader) {
        String provider = pinfo.getPersistenceProviderClassName();
        if (StringUtils.isEmpty(provider) || PersistenceProviderImpl.class.getName().equals(provider)) {
            return true;
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        try {
            if (PersistenceProviderImpl.class.isAssignableFrom(Class.forName(provider, false, loader))) {
                return true;
            }
        }
        catch (Throwable t) {
            PersistenceProductDerivation.log(_loc.get("unloadable-provider", provider, t).getMessage());
            return false;
        }
        return false;
    }

    private static void warnUnknownProvider(PersistenceUnitInfo pinfo) {
        PersistenceProductDerivation.log(_loc.get("unrecognized-provider", pinfo.getPersistenceProviderClassName()).getMessage());
    }

    private static void log(String msg) {
        System.err.println(msg);
    }

    private void addPuNameCollision(String puName, String file1, String file2) {
        PUNameCollision pun = this._puNameCollisions.get(puName);
        if (pun != null) {
            pun.addCollision(file1, file2);
        } else {
            this._puNameCollisions.put(puName, new PUNameCollision(puName, file1, file2));
        }
    }

    private static class PUNameCollision {
        private String _puName;
        private Set<String> _resources = new LinkedHashSet<String>();

        PUNameCollision(String puName, String file1, String file2) {
            this._resources.add(file1);
            this._resources.add(file2);
            this._puName = puName;
        }

        void logCollision(Log logger) {
            if (logger.isWarnEnabled()) {
                logger.warn(_loc.getFatal("dup-pu", new Object[]{this._puName, this._resources.toString(), this._resources.iterator().next()}));
            }
        }

        void addCollision(String file1, String file2) {
            this._resources.add(file1);
            this._resources.add(file2);
        }
    }

    public static class ConfigurationParser
    extends XMLMetaDataParser {
        private static final String PERSISTENCE_XSD_1_0 = "persistence_1_0.xsd";
        private static final String PERSISTENCE_XSD_2_0 = "persistence_2_0.xsd";
        private static final Localizer _loc = Localizer.forPackage(ConfigurationParser.class);
        private final Map _map;
        private PersistenceUnitInfoImpl _info = null;
        private URL _source = null;
        private String _persistenceVersion;
        private String _schemaLocation;
        private boolean _excludeUnlistedSet = false;

        public ConfigurationParser(Map map) {
            this._map = map;
            this.setCaching(false);
            this.setValidating(true);
            this.setParseText(true);
        }

        public void parse(URL url) throws IOException {
            this._source = url;
            XMLVersionParser vp = new XMLVersionParser("persistence");
            try {
                vp.parse(url);
                this._persistenceVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                PersistenceProductDerivation.log(ConfigurationParser._loc.get("version-check-error", this._source.toString()).toString());
            }
            super.parse(url);
        }

        public void parse(File file) throws IOException {
            try {
                this._source = AccessController.doPrivileged(J2DoPrivHelper.toURLAction(file));
            }
            catch (PrivilegedActionException pae) {
                throw (MalformedURLException)pae.getException();
            }
            XMLVersionParser vp = new XMLVersionParser("persistence");
            try {
                vp.parse(file);
                this._persistenceVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                PersistenceProductDerivation.log(ConfigurationParser._loc.get("version-check-error", this._source.toString()).toString());
            }
            super.parse(file);
        }

        protected Object getSchemaSource() {
            String persistencexsd = "persistence-xsd.rsrc";
            if (this._persistenceVersion != null && this._persistenceVersion.equals("2.0") || this._schemaLocation != null && this._schemaLocation.indexOf(PERSISTENCE_XSD_2_0) != -1) {
                persistencexsd = "persistence_2_0-xsd.rsrc";
            }
            return this.getClass().getResourceAsStream(persistencexsd);
        }

        protected void reset() {
            super.reset();
            this._info = null;
            this._source = null;
            this._excludeUnlistedSet = false;
        }

        protected boolean startElement(String name, Attributes attrs) throws SAXException {
            if (this.currentDepth() == 1) {
                this.startPersistenceUnit(attrs);
            } else if (this.currentDepth() == 3 && "property".equals(name)) {
                this._info.setProperty(attrs.getValue("name"), attrs.getValue("value"));
            }
            return true;
        }

        protected void endElement(String name) throws SAXException {
            if (this.currentDepth() == 1) {
                this.endPersistenceUnit();
                this._info.fromUserProperties(this._map);
                this.addResult(this._info);
            }
            if (this.currentDepth() != 2) {
                return;
            }
            switch (name.charAt(0)) {
                case 'c': {
                    if ("class".equals(name)) {
                        this._info.addManagedClassName(this.currentText());
                        break;
                    }
                    throw new PersistenceException("Not implemented yet");
                }
                case 'e': {
                    this.setExcludeUnlistedClasses(this.currentText());
                    break;
                }
                case 'j': {
                    if ("jta-data-source".equals(name)) {
                        this._info.setJtaDataSourceName(this.currentText());
                        break;
                    }
                    try {
                        this._info.addJarFileName(this.currentText());
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw this.getException(iae.getMessage());
                    }
                }
                case 'm': {
                    this._info.addMappingFileName(this.currentText());
                    break;
                }
                case 'n': {
                    this._info.setNonJtaDataSourceName(this.currentText());
                    break;
                }
                case 'p': {
                    if (!"provider".equals(name)) break;
                    this._info.setPersistenceProviderClassName(this.currentText());
                    break;
                }
                case 's': {
                    this._info.setSharedCacheMode(this.currentText());
                    break;
                }
                case 'v': {
                    this._info.setValidationMode(Enum.valueOf(ValidationMode.class, this.currentText()));
                }
            }
        }

        private void setExcludeUnlistedClasses(String value) {
            if (!this._excludeUnlistedSet) {
                BigDecimal version = this.getPersistenceVersion();
                boolean excludeUnlisted = version.compareTo(VERSION_1_0) > 0 ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
                this._info.setExcludeUnlistedClasses(excludeUnlisted);
                this._excludeUnlistedSet = true;
            }
        }

        private void startPersistenceUnit(Attributes attrs) throws SAXException {
            this._excludeUnlistedSet = false;
            this._info = new PersistenceUnitInfoImpl();
            this._info.setPersistenceUnitName(attrs.getValue("name"));
            this._info.setPersistenceXMLSchemaVersion(this._persistenceVersion);
            String val = attrs.getValue("transaction-type");
            if (val == null) {
                this._info.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                this._info.setTransactionType(Enum.valueOf(PersistenceUnitTransactionType.class, val));
            }
            if (this._source != null) {
                this._info.setPersistenceXmlFileUrl(this._source);
            }
        }

        private void endPersistenceUnit() {
            if (!this._excludeUnlistedSet) {
                this.setExcludeUnlistedClasses(null);
            }
        }

        private BigDecimal getPersistenceVersion() {
            if (this._info.getPersistenceXMLSchemaVersion() != null) {
                try {
                    return new BigDecimal(this._info.getPersistenceXMLSchemaVersion());
                }
                catch (Throwable t) {
                    PersistenceProductDerivation.log(ConfigurationParser._loc.get("invalid-version-attribute", this._info.getPersistenceXMLSchemaVersion(), VERSION_1_0.toString()).toString());
                }
            }
            return VERSION_1_0;
        }
    }

    public static class ConfigurationProviderImpl
    extends MapConfigurationProvider {
        private String _source;

        public ConfigurationProviderImpl() {
        }

        public ConfigurationProviderImpl(Map props) {
            super(props);
        }

        public void setSource(String source) {
            this._source = source;
        }

        public void setInto(Configuration conf) {
            if (conf instanceof OpenJPAConfiguration) {
                OpenJPAConfiguration oconf = (OpenJPAConfiguration)conf;
                Object persistenceVersion = this.getProperties().get("PersistenceVersion");
                if (persistenceVersion == null) {
                    oconf.setSpecification(SPEC_JPA);
                } else {
                    oconf.setSpecification("jpa " + persistenceVersion.toString());
                    this.getProperties().remove("PersistenceVersion");
                }
                String orig = oconf.getMetaDataFactory();
                if (!StringUtils.isEmpty(orig)) {
                    String key = ProductDerivations.getConfigurationKey("MetaDataFactory", this.getProperties());
                    Object override = this.getProperties().get(key);
                    if (override instanceof String) {
                        this.addProperty(key, Configurations.combinePlugins(orig, (String)override));
                    }
                }
            }
            super.setInto(conf, null);
            Log log = conf.getConfigurationLog();
            if (log.isTraceEnabled()) {
                String src = this._source == null ? "?" : this._source;
                log.trace(_loc.get("conf-load", src, this.getProperties()));
            }
        }
    }
}

