/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntValue
extends Value {
    private int value;

    public IntValue(String prop) {
        super(prop);
    }

    public Class<Integer> getValueType() {
        return Integer.TYPE;
    }

    public void set(int value) {
        this.assertChangeable();
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue) {
            this.valueChanged();
        }
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    protected String getInternalString() {
        return String.valueOf(this.value);
    }

    @Override
    protected void setInternalString(String val) {
        if (StringUtils.isEmpty(val)) {
            this.set(0);
        } else {
            this.set(Integer.parseInt(val));
        }
    }

    @Override
    protected void setInternalObject(Object obj) {
        if (obj == null) {
            this.set(0);
        } else {
            this.set(((Number)obj).intValue());
        }
    }
}

