/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.kernel.AbstractLockManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import serp.util.Numbers;

public class VersionLockManager
extends AbstractLockManager {
    private boolean _versionCheckOnReadLock = true;
    private boolean _versionUpdateOnWriteLock = true;

    public int getLockLevel(OpenJPAStateManager sm) {
        while (sm.getOwner() != null) {
            sm = sm.getOwner();
        }
        Number level = (Number)sm.getLock();
        return level == null ? 0 : level.intValue();
    }

    protected void setLockLevel(OpenJPAStateManager sm, int level) {
        sm.setLock(Numbers.valueOf(level));
    }

    public void release(OpenJPAStateManager sm) {
        sm.setLock(null);
    }

    public void lock(OpenJPAStateManager sm, int level, int timeout, Object sdata) {
        this.lock(sm, level, timeout, sdata, true);
    }

    public void lock(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        if (level == 0) {
            return;
        }
        while (sm.getOwner() != null) {
            sm = sm.getOwner();
        }
        int oldLevel = this.getLockLevel(sm);
        if (!sm.isPersistent() || sm.isNew() || level <= oldLevel) {
            return;
        }
        try {
            this.lockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        }
        catch (RuntimeException re) {
            this.setLockLevel(sm, oldLevel);
            throw re;
        }
    }

    protected void lockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        this.optimisticLockInternal(sm, level, timeout, sdata, postLockVersionCheck);
    }

    protected void optimisticLockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        this.setLockLevel(sm, level);
        if (level >= 20 && this._versionUpdateOnWriteLock) {
            this.getContext().transactional(sm.getManagedInstance(), true, null);
        } else if (level >= 10 && this._versionCheckOnReadLock) {
            this.getContext().transactional(sm.getManagedInstance(), false, null);
        }
    }

    public void setVersionCheckOnReadLock(boolean versionCheckOnReadLock) {
        this._versionCheckOnReadLock = versionCheckOnReadLock;
    }

    public boolean getVersionCheckOnReadLock() {
        return this._versionCheckOnReadLock;
    }

    public void setVersionUpdateOnWriteLock(boolean versionUpdateOnWriteLock) {
        this._versionUpdateOnWriteLock = versionUpdateOnWriteLock;
    }

    public boolean getVersionUpdateOnWriteLock() {
        return this._versionUpdateOnWriteLock;
    }
}

