/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;

public final class ScaledRAFileHybrid
implements RandomAccessInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    boolean wasNio;
    long maxLength = Long.MAX_VALUE;
    RandomAccessInterface store;

    public ScaledRAFileHybrid(Database database, String string, boolean bl) throws IOException {
        this.database = database;
        this.fileName = string;
        this.isReadOnly = bl;
        File file = new File(string);
        long l = file.length();
        this.newStore(l);
    }

    @Override
    public long length() throws IOException {
        return this.store.length();
    }

    @Override
    public void seek(long l) throws IOException {
        this.store.seek(l);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.store.read();
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.store.read(byArray, n, n2);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.store.write(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        return this.store.readInt();
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.store.writeInt(n);
    }

    @Override
    public long readLong() throws IOException {
        return this.store.readLong();
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.store.writeLong(l);
    }

    @Override
    public void close() throws IOException {
        this.store.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    @Override
    public boolean wasNio() {
        return this.wasNio;
    }

    @Override
    public boolean ensureLength(long l) {
        if (l < this.maxLength && this.store.ensureLength(l)) {
            return true;
        }
        if (this.wasNio && !this.store.wasNio()) {
            return false;
        }
        try {
            this.newStore(l);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.store.ensureLength(l);
    }

    @Override
    public boolean setLength(long l) {
        return this.store.setLength(l);
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        this.store.synch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newStore(long l) throws IOException {
        long l2 = 0L;
        if (this.store != null) {
            l2 = this.store.getFilePointer();
            this.store.synch();
            this.store.close();
        }
        if (this.wasNio) {
            this.maxLength = Long.MAX_VALUE;
        } else if (l <= this.database.logger.propNioMaxSize) {
            if (l >= 0x800000L) {
                try {
                    this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, l, this.database.logger.propNioMaxSize);
                    this.store.seek(l2);
                    this.wasNio = true;
                    return;
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.maxLength = Long.MAX_VALUE;
                }
            } else {
                this.maxLength = 0x800000L;
            }
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly, true);
        this.store.seek(l2);
    }
}

