/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.openejb.jee;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.List;

/**
 * The messageadapterType specifies information about the
 * messaging capabilities of the resource adapter. This
 * contains information specific to the implementation of the
 * resource adapter library as specified through the
 * messagelistener element.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "messageadapterType", propOrder = {
        "messageListener"
})
public class MessageAdapter {

    @XmlElement(name = "messagelistener", required = true)
    protected List<MessageListener> messageListener;
    @XmlAttribute
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public List<MessageListener> getMessageListener() {
        if (messageListener == null) {
            messageListener = new ArrayList<MessageListener>();
        }
        return this.messageListener;
    }

    public MessageListener addMessageListener(MessageListener listener){
        getMessageListener().add(listener);
        return listener;
    }
    
    public String getId() {
        return id;
    }

    public void setId(String value) {
        this.id = value;
    }

}
