/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.javaee.api.activator.org.apache.openejb.javaee.api.locator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ProviderLocator {
    private static Object context;
    private static Object registryTracker;
    private static Class<?> bundleContextClazz;
    private static Class<?> serviceTrackerClazz;

    private ProviderLocator() {
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return ProviderLocator.loadClass(className, null, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> loadClass(String className, Class<?> contextClass) throws ClassNotFoundException {
        return ProviderLocator.loadClass(className, contextClass, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> loadClass(String className, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (contextClass != null) {
            loader = contextClass.getClassLoader();
        }
        return Class.forName(className, true, loader);
    }

    public static Object getService(String iface, Class<?> contextClass, ClassLoader loader) throws Exception {
        Class<?> cls = ProviderLocator.locateServiceClass(iface, contextClass, loader);
        if (cls != null) {
            return cls.newInstance();
        }
        return null;
    }

    public static Class<?> getServiceClass(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        return ProviderLocator.locateServiceClass(iface, contextClass, loader);
    }

    public static List<Object> getServices(String iface, Class<?> contextClass, ClassLoader loader) throws Exception {
        ArrayList<Object> services = new ArrayList<Object>();
        Collection<Class<?>> classes = ProviderLocator.locateServiceClasses(iface, contextClass, loader);
        if (classes != null) {
            for (Class<?> cls : classes) {
                services.add(cls.newInstance());
            }
        }
        return services;
    }

    public static List<Class<?>> getServiceClasses(String iface, Class<?> contextClass, ClassLoader loader) throws Exception {
        LinkedHashSet serviceClasses = new LinkedHashSet();
        Collection<Class<?>> classes = ProviderLocator.locateServiceClasses(iface, contextClass, loader);
        if (classes != null) {
            serviceClasses.addAll(classes);
        }
        return new ArrayList(serviceClasses);
    }

    private static String locateServiceClassName(String iface, Class<?> contextClass, ClassLoader loader) {
        String name = ProviderLocator.locateServiceClassName(iface, loader);
        if (name != null) {
            return name;
        }
        if (contextClass != null && (name = ProviderLocator.locateServiceClassName(iface, contextClass.getClassLoader())) != null) {
            return name;
        }
        return null;
    }

    private static String locateServiceClassName(String iface, ClassLoader loader) {
        if (loader != null) {
            try {
                String service = "META-INF/services/" + iface;
                Enumeration<URL> providers = loader.getResources(service);
                while (providers.hasMoreElements()) {
                    List<String> providerNames = ProviderLocator.parseServiceDefinition(providers.nextElement());
                    if (providerNames.isEmpty()) continue;
                    return providerNames.get(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class<?> locateServiceClass(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        String className = ProviderLocator.locateServiceClassName(iface, contextClass, loader);
        if (className == null) {
            return null;
        }
        return ProviderLocator.loadClass(className, contextClass, loader);
    }

    private static Collection<String> locateServiceClassNames(String iface, Class<?> contextClass, ClassLoader loader) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        ProviderLocator.locateServiceClassNames(iface, loader, names);
        if (contextClass != null) {
            ProviderLocator.locateServiceClassNames(iface, contextClass.getClassLoader(), names);
        }
        return names;
    }

    static void locateServiceClassNames(String iface, ClassLoader loader, Set names) {
        if (loader != null) {
            try {
                String service = "META-INF/services/" + iface;
                Enumeration<URL> providers = loader.getResources(service);
                while (providers.hasMoreElements()) {
                    List<String> providerNames = ProviderLocator.parseServiceDefinition(providers.nextElement());
                    names.addAll(providerNames);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Collection<Class<?>> locateServiceClasses(String iface, Class<?> contextClass, ClassLoader loader) throws ClassNotFoundException {
        Collection<String> classNames = ProviderLocator.locateServiceClassNames(iface, contextClass, loader);
        LinkedHashSet classes = new LinkedHashSet();
        for (String name : classNames) {
            classes.add(ProviderLocator.loadClass(name, contextClass, loader));
        }
        return classes;
    }

    private static List<String> parseServiceDefinition(URL u) {
        String url = u.toString();
        ArrayList<String> classes = new ArrayList<String>();
        if (url.endsWith("/")) {
            return classes;
        }
        String providerId = url.substring(url.lastIndexOf("/") + 1);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                int comment = line.indexOf(35);
                if (comment != -1) {
                    line = line.substring(0, comment);
                }
                if ((line = line.trim()).length() > 0) {
                    classes.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupByJREPropertyFile(String path, String property) throws IOException {
        String jreDirectory = System.getProperty("java.home");
        File configurationFile = new File(jreDirectory + File.separator + path);
        if (configurationFile.exists() && configurationFile.canRead()) {
            Properties properties = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(configurationFile);
                properties.load(in);
                String string = properties.getProperty(property);
                return string;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return null;
    }

    static {
        bundleContextClazz = null;
        serviceTrackerClazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            bundleContextClazz = cl.loadClass("org.osgi.framework.BundleContext");
            serviceTrackerClazz = cl.loadClass("org.osgi.util.tracker.ServiceTracker");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

