/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidadinternal.config.LazyValueExpression;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalDesktopSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalPdaSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.MinimalPortletSkinExtension;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimpleDesktopSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimplePdaSkin;
import org.apache.myfaces.trinidadinternal.renderkit.core.skin.SimplePortletSkin;
import org.apache.myfaces.trinidadinternal.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.xml.ClassParserFactory;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.SkinExtension;
import org.apache.myfaces.trinidadinternal.skin.SkinFactoryImpl;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinAdditionNode;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinNode;
import org.apache.myfaces.trinidadinternal.skin.parse.SkinsNode;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinUtils {
    private static ParserManager _sManager;
    private static final String _LAF_PARSE_PACKAGE = "org.apache.myfaces.trinidadinternal.skin.parse.";
    private static final String _CONFIG_FILE = "/WEB-INF/trinidad-skins.xml";
    private static final String _META_INF_CONFIG_FILE = "META-INF/trinidad-skins.xml";
    private static final String _META_INF_DIR = "META-INF/";
    private static final TrinidadLogger _LOG;
    private static final String _UNKNOWN_BASE_SKIN_ERROR = "Unable to locate base skin: ";
    private static final String _RENDER_KIT_ID_DESKTOP = "org.apache.myfaces.trinidad.desktop";
    private static final String _RENDER_KIT_ID_PDA = "org.apache.myfaces.trinidad.pda";
    private static final String _SIMPLE_PDA_SKIN_ID = "simple.pda";
    private static final String _SIMPLE_DESKTOP_SKIN_ID = "simple.desktop";

    public static void registerBaseSkins() {
        SkinFactory skinFactory = SkinFactory.getFactory();
        if (skinFactory == null) {
            SkinFactory.setFactory((SkinFactory)new SkinFactoryImpl());
            skinFactory = SkinFactory.getFactory();
        }
        SkinUtils._registerTrinidadSkins(skinFactory);
    }

    public static void registerSkinExtensions(ExternalContext context) {
        SkinFactory skinFactory = SkinFactory.getFactory();
        if (skinFactory == null) {
            SkinFactory.setFactory((SkinFactory)new SkinFactoryImpl());
            skinFactory = SkinFactory.getFactory();
        }
        SkinUtils._registerSkinExtensionsAndAdditions(context, skinFactory);
    }

    public static Icon resolveReferenceIcon(Skin skin, ReferenceIcon refIcon) {
        return SkinUtils._resolveReferenceIcon(skin, refIcon, null);
    }

    private static Icon _resolveReferenceIcon(Skin skin, ReferenceIcon refIcon, Stack<String> referencedIconStack) {
        String refName = refIcon.getName();
        if (referencedIconStack != null && referencedIconStack.contains(refName)) {
            if (_LOG.isWarning()) {
                _LOG.warning("SKIN_CIRCULAR_INCLUDE_ERROR", (Object)refName);
            }
            return null;
        }
        if (referencedIconStack == null) {
            referencedIconStack = new Stack();
        }
        referencedIconStack.push(refName);
        Icon icon = skin.getIcon(refName, false);
        if (icon instanceof ReferenceIcon && icon != null) {
            return SkinUtils._resolveReferenceIcon(skin, (ReferenceIcon)icon, referencedIconStack);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SkinsNode _getSkinsNodeFromInputStream(XMLProvider provider, NameResolver resolver, InputStream inputStream, ParserManager parserManager, String configFile) {
        if (inputStream == null) {
            throw new NullPointerException(_LOG.getMessage("NO_INPUTSTREAM"));
        }
        if (parserManager == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_PARSEMANAGER"));
        }
        SkinsNode skinsNode = null;
        try {
            InputSource input = new InputSource();
            input.setByteStream(inputStream);
            input.setPublicId(configFile);
            ParseContextImpl context = new ParseContextImpl();
            if (resolver != null) {
                XMLUtils.setResolver(context, resolver);
            }
            TreeBuilder builder = new TreeBuilder(parserManager, SkinsNode.class);
            skinsNode = (SkinsNode)builder.parse(provider, input, context);
        }
        catch (IOException ioe) {
            _LOG.warning((Throwable)ioe);
        }
        catch (SAXException saxe) {
            _LOG.warning((Throwable)saxe);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {}
        }
        return skinsNode;
    }

    public static ParserManager createDefaultManager() {
        ParserManager manager = new ParserManager();
        SkinUtils._registerFactory(manager, SkinsNode.class, "SkinsNode");
        SkinUtils._registerFactory(manager, SkinNode.class, "SkinNode");
        SkinUtils._registerFactory(manager, SkinAdditionNode.class, "SkinAdditionNode");
        return manager;
    }

    private static ParserManager _getDefaultManager() {
        if (_sManager == null) {
            _sManager = SkinUtils.createDefaultManager();
        }
        return _sManager;
    }

    private static void _registerFactory(ParserManager manager, Class<?> expectedType, String baseName) {
        String className = _LAF_PARSE_PACKAGE + baseName + "Parser";
        ClassParserFactory factory = new ClassParserFactory(className);
        manager.registerFactory(expectedType, "http://myfaces.apache.org/trinidad/skin", factory);
    }

    private static void _registerTrinidadSkins(SkinFactory skinFactory) {
        SimpleDesktopSkin simpleDesktopSkin = new SimpleDesktopSkin();
        skinFactory.addSkin(simpleDesktopSkin.getId(), (Skin)simpleDesktopSkin);
        SimplePdaSkin simplePdaSkin = new SimplePdaSkin();
        skinFactory.addSkin(simplePdaSkin.getId(), (Skin)simplePdaSkin);
        SimplePortletSkin simplePortletSkin = new SimplePortletSkin();
        skinFactory.addSkin(simplePortletSkin.getId(), (Skin)simplePortletSkin);
        MinimalDesktopSkinExtension minimalDesktopSkin = new MinimalDesktopSkinExtension(simpleDesktopSkin);
        skinFactory.addSkin(minimalDesktopSkin.getId(), (Skin)minimalDesktopSkin);
        MinimalPdaSkinExtension minimalPdaSkin = new MinimalPdaSkinExtension(simplePdaSkin);
        skinFactory.addSkin(minimalPdaSkin.getId(), (Skin)minimalPdaSkin);
        MinimalPortletSkinExtension minimalPortletSkin = new MinimalPortletSkinExtension(simplePortletSkin);
        skinFactory.addSkin(minimalPortletSkin.getId(), (Skin)minimalPortletSkin);
    }

    private static void _registerSkinExtensionsAndAdditions(ExternalContext context, SkinFactory skinFactory) {
        if (context == null) {
            return;
        }
        List<SkinsNode> metaInfSkinsNodeList = SkinUtils._getMetaInfSkinsNodeList();
        ArrayList<SkinNode> metaInfSkinNodes = new ArrayList<SkinNode>();
        for (SkinsNode skinsNode : metaInfSkinsNodeList) {
            metaInfSkinNodes.addAll(skinsNode.getSkinNodes());
        }
        List<SkinNode> sortedMetaInfSkinNodes = SkinUtils._sortSkinNodes(skinFactory, metaInfSkinNodes);
        for (SkinNode skinNode : sortedMetaInfSkinNodes) {
            SkinUtils._addSkinToFactory(skinFactory, skinNode, true);
        }
        SkinsNode webInfSkinsNode = SkinUtils._getWebInfSkinsNode(context);
        if (webInfSkinsNode != null) {
            List<SkinNode> webInfSkinNodes = webInfSkinsNode.getSkinNodes();
            List<SkinNode> sortedWebInfSkinNodes = SkinUtils._sortSkinNodes(skinFactory, webInfSkinNodes);
            for (SkinNode skinNode : sortedWebInfSkinNodes) {
                SkinUtils._addSkinToFactory(skinFactory, skinNode, false);
            }
        }
        FacesContext fContext = FacesContext.getCurrentInstance();
        SkinUtils._registerMetaInfSkinAdditions(fContext, skinFactory, metaInfSkinsNodeList);
        if (webInfSkinsNode != null) {
            List<SkinAdditionNode> skinAdditionNodeList = webInfSkinsNode.getSkinAdditionNodes();
            SkinUtils._registerSkinAdditions(fContext, skinFactory, skinAdditionNodeList, false);
        }
    }

    private static List<SkinNode> _sortSkinNodes(SkinFactory skinFactory, List<SkinNode> skinNodes) {
        ArrayList<SkinNode> sortedSkinNodes = new ArrayList<SkinNode>();
        ArrayList<String> skinNodesAdded = new ArrayList<String>();
        ArrayList<String> baseSkinIds = new ArrayList<String>();
        Iterator i = skinFactory.getSkinIds();
        while (i.hasNext()) {
            baseSkinIds.add((String)i.next());
        }
        for (SkinNode skinNode : skinNodes) {
            String skinExtends = skinNode.getSkinExtends();
            if (skinExtends != null) continue;
            sortedSkinNodes.add(skinNode);
            skinNodesAdded.add(skinNode.getId());
        }
        SkinUtils._sortSkinNodesWithExtensions(skinNodes, sortedSkinNodes, skinNodesAdded, baseSkinIds, 0);
        return sortedSkinNodes;
    }

    private static void _sortSkinNodesWithExtensions(List<SkinNode> skinNodes, List<SkinNode> sortedSkinNodes, List<String> skinNodesAdded, List<String> baseSkinIds, int originalLeftOverListSize) {
        ArrayList<SkinNode> leftOverList = new ArrayList<SkinNode>();
        for (SkinNode skinNode : skinNodes) {
            String skinExtends = skinNode.getSkinExtends();
            if (skinExtends == null) continue;
            if (skinNodesAdded.contains(skinExtends) || baseSkinIds.contains(skinExtends)) {
                sortedSkinNodes.add(skinNode);
                skinNodesAdded.add(skinNode.getId());
                continue;
            }
            leftOverList.add(skinNode);
        }
        if (originalLeftOverListSize > 0 && leftOverList.size() == originalLeftOverListSize) {
            StringBuffer buffer = new StringBuffer();
            for (SkinNode leftOverNode : leftOverList) {
                buffer.append("Skin with id: " + leftOverNode.getId() + " extends skin with id: " + leftOverNode.getSkinExtends() + "\n");
                sortedSkinNodes.add(leftOverNode);
                skinNodesAdded.add(leftOverNode.getId());
            }
            _LOG.warning("The following skins extend each other in a circular fashion or the skin they extend does not exist.\n" + buffer.toString());
        } else if (leftOverList.size() > 0) {
            SkinUtils._sortSkinNodesWithExtensions(leftOverList, sortedSkinNodes, skinNodesAdded, baseSkinIds, leftOverList.size());
        }
    }

    private static void _addSkinToFactory(SkinFactory skinFactory, SkinNode skinNode, boolean isMetaInfFile) {
        String renderKitId = skinNode.getRenderKitId();
        String id = skinNode.getId();
        String family = skinNode.getFamily();
        String styleSheetName = skinNode.getStyleSheetName();
        String bundleName = skinNode.getBundleName();
        String translationSourceExpression = skinNode.getTranslationSourceExpression();
        if (renderKitId == null) {
            renderKitId = _RENDER_KIT_ID_DESKTOP;
        }
        Skin baseSkin = null;
        String skinExtends = skinNode.getSkinExtends();
        if (skinExtends != null) {
            baseSkin = skinFactory.getSkin(null, skinExtends);
        }
        if (baseSkin == null) {
            baseSkin = SkinUtils._getDefaultBaseSkin(skinFactory, renderKitId);
            if (skinExtends != null) {
                _LOG.severe("UNABLE_LOCATE_BASE_SKIN", (Object[])new String[]{skinExtends, id, family, renderKitId, baseSkin.getId()});
            }
        }
        if (styleSheetName != null && isMetaInfFile) {
            styleSheetName = SkinUtils._prependMetaInf(styleSheetName);
        }
        SkinExtension skin = null;
        if (bundleName != null) {
            skin = new SkinExtension(baseSkin, id, family, renderKitId, styleSheetName, bundleName);
        } else {
            ValueExpression translationSourceVE = null;
            if (translationSourceExpression != null) {
                translationSourceVE = SkinUtils._createTranslationSourceValueExpression(translationSourceExpression);
            }
            skin = translationSourceVE != null ? new SkinExtension(baseSkin, id, family, renderKitId, styleSheetName, translationSourceVE) : new SkinExtension(baseSkin, id, family, renderKitId, styleSheetName);
        }
        skinFactory.addSkin(id, (Skin)skin);
    }

    private static ValueExpression _createTranslationSourceValueExpression(String translationSourceExpression) {
        if (translationSourceExpression != null) {
            translationSourceExpression = translationSourceExpression.trim();
            return LazyValueExpression.createValueExpression(translationSourceExpression, Object.class);
        }
        return null;
    }

    private static SkinsNode _getWebInfSkinsNode(ExternalContext context) {
        InputStream in = context.getResourceAsStream(_CONFIG_FILE);
        if (in != null) {
            SkinsNode webInfSkinsNode = SkinUtils._getSkinsNodeFromInputStream(null, null, in, SkinUtils._getDefaultManager(), _CONFIG_FILE);
            return webInfSkinsNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SkinsNode> _getMetaInfSkinsNodeList() {
        ArrayList<SkinsNode> allSkinsNodes = new ArrayList<SkinsNode>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources(_META_INF_CONFIG_FILE);
            HashSet<String> urlPaths = new HashSet<String>(16);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                boolean successfullyAdded = urlPaths.add(url.getPath());
                if (!successfullyAdded) {
                    if (!_LOG.isFinest()) continue;
                    _LOG.finest("Skipping skin URL:{0} because it was already processed. It was on the classpath more than once.", (Object)url);
                    continue;
                }
                _LOG.finest("Processing skin URL:{0}", (Object)url);
                InputStream in = url.openStream();
                try {
                    if (in == null) continue;
                    SkinsNode metaInfSkinsNode = SkinUtils._getSkinsNodeFromInputStream(null, null, in, SkinUtils._getDefaultManager(), _META_INF_CONFIG_FILE);
                    allSkinsNodes.add(metaInfSkinsNode);
                }
                catch (Exception e) {
                    _LOG.warning("ERR_PARSING", (Object)url);
                    _LOG.warning((Throwable)e);
                }
                finally {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            _LOG.severe("ERR_LOADING_FILE", (Object)_META_INF_CONFIG_FILE);
            _LOG.severe((Throwable)e);
        }
        return allSkinsNodes;
    }

    private static Skin _getDefaultBaseSkin(SkinFactory factory, String renderKitId) {
        String baseSkinId = _RENDER_KIT_ID_PDA.equals(renderKitId) ? _SIMPLE_PDA_SKIN_ID : _SIMPLE_DESKTOP_SKIN_ID;
        Skin baseSkin = factory.getSkin(null, baseSkinId);
        if (baseSkin == null) {
            _LOG.severe(_UNKNOWN_BASE_SKIN_ERROR + baseSkinId);
        }
        return baseSkin;
    }

    private static void _registerMetaInfSkinAdditions(FacesContext fContext, SkinFactory skinFactory, List<SkinsNode> metaInfSkinsNodeList) {
        ArrayList<SkinAdditionNode> skinAdditionNodeList = new ArrayList<SkinAdditionNode>();
        for (SkinsNode skinsNode : metaInfSkinsNodeList) {
            skinAdditionNodeList.addAll(skinsNode.getSkinAdditionNodes());
        }
        Collections.sort(skinAdditionNodeList);
        SkinUtils._registerSkinAdditions(fContext, skinFactory, skinAdditionNodeList, true);
    }

    private static void _registerSkinAdditions(FacesContext fContext, SkinFactory skinFactory, List<SkinAdditionNode> skinAdditionNodeList, boolean isMetaInfFile) {
        for (SkinAdditionNode skinAdditionNode : skinAdditionNodeList) {
            String skinId = skinAdditionNode.getSkinId();
            String styleSheetName = skinAdditionNode.getStyleSheetName();
            String resourceBundleName = skinAdditionNode.getResourceBundleName();
            String translationSourceExpression = skinAdditionNode.getTranslationSourceExpression();
            Skin skin = skinFactory.getSkin(fContext, skinId);
            if (skin == null || styleSheetName == null && resourceBundleName == null && translationSourceExpression == null) continue;
            if (isMetaInfFile && styleSheetName != null) {
                styleSheetName = SkinUtils._prependMetaInf(styleSheetName);
            }
            SkinAddition addition = null;
            if (resourceBundleName != null) {
                addition = new SkinAddition(styleSheetName, resourceBundleName);
            } else {
                ValueExpression translationSourceVE = null;
                if (translationSourceExpression != null) {
                    translationSourceVE = SkinUtils._createTranslationSourceValueExpression(translationSourceExpression);
                }
                addition = translationSourceVE != null ? new SkinAddition(styleSheetName, translationSourceVE) : new SkinAddition(styleSheetName);
            }
            skin.addSkinAddition(addition);
        }
    }

    private static String _prependMetaInf(String styleSheetName) {
        if (!styleSheetName.startsWith("/")) {
            return _META_INF_DIR.concat(styleSheetName);
        }
        return styleSheetName;
    }

    private SkinUtils() {
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(SkinUtils.class);
    }
}

