/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.nls;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.nls.DateFormatContext;
import org.apache.myfaces.trinidadinternal.share.nls.DecimalFormatContext;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public class LocaleContextImpl
extends LocaleContext {
    private static final DateFormatContext _sDefaultDateFormatContext = new DefaultDate();
    private static final DecimalFormatContext _sDefaultDecimalFormatContext = new DefaultDecimal();
    private HashMap<String, ResourceBundle> _bundles;
    private Locale _formattingLocale;
    private Locale _transLocale;
    private transient String _formattingIanaLocale;
    private transient String _transIanaLocale;
    private TimeZone _timeZone;
    private int _readingDirection = 0;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LocaleContextImpl.class);

    public LocaleContextImpl(Locale locale) {
        this(locale, locale);
    }

    public LocaleContextImpl(Locale formattingLocale, Locale translationLocale) {
        if (!((Object)((Object)this)).getClass().getName().startsWith("org.apache.myfaces.trinidadinternal.share.nls.")) {
            throw new IllegalStateException(_LOG.getMessage("USER_DEFINED_SUBCLASSES_NOT_SUPOORTED"));
        }
        if (formattingLocale == null) {
            formattingLocale = Locale.getDefault();
        }
        this._formattingLocale = formattingLocale;
        if (translationLocale == null) {
            translationLocale = formattingLocale;
        }
        this._transLocale = translationLocale;
        this.setTimeZone(null);
    }

    public Locale getTranslationLocale() {
        return this._transLocale;
    }

    public Locale getFormattingLocale() {
        return this._formattingLocale;
    }

    public String getFormattingIANALocaleString() {
        if (this._formattingIanaLocale == null) {
            String localeString = this._formattingLocale.toString();
            this._formattingIanaLocale = localeString.replace('_', '-');
        }
        return this._formattingIanaLocale;
    }

    public String getTranslationIANALocaleString() {
        if (this._transIanaLocale == null) {
            String transLocaleString = this.getTranslationLocale().toString();
            this._transIanaLocale = transLocaleString.replace('_', '-');
        }
        return this._transIanaLocale;
    }

    public boolean isRightToLeft() {
        return this.getReadingDirection() == 2;
    }

    public int getReadingDirection() {
        if (this._readingDirection != 0) {
            return this._readingDirection;
        }
        return LocaleUtils.getReadingDirectionForLocale(this.getTranslationLocale());
    }

    @Deprecated
    public void setReadingDirection(int newReadingDirection) {
        if (newReadingDirection != 0 && newReadingDirection != 1 && newReadingDirection != 2) {
            throw new IllegalArgumentException(_LOG.getMessage("UNKNOWN_READING_DIRECTION", (Object)newReadingDirection));
        }
        this._readingDirection = newReadingDirection;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    @Deprecated
    public void setTimeZone(TimeZone newTimeZone) {
        if (newTimeZone == null) {
            newTimeZone = TimeZone.getDefault();
        }
        this._timeZone = newTimeZone;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append(" translationLocale=");
        buffer.append(this.getTranslationLocale());
        buffer.append(", formattingLocale=");
        buffer.append(this.getFormattingLocale());
        buffer.append(", direction=");
        buffer.append(this.getReadingDirection());
        buffer.append(", timeZone=");
        buffer.append(this.getTimeZone());
        buffer.append(", dateFormatContext=");
        buffer.append(this.getDateFormatContext());
        buffer.append(", decimalFormatContext=");
        buffer.append(this.getDecimalFormatContext());
        return buffer.toString();
    }

    public ResourceBundle getBundle(String baseBundleName) throws MissingResourceException {
        ResourceBundle bundle;
        if (this._bundles == null) {
            this._bundles = new HashMap(13);
        }
        if ((bundle = this._bundles.get(baseBundleName)) == null) {
            ClassLoader loader = ClassLoaderUtils.getContextClassLoader();
            Locale translationLocale = this.getTranslationLocale();
            bundle = loader == null ? ResourceBundle.getBundle(baseBundleName, translationLocale) : ResourceBundle.getBundle(baseBundleName, translationLocale, loader);
            this._bundles.put(baseBundleName, bundle);
        }
        return bundle;
    }

    public int getTwoDigitYearStart() {
        return this.getDateFormatContext().getTwoDigitYearStart();
    }

    public char getGroupingSeparator() {
        return this.getDecimalFormatContext().getGroupingSeparator();
    }

    public char getDecimalSeparator() {
        return this.getDecimalFormatContext().getDecimalSeparator();
    }

    public final DateFormatContext getDateFormatContext() {
        DateFormatContext dfc = this.getDateFormatContextImpl();
        if (dfc == null) {
            dfc = _sDefaultDateFormatContext;
        }
        return dfc;
    }

    public final DecimalFormatContext getDecimalFormatContext() {
        DecimalFormatContext dfc = this.getDecimalFormatContextImpl();
        if (dfc == null) {
            dfc = _sDefaultDecimalFormatContext;
        }
        return dfc;
    }

    public int hashCode() {
        return this.getFormattingLocale().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocaleContextImpl)) {
            return false;
        }
        LocaleContextImpl that = (LocaleContextImpl)((Object)obj);
        return this.getTranslationLocale().equals(that.getTranslationLocale()) && this.getFormattingLocale().equals(that.getFormattingLocale()) && this.getTimeZone().equals(that.getTimeZone()) && this.getReadingDirection() == that.getReadingDirection() && this.getDateFormatContext().equals(that.getDateFormatContext()) && this.getDecimalFormatContext().equals(that.getDecimalFormatContext());
    }

    protected DateFormatContext getDateFormatContextImpl() {
        return null;
    }

    protected DecimalFormatContext getDecimalFormatContextImpl() {
        return null;
    }

    private static class DefaultDate
    extends DateFormatContext {
        private DefaultDate() {
        }

        public int getTwoDigitYearStart() {
            return 1950;
        }
    }

    private static class DefaultDecimal
    extends DecimalFormatContext {
        private DefaultDecimal() {
        }

        public char getGroupingSeparator() {
            return '\u0000';
        }

        public char getDecimalSeparator() {
            return '\u0000';
        }
    }
}

