/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.beans.Beans;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.style.Styles;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestType;
import org.apache.myfaces.trinidadinternal.agent.AgentUtil;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgentImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRendererUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.StyleContextImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.share.nls.MutableDecimalFormatContext;
import org.apache.myfaces.trinidadinternal.share.nls.MutableLocaleContext;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.skin.SkinNotAvailable;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRenderingContext
extends RenderingContext {
    public static final String EMPTY_STYLE_CLASS = "";
    private Skin _skin;
    private boolean _checkedRequestMapSkin = false;
    private Skin _requestMapSkin;
    private Object _styleSheetDocumentIdMatch;
    private FormData _formData;
    private TrinidadAgent _agent;
    private Map<String, String> _styleMap;
    private Map<String, String> _skinResourceKeyMap;
    private String _outputMode;
    private RequestContext.Accessibility _accessibilityMode;
    private AccessibilityProfile _accessibilityProfile;
    private boolean _animationEnabled;
    private PartialPageContext _pprContext;
    private LocaleContext _localeContext;
    private StyleContext _styleContext;
    private Map<Object, Object> _properties;
    private int _linkStyleDisabledCount = 0;
    private boolean _isLinkDisabled = false;
    private final FacesContext _facesContext;
    private final RequestContext _requestContext;
    private static final String _SKIN_ID_PARAM = "org.apache.myfaces.trinidad.skin.id";
    private static final String _SKIN_STYLESHEET_ID_PARAM = "org.apache.myfaces.trinidad.skin.stylesheet.id";
    private static final Map<Object, Object> _PRINTABLE_CAPABILITIES = new HashMap<Object, Object>();
    private static final Map<Object, Object> _EMAIL_CAPABILITIES = new HashMap<Object, Object>();
    private static final Map<Object, Object> _PORTLET_CAPABILITIES = new HashMap<Object, Object>();
    private static final Map<Object, Object> _ENHANCED_PORTLET_CAPABILITIES = new HashMap<Object, Object>();
    private static final TrinidadLogger _LOG;

    public CoreRenderingContext() {
        FacesContext context = FacesContext.getCurrentInstance();
        RequestContext afContext = RequestContext.getCurrentInstance();
        this._facesContext = context;
        this._requestContext = afContext;
        this._properties = new HashMap<Object, Object>();
        this._outputMode = afContext.getOutputMode();
        this._agent = this._initializeAgent(context, afContext.getAgent(), this.getOutputMode());
        this._initializeSkin(context, afContext);
        this._initializePPR(context, afContext);
        this._accessibilityMode = afContext.getAccessibilityMode();
        this._animationEnabled = afContext.isAnimationEnabled();
        this._accessibilityProfile = afContext.getAccessibilityProfile();
        if (this._accessibilityProfile == null) {
            this._accessibilityProfile = AccessibilityProfile.getDefaultInstance();
        }
    }

    public final FacesContext getFacesContext() {
        return this._facesContext;
    }

    public final RequestContext getRequestContext() {
        return this._requestContext;
    }

    public boolean isDefaultLinkStyleDisabled() {
        return this._linkStyleDisabledCount > 0;
    }

    public void setDefaultLinkStyleDisabled(boolean isDisabled) {
        this._linkStyleDisabledCount = isDisabled ? ++this._linkStyleDisabledCount : --this._linkStyleDisabledCount;
    }

    public boolean isLinkDisabled() {
        return this._isLinkDisabled;
    }

    public void setLinkDisabled(boolean isDisabled) {
        this._isLinkDisabled = isDisabled;
    }

    public Map<Object, Object> getProperties() {
        return this._properties;
    }

    public Agent getAgent() {
        return this._agent;
    }

    public TrinidadAgent getTrinidadAgent() {
        return (TrinidadAgent)this.getAgent();
    }

    public boolean isRightToLeft() {
        if (this._localeContext != null) {
            return this._localeContext.isRightToLeft();
        }
        return this.getRequestContext().isRightToLeft();
    }

    public String getOutputMode() {
        return this._outputMode;
    }

    public RequestContext.Accessibility getAccessibilityMode() {
        return this._accessibilityMode;
    }

    public AccessibilityProfile getAccessibilityProfile() {
        return this._accessibilityProfile;
    }

    public boolean isAnimationEnabled() {
        return this._animationEnabled;
    }

    public FormData getFormData() {
        return this._formData;
    }

    public void setFormData(FormData formData) {
        this._formData = formData;
    }

    public void clearFormData() {
        this._formData = null;
    }

    public Skin getSkin() {
        if (!this._checkedRequestMapSkin) {
            Skin requestedSkin = this.getRequestMapSkin();
            this._checkedRequestMapSkin = true;
            if (requestedSkin != null) {
                this._skin = requestedSkin;
                this.getStyleContext().getStyleProvider(true);
            }
        }
        return this._skin;
    }

    public Styles getStyles() {
        return this.getStyleContext().getStyles();
    }

    public StyleContext getStyleContext() {
        if (this._styleContext == null) {
            this._styleContext = new StyleContextImpl(this, CoreRenderingContext.getTemporaryDirectory(this.getFacesContext()));
        }
        return this._styleContext;
    }

    public LocaleContext getLocaleContext() {
        if (this._localeContext == null) {
            this._initializeLocaleContext(this.getFacesContext(), this.getRequestContext());
        }
        return this._localeContext;
    }

    public PartialPageContext getPartialPageContext() {
        return this._pprContext;
    }

    public String getStyleClass(String styleClass) {
        if (styleClass == null) {
            return null;
        }
        styleClass = this.getSkinResourceMappedKey(styleClass);
        String shortenedStyle = null;
        if (this._styleMap != null) {
            shortenedStyle = this._styleMap.get(styleClass);
        }
        if (shortenedStyle != null) {
            if (EMPTY_STYLE_CLASS == shortenedStyle) {
                return null;
            }
            styleClass = shortenedStyle;
        } else {
            styleClass = StyleUtils.convertToValidSelector(styleClass);
        }
        return styleClass;
    }

    public Icon getIcon(String iconName) {
        if ((iconName = this.getSkinResourceMappedKey(iconName)) == null) {
            return null;
        }
        Skin skin = this.getSkin();
        if (this.isRightToLeft() && !iconName.endsWith(":rtl")) {
            String rtlIconName = iconName + ":rtl";
            Icon rtlIcon = skin.getIcon(rtlIconName);
            if ((rtlIcon == null || rtlIcon.isNull()) && (rtlIcon = skin.getIcon(iconName)) != null) {
                skin.registerIcon(rtlIconName, rtlIcon);
            }
            return rtlIcon;
        }
        return skin.getIcon(iconName);
    }

    public void setStyleMap(Map<String, String> mapping) {
        this._styleMap = mapping;
    }

    public void setSkinResourceKeyMap(Map<String, String> mapping) {
        this._skinResourceKeyMap = mapping;
    }

    public Map<String, String> getSkinResourceKeyMap() {
        return this._skinResourceKeyMap;
    }

    protected String getSkinResourceMappedKey(String key) {
        String mappedKey;
        Map<String, String> keyMap = this.getSkinResourceKeyMap();
        if (keyMap != null && (mappedKey = keyMap.get(key)) != null) {
            key = mappedKey;
        }
        return key;
    }

    protected String getDefaultSkinFamily() {
        return "minimal";
    }

    public Skin getRequestMapSkin() {
        FacesContext context;
        Object requestedSkinId;
        if (this._checkedRequestMapSkin) {
            return this._requestMapSkin;
        }
        this._checkedRequestMapSkin = true;
        if (("portlet".equals(this.getOutputMode()) || Beans.isDesignTime()) && (requestedSkinId = this.getRequestMapSkinId(context = this.getFacesContext())) != null) {
            SkinFactory factory = SkinFactory.getFactory();
            if (factory == null) {
                _LOG.warning("NO_SKIN_FACTORY");
                return null;
            }
            Skin requestedSkin = factory.getSkin(context, requestedSkinId.toString());
            if (requestedSkin != null) {
                if (_LOG.isFine()) {
                    _LOG.fine("The skin " + requestedSkinId + " specified on the requestMap will be used.");
                }
                this._requestMapSkin = requestedSkin;
                this.isRequestMapStyleSheetIdAndSkinEqual(context, requestedSkin);
                return new RequestSkinWrapper(requestedSkin);
            }
            if (_LOG.isWarning()) {
                _LOG.warning("REQUESTMAP_SKIN_NOT_USED_BECAUSE_NOT_EXIST", requestedSkinId);
            }
        }
        return null;
    }

    public Object getRequestMapSkinId(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object requestedSkinId = requestMap.get(_SKIN_ID_PARAM);
        return requestedSkinId;
    }

    public boolean isRequestMapStyleSheetIdAndSkinEqual(FacesContext context, Skin requestedSkin) {
        if ("portlet".equals(this.getOutputMode())) {
            if (this._styleSheetDocumentIdMatch == null) {
                this._styleSheetDocumentIdMatch = Boolean.FALSE;
                if (requestedSkin != null) {
                    Map requestMap = context.getExternalContext().getRequestMap();
                    Object requestMapStyleSheetId = requestMap.get(_SKIN_STYLESHEET_ID_PARAM);
                    if (requestMapStyleSheetId != null) {
                        this.getStyleContext().getStyleProvider();
                        String skinForPortalStyleSheetId = requestedSkin.getStyleSheetDocumentId((RenderingContext)this);
                        if (skinForPortalStyleSheetId != null && skinForPortalStyleSheetId.equals(requestMapStyleSheetId)) {
                            this._styleSheetDocumentIdMatch = Boolean.TRUE;
                        } else if (_LOG.isWarning()) {
                            _LOG.warning("STYLESHEETDOCUMENT_ID_NOT_MATCH_LOCAL_SKIN", (Object)requestedSkin.getId());
                        }
                    } else if (_LOG.isWarning()) {
                        _LOG.warning("STYLESHEETDOCUMENT_ID_NOT_IN_REQUESTMAP", (Object)requestedSkin.getId());
                    }
                }
            }
            return Boolean.TRUE.equals(this._styleSheetDocumentIdMatch);
        }
        return false;
    }

    private void _initializeSkin(FacesContext context, RequestContext afContext) {
        String skinFamily = afContext.getSkinFamily();
        if (skinFamily == null) {
            skinFamily = this.getDefaultSkinFamily();
        }
        String renderKitId = "org.apache.myfaces.trinidad.desktop";
        if ("portlet".equals(this.getOutputMode())) {
            renderKitId = "portlet";
        } else if (2 == this._agent.getAgentType()) {
            renderKitId = "org.apache.myfaces.trinidad.pda";
        }
        SkinFactory factory = SkinFactory.getFactory();
        if (factory == null) {
            _LOG.warning("NO_SKIN_FACTORY");
            return;
        }
        Skin skin = factory.getSkin(null, skinFamily, renderKitId);
        if (skin == null && _LOG.isWarning()) {
            _LOG.warning("CANNOT_GET_SKIN_FROM_SKINFACTORY", (Object)skinFamily);
        }
        if (skin == null) {
            skin = SkinNotAvailable.getSkinNotAvailable();
        }
        this._skin = skin;
    }

    private TrinidadAgent _initializeAgent(FacesContext context, Agent base, String outputMode) {
        TrinidadAgent agent = base instanceof TrinidadAgent ? (TrinidadAgent)base : new TrinidadAgentImpl(context, base);
        if ("printable".equals(outputMode)) {
            return AgentUtil.mergeCapabilities(agent, _PRINTABLE_CAPABILITIES);
        }
        if ("email".equals(outputMode)) {
            return AgentUtil.mergeCapabilities(agent, _EMAIL_CAPABILITIES);
        }
        if ("portlet".equals(outputMode)) {
            if (ExternalContextUtils.isRequestTypeSupported((RequestType)RequestType.RESOURCE)) {
                return AgentUtil.mergeCapabilities(agent, _ENHANCED_PORTLET_CAPABILITIES);
            }
            return AgentUtil.mergeCapabilities(agent, _PORTLET_CAPABILITIES);
        }
        return agent;
    }

    private void _initializePPR(FacesContext fContext, RequestContext context) {
        PartialPageContext partialPageContext;
        if (!CoreRendererUtils.supportsPartialRendering(this)) {
            return;
        }
        this._pprContext = partialPageContext = PartialPageUtils.createPartialPageContext(fContext, context);
    }

    public static String getTemporaryDirectory(FacesContext fContext) {
        String path = null;
        ExternalContext external = fContext.getExternalContext();
        Map applicationMap = external.getApplicationMap();
        if (applicationMap != null) {
            File tempdir = (File)applicationMap.get("javax.servlet.context.tempdir");
            if (tempdir == null) {
                if (Beans.isDesignTime() || !(external.getContext() instanceof ServletContext)) {
                    tempdir = new File(System.getProperty("java.io.tmpdir"));
                    path = tempdir.getAbsolutePath();
                } else {
                    _LOG.severe("The java.io.File handle (\"javax.servlet.context.tempdir\") is not set in the ServletContext");
                }
            } else {
                path = tempdir.getAbsolutePath();
            }
        }
        return path;
    }

    private void _initializeLocaleContext(FacesContext fContext, RequestContext context) {
        char decimal;
        Locale translations = fContext.getViewRoot().getLocale();
        Locale formatting = context.getFormattingLocale();
        if (formatting == null) {
            formatting = translations;
        }
        MutableLocaleContext localeContext = new MutableLocaleContext(formatting, translations);
        localeContext.setReadingDirection(context.isRightToLeft() ? 2 : 1);
        localeContext.setTimeZone(context.getTimeZone());
        MutableDecimalFormatContext mdfc = new MutableDecimalFormatContext(localeContext.getDecimalFormatContext());
        char grouping = context.getNumberGroupingSeparator();
        if (grouping != '\u0000') {
            mdfc.setGroupingSeparator(grouping);
        }
        if ((decimal = context.getDecimalSeparator()) != '\u0000') {
            mdfc.setDecimalSeparator(decimal);
        }
        localeContext.setDecimalFormatContext(mdfc);
        this._localeContext = localeContext;
    }

    static {
        _PRINTABLE_CAPABILITIES.put(TrinidadAgent.CAP_INTRINSIC_EVENTS, Boolean.FALSE);
        _PRINTABLE_CAPABILITIES.put(TrinidadAgent.CAP_SCRIPTING_SPEED, TrinidadAgent.SCRIPTING_SPEED_CAP_NONE);
        _PRINTABLE_CAPABILITIES.put(TrinidadAgent.CAP_NAVIGATION, Boolean.FALSE);
        _PRINTABLE_CAPABILITIES.put(TrinidadAgent.CAP_EDITING, Boolean.FALSE);
        _PRINTABLE_CAPABILITIES.put(TrinidadAgent.CAP_PARTIAL_RENDERING, Boolean.FALSE);
        _EMAIL_CAPABILITIES.put(TrinidadAgent.CAP_INTRINSIC_EVENTS, Boolean.FALSE);
        _EMAIL_CAPABILITIES.put(TrinidadAgent.CAP_SCRIPTING_SPEED, TrinidadAgent.SCRIPTING_SPEED_CAP_NONE);
        _EMAIL_CAPABILITIES.put(TrinidadAgent.CAP_EDITING, Boolean.FALSE);
        _EMAIL_CAPABILITIES.put(TrinidadAgent.CAP_STYLE_ATTRIBUTES, TrinidadAgent.STYLES_INTERNAL);
        _EMAIL_CAPABILITIES.put(TrinidadAgent.CAP_PARTIAL_RENDERING, Boolean.FALSE);
        _PORTLET_CAPABILITIES.put(TrinidadAgent.CAP_PARTIAL_RENDERING, Boolean.FALSE);
        _PORTLET_CAPABILITIES.put(TrinidadAgent.CAP_MULTIPLE_WINDOWS, Boolean.FALSE);
        _ENHANCED_PORTLET_CAPABILITIES.put(TrinidadAgent.CAP_MULTIPLE_WINDOWS, Boolean.FALSE);
        _LOG = TrinidadLogger.createTrinidadLogger(CoreRenderingContext.class);
    }
}

