/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.util.Arrays;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestNGReporter
implements ITestListener,
ISuiteListener {
    private final RunListener reporter;

    public TestNGReporter(RunListener reportManager) {
        this.reporter = reportManager;
    }

    public void onTestStart(ITestResult result) {
        String clazz = result.getTestClass().getName();
        String group = TestNGReporter.groupString(result.getMethod().getGroups(), clazz);
        this.reporter.testStarting((ReportEntry)new CategorizedReportEntry(clazz, TestNGReporter.testName(result), group));
    }

    public void onTestSuccess(ITestResult result) {
        SimpleReportEntry report = new SimpleReportEntry(result.getTestClass().getName(), null, TestNGReporter.testName(result), null);
        this.reporter.testSucceeded((ReportEntry)report);
    }

    public void onTestFailure(ITestResult result) {
        IClass clazz = result.getTestClass();
        SimpleReportEntry report = SimpleReportEntry.withException((String)clazz.getName(), null, (String)TestNGReporter.testName(result), null, (StackTraceWriter)new PojoStackTraceWriter(clazz.getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reporter.testFailed((ReportEntry)report);
    }

    public void onTestSkipped(ITestResult result) {
        Throwable t = result.getThrowable();
        String reason = t == null ? null : t.getMessage();
        SimpleReportEntry report = SimpleReportEntry.ignored((String)result.getTestClass().getName(), null, (String)TestNGReporter.testName(result), null, (String)reason);
        this.reporter.testSkipped((ReportEntry)report);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        IClass clazz = result.getTestClass();
        SimpleReportEntry report = SimpleReportEntry.withException((String)clazz.getName(), null, (String)TestNGReporter.testName(result), null, (StackTraceWriter)new PojoStackTraceWriter(clazz.getRealClass().getName(), result.getMethod().getMethodName(), result.getThrowable()));
        this.reporter.testSucceeded((ReportEntry)report);
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
    }

    private static String groupString(String[] groups, String defaultValue) {
        String retVal;
        if (groups != null && groups.length > 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < groups.length; ++i) {
                str.append(groups[i]);
                if (i + 1 >= groups.length) continue;
                str.append(",");
            }
            retVal = str.toString();
        } else {
            retVal = defaultValue;
        }
        return retVal;
    }

    public void onConfigurationFailure(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onConfigurationSkip(ITestResult result) {
        this.onTestSkipped(result);
    }

    public void onConfigurationSuccess(ITestResult result) {
    }

    private static String testName(ITestResult result) {
        Object[] parameters = result.getParameters();
        String name = result.getName();
        return parameters == null || parameters.length == 0 ? name : name + Arrays.toString(parameters) + "(" + result.getMethod().getCurrentInvocationCount() + ")";
    }
}

