/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGXmlTestSuite;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.TestsToRun;

public class TestNGProvider
extends AbstractProvider {
    private final Properties providerProperties;
    private final TestArtifactInfo testArtifactInfo;
    private final ReporterConfiguration reporterConfiguration;
    private final ClassLoader testClassLoader;
    private final DirectoryScannerParameters directoryScannerParameters;
    private final DirectoryScanner directoryScanner;
    private final TestRequest testRequest;
    private final ProviderParameters providerParameters;
    private TestsToRun testsToRun;
    private final File basedir;

    public TestNGProvider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScannerParameters = booterParameters.getDirectoryScannerParameters();
        this.providerProperties = booterParameters.getProviderProperties();
        this.testRequest = booterParameters.getTestRequest();
        this.basedir = this.directoryScannerParameters != null ? this.directoryScannerParameters.getTestClassesDirectory() : null;
        this.testArtifactInfo = booterParameters.getTestArtifactInfo();
        this.reporterConfiguration = booterParameters.getReporterConfiguration();
        this.directoryScanner = booterParameters.getDirectoryScanner();
    }

    public Boolean isRunnable() {
        return Boolean.TRUE;
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        if (this.isTestNGXmlTestSuite(this.testRequest)) {
            TestNGXmlTestSuite testNGXmlTestSuite = this.getXmlSuite();
            testNGXmlTestSuite.locateTestSets(this.testClassLoader);
            if (forkTestSet != null && this.testRequest == null) {
                testNGXmlTestSuite.execute((String)forkTestSet, reporterFactory);
            } else {
                testNGXmlTestSuite.execute(reporterFactory);
            }
        } else {
            if (this.testsToRun == null) {
                this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
            }
            TestNGDirectoryTestSuite suite = this.getDirectorySuite();
            suite.execute(this.testsToRun, reporterFactory);
        }
        return reporterFactory.close();
    }

    boolean isTestNGXmlTestSuite(TestRequest testSuiteDefinition) {
        return testSuiteDefinition.getSuiteXmlFiles() != null && testSuiteDefinition.getSuiteXmlFiles().size() > 0 && testSuiteDefinition.getRequestedTest() == null;
    }

    private TestNGDirectoryTestSuite getDirectorySuite() {
        return new TestNGDirectoryTestSuite(this.basedir, new ArrayList(this.directoryScannerParameters.getIncludes()), new ArrayList(this.directoryScannerParameters.getExcludes()), this.testRequest.getTestSourceDirectory().toString(), this.testArtifactInfo.getVersion(), this.providerProperties, this.reporterConfiguration.getReportsDirectory(), this.testRequest.getRequestedTestMethod());
    }

    private TestNGXmlTestSuite getXmlSuite() {
        return new TestNGXmlTestSuite(this.testRequest.getSuiteXmlFiles(), this.testRequest.getTestSourceDirectory().toString(), this.testArtifactInfo.getVersion(), this.providerProperties, this.reporterConfiguration.getReportsDirectory());
    }

    public Iterator getSuites() {
        if (this.isTestNGXmlTestSuite(this.testRequest)) {
            try {
                return this.getXmlSuite().locateTestSets(this.testClassLoader).keySet().iterator();
            }
            catch (TestSetFailedException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private TestsToRun scanClassPath() {
        return this.directoryScanner.locateTestClasses(this.testClassLoader, null);
    }
}

