/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit48.JUnit46StackTraceWriter;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class JUnitCoreRunListener
extends JUnit4RunListener {
    private final Map<String, TestSet> classMethodCounts;

    public JUnitCoreRunListener(RunListener reporter, Map<String, TestSet> classMethodCounts) {
        super(reporter);
        this.classMethodCounts = classMethodCounts;
    }

    public void testRunStarted(Description description) throws Exception {
        this.fillTestCountMap(description);
        this.reporter.testSetStarting(null);
    }

    public void testRunFinished(Result result) throws Exception {
        this.reporter.testSetCompleted(null);
    }

    private void fillTestCountMap(Description description) {
        ArrayList children = description.getChildren();
        TestSet testSet = new TestSet(description);
        String itemTestClassName = null;
        for (Description item : children) {
            if (!item.isTest()) {
                this.fillTestCountMap(item);
                continue;
            }
            if (this.extractDescriptionMethodName(item) != null) {
                testSet.incrementTestMethodCount();
                if (itemTestClassName != null) continue;
                itemTestClassName = this.extractDescriptionClassName(item);
                continue;
            }
            this.classMethodCounts.put(this.extractDescriptionClassName(item), new TestSet(item));
        }
        if (itemTestClassName != null) {
            this.classMethodCounts.put(itemTestClassName, testSet);
        }
    }

    @Override
    protected StackTraceWriter createStackTraceWriter(Failure failure) {
        return new JUnit46StackTraceWriter(failure);
    }

    @Override
    protected String extractDescriptionClassName(Description description) {
        return description.getClassName();
    }

    @Override
    protected String extractDescriptionMethodName(Description description) {
        return description.getMethodName();
    }
}

