/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.ParallelComputerFactory;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JUnitCoreWrapper {
    JUnitCoreWrapper() {
    }

    public static void execute(TestsToRun testsToRun, JUnitCoreParameters jUnitCoreParameters, List<RunListener> listeners, Filter filter) throws TestSetFailedException {
        ComputerWrapper computerWrapper = JUnitCoreWrapper.createComputer(jUnitCoreParameters);
        JUnitCore junitCore = JUnitCoreWrapper.createJUnitCore(listeners);
        if (testsToRun.allowEagerReading()) {
            JUnitCoreWrapper.executeEager(testsToRun, filter, computerWrapper.getComputer(), junitCore);
        } else {
            JUnitCoreWrapper.exeuteLazy(testsToRun, filter, computerWrapper.getComputer(), junitCore);
        }
        String timeoutMessage = computerWrapper.describeElapsedTimeout();
        if (timeoutMessage.length() != 0) {
            throw new TestSetFailedException(timeoutMessage);
        }
    }

    private static JUnitCore createJUnitCore(List<RunListener> listeners) {
        JUnitCore junitCore = new JUnitCore();
        for (RunListener runListener : listeners) {
            junitCore.addListener(runListener);
        }
        return junitCore;
    }

    private static void executeEager(TestsToRun testsToRun, Filter filter, Computer computer, JUnitCore junitCore) throws TestSetFailedException {
        Class[] tests = testsToRun.getLocatedClasses();
        JUnitCoreWrapper.createRequestAndRun(filter, computer, junitCore, tests);
    }

    private static void exeuteLazy(TestsToRun testsToRun, Filter filter, Computer computer, JUnitCore junitCore) throws TestSetFailedException {
        for (Class clazz : testsToRun) {
            JUnitCoreWrapper.createRequestAndRun(filter, computer, junitCore, clazz);
        }
    }

    private static void createRequestAndRun(Filter filter, Computer computer, JUnitCore junitCore, Class<?> ... classesToRun) throws TestSetFailedException {
        Request req = Request.classes((Computer)computer, (Class[])classesToRun);
        if (filter != null && (req = new FilteringRequest(req, filter)).getRunner() == null) {
            return;
        }
        Result run = junitCore.run(req);
        JUnit4RunListener.rethrowAnyTestMechanismFailures(run);
    }

    private static ComputerWrapper createComputer(JUnitCoreParameters parameters) throws TestSetFailedException {
        return parameters.isNoThreading() ? new ComputerWrapper(Computer.serial()) : JUnitCoreWrapper.createParallelComputer(parameters);
    }

    private static ComputerWrapper createParallelComputer(JUnitCoreParameters parameters) throws TestSetFailedException {
        ParallelComputer pc = ParallelComputerFactory.createParallelComputer(parameters);
        int timeout = parameters.getParallelTestsTimeoutInSeconds();
        int timeoutForced = parameters.getParallelTestsTimeoutForcedInSeconds();
        Future<Collection<Description>> testsBeforeShutdown = timeout > 0 ? pc.scheduleShutdown(timeout, TimeUnit.SECONDS) : null;
        Future<Collection<Description>> testsBeforeForcedShutdown = timeoutForced > 0 ? pc.scheduleForcedShutdown(timeoutForced, TimeUnit.SECONDS) : null;
        return new ComputerWrapper(pc, timeout, testsBeforeShutdown, timeoutForced, testsBeforeForcedShutdown);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputerWrapper {
        private final Computer computer;
        private final int timeout;
        private final int timeoutForced;
        private final Future<Collection<Description>> testsBeforeShutdown;
        private final Future<Collection<Description>> testsBeforeForcedShutdown;

        ComputerWrapper(Computer computer) {
            this(computer, 0, null, 0, null);
        }

        ComputerWrapper(Computer computer, int timeout, Future<Collection<Description>> testsBeforeShutdown, int timeoutForced, Future<Collection<Description>> testsBeforeForcedShutdown) {
            this.computer = computer;
            this.timeout = timeout;
            this.testsBeforeShutdown = testsBeforeShutdown;
            this.timeoutForced = timeoutForced;
            this.testsBeforeForcedShutdown = testsBeforeForcedShutdown;
        }

        Computer getComputer() {
            return this.computer;
        }

        String describeElapsedTimeout() throws TestSetFailedException {
            TreeSet<String> executedTests = new TreeSet<String>();
            if (this.timeout > 0) {
                executedTests.addAll(ComputerWrapper.printShutdownHook(this.testsBeforeShutdown));
            }
            if (this.timeoutForced > 0) {
                executedTests.addAll(ComputerWrapper.printShutdownHook(this.testsBeforeForcedShutdown));
            }
            StringBuilder msg = new StringBuilder();
            if (!executedTests.isEmpty()) {
                msg.append("The test run has finished abruptly after timeout of ");
                msg.append(Math.min(this.timeout, this.timeoutForced));
                msg.append(" seconds.\n");
                msg.append("These tests were executed in prior of the shutdown operation:\n");
                for (String executedTest : executedTests) {
                    msg.append(executedTest).append("\n");
                }
            }
            return msg.toString();
        }

        static Collection<String> printShutdownHook(Future<Collection<Description>> future) throws TestSetFailedException {
            if (!future.isCancelled() && future.isDone()) {
                try {
                    TreeSet<String> executedTests = new TreeSet<String>();
                    for (Description executedTest : future.get()) {
                        if (executedTest == null || executedTest.getDisplayName() == null) continue;
                        executedTests.add(executedTest.getDisplayName());
                    }
                    return executedTests;
                }
                catch (Exception e) {
                    throw new TestSetFailedException((Throwable)e);
                }
            }
            return Collections.emptySet();
        }
    }

    private static class FilteringRequest
    extends Request {
        private Runner filteredRunner;

        public FilteringRequest(Request req, Filter filter) {
            try {
                Runner runner = req.getRunner();
                filter.apply((Object)runner);
                this.filteredRunner = runner;
            }
            catch (NoTestsRemainException e) {
                this.filteredRunner = null;
            }
        }

        public Runner getRunner() {
            return this.filteredRunner;
        }
    }
}

