/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.ResourceBundle;
import org.apache.maven.surefire.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.junit4.JUnit4TestSet;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestSetReporter
extends RunListener {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private JUnit4TestSet testSet;
    private ReporterManager reportMgr;
    private boolean failureFlag;

    JUnit4TestSetReporter(JUnit4TestSet testSet, ReporterManager reportManager) {
        this.testSet = testSet;
        this.reportMgr = reportManager;
    }

    public void testRunStarted(Description description) throws Exception {
        String rawString = bundle.getString("testSetStarting");
        ReportEntry report = new ReportEntry((Object)this.testSet, this.testSet.getName(), rawString);
        this.reportMgr.testSetStarting(report);
    }

    public void testRunFinished(Result result) throws Exception {
        String rawString = bundle.getString("testSetCompletedNormally");
        ReportEntry report = new ReportEntry((Object)this.testSet, this.testSet.getName(), rawString);
        this.reportMgr.testSetCompleted(report);
        this.reportMgr.reset();
    }

    public void testIgnored(Description description) throws Exception {
        String rawString = bundle.getString("testSkipped");
        ReportEntry report = new ReportEntry((Object)this.testSet, description.getDisplayName(), rawString);
        this.reportMgr.testSkipped(report);
    }

    public void testStarted(Description description) throws Exception {
        String rawString = bundle.getString("testStarting");
        ReportEntry report = new ReportEntry((Object)this.testSet, description.getDisplayName(), rawString);
        this.reportMgr.testStarting(report);
        this.failureFlag = false;
    }

    public void testFailure(Failure failure) throws Exception {
        String rawString = bundle.getString("executeException");
        ReportEntry report = new ReportEntry((Object)this.testSet, failure.getTestHeader(), rawString, (StackTraceWriter)new JUnit4StackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reportMgr.testFailed(report);
        } else {
            this.reportMgr.testError(report);
        }
        this.failureFlag = true;
    }

    public void testFinished(Description description) throws Exception {
        if (!this.failureFlag) {
            String rawString = bundle.getString("testSuccessful");
            ReportEntry report = new ReportEntry((Object)this.testSet, description.getDisplayName(), rawString);
            this.reportMgr.testSucceeded(report);
        }
    }
}

