/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;
import org.apache.maven.it.util.cli.CommandLineException;
import org.apache.maven.it.util.cli.CommandLineUtils;
import org.apache.maven.it.util.cli.Commandline;
import org.apache.maven.it.util.cli.WriterStreamConsumer;

class ForkedLauncher
implements MavenLauncher {
    private final String mavenHome;
    private final String executable;

    public ForkedLauncher(String mavenHome) {
        this(mavenHome, false);
    }

    public ForkedLauncher(String mavenHome, boolean debugJvm) {
        this.mavenHome = mavenHome;
        String script = debugJvm ? "mvnDebug" : "mvn";
        this.executable = mavenHome != null ? new File(mavenHome, "bin/" + script).getPath() : script;
    }

    public int run(String[] cliArgs, Map envVars, String workingDirectory, File logFile) throws IOException, LauncherException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.executable);
        if (this.mavenHome != null) {
            cmd.addEnvironment("M2_HOME", this.mavenHome);
        }
        if (envVars != null) {
            Iterator i = envVars.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                cmd.addEnvironment(key, (String)envVars.get(key));
            }
        }
        if (envVars == null || envVars.get("JAVA_HOME") == null) {
            cmd.addEnvironment("JAVA_HOME", System.getProperty("java.home"));
        }
        cmd.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cmd.setWorkingDirectory(workingDirectory);
        for (int i = 0; i < cliArgs.length; ++i) {
            cmd.createArgument().setValue(cliArgs[i]);
        }
        FileWriter logWriter = new FileWriter(logFile);
        WriterStreamConsumer out = new WriterStreamConsumer(logWriter);
        WriterStreamConsumer err = new WriterStreamConsumer(logWriter);
        try {
            int n = CommandLineUtils.executeCommandLine(cmd, out, err);
            return n;
        }
        catch (CommandLineException e) {
            throw new LauncherException("Failed to run Maven: " + e.getMessage() + "\n" + cmd, e);
        }
        finally {
            ((Writer)logWriter).close();
        }
    }

    public int run(String[] cliArgs, String workingDirectory, File logFile) throws IOException, LauncherException {
        return this.run(cliArgs, Collections.EMPTY_MAP, workingDirectory, logFile);
    }
}

