/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.scriptinterpreter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.FileLoggerMirrorHandler;

public class FileLogger
implements ExecutionLogger,
AutoCloseable {
    private File file;
    private PrintStream stream;

    public FileLogger(File outputFile) throws IOException {
        this(outputFile, null);
    }

    public FileLogger(File outputFile, FileLoggerMirrorHandler mirrorHandler) throws IOException {
        OutputStream outputStream;
        this.file = outputFile;
        if (outputFile != null) {
            outputFile.getParentFile().mkdirs();
            outputStream = new FileOutputStream(outputFile);
        } else {
            outputStream = new NullOutputStream();
        }
        this.stream = mirrorHandler != null ? new PrintStream(new MirrorStreamWrapper(outputStream, mirrorHandler)) : new PrintStream(outputStream);
    }

    public File getOutputFile() {
        return this.file;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.stream;
    }

    @Override
    public void consumeLine(String line) {
        this.stream.println(line);
        this.stream.flush();
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.stream.flush();
            this.stream.close();
            this.stream = null;
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }

    private static class MirrorStreamWrapper
    extends OutputStream {
        private final OutputStream out;
        private final FileLoggerMirrorHandler mirrorHandler;
        private StringBuilder lineBuffer;

        MirrorStreamWrapper(OutputStream outputStream, FileLoggerMirrorHandler mirrorHandler) {
            this.out = outputStream;
            this.mirrorHandler = mirrorHandler;
            this.lineBuffer = new StringBuilder();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.lineBuffer.append((char)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.lineBuffer.append(new String(b, off, len));
        }

        @Override
        public void flush() throws IOException {
            int len;
            this.out.flush();
            if (len == 0) {
                return;
            }
            for (len = this.lineBuffer.length(); len > 0 && (this.lineBuffer.charAt(len - 1) == '\n' || this.lineBuffer.charAt(len - 1) == '\r'); --len) {
            }
            this.lineBuffer.setLength(len);
            this.mirrorHandler.consumeOutput(this.lineBuffer.toString());
            this.lineBuffer = new StringBuilder();
        }
    }
}

