/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.info;

import java.io.File;
import java.util.Collections;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;

public class JGitInfoCommand
extends AbstractCommand
implements GitCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        InfoScmResult infoScmResult;
        Git git = null;
        try {
            File basedir = fileSet.getBasedir();
            git = Git.open((File)basedir);
            ObjectId objectId = git.getRepository().resolve("HEAD");
            InfoItem infoItem = new InfoItem();
            infoItem.setRevision(StringUtils.trim((String)objectId.name()));
            infoItem.setURL(basedir.toPath().toUri().toASCIIString());
            infoScmResult = new InfoScmResult(Collections.singletonList(infoItem), new ScmResult("JGit.resolve(HEAD)", "", objectId.toString(), true));
        }
        catch (Exception e) {
            try {
                throw new ScmException("JGit resolve failure!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JGitUtils.closeRepo(git);
                throw throwable;
            }
        }
        JGitUtils.closeRepo(git);
        return infoScmResult;
    }
}

