/*
 * $Id$
 */

package org.apache.maven.scm.providers.gitlib.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *              git format allowed by changelog command.
     *           
     */
    private String revParseDateFormat = "yyyy-MM-dd HH:mm:ss";

    /**
     * 
     *              Traces the execution of a git command.
     *              could be 1,2, true or a file location
     *           .
     */
    private String traceGitCommand = "";

    /**
     * use the option --no-verify (can prevent trailing whitespace
     * issue with cygwin).
     */
    private boolean commitNoVerify = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *              git format allowed by changelog command.
     *           
     * 
     * @return String
     */
    public String getRevParseDateFormat()
    {
        return this.revParseDateFormat;
    } //-- String getRevParseDateFormat() 

    /**
     * Get 
     *              Traces the execution of a git command.
     *              could be 1,2, true or a file location
     *           .
     * 
     * @return String
     */
    public String getTraceGitCommand()
    {
        return this.traceGitCommand;
    } //-- String getTraceGitCommand() 

    /**
     * Get use the option --no-verify (can prevent trailing
     * whitespace issue with cygwin).
     * 
     * @return boolean
     */
    public boolean isCommitNoVerify()
    {
        return this.commitNoVerify;
    } //-- boolean isCommitNoVerify() 

    /**
     * Set use the option --no-verify (can prevent trailing
     * whitespace issue with cygwin).
     * 
     * @param commitNoVerify
     */
    public void setCommitNoVerify(boolean commitNoVerify)
    {
        this.commitNoVerify = commitNoVerify;
    } //-- void setCommitNoVerify(boolean) 

    /**
     * Set 
     *              git format allowed by changelog command.
     *           
     * 
     * @param revParseDateFormat
     */
    public void setRevParseDateFormat(String revParseDateFormat)
    {
        this.revParseDateFormat = revParseDateFormat;
    } //-- void setRevParseDateFormat(String) 

    /**
     * Set 
     *              Traces the execution of a git command.
     *              could be 1,2, true or a file location
     *           .
     * 
     * @param traceGitCommand
     */
    public void setTraceGitCommand(String traceGitCommand)
    {
        this.traceGitCommand = traceGitCommand;
    } //-- void setTraceGitCommand(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
