/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.commands.login;

import java.util.ArrayList;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.login.AbstractLoginCommand;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevScmProvider;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class AccuRevLoginCommand
extends AbstractLoginCommand {
    private String executable;

    public AccuRevLoginCommand(String executable) {
        this.executable = executable;
    }

    public LoginScmResult executeLoginCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        String username = repository.getUser();
        if (null == username) {
            return new LoginScmResult(null, null, null, true);
        }
        Commandline cl = this.createLoginCommandLine((AccuRevScmProviderRepository)repository);
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stderr, (StreamConsumer)stderr);
            LoginScmResult scmResult = exitCode != 0 ? new LoginScmResult(cl.toString(), null, stderr.getOutput(), false) : new LoginScmResult(cl.toString(), null, null, true);
            return scmResult;
        }
        catch (CommandLineException e) {
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
    }

    protected Commandline createLoginCommandLine(AccuRevScmProviderRepository repository) {
        Commandline cl = new Commandline();
        cl.setExecutable(this.executable);
        ArrayList<String> params = new ArrayList<String>();
        params.add("login");
        AccuRevScmProvider.appendHostToParamsIfNeeded(repository, params);
        params.add(repository.getUser());
        String password = repository.getPassword();
        params.add(StringUtils.isEmpty((String)password) ? "\"\"" : password);
        cl.addArguments(params.toArray(new String[params.size()]));
        return cl;
    }
}

