/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractConsumer
implements StreamConsumer {
    private ScmLogger logger;

    public AbstractConsumer(ScmLogger logger) {
        this.setLogger(logger);
    }

    public ScmLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ScmLogger logger) {
        this.logger = logger;
    }

    protected Date parseDate(String date, String userPattern, String defaultPattern) {
        return this.parseDate(date, userPattern, defaultPattern, null);
    }

    protected Date parseDate(String date, String userPattern, String defaultPattern, Locale locale) {
        DateFormat format = StringUtils.isNotEmpty((String)userPattern) ? new SimpleDateFormat(userPattern) : (StringUtils.isNotEmpty((String)defaultPattern) ? (locale != null ? new SimpleDateFormat(defaultPattern, locale) : new SimpleDateFormat(defaultPattern)) : DateFormat.getDateInstance(3, Locale.ENGLISH));
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            if (this.getLogger() != null && this.getLogger().isErrorEnabled()) {
                this.getLogger().error("ParseException: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

