/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.util.ReleaseUtil;

public abstract class AbstractBackupPomsPhase
extends AbstractReleasePhase {
    protected static final String BACKUP_SUFFIX = ".releaseBackup";

    protected File getPomBackup(MavenProject project) {
        File pomFile = ReleaseUtil.getStandardPom(project);
        if (pomFile != null) {
            return new File(pomFile.getAbsolutePath() + BACKUP_SUFFIX);
        }
        return null;
    }

    protected void deletePomBackup(MavenProject project) {
        File pomBackup = this.getPomBackup(project);
        if (pomBackup != null && pomBackup.exists()) {
            pomBackup.delete();
        }
    }
}

