/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.surefire.report.SurefireReportGenerator;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSurefireReportMojo
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    private boolean showSuccess;
    private File[] reportsDirectories;
    private File reportsDirectory;
    private List<MavenProject> reactorProjects;
    private File xrefLocation;
    private boolean linkXRef;
    private boolean aggregate;

    protected boolean isSkipped() {
        return false;
    }

    protected boolean isGeneratedWhenNoResults() {
        return false;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.isSkipped()) {
            return;
        }
        List<File> reportsDirectoryList = this.getReportsDirectories();
        if (reportsDirectoryList == null) {
            return;
        }
        if (!this.isGeneratedWhenNoResults()) {
            boolean atLeastOneDirectoryExists = false;
            Iterator<File> i = reportsDirectoryList.iterator();
            while (i.hasNext() && !atLeastOneDirectoryExists) {
                atLeastOneDirectoryExists = SurefireReportParser.hasReportFiles(i.next());
            }
            if (!atLeastOneDirectoryExists) {
                return;
            }
        }
        SurefireReportGenerator report = new SurefireReportGenerator(reportsDirectoryList, locale, this.showSuccess, this.determineXrefLocation());
        report.doGenerateReport(this.getBundle(locale), this.getSink());
    }

    public boolean canGenerateReport() {
        if (this.isSkipped()) {
            return false;
        }
        List<File> reportsDirectoryList = this.getReportsDirectories();
        if (reportsDirectoryList == null) {
            return false;
        }
        if (!this.isGeneratedWhenNoResults()) {
            boolean atLeastOneDirectoryExists = false;
            Iterator<File> i = reportsDirectoryList.iterator();
            while (i.hasNext() && !atLeastOneDirectoryExists) {
                atLeastOneDirectoryExists = SurefireReportParser.hasReportFiles(i.next());
            }
            if (!atLeastOneDirectoryExists) {
                return false;
            }
        }
        return super.canGenerateReport();
    }

    private List<File> getReportsDirectories() {
        ArrayList<File> reportsDirectoryList = new ArrayList<File>();
        if (this.reportsDirectories != null) {
            reportsDirectoryList.addAll(Arrays.asList(this.reportsDirectories));
        }
        if (this.reportsDirectory != null) {
            reportsDirectoryList.add(this.reportsDirectory);
        }
        if (this.aggregate) {
            if (!this.project.isExecutionRoot()) {
                return null;
            }
            if (this.reportsDirectories == null) {
                for (MavenProject mavenProject : this.getProjectsWithoutRoot()) {
                    reportsDirectoryList.add(this.getSurefireReportsDirectory(mavenProject));
                }
            } else {
                String parentBaseDir = this.getProject().getBasedir().getAbsolutePath();
                for (MavenProject subProject : this.getProjectsWithoutRoot()) {
                    String moduleBaseDir = subProject.getBasedir().getAbsolutePath();
                    for (File reportsDirectory1 : this.reportsDirectories) {
                        File reportsDirectory;
                        String reportDir = reportsDirectory1.getPath();
                        if (reportDir.startsWith(parentBaseDir)) {
                            reportDir = reportDir.substring(parentBaseDir.length());
                        }
                        if (!(reportsDirectory = new File(moduleBaseDir, reportDir)).exists() || !reportsDirectory.isDirectory()) continue;
                        this.getLog().debug((CharSequence)("Adding report dir : " + moduleBaseDir + reportDir));
                        reportsDirectoryList.add(reportsDirectory);
                    }
                }
            }
        } else if (reportsDirectoryList.size() == 0) {
            reportsDirectoryList.add(this.getSurefireReportsDirectory(this.project));
        }
        return reportsDirectoryList;
    }

    protected abstract File getSurefireReportsDirectory(MavenProject var1);

    private List<MavenProject> getProjectsWithoutRoot() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject subProject : this.reactorProjects) {
            if (this.project.equals((Object)subProject)) continue;
            result.add(subProject);
        }
        return result;
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                for (Object o : this.project.getReportPlugins()) {
                    ReportPlugin report = (ReportPlugin)o;
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.surefire.description");
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public abstract String getOutputName();

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("surefire-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

