/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.reactor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-reactor-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Reactor Plugin 1.0", 0);
        this.append(sb, "Build a subset of interdependent projects in a reactor", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "reactor:help", 0);
            this.append(sb, "Display help information on maven-reactor-plugin.\nCall\n\u00a0\u00a0mvn\u00a0reactor:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make".equals(this.goal)) {
            this.append(sb, "reactor:make", 0);
            this.append(sb, "Goal to build a project X and all of the reactor projects on which X depends", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactList", 2);
                this.append(sb, "A list of artifacts to build, e.g. 'com.mycompany:bar,com.mycompany:foo' or just 'foo,bar', or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "baseDir", 2);
                this.append(sb, "Location of the POM file; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "collectedProjects", 2);
                this.append(sb, "A list of every project in this reactor; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromFolder", 2);
                this.append(sb, "The project folder from which we'll resume", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromProject", 2);
                this.append(sb, "The artifact from which we'll resume, e.g. 'com.mycompany:foo' or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroup (Default: ${project.groupId})", 2);
                this.append(sb, "If you don't specify a groupId in your artifactList, we'll use this as the default groupId.", 3);
                this.append(sb, "", 0);
                this.append(sb, "folderList", 2);
                this.append(sb, "A list of relative paths to build, e.g. 'foo,baz/bar'", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals (Default: install)", 2);
                this.append(sb, "Goals to run on subproject.", 3);
                this.append(sb, "", 0);
                this.append(sb, "printOnly", 2);
                this.append(sb, "Don't really do anything; just print a command that describes what the command would have done", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make-dependents".equals(this.goal)) {
            this.append(sb, "reactor:make-dependents", 0);
            this.append(sb, "Goal to build a project X and all of the reactor projects that depend on X", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactList", 2);
                this.append(sb, "A list of artifacts to build, e.g. 'com.mycompany:bar,com.mycompany:foo' or just 'foo,bar', or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "baseDir", 2);
                this.append(sb, "Location of the POM file; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "collectedProjects", 2);
                this.append(sb, "A list of every project in this reactor; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromFolder", 2);
                this.append(sb, "The project folder from which we'll resume", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromProject", 2);
                this.append(sb, "The artifact from which we'll resume, e.g. 'com.mycompany:foo' or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroup (Default: ${project.groupId})", 2);
                this.append(sb, "If you don't specify a groupId in your artifactList, we'll use this as the default groupId.", 3);
                this.append(sb, "", 0);
                this.append(sb, "folderList", 2);
                this.append(sb, "A list of relative paths to build, e.g. 'foo,baz/bar'", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals (Default: install)", 2);
                this.append(sb, "Goals to run on subproject.", 3);
                this.append(sb, "", 0);
                this.append(sb, "printOnly", 2);
                this.append(sb, "Don't really do anything; just print a command that describes what the command would have done", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "make-scm-changes".equals(this.goal)) {
            this.append(sb, "reactor:make-scm-changes", 0);
            this.append(sb, "Goal to build all projects that you personally have changed (according to SCM)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifactList", 2);
                this.append(sb, "A list of artifacts to build, e.g. 'com.mycompany:bar,com.mycompany:foo' or just 'foo,bar', or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "baseDir", 2);
                this.append(sb, "Location of the POM file; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "collectedProjects", 2);
                this.append(sb, "A list of every project in this reactor; provided by Maven", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromFolder", 2);
                this.append(sb, "The project folder from which we'll resume", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromProject", 2);
                this.append(sb, "The artifact from which we'll resume, e.g. 'com.mycompany:foo' or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultGroup (Default: ${project.groupId})", 2);
                this.append(sb, "If you don't specify a groupId in your artifactList, we'll use this as the default groupId.", 3);
                this.append(sb, "", 0);
                this.append(sb, "folderList", 2);
                this.append(sb, "A list of relative paths to build, e.g. 'foo,baz/bar'", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals (Default: install)", 2);
                this.append(sb, "Goals to run on subproject.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreUnknown (Default: true)", 2);
                this.append(sb, "Ignore files in the 'unknown' status (created but not added to source control)", 3);
                this.append(sb, "", 0);
                this.append(sb, "printOnly", 2);
                this.append(sb, "Don't really do anything; just print a command that describes what the command would have done", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmConnection (Default: ${project.scm.connection})", 2);
                this.append(sb, "The SCM connection/provider info. Should be specified in your POM.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "resume".equals(this.goal)) {
            this.append(sb, "reactor:resume", 0);
            this.append(sb, "Goal to resume building a reactor at a certain point", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "baseDir", 2);
                this.append(sb, "Location of the file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "collectedProjects", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromFolder (Default: null)", 2);
                this.append(sb, "The project folder from which we'll resume", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromGroup (Default: ${project.groupId})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "continueFromProject (Default: null)", 2);
                this.append(sb, "The artifact from which we'll resume, e.g. 'com.mycompany:foo' or just 'foo'", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals (Default: install)", 2);
                this.append(sb, "Goals to run on subproject", 3);
                this.append(sb, "", 0);
                this.append(sb, "printOnly", 2);
                this.append(sb, "Don't really do anything; just print a message that describes what the command would have done", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

